/*
 * Decompiled with CFR 0.152.
 */
package net.atlas.defaulted.component.generators;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.atlas.defaulted.Defaulted;
import net.atlas.defaulted.component.PatchGenerator;
import net.atlas.defaulted.component.ToolMaterialWrapper;
import net.atlas.defaulted.component.generators.WeaponLevelBasedValue;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.component.PatchedDataComponentMap;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.component.ItemAttributeModifiers;

public record WeaponStatsGenerator(Optional<WeaponLevelBasedValue> damage, Optional<WeaponLevelBasedValue> speed, Optional<ResourceLocation> damageIdOverride, Optional<ResourceLocation> speedIdOverride, List<ItemAttributeModifiers.Entry> additionalModifiers, boolean tieredDamage, boolean persistPrevious) implements PatchGenerator
{
    public static final MapCodec<WeaponStatsGenerator> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)WeaponLevelBasedValue.CODEC.optionalFieldOf("attack_damage").forGetter(WeaponStatsGenerator::damage), (App)WeaponLevelBasedValue.CODEC.optionalFieldOf("attack_speed").forGetter(WeaponStatsGenerator::speed), (App)ResourceLocation.CODEC.optionalFieldOf("damage_id_override").forGetter(WeaponStatsGenerator::damageIdOverride), (App)ResourceLocation.CODEC.optionalFieldOf("speed_id_override").forGetter(WeaponStatsGenerator::speedIdOverride), (App)ItemAttributeModifiers.Entry.CODEC.listOf().optionalFieldOf("additional_modifiers", Collections.emptyList()).forGetter(WeaponStatsGenerator::additionalModifiers), (App)Codec.BOOL.optionalFieldOf("apply_tier_to_damage", (Object)true).forGetter(WeaponStatsGenerator::tieredDamage), (App)Codec.BOOL.fieldOf("persist_previous").forGetter(WeaponStatsGenerator::persistPrevious)).apply((Applicative)instance, WeaponStatsGenerator::new));

    @Override
    public void patchDataComponentMap(Item item, PatchedDataComponentMap patchedDataComponentMap) {
        ItemAttributeModifiers oldModifiers = (ItemAttributeModifiers)patchedDataComponentMap.get(DataComponents.ATTRIBUTE_MODIFIERS);
        ToolMaterialWrapper toolMaterialWrapper = item.defaulted$getToolMaterial();
        if (toolMaterialWrapper == null) {
            toolMaterialWrapper = Defaulted.DEFAULT_WRAPPER;
        }
        ItemAttributeModifiers.Builder builder = ItemAttributeModifiers.builder();
        ResourceLocation damageID = this.damageIdOverride.orElse(Item.BASE_ATTACK_DAMAGE_ID);
        ResourceLocation speedID = this.speedIdOverride.orElse(Item.BASE_ATTACK_SPEED_ID);
        AttributeModifier attackDamage = null;
        boolean hasDamage = false;
        if (this.damage.isPresent()) {
            hasDamage = true;
            attackDamage = new AttributeModifier(damageID, (double)this.damage.get().getResult(toolMaterialWrapper.weaponLevel(), toolMaterialWrapper.attackDamageBonus(), this.tieredDamage).floatValue(), AttributeModifier.Operation.ADD_VALUE);
        }
        AttributeModifier attackSpeed = null;
        boolean hasSpeed = false;
        if (this.speed.isPresent()) {
            hasSpeed = true;
            attackSpeed = new AttributeModifier(speedID, (double)this.speed.get().getResult(toolMaterialWrapper.speedLevel(), true).floatValue(), AttributeModifier.Operation.ADD_VALUE);
        }
        if (!hasDamage && !hasSpeed) {
            return;
        }
        for (ItemAttributeModifiers.Entry entry : this.additionalModifiers) {
            if (hasDamage && entry.matches(Attributes.ATTACK_DAMAGE, damageID) || hasSpeed && entry.matches(Attributes.ATTACK_SPEED, speedID)) continue;
            builder.add(entry.attribute(), entry.modifier(), entry.slot());
        }
        if (this.persistPrevious && oldModifiers != null) {
            for (ItemAttributeModifiers.Entry entry : oldModifiers.modifiers()) {
                if (hasDamage && entry.matches(Attributes.ATTACK_DAMAGE, damageID) || hasSpeed && entry.matches(Attributes.ATTACK_SPEED, speedID)) continue;
                builder.add(entry.attribute(), entry.modifier(), entry.slot());
            }
        }
        if (hasDamage) {
            builder.add(Attributes.ATTACK_DAMAGE, attackDamage, EquipmentSlotGroup.MAINHAND);
        }
        if (hasSpeed) {
            builder.add(Attributes.ATTACK_SPEED, attackSpeed, EquipmentSlotGroup.MAINHAND);
        }
        patchedDataComponentMap.set(DataComponents.ATTRIBUTE_MODIFIERS, (Object)builder.build());
    }

    @Override
    public MapCodec<? extends PatchGenerator> codec() {
        return CODEC;
    }
}

