/*
 * Decompiled with CFR 0.152.
 */
package net.atlas.defaulted.component.generators.handler;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.equipment.Equippable;

public record ArmourVariable<T>(Optional<T> any, Optional<T> helmet, Optional<T> chestplate, Optional<T> leggings, Optional<T> boots, Optional<T> body) {
    public static final ArmourVariable<?> EMPTY = new ArmourVariable<Object>(null, null, null, null, null, null);

    public ArmourVariable(T any, T helmet, T chestplate, T leggings, T boots, T body) {
        this(Optional.ofNullable(any), Optional.ofNullable(helmet), Optional.ofNullable(chestplate), Optional.ofNullable(leggings), Optional.ofNullable(boots), Optional.ofNullable(body));
    }

    public static <T> Codec<ArmourVariable<T>> codec(Codec<T> varCodec) {
        Codec simpleCodec = varCodec.xmap(ArmourVariable::create, armourVariable -> armourVariable.any().orElse(null));
        Codec fullCodec = RecordCodecBuilder.create(instance -> instance.group((App)varCodec.optionalFieldOf("any").forGetter(ArmourVariable::any), (App)varCodec.optionalFieldOf("helmet").forGetter(ArmourVariable::helmet), (App)varCodec.optionalFieldOf("chestplate").forGetter(ArmourVariable::chestplate), (App)varCodec.optionalFieldOf("leggings").forGetter(ArmourVariable::leggings), (App)varCodec.optionalFieldOf("boots").forGetter(ArmourVariable::boots), (App)varCodec.optionalFieldOf("body").forGetter(ArmourVariable::body)).apply((Applicative)instance, (any, helmet, chestplate, leggings, boots, body) -> new ArmourVariable(any, helmet, chestplate, leggings, boots, body)));
        return Codec.withAlternative((Codec)fullCodec, (Codec)simpleCodec);
    }

    public static <T> ArmourVariable<T> empty() {
        return EMPTY;
    }

    public static <T> ArmourVariable<T> create(T any) {
        return new ArmourVariable<Object>(any, null, null, null, null, null);
    }

    public T getValue(Item item) {
        if (item.components().has(DataComponents.EQUIPPABLE)) {
            return (T)(switch (((Equippable)item.components().get(DataComponents.EQUIPPABLE)).slot()) {
                case EquipmentSlot.HEAD -> this.helmet.orElseGet(() -> this.any.orElse(null));
                case EquipmentSlot.CHEST -> this.chestplate.orElseGet(() -> this.any.orElse(null));
                case EquipmentSlot.LEGS -> this.leggings.orElseGet(() -> this.any.orElse(null));
                case EquipmentSlot.FEET -> this.boots.orElseGet(() -> this.any.orElse(null));
                case EquipmentSlot.BODY -> this.body.orElseGet(() -> this.any.orElse(null));
                default -> this.any.orElse(null);
            });
        }
        return this.any.orElse(null);
    }

    public boolean isEmpty() {
        return this.equals(EMPTY);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ArmourVariable)) {
            return false;
        }
        ArmourVariable that = (ArmourVariable)o;
        return Objects.equals(this.any, that.any) && Objects.equals(this.helmet, that.helmet) && Objects.equals(this.chestplate, that.chestplate) && Objects.equals(this.leggings, that.leggings) && Objects.equals(this.boots, that.boots) && Objects.equals(this.body, that.body);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.any, this.helmet, this.chestplate, this.leggings, this.boots, this.body);
    }

    public static Optional<Integer> max(Optional<Integer> value, int min) {
        return value.map(integer -> Math.max(integer, min));
    }
}

