/*
 * Decompiled with CFR 0.152.
 */
package net.atlas.defaulted;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.mojang.serialization.Codec;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.atlas.defaulted.Defaulted;
import net.atlas.defaulted.component.ItemPatches;
import net.minecraft.class_1792;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import net.minecraft.class_6903;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public abstract class DefaultComponentPatchesManager
extends class_4309 {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final Logger LOGGER = LogManager.getLogger();
    public static List<ItemPatches> CLIENT_CACHED = null;
    private static DefaultComponentPatchesManager INSTANCE;
    private List<ItemPatches> cached = null;
    private Map<class_2960, ItemPatches> intermediary = new HashMap<class_2960, ItemPatches>();

    public DefaultComponentPatchesManager() {
        super(GSON, "defaulted/default_component_patches");
        INSTANCE = this;
    }

    public void patch() {
        Defaulted.patchItemComponents(this.cached);
        Defaulted.EXECUTE_ON_RELOAD.forEach(collectionConsumer -> collectionConsumer.accept(this.cached));
    }

    @NotNull
    protected Map<class_2960, JsonElement> method_20731(class_3300 resourceManager, class_3695 profilerFiller) {
        DefaultComponentPatchesManager.clear();
        return super.method_20731(resourceManager, profilerFiller);
    }

    protected void apply(Map<class_2960, JsonElement> map, class_3300 resourceManager, class_3695 profilerFiller) {
        HashMap<class_2960, ItemPatches> patchesMap = new HashMap<class_2960, ItemPatches>();
        class_6903<JsonElement> registryOps = this.makeOps();
        for (Map.Entry<class_2960, JsonElement> entry : map.entrySet()) {
            class_2960 loc = entry.getKey();
            try {
                Optional optionalItemPatches = (Optional)this.getCodec().parse(registryOps, (Object)entry.getValue()).getOrThrow(JsonParseException::new);
                optionalItemPatches.ifPresentOrElse(itemPatches -> patchesMap.put(loc, (ItemPatches)itemPatches), () -> LOGGER.debug("Skipping loading item components patch {} as its conditions were not met", (Object)loc));
            }
            catch (JsonParseException | IllegalArgumentException runtimeException) {
                LOGGER.error("Parsing error loading item patches {}", (Object)loc, (Object)runtimeException);
            }
        }
        this.intermediary = patchesMap;
    }

    public Codec<Optional<ItemPatches>> getCodec() {
        return ItemPatches.DIRECT_CODEC.xmap(Optional::of, Optional::get);
    }

    public abstract class_6903<JsonElement> makeOps();

    public static DefaultComponentPatchesManager getInstance() {
        return INSTANCE;
    }

    public static List<ItemPatches> getCached() {
        if (INSTANCE == null) {
            return null;
        }
        INSTANCE.load();
        return DefaultComponentPatchesManager.INSTANCE.cached;
    }

    public void load() {
        if (this.cached == null) {
            this.cached = this.intermediary.entrySet().stream().map(entry -> new ItemPatchesEntry((class_2960)entry.getKey(), (ItemPatches)entry.getValue())).sorted(Comparator.naturalOrder()).map(ItemPatchesEntry::itemPatches).toList();
            this.patch();
        }
    }

    public static void clear() {
        if (INSTANCE != null) {
            DefaultComponentPatchesManager.INSTANCE.cached = null;
        }
        if (CLIENT_CACHED != null) {
            CLIENT_CACHED = null;
        }
    }

    public static void clearClient() {
        DefaultComponentPatchesManager.clear();
        Defaulted.originalComponents.forEach((itemHolder, components) -> {
            ((class_1792)itemHolder.comp_349()).field_49263 = components;
        });
    }

    public static void loadClientCache(List<ItemPatches> cached) {
        CLIENT_CACHED = cached;
        Defaulted.patchItemComponents(cached);
    }

    public static void setClientCache() {
        CLIENT_CACHED = DefaultComponentPatchesManager.getCached();
    }

    public record ItemPatchesEntry(class_2960 id, ItemPatches itemPatches) implements Comparable<ItemPatchesEntry>
    {
        @Override
        public int compareTo(ItemPatchesEntry other) {
            int priority = this.itemPatches.compareTo(other.itemPatches);
            return priority == 0 ? this.id.method_12833(other.id) : priority;
        }
    }
}

