/*
 * Decompiled with CFR 0.152.
 */
package net.atlas.defaulted.component.generators;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.UUID;
import java.util.function.Function;
import net.atlas.defaulted.Defaulted;
import net.atlas.defaulted.component.ItemPatches;
import net.atlas.defaulted.component.PatchGenerator;
import net.atlas.defaulted.component.generators.handler.ArmourVariable;
import net.minecraft.class_1304;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1792;
import net.minecraft.class_5134;
import net.minecraft.class_5151;
import net.minecraft.class_5699;
import net.minecraft.class_6880;
import net.minecraft.class_9274;
import net.minecraft.class_9285;
import net.minecraft.class_9334;
import net.minecraft.class_9335;

public record ArmourStatsGenerator(ArmourVariable<Integer> durability, ArmourVariable<Integer> protection, ArmourVariable<Double> armourToughness, ArmourVariable<Double> armourKbRes, boolean persistPrevious) implements PatchGenerator
{
    public static final Codec<Double> POSITIVE_DOUBLE = ArmourStatsGenerator.doubleMiniumumExclusiveWithMessage(0.0, double_ -> "Value must be positive: " + double_);
    public static final MapCodec<ArmourStatsGenerator> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ArmourVariable.codec(class_5699.field_33442).optionalFieldOf("max_damage", ArmourVariable.empty()).forGetter(ArmourStatsGenerator::durability), (App)ArmourVariable.codec(class_5699.field_33442).optionalFieldOf("armor", ArmourVariable.empty()).forGetter(ArmourStatsGenerator::protection), (App)ArmourVariable.codec(POSITIVE_DOUBLE).optionalFieldOf("armor_toughness", ArmourVariable.empty()).forGetter(ArmourStatsGenerator::armourToughness), (App)ArmourVariable.codec(POSITIVE_DOUBLE).optionalFieldOf("knockback_resistance", ArmourVariable.empty()).forGetter(ArmourStatsGenerator::armourKbRes), (App)Codec.BOOL.fieldOf("persist_previous").forGetter(ArmourStatsGenerator::persistPrevious)).apply((Applicative)instance, ArmourStatsGenerator::new));

    @Override
    public void patchDataComponentMap(class_1792 item, class_9335 patchedDataComponentMap) {
        Integer maxDamage = this.durability.getValue(item);
        if (maxDamage != null) {
            Defaulted.setDurability(maxDamage, patchedDataComponentMap);
        }
        Integer armor = this.protection.getValue(item);
        Double toughness = this.armourToughness.getValue(item);
        Double kbRes = this.armourKbRes.getValue(item);
        if (armor == null && toughness == null && kbRes == null) {
            return;
        }
        class_9285 oldModifiers = (class_9285)patchedDataComponentMap.method_57829(class_9334.field_49636);
        class_9285.class_9286 builder = class_9285.method_57480();
        ArrayList<class_6880> addedEntries = new ArrayList<class_6880>();
        String uuid = "2AD3F246-C118-495F-4726-6020A9A58B6B";
        class_9274 slotGroup = class_9274.field_49224;
        if (item instanceof class_5151) {
            class_5151 equipable = (class_5151)item;
            slotGroup = class_9274.method_59524((class_1304)equipable.method_7685());
        }
        switch (slotGroup) {
            case field_49223: {
                String string = "2AD3F246-FEE1-4E67-B886-69FD380BB150";
                break;
            }
            case field_49222: {
                String string = "9F3D476D-C118-4544-8365-64846904B48E";
                break;
            }
            case field_49221: {
                String string = "D8499B04-0E66-4726-AB29-64469D734E0D";
                break;
            }
            case field_49220: {
                String string = "845DB27C-C624-495F-8C9F-6020A9A58B6B";
                break;
            }
            case field_50127: {
                String string = "C1C72771-8B8E-BA4A-ACE0-81A93C8928B2";
                break;
            }
            default: {
                String string = uuid = uuid;
            }
        }
        if (armor != null) {
            addedEntries.add(class_5134.field_23724);
            builder.method_57487(class_5134.field_23724, new class_1322(uuid, (double)armor.intValue(), class_1322.class_1323.field_6328), slotGroup);
        }
        if (toughness != null) {
            addedEntries.add(class_5134.field_23725);
            if (toughness > 0.0) {
                builder.method_57487(class_5134.field_23725, new class_1322(uuid, toughness.doubleValue(), class_1322.class_1323.field_6328), slotGroup);
            }
        }
        if (kbRes != null) {
            addedEntries.add(class_5134.field_23718);
            if (kbRes > 0.0) {
                builder.method_57487(class_5134.field_23718, new class_1322(uuid, kbRes.doubleValue(), class_1322.class_1323.field_6328), slotGroup);
            }
        }
        if (this.persistPrevious && oldModifiers != null) {
            block7: for (class_9285.class_9287 entry : oldModifiers.comp_2393()) {
                for (class_6880 attribute : addedEntries) {
                    if (!ItemPatches.matches(entry, (class_6880<class_1320>)attribute, UUID.fromString(uuid))) continue;
                    continue block7;
                }
                builder.method_57487(entry.comp_2395(), entry.comp_2396(), entry.comp_2397());
            }
        }
        patchedDataComponentMap.method_57938(class_9334.field_49636, (Object)builder.method_57486());
    }

    @Override
    public MapCodec<? extends PatchGenerator> codec() {
        return CODEC;
    }

    public static Codec<Double> doubleMiniumumExclusiveWithMessage(double min, Function<Double, String> function) {
        return Codec.DOUBLE.validate(double_ -> double_.compareTo(min) > 0 ? DataResult.success((Object)double_) : DataResult.error(() -> (String)function.apply((Double)double_)));
    }
}

