/*
 * Decompiled with CFR 0.152.
 */
package net.atlas.defaulted.component.generators;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collections;
import java.util.List;
import net.atlas.defaulted.extension.LateBoundIdMapper;
import net.minecraft.class_2960;

public interface WeaponLevelBasedValue {
    public static final LateBoundIdMapper<class_2960, MapCodec<? extends WeaponLevelBasedValue>> ID_MAPPER = new LateBoundIdMapper();
    public static final Codec<WeaponLevelBasedValue> BASE_CODEC = ID_MAPPER.codec((Codec<class_2960>)class_2960.field_25139).dispatch(WeaponLevelBasedValue::codec, mapCodec -> mapCodec);
    public static final Codec<List<WeaponLevelBasedValue>> CODEC = Codec.withAlternative((Codec)BASE_CODEC.listOf(), (Codec)Codec.FLOAT.xmap(Unconditional::new, Unconditional::value), Collections::singletonList);

    public static void bootstrap() {
        ID_MAPPER.put(new class_2960("unconditional"), Unconditional.CODEC);
        ID_MAPPER.put(new class_2960("match_weapon_level"), MatchingLevel.CODEC);
    }

    public Float getResult(int var1, boolean var2);

    public MapCodec<? extends WeaponLevelBasedValue> codec();

    public record Unconditional(float value) implements WeaponLevelBasedValue
    {
        public static final MapCodec<Unconditional> CODEC = Codec.FLOAT.xmap(Unconditional::new, Unconditional::value).fieldOf("value");

        @Override
        public Float getResult(int weaponLevel, boolean applyTier) {
            return Float.valueOf(this.value);
        }

        @Override
        public MapCodec<? extends WeaponLevelBasedValue> codec() {
            return CODEC;
        }
    }

    public record MatchingLevel(float value, LevelCondition levelCondition) implements WeaponLevelBasedValue
    {
        public static final MapCodec<MatchingLevel> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.FLOAT.fieldOf("value").forGetter(MatchingLevel::value), (App)LevelCondition.CODEC.fieldOf("condition").forGetter(MatchingLevel::levelCondition)).apply((Applicative)instance, MatchingLevel::new));

        @Override
        public Float getResult(int weaponLevel, boolean applyTier) {
            return this.levelCondition.matches(weaponLevel) || !applyTier ? Float.valueOf(this.value) : null;
        }

        @Override
        public MapCodec<? extends WeaponLevelBasedValue> codec() {
            return CODEC;
        }
    }

    public record LevelCondition(int min, int max) {
        public static final Codec<LevelCondition> CODEC = Codec.withAlternative((Codec)RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("min").forGetter(LevelCondition::min), (App)Codec.INT.fieldOf("max").forGetter(LevelCondition::max)).apply((Applicative)instance, LevelCondition::new)), (Codec)Codec.INT, i -> new LevelCondition((int)i, (int)i));

        public boolean matches(int value) {
            return value >= this.min && value <= this.max;
        }
    }
}

