/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.escalated.walkways;

import com.simibubi.create.content.kinetics.base.KineticBlock;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.simpleRelays.AbstractSimpleShaftBlock;
import com.simibubi.create.content.kinetics.simpleRelays.ShaftBlock;
import com.simibubi.create.foundation.block.ProperWaterloggedBlock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import rbasamoyai.escalated.config.EscalatedConfigs;
import rbasamoyai.escalated.handrails.AbstractHandrailBlock;
import rbasamoyai.escalated.handrails.HandrailBlockEntity;
import rbasamoyai.escalated.index.EscalatedDataComponents;
import rbasamoyai.escalated.index.EscalatedTriggers;
import rbasamoyai.escalated.walkways.AbstractWalkwayBlock;
import rbasamoyai.escalated.walkways.NarrowEscalatorBlock;
import rbasamoyai.escalated.walkways.NarrowWalkwayBlock;
import rbasamoyai.escalated.walkways.WalkwayBlock;
import rbasamoyai.escalated.walkways.WalkwayBlockEntity;
import rbasamoyai.escalated.walkways.WalkwayCaps;
import rbasamoyai.escalated.walkways.WalkwaySlope;
import rbasamoyai.escalated.walkways.WalkwayTerminalBlock;

public class WalkwayConnectorItem
extends BlockItem {
    private final AbstractWalkwayBlock walkwayBlock;
    private final AbstractWalkwayBlock escalatorBlock;
    private final Set<Block> otherBlocks = new HashSet<Block>();

    public WalkwayConnectorItem(WalkwayTerminalBlock primaryBlock, Item.Properties properties, NarrowWalkwayBlock walkway, NarrowEscalatorBlock escalator, Block ... otherBlocks) {
        super((Block)primaryBlock, properties);
        this.walkwayBlock = walkway;
        this.otherBlocks.add((Block)this.walkwayBlock);
        this.escalatorBlock = escalator;
        this.otherBlocks.add((Block)this.escalatorBlock);
        this.otherBlocks.addAll(Arrays.asList(otherBlocks));
    }

    public String getDescriptionId() {
        return this.getOrCreateDescriptionId();
    }

    public InteractionResult useOn(UseOnContext context) {
        Player playerEntity = context.getPlayer();
        ItemStack heldStack = context.getItemInHand();
        if (playerEntity != null && playerEntity.isShiftKeyDown()) {
            heldStack.remove(EscalatedDataComponents.WALKWAY_FIRST_TERMINAL);
            return InteractionResult.SUCCESS;
        }
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        boolean validAxis = WalkwayConnectorItem.validateAxis(level, pos);
        if (level.isClientSide) {
            return validAxis ? InteractionResult.SUCCESS : InteractionResult.FAIL;
        }
        BlockPos firstTerminal = null;
        if (!(!heldStack.has(EscalatedDataComponents.WALKWAY_FIRST_TERMINAL) || WalkwayConnectorItem.validateAxis(level, firstTerminal = (BlockPos)heldStack.get(EscalatedDataComponents.WALKWAY_FIRST_TERMINAL)) && firstTerminal.closerThan((Vec3i)pos, (double)(this.maxWalkwayLength() * 2)))) {
            heldStack.remove(EscalatedDataComponents.WALKWAY_FIRST_TERMINAL);
        }
        if (!validAxis || playerEntity == null) {
            return InteractionResult.FAIL;
        }
        if (heldStack.has(EscalatedDataComponents.WALKWAY_FIRST_TERMINAL)) {
            if (!this.canConnect(level, firstTerminal, pos)) {
                return InteractionResult.FAIL;
            }
            if (firstTerminal != null && !firstTerminal.equals((Object)pos)) {
                this.createSteps(level, firstTerminal, pos);
                EscalatedTriggers.WALKWAY.tryAwardingTo(playerEntity);
                if (!playerEntity.isCreative()) {
                    context.getItemInHand().shrink(1);
                }
            }
            if (!context.getItemInHand().isEmpty()) {
                heldStack.remove(EscalatedDataComponents.WALKWAY_FIRST_TERMINAL);
                playerEntity.getCooldowns().addCooldown((Item)this, 5);
            }
            return InteractionResult.SUCCESS;
        }
        heldStack.set(EscalatedDataComponents.WALKWAY_FIRST_TERMINAL, (Object)pos);
        playerEntity.getCooldowns().addCooldown((Item)this, 5);
        return InteractionResult.SUCCESS;
    }

    public int maxWalkwayLength() {
        return (Integer)EscalatedConfigs.SERVER.maxWalkwayLength.get();
    }

    public int maxEscalatorHeight() {
        return (Integer)EscalatedConfigs.SERVER.maxEscalatorHeight.get();
    }

    public int maxWalkwayWidth() {
        return (Integer)EscalatedConfigs.SERVER.maxWalkwayWidth.get();
    }

    public int maxEscalatorWidth() {
        return (Integer)EscalatedConfigs.SERVER.maxEscalatorWidth.get();
    }

    public static boolean validateAxis(Level level, BlockPos pos) {
        BlockState state = level.getBlockState(pos);
        return level.isLoaded(pos) && (ShaftBlock.isShaft((BlockState)state) || state.getBlock() instanceof WalkwayBlock);
    }

    /*
     * WARNING - void declaration
     */
    public boolean canConnect(Level level, BlockPos first, BlockPos second) {
        KineticBlockEntity kbe;
        BlockEntity secondAxis22;
        boolean escalator;
        int y;
        BlockPos diff;
        Direction.Axis shaftAxis;
        block38: {
            block37: {
                if (!level.isLoaded(first) || !level.isLoaded(second)) {
                    return false;
                }
                BlockState firstState = level.getBlockState(first);
                BlockState secondState = level.getBlockState(second);
                shaftAxis = Direction.Axis.Y;
                if (ShaftBlock.isShaft((BlockState)firstState)) {
                    shaftAxis = (Direction.Axis)firstState.getValue((Property)BlockStateProperties.AXIS);
                } else {
                    KineticBlock kinetic;
                    Block block = firstState.getBlock();
                    if (block instanceof KineticBlock && (kinetic = (KineticBlock)block) instanceof WalkwayBlock) {
                        shaftAxis = kinetic.getRotationAxis(firstState);
                    }
                }
                if (shaftAxis == Direction.Axis.Y) {
                    return false;
                }
                diff = second.subtract((Vec3i)first);
                int x = diff.getX();
                y = diff.getY();
                int z = diff.getZ();
                boolean bl = escalator = y != 0;
                if (Math.abs(shaftAxis.choose(x, y, z)) == 1) {
                    void var21_38;
                    int MAX_WIDTH;
                    BlockPos actualDiff = new BlockPos(shaftAxis.choose(x, 0, 0), 0, shaftAxis.choose(0, 0, z));
                    if (!(ShaftBlock.isShaft((BlockState)firstState) && this.canExtendWalkwayBlock(secondState) || this.canExtendWalkwayBlock(firstState) && ShaftBlock.isShaft((BlockState)secondState))) {
                        return false;
                    }
                    boolean extendingEscalator = ShaftBlock.isShaft((BlockState)firstState) ? ((WalkwayBlock)secondState.getBlock()).isEscalator(level, secondState, second) : ((WalkwayBlock)firstState.getBlock()).isEscalator(level, firstState, first);
                    if (!extendingEscalator && y != 0) {
                        return false;
                    }
                    Direction.Axis secondAxis22 = Direction.Axis.Y;
                    if (ShaftBlock.isShaft((BlockState)secondState)) {
                        secondAxis22 = (Direction.Axis)secondState.getValue((Property)BlockStateProperties.AXIS);
                    } else {
                        Block block = secondState.getBlock();
                        if (block instanceof KineticBlock) {
                            KineticBlock kinetic = (KineticBlock)block;
                            secondAxis22 = kinetic.getRotationAxis(secondState);
                            actualDiff = actualDiff.multiply(-1);
                        }
                    }
                    if (shaftAxis != secondAxis22) {
                        return false;
                    }
                    List<Object> list = new ArrayList();
                    float matchSpeed = 0.0f;
                    int width = 1;
                    Object object = level.getBlockEntity(first);
                    if (object instanceof WalkwayBlockEntity) {
                        WalkwayBlockEntity walkwayBE = (WalkwayBlockEntity)((Object)object);
                        list = walkwayBE.getAllBlocks();
                        matchSpeed = walkwayBE.getTheoreticalSpeed();
                        width = walkwayBE.getWalkwayWidth();
                    } else {
                        object = level.getBlockEntity(second);
                        if (object instanceof WalkwayBlockEntity) {
                            WalkwayBlockEntity walkwayBE = (WalkwayBlockEntity)((Object)object);
                            list = walkwayBE.getAllBlocks();
                            matchSpeed = walkwayBE.getTheoreticalSpeed();
                            width = walkwayBE.getWalkwayWidth();
                        }
                    }
                    if (list.isEmpty()) {
                        return false;
                    }
                    int sz = list.size();
                    int y1 = ((BlockPos)list.get(0)).getY();
                    for (BlockPos blockPos : list) {
                        if (blockPos.getY() == y1) continue;
                        escalator = true;
                        break;
                    }
                    int n = MAX_WIDTH = escalator ? this.maxEscalatorWidth() : this.maxWalkwayWidth();
                    if (width >= MAX_WIDTH) {
                        return false;
                    }
                    boolean bl2 = false;
                    while (var21_38 < sz) {
                        BlockPos pos = (BlockPos)list.get((int)var21_38);
                        BlockPos destPos = pos.offset((Vec3i)actualDiff);
                        BlockState currentState = level.getBlockState(destPos);
                        boolean correctShaft = ShaftBlock.isShaft((BlockState)currentState) && currentState.getValue((Property)BlockStateProperties.AXIS) == shaftAxis;
                        boolean empty = currentState.canBeReplaced();
                        if ((var21_38 == false || var21_38 == sz - 1) && !correctShaft || !correctShaft && !empty) {
                            return false;
                        }
                        if (escalator && var21_38 != false && var21_38 != sz - 1 && !empty) {
                            return false;
                        }
                        if (correctShaft) {
                            void kbe2;
                            BlockEntity blockEntity = level.getBlockEntity(destPos);
                            if (!(blockEntity instanceof KineticBlockEntity)) {
                                return false;
                            }
                            KineticBlockEntity kbe22 = (KineticBlockEntity)blockEntity;
                            float speed2 = kbe2.getTheoreticalSpeed();
                            if (Math.signum(matchSpeed) != Math.signum(speed2) && matchSpeed != 0.0f && speed2 != 0.0f) {
                                return false;
                            }
                        }
                        ++var21_38;
                    }
                    return true;
                }
                if (escalator && Math.abs(second.getY() - first.getY()) > this.maxEscalatorHeight() || !escalator && !second.closerThan((Vec3i)first, (double)this.maxWalkwayLength())) {
                    return false;
                }
                if (shaftAxis.choose(x, y, z) != 0) {
                    return false;
                }
                if (escalator && Math.abs(x) != Math.abs(y) + 3 && Math.abs(z) != Math.abs(y) + 3) {
                    return false;
                }
                if (!(escalator || Math.abs(x) != 1 && Math.abs(z) != 1)) {
                    return false;
                }
                if (!ShaftBlock.isShaft((BlockState)firstState) || !ShaftBlock.isShaft((BlockState)secondState) || shaftAxis != secondState.getValue((Property)BlockStateProperties.AXIS)) {
                    return false;
                }
                secondAxis22 = level.getBlockEntity(first);
                if (!(secondAxis22 instanceof KineticBlockEntity)) break block37;
                kbe = (KineticBlockEntity)secondAxis22;
                secondAxis22 = level.getBlockEntity(second);
                if (secondAxis22 instanceof KineticBlockEntity) break block38;
            }
            return false;
        }
        KineticBlockEntity kbe1 = (KineticBlockEntity)secondAxis22;
        float speed1 = kbe.getTheoreticalSpeed();
        float speed2 = kbe1.getTheoreticalSpeed();
        if (Math.signum(speed1) != Math.signum(speed2) && speed1 != 0.0f && speed2 != 0.0f) {
            return false;
        }
        BlockPos step = BlockPos.containing((double)Math.signum(diff.getX()), (double)Math.signum(diff.getY()), (double)Math.signum(diff.getZ()));
        if (escalator) {
            boolean firstLower = y > 0;
            BlockPos lowerPos = firstLower ? first : second;
            BlockPos upperPos = firstLower ? second : first;
            int sgn = firstLower ? 1 : -1;
            ArrayList<BlockPos> arrayList = new ArrayList<BlockPos>();
            lowerPos = lowerPos.offset(sgn * step.getX(), 0, sgn * step.getZ());
            arrayList.add(lowerPos);
            arrayList.add(upperPos.offset(sgn * -step.getX(), 0, sgn * -step.getZ()));
            upperPos = upperPos.offset(sgn * -step.getX() * 2, 0, sgn * -step.getZ() * 2);
            arrayList.add(upperPos);
            for (BlockPos pos : arrayList) {
                BlockState blockState = level.getBlockState(pos);
                if (ShaftBlock.isShaft((BlockState)blockState) && blockState.getValue((Property)AbstractSimpleShaftBlock.AXIS) == shaftAxis && (pos.equals((Object)lowerPos) || pos.equals((Object)upperPos)) || blockState.canBeReplaced()) continue;
                return false;
            }
            first = firstLower ? lowerPos : upperPos;
            second = firstLower ? upperPos : lowerPos;
        }
        int LIMIT = 1000;
        BlockPos currentPos = first.offset((Vec3i)step);
        while (!currentPos.equals((Object)second) && LIMIT-- > 0) {
            BlockState blockState = level.getBlockState(currentPos);
            if (!(!escalator && ShaftBlock.isShaft((BlockState)blockState) && blockState.getValue((Property)AbstractSimpleShaftBlock.AXIS) == shaftAxis || blockState.canBeReplaced())) {
                return false;
            }
            currentPos = currentPos.offset((Vec3i)step);
        }
        return true;
    }

    public void createSteps(Level level, BlockPos start, BlockPos end) {
        level.playSound(null, BlockPos.containing((Position)VecHelper.getCenterOf((Vec3i)start.offset((Vec3i)end)).scale(0.5)), this.getPlaceSoundEvent(), SoundSource.BLOCKS, 0.5f, 1.0f);
        BlockPos diff = end.subtract((Vec3i)start);
        int x = diff.getX();
        int y = diff.getY();
        int z = diff.getZ();
        boolean escalator = y != 0;
        BlockState firstState = level.getBlockState(start);
        Direction.Axis shaftAxis = Direction.Axis.Y;
        if (ShaftBlock.isShaft((BlockState)firstState)) {
            shaftAxis = (Direction.Axis)firstState.getValue((Property)BlockStateProperties.AXIS);
        } else {
            KineticBlock kinetic;
            Block block = firstState.getBlock();
            if (block instanceof KineticBlock && (kinetic = (KineticBlock)block) instanceof WalkwayBlock) {
                shaftAxis = kinetic.getRotationAxis(firstState);
            }
        }
        if (shaftAxis == Direction.Axis.Y) {
            return;
        }
        if (Math.abs(shaftAxis.choose(x, y, z)) == 1) {
            BlockState aboveSrcState;
            BlockPos aboveSrcPos;
            BlockPos destPos;
            BlockPos srcPos;
            int i;
            BlockPos actualDiff = new BlockPos(shaftAxis.choose(x, 0, 0), 0, shaftAxis.choose(0, 0, z));
            List<Object> list = new ArrayList();
            BlockPos referencePos = start;
            BlockEntity blockEntity = level.getBlockEntity(start);
            if (blockEntity instanceof WalkwayBlockEntity) {
                WalkwayBlockEntity walkwayBE = (WalkwayBlockEntity)blockEntity;
                list = walkwayBE.getAllBlocks();
                referencePos = walkwayBE.widthReferencePos;
            } else {
                blockEntity = level.getBlockEntity(end);
                if (blockEntity instanceof WalkwayBlockEntity) {
                    WalkwayBlockEntity walkwayBE = (WalkwayBlockEntity)blockEntity;
                    list = walkwayBE.getAllBlocks();
                    actualDiff = actualDiff.multiply(-1);
                    referencePos = walkwayBE.widthReferencePos;
                }
            }
            if (list.isEmpty()) {
                return;
            }
            Collections.reverse(list);
            int sz = list.size();
            Direction face = Direction.getNearest((float)actualDiff.getX(), (float)actualDiff.getY(), (float)actualDiff.getZ());
            for (i = 0; i < sz; ++i) {
                boolean left;
                srcPos = (BlockPos)list.get(i);
                destPos = srcPos.offset((Vec3i)actualDiff);
                BlockState srcState = level.getBlockState(srcPos);
                BlockState destState = level.getBlockState(destPos);
                boolean isShaft = ShaftBlock.isShaft((BlockState)destState);
                Block block = srcState.getBlock();
                if (!(block instanceof WalkwayBlock)) continue;
                WalkwayBlock walkwaySrc = (WalkwayBlock)block;
                block = level.getBlockEntity(srcPos);
                if (!(block instanceof WalkwayBlockEntity)) continue;
                WalkwayBlockEntity walkwayBE = (WalkwayBlockEntity)block;
                DyeColor color = walkwayBE.getColor();
                float visualProgress = walkwayBE.getVisualProgress();
                Direction walkwayFacing = walkwaySrc.getFacing(srcState);
                boolean bl = left = walkwayFacing.getCounterClockWise() == face;
                if (i == 0 || i == sz - 1) {
                    left = !left;
                }
                boolean srcShaft = walkwaySrc.hasWalkwayShaft(srcState);
                BlockState replaceSrcState = walkwaySrc.transformFromMerge(level, srcState, srcPos, left, srcShaft, false, true);
                BlockState placeState = walkwaySrc.transformFromMerge(level, srcState, srcPos, !left, isShaft, false, false);
                KineticBlockEntity.switchToBlockState((Level)level, (BlockPos)srcPos, (BlockState)replaceSrcState);
                KineticBlockEntity.switchToBlockState((Level)level, (BlockPos)destPos, (BlockState)placeState);
                BlockEntity blockEntity2 = level.getBlockEntity(srcPos);
                if (blockEntity2 instanceof WalkwayBlockEntity) {
                    WalkwayBlockEntity newWalkwayBE = (WalkwayBlockEntity)blockEntity2;
                    newWalkwayBE.applyColor(color);
                    newWalkwayBE.setVisualProgress(visualProgress);
                    newWalkwayBE.widthReferencePos = referencePos;
                    newWalkwayBE.resetClientRender = true;
                    newWalkwayBE.notifyUpdate();
                }
                if (!((blockEntity2 = level.getBlockEntity(destPos)) instanceof WalkwayBlockEntity)) continue;
                WalkwayBlockEntity destWalkwayBE = (WalkwayBlockEntity)blockEntity2;
                destWalkwayBE.applyColor(color);
                destWalkwayBE.setVisualProgress(visualProgress);
                destWalkwayBE.widthReferencePos = referencePos;
                destWalkwayBE.resetClientRender = true;
                destWalkwayBE.notifyUpdate();
            }
            for (i = 0; i < sz; ++i) {
                BlockPos aboveDestPos;
                srcPos = (BlockPos)list.get(i);
                destPos = srcPos.offset((Vec3i)actualDiff);
                aboveSrcPos = srcPos.above();
                aboveSrcState = level.getBlockState(aboveSrcPos);
                if (!(aboveSrcState.getBlock() instanceof AbstractHandrailBlock) || level.getBlockState(aboveDestPos = destPos.above()).canBeReplaced()) continue;
                level.destroyBlock(aboveSrcPos, true);
                return;
            }
            for (i = 0; i < sz; ++i) {
                BlockPos oppositePos;
                BlockEntity blockEntity3;
                HandrailBlockEntity handrailBE;
                AbstractHandrailBlock.Side srcSide;
                srcPos = (BlockPos)list.get(i);
                destPos = srcPos.offset((Vec3i)actualDiff);
                aboveSrcPos = srcPos.above();
                aboveSrcState = level.getBlockState(aboveSrcPos);
                if (!(aboveSrcState.getBlock() instanceof AbstractHandrailBlock)) continue;
                BlockPos aboveDestPos = destPos.above();
                int width = 1;
                Direction forward = (Direction)aboveSrcState.getValue((Property)AbstractHandrailBlock.FACING);
                Direction handrailLeft = forward.getCounterClockWise();
                if (aboveSrcState.getValue(AbstractHandrailBlock.SIDE) == AbstractHandrailBlock.Side.BOTH) {
                    AbstractHandrailBlock.Side destSide = face == handrailLeft ? AbstractHandrailBlock.Side.LEFT : AbstractHandrailBlock.Side.RIGHT;
                    srcSide = destSide == AbstractHandrailBlock.Side.LEFT ? AbstractHandrailBlock.Side.RIGHT : AbstractHandrailBlock.Side.LEFT;
                    level.setBlock(aboveSrcPos, ProperWaterloggedBlock.withWater((LevelAccessor)level, (BlockState)((BlockState)aboveSrcState.setValue(AbstractHandrailBlock.SIDE, (Comparable)((Object)srcSide))), (BlockPos)aboveSrcPos), 3);
                    level.setBlock(aboveDestPos, ProperWaterloggedBlock.withWater((LevelAccessor)level, (BlockState)((BlockState)aboveSrcState.setValue(AbstractHandrailBlock.SIDE, (Comparable)((Object)destSide))), (BlockPos)aboveDestPos), 3);
                } else {
                    level.setBlock(aboveDestPos, ProperWaterloggedBlock.withWater((LevelAccessor)level, (BlockState)aboveSrcState, (BlockPos)aboveDestPos), 3);
                    srcSide = level.getBlockEntity(aboveSrcPos);
                    if (srcSide instanceof HandrailBlockEntity) {
                        handrailBE = (HandrailBlockEntity)((Object)srcSide);
                        handrailBE.propagateBreak = false;
                        width = handrailBE.width;
                    }
                    level.setBlock(aboveSrcPos, ProperWaterloggedBlock.withWater((LevelAccessor)level, (BlockState)Blocks.AIR.defaultBlockState(), (BlockPos)aboveSrcPos), 3);
                }
                ++width;
                srcSide = level.getBlockEntity(aboveDestPos);
                if (srcSide instanceof HandrailBlockEntity) {
                    handrailBE = (HandrailBlockEntity)((Object)srcSide);
                    handrailBE.width = width;
                }
                if (!((blockEntity3 = level.getBlockEntity(oppositePos = aboveDestPos.relative(face.getOpposite(), width - 1))) instanceof HandrailBlockEntity)) continue;
                HandrailBlockEntity handrailBE2 = (HandrailBlockEntity)blockEntity3;
                handrailBE2.width = width;
            }
            return;
        }
        Direction facing = WalkwayConnectorItem.getFacingFromTo(start, end);
        KineticBlockEntity.switchToBlockState((Level)level, (BlockPos)start, (BlockState)((BlockState)this.getBlock().defaultBlockState().setValue(WalkwayTerminalBlock.HORIZONTAL_FACING, (Comparable)facing)));
        KineticBlockEntity.switchToBlockState((Level)level, (BlockPos)end, (BlockState)((BlockState)this.getBlock().defaultBlockState().setValue(WalkwayTerminalBlock.HORIZONTAL_FACING, (Comparable)facing.getOpposite())));
        List<BlockPos> walkwaysToCreate = WalkwayConnectorItem.getWalkwayChainBetween(start, end, escalator, facing);
        if (escalator && end.subtract((Vec3i)start).getY() <= 0) {
            facing = facing.getOpposite();
        }
        boolean failed = false;
        for (BlockPos pos : walkwaysToCreate) {
            BlockState existingBlock = level.getBlockState(pos);
            if (existingBlock.getDestroySpeed((BlockGetter)level, pos) == -1.0f) {
                failed = true;
                break;
            }
            BlockState shaftState = level.getBlockState(pos);
            boolean existingShaft = ShaftBlock.isShaft((BlockState)shaftState);
            if (!existingBlock.canBeReplaced()) {
                level.destroyBlock(pos, false);
            }
            BlockState placeState = this.getPlacedWalkwayBlock(escalator, facing, existingShaft);
            KineticBlockEntity.switchToBlockState((Level)level, (BlockPos)pos, (BlockState)placeState);
        }
        if (!failed) {
            if (escalator) {
                boolean firstLower = end.subtract((Vec3i)start).getY() > 0;
                BlockPos lowerPos = firstLower ? start : end;
                BlockPos upperPos = firstLower ? end : start;
                BlockPos horizontalPos = upperPos.relative(facing, -1);
                BlockState horizontalState = level.getBlockState(horizontalPos);
                KineticBlockEntity.switchToBlockState((Level)level, (BlockPos)horizontalPos, (BlockState)((BlockState)horizontalState.setValue(WalkwayBlock.SLOPE, (Comparable)((Object)WalkwaySlope.HORIZONTAL))));
                BlockPos topPos = upperPos.relative(facing, -2);
                BlockState topState = level.getBlockState(topPos);
                KineticBlockEntity.switchToBlockState((Level)level, (BlockPos)topPos, (BlockState)((BlockState)topState.setValue(WalkwayBlock.SLOPE, (Comparable)((Object)WalkwaySlope.TOP))));
                BlockPos bottomPos = lowerPos.relative(facing);
                BlockState bottomState = level.getBlockState(bottomPos);
                KineticBlockEntity.switchToBlockState((Level)level, (BlockPos)bottomPos, (BlockState)((BlockState)bottomState.setValue(WalkwayBlock.SLOPE, (Comparable)((Object)WalkwaySlope.BOTTOM))));
            }
            return;
        }
        for (BlockPos pos : walkwaysToCreate) {
            BlockState failedState = level.getBlockState(pos);
            if (!(failedState.getBlock() instanceof WalkwayBlock)) continue;
            level.destroyBlock(pos, false);
        }
    }

    protected BlockState getPlacedWalkwayBlock(boolean escalator, Direction facing, boolean shaft) {
        if (escalator) {
            return (BlockState)((BlockState)this.escalatorBlock.defaultBlockState().setValue((Property)AbstractWalkwayBlock.SLOPE, (Comparable)((Object)WalkwaySlope.MIDDLE))).setValue(AbstractWalkwayBlock.HORIZONTAL_FACING, (Comparable)facing);
        }
        return (BlockState)((BlockState)this.walkwayBlock.defaultBlockState().setValue(AbstractWalkwayBlock.HORIZONTAL_FACING, (Comparable)facing)).setValue(WalkwayBlock.CAPS, (Comparable)((Object)(shaft ? WalkwayCaps.NONE : WalkwayCaps.NO_SHAFT)));
    }

    protected SoundEvent getPlaceSoundEvent() {
        return SoundEvents.CHAIN_PLACE;
    }

    private static Direction getFacingFromTo(BlockPos start, BlockPos end) {
        Direction.Axis beltAxis = start.getX() == end.getX() ? Direction.Axis.Z : Direction.Axis.X;
        BlockPos diff = end.subtract((Vec3i)start);
        Direction.AxisDirection axisDirection = beltAxis.choose(diff.getX(), 0, diff.getZ()) > 0 ? Direction.AxisDirection.POSITIVE : Direction.AxisDirection.NEGATIVE;
        return Direction.get((Direction.AxisDirection)axisDirection, (Direction.Axis)beltAxis);
    }

    private static List<BlockPos> getWalkwayChainBetween(BlockPos start, BlockPos end, boolean escalator, Direction direction) {
        LinkedList<BlockPos> positions = new LinkedList<BlockPos>();
        int limit = 1000;
        if (escalator) {
            BlockPos upperPos;
            boolean firstLower = end.subtract((Vec3i)start).getY() > 0;
            BlockPos lowerPos = firstLower ? start : end;
            BlockPos blockPos = upperPos = firstLower ? end : start;
            if (!firstLower) {
                direction = direction.getOpposite();
            }
            positions.add(upperPos.relative(direction, -1));
            positions.add(upperPos.relative(direction, -2));
            start = lowerPos.relative(direction);
            end = upperPos.relative(direction, -2);
        }
        BlockPos current = start;
        do {
            positions.add(current);
            current = current.relative(direction);
            if (!escalator) continue;
            current = current.above();
        } while (!current.equals((Object)end) && limit-- > 0);
        if (!escalator) {
            positions.remove(start);
        }
        return positions;
    }

    public void registerBlocks(Map<Block, Item> map, Item item) {
        super.registerBlocks(map, item);
        for (Block b : this.otherBlocks) {
            map.put(b, item);
        }
    }

    protected boolean canExtendWalkwayBlock(BlockState state) {
        return state.is(this.getBlock()) || this.otherBlocks.contains(state.getBlock());
    }
}

