/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.escalated.handrails;

import com.simibubi.create.foundation.block.IBE;
import com.simibubi.create.foundation.block.ProperWaterloggedBlock;
import java.util.Locale;
import net.createmod.catnip.data.Iterate;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2383;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_3542;
import net.minecraft.class_3610;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import rbasamoyai.escalated.handrails.HandrailBlockEntity;
import rbasamoyai.escalated.index.EscalatedBlockEntities;
import rbasamoyai.escalated.walkways.WalkwayHelper;
import rbasamoyai.escalated.walkways.WalkwaySlope;

public abstract class AbstractHandrailBlock
extends class_2383
implements IBE<HandrailBlockEntity>,
ProperWaterloggedBlock {
    public static final class_2754<Side> SIDE = class_2754.method_11850((String)"side", Side.class);
    public static final class_2746 WATERLOGGED = class_2741.field_12508;

    protected AbstractHandrailBlock(class_4970.class_2251 properties) {
        super(properties);
        this.method_9590((class_2680)((class_2680)this.method_9595().method_11664()).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(new class_2769[]{field_11177, SIDE, WATERLOGGED});
    }

    public void method_9536(class_2680 state, class_1937 level, class_2338 pos, class_2680 newState, boolean isMoving) {
        int width = 1;
        boolean propagateBreak = true;
        class_2586 class_25862 = level.method_8321(pos);
        if (class_25862 instanceof HandrailBlockEntity) {
            HandrailBlockEntity handrailBlockEntity = (HandrailBlockEntity)class_25862;
            width = handrailBlockEntity.width;
            propagateBreak = handrailBlockEntity.propagateBreak;
        }
        super.method_9536(state, level, pos, newState, isMoving);
        if (level.field_9236 || !propagateBreak || state.method_26204() == newState.method_26204() || isMoving) {
            return;
        }
        for (boolean forward : Iterate.trueAndFalse) {
            class_2680 otherState;
            class_2338 otherPos = AbstractHandrailBlock.nextSegmentPosition(state, pos, forward);
            if (otherPos == null || !((otherState = level.method_8320(otherPos)).method_26204() instanceof AbstractHandrailBlock)) continue;
            class_2586 class_25863 = level.method_8321(otherPos);
            if (class_25863 instanceof HandrailBlockEntity) {
                HandrailBlockEntity handrailBE = (HandrailBlockEntity)class_25863;
                handrailBE.width = width;
            }
            level.method_8652(otherPos, ProperWaterloggedBlock.withWater((class_1936)level, (class_2680)class_2246.field_10124.method_9564(), (class_2338)otherPos), 3);
            level.method_20290(2001, otherPos, class_2248.method_9507((class_2680)otherState));
        }
        Side side = (Side)((Object)state.method_11654(SIDE));
        if (side != Side.BOTH && width > 1) {
            class_2350 dir = (class_2350)state.method_11654((class_2769)field_11177);
            class_2350 checkDir = side == Side.LEFT ? dir.method_10170() : dir.method_10160();
            class_2338 otherPos = pos.method_10079(checkDir, width - 1);
            class_2586 class_25864 = level.method_8321(otherPos);
            if (class_25864 instanceof HandrailBlockEntity) {
                HandrailBlockEntity handrailBE = (HandrailBlockEntity)class_25864;
                handrailBE.width = 0;
            }
            level.method_8652(otherPos, ProperWaterloggedBlock.withWater((class_1936)level, (class_2680)class_2246.field_10124.method_9564(), (class_2338)otherPos), 3);
            level.method_20290(2001, otherPos, class_2248.method_9507((class_2680)level.method_8320(otherPos)));
        }
    }

    public abstract class_2680 getStateForSlope(class_1937 var1, class_2338 var2, class_2680 var3, class_2338 var4, class_2350 var5, WalkwaySlope var6, Side var7);

    public Class<HandrailBlockEntity> getBlockEntityClass() {
        return HandrailBlockEntity.class;
    }

    public class_2591<? extends HandrailBlockEntity> getBlockEntityType() {
        return (class_2591)EscalatedBlockEntities.HANDRAIL.get();
    }

    public abstract WalkwaySlope getHandrailSlope(class_2680 var1);

    public abstract boolean isEndHandrail(class_2680 var1);

    public class_3610 method_9545(class_2680 blockState) {
        return this.fluidState(blockState);
    }

    public class_1269 method_9534(class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hitResult) {
        if (player.method_5715() || !player.method_7294()) {
            return class_1269.field_5811;
        }
        class_1799 heldItem = player.method_5998(hand);
        boolean isDye = WalkwayHelper.isDye(heldItem);
        boolean hasWater = WalkwayHelper.hasWater(level, heldItem);
        if (isDye || hasWater) {
            return this.onBlockEntityUse((class_1922)level, pos, be -> be.setHandrailColor(WalkwayHelper.getDyeColorFromItem(heldItem)) ? class_1269.field_5812 : class_1269.field_5811);
        }
        boolean isGlass = heldItem.method_31574(class_2246.field_10033.method_8389());
        if (isGlass && this.canConvertToGlassHandrail()) {
            this.convertToGlass(state, level, pos);
            return class_1269.field_5812;
        }
        return super.method_9534(state, level, pos, player, hand, hitResult);
    }

    protected void convertToGlass(class_2680 state, class_1937 level, class_2338 pos) {
        class_2350 class_23502;
        class_2338 offsetPos;
        class_2586 class_25862;
        HandrailBlockEntity handrailBE;
        if (level.field_9236) {
            return;
        }
        int MAX_ITER = 1100;
        class_2350 facing = (class_2350)state.method_11654((class_2769)field_11177);
        class_2350 left = facing.method_10160();
        Side side = (Side)((Object)state.method_11654(SIDE));
        int width = 1;
        class_1767 color = null;
        class_2586 class_25863 = level.method_8321(pos);
        if (class_25863 instanceof HandrailBlockEntity) {
            handrailBE = (HandrailBlockEntity)class_25863;
            width = handrailBE.width;
            color = handrailBE.getHandrailColor();
            handrailBE.propagateBreak = false;
        }
        level.method_8652(pos, this.getGlassHandrail(state), 3);
        class_2586 class_25864 = level.method_8321(pos);
        if (class_25864 instanceof HandrailBlockEntity) {
            handrailBE = (HandrailBlockEntity)class_25864;
            handrailBE.width = width;
        }
        class_2338 offset = class_2338.field_10980;
        if (width > 1 && (class_25862 = level.method_8321(offsetPos = pos.method_10081((class_2382)(offset = class_2338.field_10980.method_10079(class_23502 = side == Side.LEFT ? left.method_10153() : left, width - 1))))) instanceof HandrailBlockEntity) {
            HandrailBlockEntity handrailBE2 = (HandrailBlockEntity)class_25862;
            handrailBE2.propagateBreak = false;
            level.method_8652(offsetPos, this.getGlassHandrail(level.method_8320(offsetPos)), 3);
            class_2586 class_25865 = level.method_8321(offsetPos);
            if (class_25865 instanceof HandrailBlockEntity) {
                HandrailBlockEntity handrailBE1 = (HandrailBlockEntity)class_25865;
                handrailBE1.width = width;
            }
        }
        for (boolean forward : Iterate.trueAndFalse) {
            class_2338 iterPos = pos;
            class_2680 iterState = state;
            for (int i = 0; i < MAX_ITER && (iterPos = AbstractHandrailBlock.nextSegmentPosition(iterState, iterPos, forward)) != null && (iterState = level.method_8320(iterPos)).method_26204() instanceof AbstractHandrailBlock; ++i) {
                class_2586 class_25866;
                class_2586 class_25867 = level.method_8321(iterPos);
                if (class_25867 instanceof HandrailBlockEntity) {
                    HandrailBlockEntity other = (HandrailBlockEntity)class_25867;
                    other.propagateBreak = false;
                    level.method_8652(iterPos, this.getGlassHandrail(iterState), 3);
                    class_25866 = level.method_8321(iterPos);
                    if (class_25866 instanceof HandrailBlockEntity) {
                        HandrailBlockEntity other1 = (HandrailBlockEntity)class_25866;
                        other1.width = width;
                    }
                }
                class_2338 offsetPos2 = iterPos.method_10081((class_2382)offset);
                if (width <= 1 || !((class_25866 = level.method_8321(offsetPos2)) instanceof HandrailBlockEntity)) continue;
                HandrailBlockEntity other = (HandrailBlockEntity)class_25866;
                other.propagateBreak = false;
                level.method_8652(offsetPos2, this.getGlassHandrail(level.method_8320(offsetPos2)), 3);
                class_2586 class_25868 = level.method_8321(offsetPos2);
                if (!(class_25868 instanceof HandrailBlockEntity)) continue;
                HandrailBlockEntity other1 = (HandrailBlockEntity)class_25868;
                other1.width = width;
            }
        }
        class_2586 class_25869 = level.method_8321(pos);
        if (class_25869 instanceof HandrailBlockEntity) {
            HandrailBlockEntity handrailBlockEntity = (HandrailBlockEntity)class_25869;
            handrailBlockEntity.setHandrailColor(color);
        }
    }

    protected abstract boolean canConvertToGlassHandrail();

    protected abstract class_2680 getGlassHandrail(class_2680 var1);

    public static class_2338 nextSegmentPosition(class_2680 state, class_2338 pos, boolean forward) {
        int offset;
        AbstractHandrailBlock handrail = (AbstractHandrailBlock)state.method_26204();
        class_2350 direction = (class_2350)state.method_11654((class_2769)field_11177);
        WalkwaySlope slope = handrail.getHandrailSlope(state);
        boolean isEnd = handrail.isEndHandrail(state);
        int n = offset = forward ? 1 : -1;
        if (slope == WalkwaySlope.TERMINAL && isEnd == forward) {
            return null;
        }
        pos = pos.method_10079(direction, offset);
        if (slope == WalkwaySlope.MIDDLE) {
            return pos.method_10086(offset);
        }
        if (slope == WalkwaySlope.TOP && !forward) {
            return pos.method_10074();
        }
        if (slope == WalkwaySlope.BOTTOM && forward) {
            return pos.method_10084();
        }
        return pos;
    }

    public static enum Side implements class_3542
    {
        LEFT,
        RIGHT,
        BOTH;

        private final String id = this.name().toLowerCase(Locale.ROOT);

        public String method_15434() {
            return this.id;
        }
    }
}

