/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.escalated.handrails;

import dev.engine_room.flywheel.api.instance.Instance;
import dev.engine_room.flywheel.api.instance.Instancer;
import dev.engine_room.flywheel.api.visual.DynamicVisual;
import dev.engine_room.flywheel.api.visualization.VisualizationContext;
import dev.engine_room.flywheel.lib.instance.FlatLit;
import dev.engine_room.flywheel.lib.model.Models;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import dev.engine_room.flywheel.lib.visual.AbstractBlockEntityVisual;
import dev.engine_room.flywheel.lib.visual.SimpleDynamicVisual;
import java.util.function.Consumer;
import net.createmod.catnip.render.SpriteShiftEntry;
import net.minecraft.class_1767;
import net.minecraft.class_2246;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import org.jetbrains.annotations.Nullable;
import rbasamoyai.escalated.handrails.AbstractHandrailBlock;
import rbasamoyai.escalated.handrails.HandrailBlockEntity;
import rbasamoyai.escalated.handrails.HandrailInstance;
import rbasamoyai.escalated.handrails.HandrailRenderer;
import rbasamoyai.escalated.index.EscalatedInstanceTypes;
import rbasamoyai.escalated.walkways.WalkwaySlope;

public class HandrailVisual
extends AbstractBlockEntityVisual<HandrailBlockEntity>
implements SimpleDynamicVisual {
    protected final HandrailInstance leftHandrail;
    protected final HandrailInstance rightHandrail;
    private final class_2350 facing;
    private float v0;
    private float v1;
    private class_1767 handrailColor;

    public HandrailVisual(VisualizationContext ctx, HandrailBlockEntity blockEntity, float partialTick) {
        super(ctx, (class_2586)blockEntity, partialTick);
        AbstractHandrailBlock.Side side = (AbstractHandrailBlock.Side)((Object)this.blockState.method_11654(AbstractHandrailBlock.SIDE));
        this.facing = (class_2350)this.blockState.method_11654((class_2769)AbstractHandrailBlock.field_11177);
        this.handrailColor = ((HandrailBlockEntity)this.blockEntity).getHandrailColor();
        SpriteShiftEntry spriteShift = HandrailRenderer.getSpriteShift(this.handrailColor);
        this.v0 = spriteShift.getTarget().method_4593();
        this.v1 = spriteShift.getTarget().method_4575();
        Instancer<HandrailInstance> instancer = this.getHandrailInstancer();
        this.leftHandrail = side == AbstractHandrailBlock.Side.LEFT || side == AbstractHandrailBlock.Side.BOTH ? this.setup((HandrailInstance)instancer.createInstance(), true, spriteShift) : (HandrailInstance)this.getEmptyHandrailInstancer().createInstance();
        this.rightHandrail = side == AbstractHandrailBlock.Side.RIGHT || side == AbstractHandrailBlock.Side.BOTH ? this.setup((HandrailInstance)instancer.createInstance(), false, spriteShift) : (HandrailInstance)this.getEmptyHandrailInstancer().createInstance();
    }

    private Instancer<HandrailInstance> getHandrailInstancer() {
        AbstractHandrailBlock handrail = (AbstractHandrailBlock)this.blockState.method_26204();
        WalkwaySlope slope = handrail.getHandrailSlope(this.blockState);
        boolean end = handrail.isEndHandrail(this.blockState);
        return this.instancerProvider().instancer(EscalatedInstanceTypes.HANDRAIL, Models.partial((PartialModel)HandrailRenderer.getHandrailModel(slope, end), (class_2350)this.facing.method_10153()));
    }

    private Instancer<HandrailInstance> getEmptyHandrailInstancer() {
        return this.instancerProvider().instancer(EscalatedInstanceTypes.HANDRAIL, Models.block((class_2680)class_2246.field_10124.method_9564()));
    }

    private void resetHandrailTexture() {
        AbstractHandrailBlock.Side side = (AbstractHandrailBlock.Side)((Object)this.blockState.method_11654(AbstractHandrailBlock.SIDE));
        SpriteShiftEntry spriteShift = HandrailRenderer.getSpriteShift(this.handrailColor);
        this.v0 = spriteShift.getTarget().method_4593();
        this.v1 = spriteShift.getTarget().method_4575();
        if (side == AbstractHandrailBlock.Side.LEFT || side == AbstractHandrailBlock.Side.BOTH) {
            this.leftHandrail.setScrollTexture(spriteShift).setChanged();
        }
        if (side == AbstractHandrailBlock.Side.RIGHT || side == AbstractHandrailBlock.Side.BOTH) {
            this.rightHandrail.setScrollTexture(spriteShift).setChanged();
        }
    }

    private HandrailInstance setup(HandrailInstance data, boolean left, SpriteShiftEntry spriteShift) {
        class_2350 offset = left ? this.facing.method_10160() : this.facing.method_10170();
        data.setScrollTexture(spriteShift).setScrollOffset(0.0f).position((class_2382)this.getVisualPosition()).translatePosition((float)(offset.method_10148() * 7) / 16.0f, 0.0f, (float)(offset.method_10165() * 7) / 16.0f);
        return data;
    }

    public void beginFrame(DynamicVisual.Context ctx) {
        float partialTick = ctx.partialTick();
        float scroll = HandrailRenderer.getScrollOffset((HandrailBlockEntity)this.blockEntity, partialTick, this.facing, this.v0, this.v1);
        this.leftHandrail.setScrollOffset(scroll).setChanged();
        this.rightHandrail.setScrollOffset(scroll).setChanged();
    }

    public void update(float partialTick) {
        super.update(partialTick);
        if (((HandrailBlockEntity)this.blockEntity).getHandrailColor() != this.handrailColor) {
            this.handrailColor = ((HandrailBlockEntity)this.blockEntity).getHandrailColor();
            this.resetHandrailTexture();
        }
    }

    public void updateLight(float partialTick) {
        this.relight(this.pos, new FlatLit[]{this.leftHandrail});
        this.relight(this.pos, new FlatLit[]{this.rightHandrail});
    }

    protected void _delete() {
        this.leftHandrail.delete();
        this.rightHandrail.delete();
    }

    public void collectCrumblingInstances(Consumer<@Nullable Instance> consumer) {
        consumer.accept((Instance)this.leftHandrail);
        consumer.accept((Instance)this.rightHandrail);
    }
}

