/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.escalated.walkways;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.equipment.armor.DivingBootsItem;
import com.simibubi.create.content.kinetics.base.HorizontalKineticBlock;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.foundation.block.IBE;
import com.simibubi.create.foundation.block.ProperWaterloggedBlock;
import com.tterrag.registrate.util.nullness.NonNullSupplier;
import java.util.ArrayList;
import java.util.List;
import net.createmod.catnip.data.Iterate;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_8567;
import rbasamoyai.escalated.config.EscalatedConfigs;
import rbasamoyai.escalated.handrails.AbstractHandrailBlock;
import rbasamoyai.escalated.handrails.HandrailBlockEntity;
import rbasamoyai.escalated.index.EscalatedBlockEntities;
import rbasamoyai.escalated.index.EscalatedTriggers;
import rbasamoyai.escalated.walkways.WalkwayBlock;
import rbasamoyai.escalated.walkways.WalkwayBlockEntity;
import rbasamoyai.escalated.walkways.WalkwayHelper;
import rbasamoyai.escalated.walkways.WalkwayMovementHandler;
import rbasamoyai.escalated.walkways.WalkwaySet;
import rbasamoyai.escalated.walkways.WalkwaySlope;

public abstract class AbstractWalkwayBlock
extends HorizontalKineticBlock
implements IBE<WalkwayBlockEntity>,
WalkwayBlock {
    private final NonNullSupplier<WalkwaySet> walkwaySetSupplier;
    private WalkwaySet walkwaySet = null;

    protected AbstractWalkwayBlock(class_4970.class_2251 properties, NonNullSupplier<WalkwaySet> walkwaySetSupplier) {
        super(properties);
        this.walkwaySetSupplier = walkwaySetSupplier;
    }

    @Override
    public class_2350 getFacing(class_2680 state) {
        return (class_2350)state.method_11654(HORIZONTAL_FACING);
    }

    public class_2350.class_2351 getRotationAxis(class_2680 state) {
        return ((class_2350)state.method_11654(HORIZONTAL_FACING)).method_10170().method_10166();
    }

    public Class<WalkwayBlockEntity> getBlockEntityClass() {
        return WalkwayBlockEntity.class;
    }

    public class_2591<? extends WalkwayBlockEntity> getBlockEntityType() {
        return (class_2591)EscalatedBlockEntities.WALKWAY.get();
    }

    public void method_9548(class_2680 state, class_1937 level, class_2338 pos, class_1297 entity) {
        this.transportEntity(level, pos, state, entity);
    }

    public void method_9591(class_1937 level, class_2338 pos, class_2680 state, class_1297 entity) {
        class_2338 actualPos = entity.method_23312();
        class_2680 actualState = level.method_8320(actualPos);
        this.transportEntity(level, actualPos, actualState, entity);
    }

    protected void transportEntity(class_1937 level, class_2338 pos, class_2680 state, class_1297 entity) {
        class_1657 player;
        if (entity instanceof class_1657 && ((player = (class_1657)entity).method_5715() || player.method_31549().field_7479)) {
            return;
        }
        if (((Boolean)EscalatedConfigs.SERVER.divingBootsPreventWalkwayMotion.get()).booleanValue() && DivingBootsItem.isWornBy((class_1297)entity)) {
            return;
        }
        WalkwayBlockEntity walkway = WalkwayHelper.getSegmentBE((class_1936)level, pos);
        if (walkway == null) {
            return;
        }
        WalkwayBlockEntity controller = WalkwayHelper.getControllerBE((class_1936)level, pos);
        if (controller == null || controller.passengers == null) {
            return;
        }
        if (controller.passengers.containsKey(entity)) {
            WalkwayMovementHandler.TransportedEntityInfo info = controller.passengers.get(entity);
            if (info.getTicksSinceLastCollision() != 0 || pos.equals((Object)entity.method_24515())) {
                info.refresh(pos, state);
            }
        } else {
            controller.passengers.put(entity, new WalkwayMovementHandler.TransportedEntityInfo(pos, state));
            entity.method_24830(true);
        }
    }

    public void method_9536(class_2680 state, class_1937 level, class_2338 pos, class_2680 newState, boolean isMoving) {
        block32: {
            boolean connectedRight;
            boolean connectedLeft;
            class_2350 left;
            block31: {
                class_2350 facing = this.getFacing(state);
                left = facing.method_10160();
                connectedLeft = this.connectedToWalkwayOnSide(level, state, pos, left);
                connectedRight = this.connectedToWalkwayOnSide(level, state, pos, left.method_10153());
                super.method_9536(state, level, pos, newState, isMoving);
                if (level.field_9236 || state.method_26204() == newState.method_26204() || this.getWalkwaySet().blockInSet(newState) || isMoving) {
                    return;
                }
                WalkwayBlock walkwayBlock = this;
                class_2680 currentState = state;
                for (class_2350 dir : Iterate.directionsInAxis((class_2350.class_2351)left.method_10166())) {
                    WalkwayBlockEntity sideWalkwayBE;
                    WalkwayBlock sideWalkway;
                    class_2338 sidePos = pos.method_10093(dir);
                    class_2680 sideState = level.method_8320(sidePos);
                    class_2248 class_22482 = sideState.method_26204();
                    if (!(class_22482 instanceof WalkwayBlock) || !(sideWalkway = (WalkwayBlock)class_22482).connectedToWalkwayOnSide(level, sideState, sidePos, dir.method_10153())) continue;
                    boolean sideShaft = sideWalkway.hasWalkwayShaft(sideState);
                    class_2680 transformState = sideWalkway.transformFromMerge(level, sideState, sidePos, dir != left, sideShaft, true, false);
                    class_1767 color = null;
                    float visualProgress = 0.0f;
                    class_2586 class_25862 = level.method_8321(sidePos);
                    if (class_25862 instanceof WalkwayBlockEntity) {
                        sideWalkwayBE = (WalkwayBlockEntity)class_25862;
                        color = sideWalkwayBE.getColor();
                        visualProgress = sideWalkwayBE.getVisualProgress();
                    }
                    KineticBlockEntity.switchToBlockState((class_1937)level, (class_2338)sidePos, (class_2680)transformState);
                    class_25862 = level.method_8321(sidePos);
                    if (!(class_25862 instanceof WalkwayBlockEntity)) continue;
                    sideWalkwayBE = (WalkwayBlockEntity)class_25862;
                    sideWalkwayBE.applyColor(color);
                    sideWalkwayBE.setVisualProgress(visualProgress);
                    sideWalkwayBE.resetClientRender = true;
                    sideWalkwayBE.notifyUpdate();
                }
                boolean terminal = this.getWalkwaySlope(state) == WalkwaySlope.TERMINAL;
                for (boolean forward : Iterate.trueAndFalse) {
                    WalkwayBlock newWalkway;
                    class_2248 sideShaft;
                    class_2338 currentPos = WalkwayBlock.nextSegmentPosition(state, pos, forward, terminal && !forward);
                    if (currentPos == null || !((sideShaft = (currentState = level.method_8320(currentPos)).method_26204()) instanceof WalkwayBlock)) continue;
                    walkwayBlock = newWalkway = (WalkwayBlock)sideShaft;
                    boolean hasPulley = walkwayBlock.hasWalkwayShaft(currentState);
                    level.method_8544(currentPos);
                    Object shaftState = (class_2680)AllBlocks.SHAFT.getDefaultState().method_11657((class_2769)class_2741.field_12496, (Comparable)this.getRotationAxis(currentState));
                    level.method_8652(currentPos, ProperWaterloggedBlock.withWater((class_1936)level, (class_2680)((boolean[])(hasPulley ? shaftState : (boolean[])class_2246.field_10124.method_9564())), (class_2338)currentPos), 3);
                    level.method_20290(2001, currentPos, class_2248.method_9507((class_2680)currentState));
                }
                class_2338 abovePos = pos.method_10084();
                class_2680 aboveState = level.method_8320(abovePos);
                if (!(aboveState.method_26204() instanceof AbstractHandrailBlock)) break block31;
                AbstractHandrailBlock.Side side = (AbstractHandrailBlock.Side)((Object)aboveState.method_11654(AbstractHandrailBlock.SIDE));
                if (side == AbstractHandrailBlock.Side.BOTH) {
                    level.method_22352(abovePos, true);
                } else {
                    class_2350 offsetDir;
                    ArrayList<class_2338> positions = new ArrayList<class_2338>();
                    positions.add(abovePos);
                    class_2338 iterPos = abovePos;
                    class_2680 iterState = aboveState;
                    int MAX_ITER = 1100;
                    for (boolean forward : Iterate.trueAndFalse) {
                        iterPos = abovePos;
                        iterState = aboveState;
                        for (int i = 0; i < MAX_ITER && (iterPos = AbstractHandrailBlock.nextSegmentPosition(iterState, iterPos, forward)) != null && (iterState = level.method_8320(iterPos)).method_26204() instanceof AbstractHandrailBlock; ++i) {
                            positions.add(iterPos);
                        }
                    }
                    class_2586 color = level.method_8321(abovePos);
                    if (!(color instanceof HandrailBlockEntity)) {
                        return;
                    }
                    HandrailBlockEntity handrailBE = (HandrailBlockEntity)color;
                    int handrailWidth = handrailBE.width;
                    class_2350 handrailLeft = ((class_2350)aboveState.method_11654((class_2769)AbstractHandrailBlock.field_11177)).method_10160();
                    class_2350 class_23502 = offsetDir = side == AbstractHandrailBlock.Side.LEFT ? handrailLeft.method_10153() : handrailLeft;
                    if (handrailWidth == 2) {
                        for (class_2338 handrailPos : positions) {
                            class_2338 newHandrailPos = handrailPos.method_10093(offsetDir);
                            class_2680 oldHandrailState = level.method_8320(newHandrailPos);
                            if (!(oldHandrailState.method_26204() instanceof AbstractHandrailBlock)) continue;
                            level.method_8652(newHandrailPos, ProperWaterloggedBlock.withWater((class_1936)level, (class_2680)((class_2680)oldHandrailState.method_11657(AbstractHandrailBlock.SIDE, (Comparable)((Object)AbstractHandrailBlock.Side.BOTH))), (class_2338)newHandrailPos), 3);
                            class_2586 class_25863 = level.method_8321(handrailPos);
                            if (class_25863 instanceof HandrailBlockEntity) {
                                HandrailBlockEntity handrailBE1 = (HandrailBlockEntity)class_25863;
                                handrailBE1.propagateBreak = false;
                            }
                            level.method_8652(handrailPos, ProperWaterloggedBlock.withWater((class_1936)level, (class_2680)class_2246.field_10124.method_9564(), (class_2338)handrailPos), 3);
                            level.method_20290(2001, handrailPos, class_2248.method_9507((class_2680)oldHandrailState));
                        }
                    } else {
                        class_2338 newHandrailPos;
                        for (class_2338 handrailPos : positions) {
                            newHandrailPos = handrailPos.method_10093(offsetDir);
                            if (level.method_8320(newHandrailPos).method_45474()) continue;
                            level.method_22352(abovePos, true);
                            return;
                        }
                        for (class_2338 handrailPos : positions) {
                            newHandrailPos = handrailPos.method_10093(offsetDir);
                            class_2680 placeState = level.method_8320(handrailPos);
                            level.method_22352(newHandrailPos, true);
                            level.method_8652(newHandrailPos, ProperWaterloggedBlock.withWater((class_1936)level, (class_2680)placeState, (class_2338)newHandrailPos), 3);
                            class_2586 class_25864 = level.method_8321(newHandrailPos);
                            if (class_25864 instanceof HandrailBlockEntity) {
                                HandrailBlockEntity newHandrailBE = (HandrailBlockEntity)class_25864;
                                class_25864 = level.method_8321(handrailPos);
                                if (class_25864 instanceof HandrailBlockEntity) {
                                    HandrailBlockEntity oldHandrailBE = (HandrailBlockEntity)class_25864;
                                    newHandrailBE.width = handrailWidth - 1;
                                    oldHandrailBE.width = 0;
                                    oldHandrailBE.propagateBreak = false;
                                    class_2586 class_25865 = level.method_8321(newHandrailPos.method_10079(offsetDir, handrailWidth - 1));
                                    if (class_25865 instanceof HandrailBlockEntity) {
                                        HandrailBlockEntity oppositeHandrailBE = (HandrailBlockEntity)class_25865;
                                        oppositeHandrailBE.width = newHandrailBE.width;
                                    }
                                }
                            }
                            level.method_8652(handrailPos, ProperWaterloggedBlock.withWater((class_1936)level, (class_2680)class_2246.field_10124.method_9564(), (class_2338)handrailPos), 3);
                            level.method_20290(2001, abovePos, class_2248.method_9507((class_2680)placeState));
                        }
                    }
                }
                break block32;
            }
            if (!connectedLeft || !connectedRight) break block32;
            for (class_2350 dir : Iterate.directionsInAxis((class_2350.class_2351)left.method_10166())) {
                class_2586 newHandrailPos;
                class_2338 abovePos1;
                class_2680 aboveState1;
                int offset;
                int MAX_ITER = 256;
                class_2338 offsetPos = pos.method_10079(dir, offset);
                class_2680 offsetState = level.method_8320(offsetPos);
                for (offset = 1; offset < MAX_ITER; ++offset) {
                    offsetPos = pos.method_10079(dir, offset);
                    offsetState = level.method_8320(offsetPos);
                    class_2248 i = offsetState.method_26204();
                    if (!(i instanceof WalkwayBlock)) {
                        return;
                    }
                    WalkwayBlock offsetWalkway = (WalkwayBlock)i;
                    if (!offsetWalkway.connectedToWalkwayOnSide(level, offsetState, offsetPos, dir)) break;
                }
                if (!((aboveState1 = level.method_8320(abovePos1 = offsetPos.method_10084())).method_26204() instanceof AbstractHandrailBlock) || !((newHandrailPos = level.method_8321(abovePos1)) instanceof HandrailBlockEntity)) continue;
                HandrailBlockEntity handrailBE = (HandrailBlockEntity)newHandrailPos;
                if (handrailBE.width == offset) continue;
                ArrayList<class_2338> positions = new ArrayList<class_2338>();
                positions.add(abovePos1);
                for (boolean forward : Iterate.trueAndFalse) {
                    class_2338 iterPos = abovePos1;
                    class_2680 iterState = aboveState1;
                    for (int i = 0; i < MAX_ITER && (iterPos = AbstractHandrailBlock.nextSegmentPosition(iterState, iterPos, forward)) != null && (iterState = level.method_8320(iterPos)).method_26204() instanceof AbstractHandrailBlock; ++i) {
                        positions.add(iterPos);
                    }
                }
                if (offset > 1) {
                    boolean fail = false;
                    for (class_2338 handrailPos : positions) {
                        class_2338 otherHandrailPos = handrailPos.method_10079(dir, -offset + 1);
                        if (level.method_8320(otherHandrailPos).method_45474()) continue;
                        fail = true;
                        break;
                    }
                    if (fail) {
                        for (class_2338 handrailPos : positions) {
                            class_2586 i = level.method_8321(handrailPos);
                            if (i instanceof HandrailBlockEntity) {
                                HandrailBlockEntity handrailBE1 = (HandrailBlockEntity)i;
                                handrailBE1.propagateBreak = false;
                            }
                            level.method_22352(handrailPos, true);
                        }
                        continue;
                    }
                    for (class_2338 handrailPos : positions) {
                        class_2586 i = level.method_8321(handrailPos);
                        if (i instanceof HandrailBlockEntity) {
                            HandrailBlockEntity handrailBE1 = (HandrailBlockEntity)i;
                            handrailBE1.width = offset;
                        }
                        class_2680 srcHandrailState = level.method_8320(handrailPos);
                        class_2338 otherHandrailPos = handrailPos.method_10079(dir, -offset + 1);
                        level.method_22352(otherHandrailPos, true);
                        AbstractHandrailBlock.Side side = (AbstractHandrailBlock.Side)((Object)srcHandrailState.method_11654(AbstractHandrailBlock.SIDE));
                        AbstractHandrailBlock.Side placeSide = side == AbstractHandrailBlock.Side.LEFT ? AbstractHandrailBlock.Side.RIGHT : AbstractHandrailBlock.Side.LEFT;
                        level.method_8652(otherHandrailPos, ProperWaterloggedBlock.withWater((class_1936)level, (class_2680)((class_2680)srcHandrailState.method_11657(AbstractHandrailBlock.SIDE, (Comparable)((Object)placeSide))), (class_2338)otherHandrailPos), 3);
                        class_2586 class_25866 = level.method_8321(otherHandrailPos);
                        if (!(class_25866 instanceof HandrailBlockEntity)) continue;
                        HandrailBlockEntity handrailBE1 = (HandrailBlockEntity)class_25866;
                        handrailBE1.width = offset;
                    }
                    continue;
                }
                for (class_2338 handrailPos : positions) {
                    class_2680 handrailState = level.method_8320(handrailPos);
                    level.method_8652(handrailPos, ProperWaterloggedBlock.withWater((class_1936)level, (class_2680)((class_2680)handrailState.method_11657(AbstractHandrailBlock.SIDE, (Comparable)((Object)AbstractHandrailBlock.Side.BOTH))), (class_2338)handrailPos), 3);
                    class_2586 class_25867 = level.method_8321(handrailPos);
                    if (!(class_25867 instanceof HandrailBlockEntity)) continue;
                    HandrailBlockEntity handrailBE1 = (HandrailBlockEntity)class_25867;
                    handrailBE1.width = 1;
                }
            }
        }
    }

    public List<class_1799> method_9560(class_2680 state, class_8567.class_8568 builder) {
        List drops = super.method_9560(state, builder);
        if (this.hasWalkwayShaft(state)) {
            drops.addAll(AllBlocks.SHAFT.getDefaultState().method_26189(builder));
        }
        return drops;
    }

    public class_1269 method_9534(class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hitResult) {
        if (player.method_5715() || !player.method_7294()) {
            return class_1269.field_5811;
        }
        class_1799 heldItem = player.method_5998(hand);
        boolean isDye = WalkwayHelper.isDye(heldItem);
        boolean hasWater = WalkwayHelper.hasWater(level, heldItem);
        if (isDye || hasWater) {
            return this.onBlockEntityUse((class_1922)level, pos, be -> be.applyColor(WalkwayHelper.getDyeColorFromItem(heldItem)) ? class_1269.field_5812 : class_1269.field_5811);
        }
        boolean isBelt = WalkwayHelper.isHandrail(heldItem);
        if (isBelt) {
            return this.placeHandrail(level, state, pos, player, heldItem) ? class_1269.field_5812 : class_1269.field_5811;
        }
        return super.method_9534(state, level, pos, player, hand, hitResult);
    }

    /*
     * WARNING - void declaration
     */
    protected boolean placeHandrail(class_1937 level, class_2680 state, class_2338 pos, class_1657 player, class_1799 itemStack) {
        class_2586 leftPos;
        class_2338 centralPos = pos;
        class_2680 referenceState = state;
        if (this.getWalkwaySlope(referenceState) == WalkwaySlope.TERMINAL && !((referenceState = level.method_8320(centralPos = pos.method_10093(this.getFacing(referenceState)))).method_26204() instanceof WalkwayBlock)) {
            return false;
        }
        WalkwayBlock walkway = (WalkwayBlock)referenceState.method_26204();
        class_2350 dir = walkway.getFacing(referenceState);
        AbstractHandrailBlock handrail = (AbstractHandrailBlock)walkway.getWalkwaySet().getHandrailBlock(level, referenceState, centralPos).method_26204();
        int MAX_ITER = 1100;
        if (!walkway.connectedToWalkwayOnSide(level, referenceState, pos, dir.method_10170()) && !walkway.connectedToWalkwayOnSide(level, referenceState, pos, dir.method_10160())) {
            void var17_25;
            if (level.method_8320(centralPos.method_10084()).method_26204() instanceof AbstractHandrailBlock) {
                return false;
            }
            ArrayList<class_2338> positions = new ArrayList<class_2338>();
            class_2680 iterState = referenceState;
            class_2338 iterPos = centralPos;
            positions.add(iterPos);
            Object object = Iterate.trueAndFalse;
            int n = ((boolean[])object).length;
            boolean bl = false;
            while (var17_25 < n) {
                boolean forward = object[var17_25];
                iterState = referenceState;
                iterPos = centralPos;
                for (int i = 0; i < MAX_ITER && (iterPos = WalkwayBlock.nextSegmentPosition(iterState, iterPos, forward, true)) != null; ++i) {
                    iterState = level.method_8320(iterPos);
                    if (!(iterState.method_26204() instanceof WalkwayBlock) || !level.method_8320(iterPos.method_10084()).method_45474()) {
                        return false;
                    }
                    positions.add(iterPos);
                }
                ++var17_25;
            }
            object = positions.iterator();
            while (object.hasNext()) {
                class_2338 basePos = (class_2338)object.next();
                class_2680 class_26802 = level.method_8320(basePos);
                WalkwayBlock otherWalkway = (WalkwayBlock)class_26802.method_26204();
                class_2338 abovePos = basePos.method_10084();
                class_2680 placeState = handrail.getStateForSlope(level, basePos, class_26802, abovePos, dir, otherWalkway.getWalkwaySlope(class_26802), AbstractHandrailBlock.Side.BOTH);
                level.method_22352(abovePos, true);
                level.method_8652(abovePos, placeState, 3);
            }
            level.method_8396(null, pos.method_10084(), class_3417.field_15226, class_3419.field_15245, 0.5f, 1.0f);
            EscalatedTriggers.HANDRAIL.tryAwardingTo(player);
            return true;
        }
        class_2350 left = dir.method_10160();
        for (int i = 0; i < MAX_ITER; ++i) {
            leftPos = centralPos.method_10079(left, i);
            class_2680 leftState = level.method_8320((class_2338)leftPos);
            class_2248 class_22482 = leftState.method_26204();
            if (!(class_22482 instanceof WalkwayBlock)) {
                return false;
            }
            WalkwayBlock leftWalkway = (WalkwayBlock)class_22482;
            if (leftWalkway.connectedToWalkwayOnSide(level, leftState, (class_2338)leftPos, left)) continue;
            referenceState = leftState;
            centralPos = leftPos;
            break;
        }
        if (!((leftPos = level.method_8321(centralPos)) instanceof WalkwayBlockEntity)) {
            return false;
        }
        WalkwayBlockEntity centralBE = (WalkwayBlockEntity)leftPos;
        if (level.method_8320(centralPos.method_10084()).method_26204() instanceof AbstractHandrailBlock) {
            return false;
        }
        ArrayList<class_2338> leftPositions = new ArrayList<class_2338>();
        class_2680 iterState = referenceState;
        class_2338 iterPos = centralPos;
        leftPositions.add(iterPos);
        for (boolean forward : Iterate.trueAndFalse) {
            iterState = referenceState;
            iterPos = centralPos;
            for (int i = 0; i < MAX_ITER && (iterPos = WalkwayBlock.nextSegmentPosition(iterState, iterPos, forward, true)) != null; ++i) {
                iterState = level.method_8320(iterPos);
                if (!(iterState.method_26204() instanceof WalkwayBlock) || !level.method_8320(iterPos.method_10084()).method_45474()) {
                    return false;
                }
                leftPositions.add(iterPos);
            }
        }
        WalkwayBlockEntity walkwayBlockEntity = centralBE.getControllerBE();
        if (walkwayBlockEntity == null) {
            return false;
        }
        int width = walkwayBlockEntity.walkwayWidth;
        int offset = width - 1;
        referenceState = level.method_8320(centralPos = centralPos.method_10079(left, -offset));
        if (!(referenceState.method_26204() instanceof WalkwayBlock)) {
            return false;
        }
        for (class_2338 leftBasePos : leftPositions) {
            class_2338 rightAbovePos = leftBasePos.method_10079(left, -offset).method_10084();
            if (level.method_8320(leftBasePos.method_10084()).method_45474() && level.method_8320(rightAbovePos).method_45474()) continue;
            return false;
        }
        for (class_2338 leftBasePos : leftPositions) {
            class_2680 leftBaseState = level.method_8320(leftBasePos);
            WalkwayBlock otherWalkway = (WalkwayBlock)leftBaseState.method_26204();
            class_2338 leftAbovePos = leftBasePos.method_10084();
            class_2680 leftPlaceState = handrail.getStateForSlope(level, leftBasePos, leftBaseState, leftAbovePos, dir, otherWalkway.getWalkwaySlope(leftBaseState), AbstractHandrailBlock.Side.LEFT);
            level.method_22352(leftAbovePos, true);
            level.method_8652(leftAbovePos, ProperWaterloggedBlock.withWater((class_1936)level, (class_2680)leftPlaceState, (class_2338)leftAbovePos), 3);
            class_2586 class_25862 = level.method_8321(leftAbovePos);
            if (class_25862 instanceof HandrailBlockEntity) {
                HandrailBlockEntity handrailBE = (HandrailBlockEntity)class_25862;
                handrailBE.width = width;
            }
            class_2338 rightBasePos = leftBasePos.method_10079(left, -offset);
            class_2680 rightBaseState = level.method_8320(rightBasePos);
            class_2338 rightAbovePos = rightBasePos.method_10084();
            class_2680 rightPlaceState = handrail.getStateForSlope(level, rightBasePos, rightBaseState, rightAbovePos, dir, otherWalkway.getWalkwaySlope(rightBaseState), AbstractHandrailBlock.Side.RIGHT);
            level.method_22352(rightAbovePos, true);
            level.method_8652(rightAbovePos, ProperWaterloggedBlock.withWater((class_1936)level, (class_2680)rightPlaceState, (class_2338)rightAbovePos), 3);
            class_2586 class_25863 = level.method_8321(rightAbovePos);
            if (!(class_25863 instanceof HandrailBlockEntity)) continue;
            HandrailBlockEntity handrailBE = (HandrailBlockEntity)class_25863;
            handrailBE.width = width;
        }
        level.method_8396(null, pos.method_10084(), class_3417.field_15226, class_3419.field_15245, 0.5f, 1.0f);
        EscalatedTriggers.HANDRAIL.tryAwardingTo(player);
        return true;
    }

    @Override
    public WalkwaySet getWalkwaySet() {
        if (this.walkwaySet == null) {
            this.walkwaySet = (WalkwaySet)this.walkwaySetSupplier.get();
        }
        return this.walkwaySet;
    }
}

