/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.escalated.walkways;

import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.createmod.catnip.data.Iterate;
import net.createmod.catnip.nbt.NBTHelper;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1767;
import net.minecraft.class_1936;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import rbasamoyai.escalated.advancements.WalkwayTravelTracker;
import rbasamoyai.escalated.walkways.WalkwayBlock;
import rbasamoyai.escalated.walkways.WalkwayHelper;
import rbasamoyai.escalated.walkways.WalkwayMovementHandler;
import rbasamoyai.escalated.walkways.WalkwaySlope;

public class WalkwayBlockEntity
extends KineticBlockEntity {
    public Map<class_1297, WalkwayMovementHandler.TransportedEntityInfo> passengers;
    public int walkwayLength;
    public int walkwayWidth = 1;
    protected class_2338 controller;
    protected class_2338 widthReferencePos = this.method_11016();
    public float visualProgress = 0.0f;
    protected int updateCount = 0;
    private class_1767 color = null;
    public boolean resetClientRender;
    public boolean lazyResetClientRender;

    public WalkwayBlockEntity(class_2591<?> typeIn, class_2338 pos, class_2680 state) {
        super(typeIn, pos, state);
        this.setLazyTickRate(3);
    }

    public void tick() {
        if (this.walkwayLength == 0) {
            WalkwayBlock.initWalkway(this.field_11863, this.field_11867);
        }
        if (this.field_11863.field_9236 && this.lazyResetClientRender) {
            this.lazyResetClientRender = false;
            this.resetClientRender = true;
        }
        super.tick();
        if (!(this.field_11863.method_8320(this.field_11867).method_26204() instanceof WalkwayBlock)) {
            return;
        }
        if (!this.isController()) {
            return;
        }
        if (this.updateCount <= 0) {
            this.visualProgress += this.getWalkwayMovementSpeed();
            if (Math.abs(this.visualProgress) > 0.5f) {
                this.visualProgress = Math.signum(this.visualProgress) * (Math.abs(this.visualProgress) % 0.5f);
            }
            this.updateNeighbors();
        } else {
            this.updateCount = Math.max(0, this.updateCount - 1);
        }
        if (this.getSpeed() == 0.0f) {
            return;
        }
        if (this.field_11863.method_8510() % 40L == 0L) {
            this.sendData();
        }
        if (this.passengers == null) {
            this.passengers = new HashMap<class_1297, WalkwayMovementHandler.TransportedEntityInfo>();
        }
        Iterator<Map.Entry<class_1297, WalkwayMovementHandler.TransportedEntityInfo>> iter = this.passengers.entrySet().iterator();
        while (iter.hasNext()) {
            WalkwaySlope slope;
            Map.Entry<class_1297, WalkwayMovementHandler.TransportedEntityInfo> entry = iter.next();
            class_1297 entity = entry.getKey();
            WalkwayMovementHandler.TransportedEntityInfo info = entry.getValue();
            boolean canBeTransported = WalkwayMovementHandler.canBeTransported(entity);
            boolean leftTheBelt = info.getTicksSinceLastCollision() > 3;
            class_2338 lastCollidedPos = info.lastCollidedPos;
            class_2680 lastCollidedState = info.lastCollidedState;
            class_2248 class_22482 = lastCollidedState.method_26204();
            if (class_22482 instanceof WalkwayBlock) {
                WalkwayBlock other = (WalkwayBlock)class_22482;
                v0 = other.getWalkwaySlope(lastCollidedState);
            } else {
                v0 = slope = WalkwaySlope.TERMINAL;
            }
            if (leftTheBelt && slope != WalkwaySlope.TERMINAL && slope != WalkwaySlope.HORIZONTAL && this.field_11863.method_8321(lastCollidedPos) instanceof WalkwayBlockEntity && entity.method_5829().method_994(new class_238(lastCollidedPos).method_1009(0.0, 0.5, 0.0))) {
                info.refresh(lastCollidedPos, info.lastCollidedState);
                leftTheBelt = false;
            }
            if (!canBeTransported || leftTheBelt) {
                if (entity instanceof class_1657) {
                    class_1657 player = (class_1657)entity;
                    if (!this.field_11863.field_9236) {
                        WalkwayTravelTracker.stopTrackingPlayerOnWalkway(player);
                    }
                }
                iter.remove();
                continue;
            }
            info.tick();
            WalkwayMovementHandler.transportEntity(this, entity, info);
        }
    }

    public void attachKinetics() {
        if (this.field_11865) {
            return;
        }
        super.attachKinetics();
    }

    public void updateNeighbors() {
        int actualWidth;
        WalkwayBlock currentWalkway = null;
        class_2680 thisState = this.method_11010();
        class_2248 class_22482 = thisState.method_26204();
        if (!(class_22482 instanceof WalkwayBlock)) {
            return;
        }
        WalkwayBlock walkwayBlock = (WalkwayBlock)class_22482;
        class_2338 pos = this.method_11016();
        class_2338 referencePos = this.widthReferencePos;
        class_2350 facing = walkwayBlock.getFacing(thisState);
        class_2350 left = facing.method_10160();
        int ITERATE_LIMIT = this.walkwayWidth + 2;
        ArrayList<WalkwayBlockEntity> updateSecondPass = new ArrayList<WalkwayBlockEntity>();
        HashSet<class_2338> iteratedBlocks = new HashSet<class_2338>();
        iteratedBlocks.add(pos);
        block0: for (class_2350 dir : Iterate.directionsInAxis((class_2350.class_2351)left.method_10166())) {
            class_2338 currentPos;
            class_2680 currentState;
            class_2248 class_22483;
            for (int i = 0; i < ITERATE_LIMIT && (class_22483 = (currentState = this.field_11863.method_8320(currentPos = pos.method_10079(dir, i))).method_26204()) instanceof WalkwayBlock; ++i) {
                WalkwayBlock otherWalkway;
                currentWalkway = otherWalkway = (WalkwayBlock)class_22483;
                if (i > 0) {
                    class_2586 class_25862 = this.field_11863.method_8321(currentPos);
                    if (!(class_25862 instanceof WalkwayBlockEntity)) continue block0;
                    WalkwayBlockEntity otherWalkwayBE = (WalkwayBlockEntity)class_25862;
                    iteratedBlocks.add(currentPos);
                    updateSecondPass.add(otherWalkwayBE);
                }
                if (!currentWalkway.connectedToWalkwayOnSide(this.field_11863, currentState, currentPos, dir)) continue block0;
            }
        }
        if (!iteratedBlocks.contains(referencePos)) {
            this.widthReferencePos = pos;
        }
        this.walkwayWidth = actualWidth = iteratedBlocks.size();
        for (WalkwayBlockEntity walkwayBE : updateSecondPass) {
            walkwayBE.visualProgress = this.visualProgress;
            walkwayBE.setWalkwayWidth(actualWidth);
            walkwayBE.widthReferencePos = this.widthReferencePos;
            walkwayBE.updateCount = 1;
        }
    }

    public float calculateStressApplied() {
        return this.isController() ? super.calculateStressApplied() : 0.0f;
    }

    public class_238 createRenderBoundingBox() {
        return super.createRenderBoundingBox().method_1014(1.0);
    }

    public void clearKineticInformation() {
        super.clearKineticInformation();
        this.walkwayLength = 0;
        this.controller = null;
    }

    public WalkwayBlockEntity getControllerBE() {
        WalkwayBlockEntity walkway;
        class_2586 class_25862;
        if (this.controller == null || !this.field_11863.method_8477(this.controller)) {
            return null;
        }
        return this.controller != null && this.field_11863.method_8477(this.controller) && (class_25862 = this.field_11863.method_8321(this.controller)) instanceof WalkwayBlockEntity ? (walkway = (WalkwayBlockEntity)class_25862) : null;
    }

    public void setController(class_2338 controller) {
        this.controller = controller;
    }

    public class_2338 getController() {
        return this.controller == null ? this.field_11867 : this.controller;
    }

    public boolean isController() {
        return this.controller != null && this.field_11867.method_10263() == this.controller.method_10263() && this.field_11867.method_10264() == this.controller.method_10264() && this.field_11867.method_10260() == this.controller.method_10260();
    }

    public int getWalkwayWidth() {
        WalkwayBlockEntity controller = this.getControllerBE();
        return controller == null ? 1 : controller.walkwayWidth;
    }

    public void setWalkwayWidth(int width) {
        WalkwayBlockEntity controller = this.getControllerBE();
        if (controller != null) {
            controller.walkwayWidth = width;
        }
    }

    public boolean isEscalator() {
        class_2248 class_22482 = this.method_11010().method_26204();
        if (!(class_22482 instanceof WalkwayBlock)) {
            return false;
        }
        WalkwayBlock walkwayBlock = (WalkwayBlock)class_22482;
        WalkwaySlope slope = walkwayBlock.getWalkwaySlope(this.method_11010());
        return slope != WalkwaySlope.HORIZONTAL && slope != WalkwaySlope.TERMINAL;
    }

    public List<class_2338> getAllBlocks() {
        ArrayList<class_2338> list = new ArrayList<class_2338>();
        WalkwayBlockEntity controller = this.getControllerBE();
        if (controller == null) {
            return list;
        }
        class_2338 current = controller.method_11016();
        boolean terminal = false;
        for (int i = 0; i < this.walkwayLength; ++i) {
            list.add(current);
            class_2680 state = this.field_11863.method_8320(current);
            if (!(state.method_26204() instanceof WalkwayBlock)) {
                return new ArrayList<class_2338>();
            }
            class_2338 nextPos = WalkwayBlock.nextSegmentPosition(state, current, !terminal, terminal);
            terminal = true;
            if (nextPos == null) break;
            current = nextPos;
        }
        return list;
    }

    protected boolean canPropagateDiagonally(IRotate block, class_2680 state) {
        return super.canPropagateDiagonally(block, state) || this.isEscalator();
    }

    public float propagateRotationTo(KineticBlockEntity target, class_2680 stateFrom, class_2680 stateTo, class_2338 diff, boolean connectedViaAxes, boolean connectedViaCogs) {
        if (target instanceof WalkwayBlockEntity) {
            WalkwayBlockEntity walkway = (WalkwayBlockEntity)target;
            if (!connectedViaAxes) {
                return this.getController().equals((Object)walkway.getController()) ? 1.0f : 0.0f;
            }
        }
        return 0.0f;
    }

    public float getWalkwayMovementSpeed() {
        return this.getSpeed() / 480.0f;
    }

    public float getVisualProgress() {
        WalkwayBlockEntity controller = this.getControllerBE();
        return controller == null ? 0.0f : controller.visualProgress;
    }

    public void setVisualProgress(float visualProgress) {
        this.visualProgress = visualProgress;
    }

    public boolean applyColor(@Nullable class_1767 colorIn) {
        if (colorIn == this.color) {
            return false;
        }
        if (this.field_11863.field_9236) {
            return true;
        }
        int WIDTH_LIMIT = 256;
        class_2350 facing = ((WalkwayBlock)this.method_11010().method_26204()).getFacing(this.method_11010());
        class_2350 left = facing.method_10160();
        List<class_2338> walkwayChain = WalkwayBlock.getWalkwayChain(this.field_11863, this.getController());
        for (class_2338 pos : walkwayChain) {
            block1: for (class_2350 dir : Iterate.directionsInAxis((class_2350.class_2351)left.method_10166())) {
                for (int i = 0; i < WIDTH_LIMIT; ++i) {
                    WalkwayBlock walkwayBlock;
                    class_2680 currentState;
                    class_2248 class_22482;
                    class_2338 currentPos = pos.method_10079(dir, i);
                    WalkwayBlockEntity walkway = WalkwayHelper.getSegmentBE((class_1936)this.field_11863, currentPos);
                    if (walkway != null) {
                        walkway.color = colorIn;
                        walkway.notifyUpdate();
                    }
                    if (!((class_22482 = (currentState = this.field_11863.method_8320(currentPos)).method_26204()) instanceof WalkwayBlock) || !(walkwayBlock = (WalkwayBlock)class_22482).connectedToWalkwayOnSide(this.field_11863, currentState, currentPos, dir)) continue block1;
                }
            }
        }
        return true;
    }

    @Nullable
    public class_1767 getColor() {
        return this.color;
    }

    protected void write(class_2487 compound, boolean clientPacket) {
        if (this.controller != null) {
            compound.method_10566("Controller", (class_2520)class_2512.method_10692((class_2338)this.controller));
        }
        compound.method_10556("IsController", this.isController());
        compound.method_10569("Length", this.walkwayLength);
        if (this.isController()) {
            compound.method_10548("VisualProgress", this.visualProgress);
            compound.method_10569("Width", this.walkwayWidth);
            if (this.widthReferencePos != null) {
                compound.method_10566("WidthReferencePos", (class_2520)class_2512.method_10692((class_2338)this.widthReferencePos));
            }
        }
        if (this.color != null) {
            NBTHelper.writeEnum((class_2487)compound, (String)"Dye", (Enum)this.color);
        }
        super.write(compound, clientPacket);
        if (!clientPacket) {
            return;
        }
        if (this.resetClientRender) {
            compound.method_10556("UpdateRendering", false);
        }
    }

    protected void read(class_2487 compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        if (compound.method_10577("IsController")) {
            this.controller = this.field_11867;
            this.visualProgress = compound.method_10583("VisualProgress");
            this.walkwayWidth = compound.method_10550("Width");
            this.widthReferencePos = compound.method_10573("WidthReferencePos", 10) ? class_2512.method_10691((class_2487)compound.method_10562("WidthReferencePos")) : this.method_11016();
        }
        class_1767 class_17672 = this.color = compound.method_10573("Dye", 8) ? (class_1767)NBTHelper.readEnum((class_2487)compound, (String)"Dye", class_1767.class) : null;
        if (!this.wasMoved) {
            if (!this.isController()) {
                this.controller = class_2512.method_10691((class_2487)compound.method_10562("Controller"));
            }
            this.walkwayLength = compound.method_10550("Length");
        }
        if (!clientPacket) {
            return;
        }
        if (this.isController()) {
            this.lazyResetClientRender = true;
            float speed = this.getWalkwayMovementSpeed();
            this.visualProgress += speed * 1.0f;
            if (Math.abs(this.visualProgress) > 0.5f) {
                this.visualProgress = Math.signum(this.visualProgress) * (Math.abs(this.visualProgress) % 0.5f);
            }
        }
        this.resetClientRender |= compound.method_10545("UpdateRendering");
    }

    public void writeSafe(class_2487 tag) {
        super.writeSafe(tag);
        if (this.color != null) {
            NBTHelper.writeEnum((class_2487)tag, (String)"Dye", (Enum)this.color);
        }
    }
}

