/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.escalated.walkways;

import com.simibubi.create.content.kinetics.base.KineticBlock;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.simpleRelays.AbstractSimpleShaftBlock;
import com.simibubi.create.content.kinetics.simpleRelays.ShaftBlock;
import com.simibubi.create.foundation.block.ProperWaterloggedBlock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1838;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import rbasamoyai.escalated.config.EscalatedConfigs;
import rbasamoyai.escalated.handrails.AbstractHandrailBlock;
import rbasamoyai.escalated.handrails.HandrailBlockEntity;
import rbasamoyai.escalated.index.EscalatedTriggers;
import rbasamoyai.escalated.walkways.AbstractWalkwayBlock;
import rbasamoyai.escalated.walkways.NarrowEscalatorBlock;
import rbasamoyai.escalated.walkways.NarrowWalkwayBlock;
import rbasamoyai.escalated.walkways.WalkwayBlock;
import rbasamoyai.escalated.walkways.WalkwayBlockEntity;
import rbasamoyai.escalated.walkways.WalkwayCaps;
import rbasamoyai.escalated.walkways.WalkwaySlope;
import rbasamoyai.escalated.walkways.WalkwayTerminalBlock;

public class WalkwayConnectorItem
extends class_1747 {
    private final AbstractWalkwayBlock walkwayBlock;
    private final AbstractWalkwayBlock escalatorBlock;
    private final Set<class_2248> otherBlocks = new HashSet<class_2248>();

    public WalkwayConnectorItem(WalkwayTerminalBlock primaryBlock, class_1792.class_1793 properties, NarrowWalkwayBlock walkway, NarrowEscalatorBlock escalator, class_2248 ... otherBlocks) {
        super((class_2248)primaryBlock, properties);
        this.walkwayBlock = walkway;
        this.otherBlocks.add((class_2248)this.walkwayBlock);
        this.escalatorBlock = escalator;
        this.otherBlocks.add((class_2248)this.escalatorBlock);
        this.otherBlocks.addAll(Arrays.asList(otherBlocks));
    }

    public String method_7876() {
        return this.method_7869();
    }

    public class_1269 method_7884(class_1838 context) {
        class_1657 playerEntity = context.method_8036();
        if (playerEntity != null && playerEntity.method_5715()) {
            context.method_8041().method_7980(null);
            return class_1269.field_5812;
        }
        class_1937 level = context.method_8045();
        class_2338 pos = context.method_8037();
        boolean validAxis = WalkwayConnectorItem.validateAxis(level, pos);
        if (level.field_9236) {
            return validAxis ? class_1269.field_5812 : class_1269.field_5814;
        }
        class_2487 tag = context.method_8041().method_7948();
        class_2338 firstTerminal = null;
        if (!(!tag.method_10545("FirstTerminal") || WalkwayConnectorItem.validateAxis(level, firstTerminal = class_2512.method_10691((class_2487)tag.method_10562("FirstTerminal"))) && firstTerminal.method_19771((class_2382)pos, (double)(this.maxWalkwayLength() * 2)))) {
            tag.method_10551("FirstTerminal");
            context.method_8041().method_7980(tag);
        }
        if (!validAxis || playerEntity == null) {
            return class_1269.field_5814;
        }
        if (tag.method_10545("FirstTerminal")) {
            if (!this.canConnect(level, firstTerminal, pos)) {
                return class_1269.field_5814;
            }
            if (firstTerminal != null && !firstTerminal.equals((Object)pos)) {
                this.createSteps(level, firstTerminal, pos);
                EscalatedTriggers.WALKWAY.tryAwardingTo(playerEntity);
                if (!playerEntity.method_7337()) {
                    context.method_8041().method_7934(1);
                }
            }
            if (!context.method_8041().method_7960()) {
                context.method_8041().method_7980(null);
                playerEntity.method_7357().method_7906((class_1792)this, 5);
            }
            return class_1269.field_5812;
        }
        tag.method_10566("FirstTerminal", (class_2520)class_2512.method_10692((class_2338)pos));
        context.method_8041().method_7980(tag);
        playerEntity.method_7357().method_7906((class_1792)this, 5);
        return class_1269.field_5812;
    }

    public int maxWalkwayLength() {
        return (Integer)EscalatedConfigs.SERVER.maxWalkwayLength.get();
    }

    public int maxEscalatorHeight() {
        return (Integer)EscalatedConfigs.SERVER.maxEscalatorHeight.get();
    }

    public int maxWalkwayWidth() {
        return (Integer)EscalatedConfigs.SERVER.maxWalkwayWidth.get();
    }

    public int maxEscalatorWidth() {
        return (Integer)EscalatedConfigs.SERVER.maxEscalatorWidth.get();
    }

    public static boolean validateAxis(class_1937 level, class_2338 pos) {
        class_2680 state = level.method_8320(pos);
        return level.method_8477(pos) && (ShaftBlock.isShaft((class_2680)state) || state.method_26204() instanceof WalkwayBlock);
    }

    /*
     * WARNING - void declaration
     */
    public boolean canConnect(class_1937 level, class_2338 first, class_2338 second) {
        KineticBlockEntity kbe;
        class_2586 secondAxis22;
        boolean escalator;
        int y;
        class_2338 diff;
        class_2350.class_2351 shaftAxis;
        block38: {
            block37: {
                if (!level.method_8477(first) || !level.method_8477(second)) {
                    return false;
                }
                class_2680 firstState = level.method_8320(first);
                class_2680 secondState = level.method_8320(second);
                shaftAxis = class_2350.class_2351.field_11052;
                if (ShaftBlock.isShaft((class_2680)firstState)) {
                    shaftAxis = (class_2350.class_2351)firstState.method_11654((class_2769)class_2741.field_12496);
                } else {
                    KineticBlock kinetic;
                    class_2248 class_22482 = firstState.method_26204();
                    if (class_22482 instanceof KineticBlock && (kinetic = (KineticBlock)class_22482) instanceof WalkwayBlock) {
                        shaftAxis = kinetic.getRotationAxis(firstState);
                    }
                }
                if (shaftAxis == class_2350.class_2351.field_11052) {
                    return false;
                }
                diff = second.method_10059((class_2382)first);
                int x = diff.method_10263();
                y = diff.method_10264();
                int z = diff.method_10260();
                boolean bl = escalator = y != 0;
                if (Math.abs(shaftAxis.method_10173(x, y, z)) == 1) {
                    void var21_38;
                    int MAX_WIDTH;
                    class_2338 actualDiff = new class_2338(shaftAxis.method_10173(x, 0, 0), 0, shaftAxis.method_10173(0, 0, z));
                    if (!(ShaftBlock.isShaft((class_2680)firstState) && this.canExtendWalkwayBlock(secondState) || this.canExtendWalkwayBlock(firstState) && ShaftBlock.isShaft((class_2680)secondState))) {
                        return false;
                    }
                    boolean extendingEscalator = ShaftBlock.isShaft((class_2680)firstState) ? ((WalkwayBlock)secondState.method_26204()).isEscalator(level, secondState, second) : ((WalkwayBlock)firstState.method_26204()).isEscalator(level, firstState, first);
                    if (!extendingEscalator && y != 0) {
                        return false;
                    }
                    class_2350.class_2351 secondAxis22 = class_2350.class_2351.field_11052;
                    if (ShaftBlock.isShaft((class_2680)secondState)) {
                        secondAxis22 = (class_2350.class_2351)secondState.method_11654((class_2769)class_2741.field_12496);
                    } else {
                        class_2248 class_22483 = secondState.method_26204();
                        if (class_22483 instanceof KineticBlock) {
                            KineticBlock kinetic = (KineticBlock)class_22483;
                            secondAxis22 = kinetic.getRotationAxis(secondState);
                            actualDiff = actualDiff.method_35830(-1);
                        }
                    }
                    if (shaftAxis != secondAxis22) {
                        return false;
                    }
                    List<Object> list = new ArrayList();
                    float matchSpeed = 0.0f;
                    int width = 1;
                    Object object = level.method_8321(first);
                    if (object instanceof WalkwayBlockEntity) {
                        WalkwayBlockEntity walkwayBE = (WalkwayBlockEntity)((Object)object);
                        list = walkwayBE.getAllBlocks();
                        matchSpeed = walkwayBE.getTheoreticalSpeed();
                        width = walkwayBE.getWalkwayWidth();
                    } else {
                        object = level.method_8321(second);
                        if (object instanceof WalkwayBlockEntity) {
                            WalkwayBlockEntity walkwayBE = (WalkwayBlockEntity)((Object)object);
                            list = walkwayBE.getAllBlocks();
                            matchSpeed = walkwayBE.getTheoreticalSpeed();
                            width = walkwayBE.getWalkwayWidth();
                        }
                    }
                    if (list.isEmpty()) {
                        return false;
                    }
                    int sz = list.size();
                    int y1 = ((class_2338)list.get(0)).method_10264();
                    for (class_2338 class_23382 : list) {
                        if (class_23382.method_10264() == y1) continue;
                        escalator = true;
                        break;
                    }
                    int n = MAX_WIDTH = escalator ? this.maxEscalatorWidth() : this.maxWalkwayWidth();
                    if (width >= MAX_WIDTH) {
                        return false;
                    }
                    boolean bl2 = false;
                    while (var21_38 < sz) {
                        class_2338 pos = (class_2338)list.get((int)var21_38);
                        class_2338 destPos = pos.method_10081((class_2382)actualDiff);
                        class_2680 currentState = level.method_8320(destPos);
                        boolean correctShaft = ShaftBlock.isShaft((class_2680)currentState) && currentState.method_11654((class_2769)class_2741.field_12496) == shaftAxis;
                        boolean empty = currentState.method_45474();
                        if ((var21_38 == false || var21_38 == sz - 1) && !correctShaft || !correctShaft && !empty) {
                            return false;
                        }
                        if (escalator && var21_38 != false && var21_38 != sz - 1 && !empty) {
                            return false;
                        }
                        if (correctShaft) {
                            void kbe2;
                            class_2586 class_25862 = level.method_8321(destPos);
                            if (!(class_25862 instanceof KineticBlockEntity)) {
                                return false;
                            }
                            KineticBlockEntity kbe22 = (KineticBlockEntity)class_25862;
                            float speed2 = kbe2.getTheoreticalSpeed();
                            if (Math.signum(matchSpeed) != Math.signum(speed2) && matchSpeed != 0.0f && speed2 != 0.0f) {
                                return false;
                            }
                        }
                        ++var21_38;
                    }
                    return true;
                }
                if (escalator && Math.abs(second.method_10264() - first.method_10264()) > this.maxEscalatorHeight() || !escalator && !second.method_19771((class_2382)first, (double)this.maxWalkwayLength())) {
                    return false;
                }
                if (shaftAxis.method_10173(x, y, z) != 0) {
                    return false;
                }
                if (escalator && Math.abs(x) != Math.abs(y) + 3 && Math.abs(z) != Math.abs(y) + 3) {
                    return false;
                }
                if (!(escalator || Math.abs(x) != 1 && Math.abs(z) != 1)) {
                    return false;
                }
                if (!ShaftBlock.isShaft((class_2680)firstState) || !ShaftBlock.isShaft((class_2680)secondState) || shaftAxis != secondState.method_11654((class_2769)class_2741.field_12496)) {
                    return false;
                }
                secondAxis22 = level.method_8321(first);
                if (!(secondAxis22 instanceof KineticBlockEntity)) break block37;
                kbe = (KineticBlockEntity)secondAxis22;
                secondAxis22 = level.method_8321(second);
                if (secondAxis22 instanceof KineticBlockEntity) break block38;
            }
            return false;
        }
        KineticBlockEntity kbe1 = (KineticBlockEntity)secondAxis22;
        float speed1 = kbe.getTheoreticalSpeed();
        float speed2 = kbe1.getTheoreticalSpeed();
        if (Math.signum(speed1) != Math.signum(speed2) && speed1 != 0.0f && speed2 != 0.0f) {
            return false;
        }
        class_2338 step = class_2338.method_49637((double)Math.signum(diff.method_10263()), (double)Math.signum(diff.method_10264()), (double)Math.signum(diff.method_10260()));
        if (escalator) {
            boolean firstLower = y > 0;
            class_2338 lowerPos = firstLower ? first : second;
            class_2338 upperPos = firstLower ? second : first;
            int sgn = firstLower ? 1 : -1;
            ArrayList<class_2338> arrayList = new ArrayList<class_2338>();
            lowerPos = lowerPos.method_10069(sgn * step.method_10263(), 0, sgn * step.method_10260());
            arrayList.add(lowerPos);
            arrayList.add(upperPos.method_10069(sgn * -step.method_10263(), 0, sgn * -step.method_10260()));
            upperPos = upperPos.method_10069(sgn * -step.method_10263() * 2, 0, sgn * -step.method_10260() * 2);
            arrayList.add(upperPos);
            for (class_2338 pos : arrayList) {
                class_2680 blockState = level.method_8320(pos);
                if (ShaftBlock.isShaft((class_2680)blockState) && blockState.method_11654((class_2769)AbstractSimpleShaftBlock.AXIS) == shaftAxis && (pos.equals((Object)lowerPos) || pos.equals((Object)upperPos)) || blockState.method_45474()) continue;
                return false;
            }
            first = firstLower ? lowerPos : upperPos;
            second = firstLower ? upperPos : lowerPos;
        }
        int LIMIT = 1000;
        class_2338 currentPos = first.method_10081((class_2382)step);
        while (!currentPos.equals((Object)second) && LIMIT-- > 0) {
            class_2680 blockState = level.method_8320(currentPos);
            if (!(!escalator && ShaftBlock.isShaft((class_2680)blockState) && blockState.method_11654((class_2769)AbstractSimpleShaftBlock.AXIS) == shaftAxis || blockState.method_45474())) {
                return false;
            }
            currentPos = currentPos.method_10081((class_2382)step);
        }
        return true;
    }

    public void createSteps(class_1937 level, class_2338 start, class_2338 end) {
        level.method_8396(null, class_2338.method_49638((class_2374)VecHelper.getCenterOf((class_2382)start.method_10081((class_2382)end)).method_1021(0.5)), this.getPlaceSoundEvent(), class_3419.field_15245, 0.5f, 1.0f);
        class_2338 diff = end.method_10059((class_2382)start);
        int x = diff.method_10263();
        int y = diff.method_10264();
        int z = diff.method_10260();
        boolean escalator = y != 0;
        class_2680 firstState = level.method_8320(start);
        class_2350.class_2351 shaftAxis = class_2350.class_2351.field_11052;
        if (ShaftBlock.isShaft((class_2680)firstState)) {
            shaftAxis = (class_2350.class_2351)firstState.method_11654((class_2769)class_2741.field_12496);
        } else {
            KineticBlock kinetic;
            class_2248 class_22482 = firstState.method_26204();
            if (class_22482 instanceof KineticBlock && (kinetic = (KineticBlock)class_22482) instanceof WalkwayBlock) {
                shaftAxis = kinetic.getRotationAxis(firstState);
            }
        }
        if (shaftAxis == class_2350.class_2351.field_11052) {
            return;
        }
        if (Math.abs(shaftAxis.method_10173(x, y, z)) == 1) {
            class_2680 aboveSrcState;
            class_2338 aboveSrcPos;
            class_2338 destPos;
            class_2338 srcPos;
            int i;
            class_2338 actualDiff = new class_2338(shaftAxis.method_10173(x, 0, 0), 0, shaftAxis.method_10173(0, 0, z));
            List<Object> list = new ArrayList();
            class_2338 referencePos = start;
            class_2586 class_25862 = level.method_8321(start);
            if (class_25862 instanceof WalkwayBlockEntity) {
                WalkwayBlockEntity walkwayBE = (WalkwayBlockEntity)class_25862;
                list = walkwayBE.getAllBlocks();
                referencePos = walkwayBE.widthReferencePos;
            } else {
                class_25862 = level.method_8321(end);
                if (class_25862 instanceof WalkwayBlockEntity) {
                    WalkwayBlockEntity walkwayBE = (WalkwayBlockEntity)class_25862;
                    list = walkwayBE.getAllBlocks();
                    actualDiff = actualDiff.method_35830(-1);
                    referencePos = walkwayBE.widthReferencePos;
                }
            }
            if (list.isEmpty()) {
                return;
            }
            Collections.reverse(list);
            int sz = list.size();
            class_2350 face = class_2350.method_10147((float)actualDiff.method_10263(), (float)actualDiff.method_10264(), (float)actualDiff.method_10260());
            for (i = 0; i < sz; ++i) {
                boolean left;
                srcPos = (class_2338)list.get(i);
                destPos = srcPos.method_10081((class_2382)actualDiff);
                class_2680 srcState = level.method_8320(srcPos);
                class_2680 destState = level.method_8320(destPos);
                boolean isShaft = ShaftBlock.isShaft((class_2680)destState);
                class_2248 class_22483 = srcState.method_26204();
                if (!(class_22483 instanceof WalkwayBlock)) continue;
                WalkwayBlock walkwaySrc = (WalkwayBlock)class_22483;
                class_22483 = level.method_8321(srcPos);
                if (!(class_22483 instanceof WalkwayBlockEntity)) continue;
                WalkwayBlockEntity walkwayBE = (WalkwayBlockEntity)class_22483;
                class_1767 color = walkwayBE.getColor();
                float visualProgress = walkwayBE.getVisualProgress();
                class_2350 walkwayFacing = walkwaySrc.getFacing(srcState);
                boolean bl = left = walkwayFacing.method_10160() == face;
                if (i == 0 || i == sz - 1) {
                    left = !left;
                }
                boolean srcShaft = walkwaySrc.hasWalkwayShaft(srcState);
                class_2680 replaceSrcState = walkwaySrc.transformFromMerge(level, srcState, srcPos, left, srcShaft, false, true);
                class_2680 placeState = walkwaySrc.transformFromMerge(level, srcState, srcPos, !left, isShaft, false, false);
                KineticBlockEntity.switchToBlockState((class_1937)level, (class_2338)srcPos, (class_2680)replaceSrcState);
                KineticBlockEntity.switchToBlockState((class_1937)level, (class_2338)destPos, (class_2680)placeState);
                class_2586 class_25863 = level.method_8321(srcPos);
                if (class_25863 instanceof WalkwayBlockEntity) {
                    WalkwayBlockEntity newWalkwayBE = (WalkwayBlockEntity)class_25863;
                    newWalkwayBE.applyColor(color);
                    newWalkwayBE.setVisualProgress(visualProgress);
                    newWalkwayBE.widthReferencePos = referencePos;
                    newWalkwayBE.resetClientRender = true;
                    newWalkwayBE.notifyUpdate();
                }
                if (!((class_25863 = level.method_8321(destPos)) instanceof WalkwayBlockEntity)) continue;
                WalkwayBlockEntity destWalkwayBE = (WalkwayBlockEntity)class_25863;
                destWalkwayBE.applyColor(color);
                destWalkwayBE.setVisualProgress(visualProgress);
                destWalkwayBE.widthReferencePos = referencePos;
                destWalkwayBE.resetClientRender = true;
                destWalkwayBE.notifyUpdate();
            }
            for (i = 0; i < sz; ++i) {
                class_2338 aboveDestPos;
                srcPos = (class_2338)list.get(i);
                destPos = srcPos.method_10081((class_2382)actualDiff);
                aboveSrcPos = srcPos.method_10084();
                aboveSrcState = level.method_8320(aboveSrcPos);
                if (!(aboveSrcState.method_26204() instanceof AbstractHandrailBlock) || level.method_8320(aboveDestPos = destPos.method_10084()).method_45474()) continue;
                level.method_22352(aboveSrcPos, true);
                return;
            }
            for (i = 0; i < sz; ++i) {
                class_2338 oppositePos;
                class_2586 class_25864;
                HandrailBlockEntity handrailBE;
                AbstractHandrailBlock.Side srcSide;
                srcPos = (class_2338)list.get(i);
                destPos = srcPos.method_10081((class_2382)actualDiff);
                aboveSrcPos = srcPos.method_10084();
                aboveSrcState = level.method_8320(aboveSrcPos);
                if (!(aboveSrcState.method_26204() instanceof AbstractHandrailBlock)) continue;
                class_2338 aboveDestPos = destPos.method_10084();
                int width = 1;
                class_2350 forward = (class_2350)aboveSrcState.method_11654((class_2769)AbstractHandrailBlock.field_11177);
                class_2350 handrailLeft = forward.method_10160();
                if (aboveSrcState.method_11654(AbstractHandrailBlock.SIDE) == AbstractHandrailBlock.Side.BOTH) {
                    AbstractHandrailBlock.Side destSide = face == handrailLeft ? AbstractHandrailBlock.Side.LEFT : AbstractHandrailBlock.Side.RIGHT;
                    srcSide = destSide == AbstractHandrailBlock.Side.LEFT ? AbstractHandrailBlock.Side.RIGHT : AbstractHandrailBlock.Side.LEFT;
                    level.method_8652(aboveSrcPos, ProperWaterloggedBlock.withWater((class_1936)level, (class_2680)((class_2680)aboveSrcState.method_11657(AbstractHandrailBlock.SIDE, (Comparable)((Object)srcSide))), (class_2338)aboveSrcPos), 3);
                    level.method_8652(aboveDestPos, ProperWaterloggedBlock.withWater((class_1936)level, (class_2680)((class_2680)aboveSrcState.method_11657(AbstractHandrailBlock.SIDE, (Comparable)((Object)destSide))), (class_2338)aboveDestPos), 3);
                } else {
                    level.method_8652(aboveDestPos, ProperWaterloggedBlock.withWater((class_1936)level, (class_2680)aboveSrcState, (class_2338)aboveDestPos), 3);
                    srcSide = level.method_8321(aboveSrcPos);
                    if (srcSide instanceof HandrailBlockEntity) {
                        handrailBE = (HandrailBlockEntity)((Object)srcSide);
                        handrailBE.propagateBreak = false;
                        width = handrailBE.width;
                    }
                    level.method_8652(aboveSrcPos, ProperWaterloggedBlock.withWater((class_1936)level, (class_2680)class_2246.field_10124.method_9564(), (class_2338)aboveSrcPos), 3);
                }
                ++width;
                srcSide = level.method_8321(aboveDestPos);
                if (srcSide instanceof HandrailBlockEntity) {
                    handrailBE = (HandrailBlockEntity)((Object)srcSide);
                    handrailBE.width = width;
                }
                if (!((class_25864 = level.method_8321(oppositePos = aboveDestPos.method_10079(face.method_10153(), width - 1))) instanceof HandrailBlockEntity)) continue;
                HandrailBlockEntity handrailBE2 = (HandrailBlockEntity)class_25864;
                handrailBE2.width = width;
            }
            return;
        }
        class_2350 facing = WalkwayConnectorItem.getFacingFromTo(start, end);
        KineticBlockEntity.switchToBlockState((class_1937)level, (class_2338)start, (class_2680)((class_2680)this.method_7711().method_9564().method_11657(WalkwayTerminalBlock.HORIZONTAL_FACING, (Comparable)facing)));
        KineticBlockEntity.switchToBlockState((class_1937)level, (class_2338)end, (class_2680)((class_2680)this.method_7711().method_9564().method_11657(WalkwayTerminalBlock.HORIZONTAL_FACING, (Comparable)facing.method_10153())));
        List<class_2338> walkwaysToCreate = WalkwayConnectorItem.getWalkwayChainBetween(start, end, escalator, facing);
        if (escalator && end.method_10059((class_2382)start).method_10264() <= 0) {
            facing = facing.method_10153();
        }
        boolean failed = false;
        for (class_2338 pos : walkwaysToCreate) {
            class_2680 existingBlock = level.method_8320(pos);
            if (existingBlock.method_26214((class_1922)level, pos) == -1.0f) {
                failed = true;
                break;
            }
            class_2680 shaftState = level.method_8320(pos);
            boolean existingShaft = ShaftBlock.isShaft((class_2680)shaftState);
            if (!existingBlock.method_45474()) {
                level.method_22352(pos, false);
            }
            class_2680 placeState = this.getPlacedWalkwayBlock(escalator, facing, existingShaft);
            KineticBlockEntity.switchToBlockState((class_1937)level, (class_2338)pos, (class_2680)placeState);
        }
        if (!failed) {
            if (escalator) {
                boolean firstLower = end.method_10059((class_2382)start).method_10264() > 0;
                class_2338 lowerPos = firstLower ? start : end;
                class_2338 upperPos = firstLower ? end : start;
                class_2338 horizontalPos = upperPos.method_10079(facing, -1);
                class_2680 horizontalState = level.method_8320(horizontalPos);
                KineticBlockEntity.switchToBlockState((class_1937)level, (class_2338)horizontalPos, (class_2680)((class_2680)horizontalState.method_11657(WalkwayBlock.SLOPE, (Comparable)((Object)WalkwaySlope.HORIZONTAL))));
                class_2338 topPos = upperPos.method_10079(facing, -2);
                class_2680 topState = level.method_8320(topPos);
                KineticBlockEntity.switchToBlockState((class_1937)level, (class_2338)topPos, (class_2680)((class_2680)topState.method_11657(WalkwayBlock.SLOPE, (Comparable)((Object)WalkwaySlope.TOP))));
                class_2338 bottomPos = lowerPos.method_10093(facing);
                class_2680 bottomState = level.method_8320(bottomPos);
                KineticBlockEntity.switchToBlockState((class_1937)level, (class_2338)bottomPos, (class_2680)((class_2680)bottomState.method_11657(WalkwayBlock.SLOPE, (Comparable)((Object)WalkwaySlope.BOTTOM))));
            }
            return;
        }
        for (class_2338 pos : walkwaysToCreate) {
            class_2680 failedState = level.method_8320(pos);
            if (!(failedState.method_26204() instanceof WalkwayBlock)) continue;
            level.method_22352(pos, false);
        }
    }

    protected class_2680 getPlacedWalkwayBlock(boolean escalator, class_2350 facing, boolean shaft) {
        if (escalator) {
            return (class_2680)((class_2680)this.escalatorBlock.method_9564().method_11657((class_2769)AbstractWalkwayBlock.SLOPE, (Comparable)((Object)WalkwaySlope.MIDDLE))).method_11657(AbstractWalkwayBlock.HORIZONTAL_FACING, (Comparable)facing);
        }
        return (class_2680)((class_2680)this.walkwayBlock.method_9564().method_11657(AbstractWalkwayBlock.HORIZONTAL_FACING, (Comparable)facing)).method_11657(WalkwayBlock.CAPS, (Comparable)((Object)(shaft ? WalkwayCaps.NONE : WalkwayCaps.NO_SHAFT)));
    }

    protected class_3414 getPlaceSoundEvent() {
        return class_3417.field_24063;
    }

    private static class_2350 getFacingFromTo(class_2338 start, class_2338 end) {
        class_2350.class_2351 beltAxis = start.method_10263() == end.method_10263() ? class_2350.class_2351.field_11051 : class_2350.class_2351.field_11048;
        class_2338 diff = end.method_10059((class_2382)start);
        class_2350.class_2352 axisDirection = beltAxis.method_10173(diff.method_10263(), 0, diff.method_10260()) > 0 ? class_2350.class_2352.field_11056 : class_2350.class_2352.field_11060;
        return class_2350.method_10156((class_2350.class_2352)axisDirection, (class_2350.class_2351)beltAxis);
    }

    private static List<class_2338> getWalkwayChainBetween(class_2338 start, class_2338 end, boolean escalator, class_2350 direction) {
        LinkedList<class_2338> positions = new LinkedList<class_2338>();
        int limit = 1000;
        if (escalator) {
            class_2338 upperPos;
            boolean firstLower = end.method_10059((class_2382)start).method_10264() > 0;
            class_2338 lowerPos = firstLower ? start : end;
            class_2338 class_23382 = upperPos = firstLower ? end : start;
            if (!firstLower) {
                direction = direction.method_10153();
            }
            positions.add(upperPos.method_10079(direction, -1));
            positions.add(upperPos.method_10079(direction, -2));
            start = lowerPos.method_10093(direction);
            end = upperPos.method_10079(direction, -2);
        }
        class_2338 current = start;
        do {
            positions.add(current);
            current = current.method_10093(direction);
            if (!escalator) continue;
            current = current.method_10084();
        } while (!current.equals((Object)end) && limit-- > 0);
        if (!escalator) {
            positions.remove(start);
        }
        return positions;
    }

    public void method_7713(Map<class_2248, class_1792> map, class_1792 item) {
        super.method_7713(map, item);
        for (class_2248 b : this.otherBlocks) {
            map.put(b, item);
        }
    }

    protected boolean canExtendWalkwayBlock(class_2680 state) {
        return state.method_27852(this.method_7711()) || this.otherBlocks.contains(state.method_26204());
    }
}

