/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.escalated.walkways;

import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.kinetics.base.KineticBlock;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityVisual;
import com.simibubi.create.content.kinetics.base.RotatingInstance;
import com.simibubi.create.foundation.render.AllInstanceTypes;
import dev.engine_room.flywheel.api.instance.Instance;
import dev.engine_room.flywheel.api.instance.Instancer;
import dev.engine_room.flywheel.api.model.Model;
import dev.engine_room.flywheel.api.visual.DynamicVisual;
import dev.engine_room.flywheel.api.visualization.VisualizationContext;
import dev.engine_room.flywheel.lib.instance.FlatLit;
import dev.engine_room.flywheel.lib.instance.InstanceTypes;
import dev.engine_room.flywheel.lib.instance.OrientedInstance;
import dev.engine_room.flywheel.lib.model.Models;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import dev.engine_room.flywheel.lib.visual.SimpleDynamicVisual;
import java.util.function.Consumer;
import net.minecraft.class_1767;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_4538;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3fc;
import rbasamoyai.escalated.walkways.WalkwayBlock;
import rbasamoyai.escalated.walkways.WalkwayBlockEntity;
import rbasamoyai.escalated.walkways.WalkwayRenderer;
import rbasamoyai.escalated.walkways.WalkwaySlope;

public class WalkwayVisual
extends KineticBlockEntityVisual<WalkwayBlockEntity>
implements SimpleDynamicVisual {
    private final RotatingInstance leftShaft;
    private final RotatingInstance rightShaft;
    private final RotatingInstance bottomShaft;
    private final OrientedInstance backStep;
    private final OrientedInstance frontStep;
    private class_1767 color;

    public WalkwayVisual(VisualizationContext ctx, WalkwayBlockEntity blockEntity, float partialTick) {
        super(ctx, (KineticBlockEntity)blockEntity, partialTick);
        KineticBlock kinetic = (KineticBlock)this.blockState.method_26204();
        WalkwayBlock walkway = (WalkwayBlock)this.blockState.method_26204();
        class_1937 level = ((WalkwayBlockEntity)this.blockEntity).method_10997();
        class_2350 left = class_2350.method_10169((class_2350.class_2351)kinetic.getRotationAxis(this.blockState), (class_2350.class_2352)class_2350.class_2352.field_11056);
        class_2350 right = left.method_10153();
        this.leftShaft = kinetic.hasShaftTowards((class_4538)level, this.pos, this.blockState, left) ? (RotatingInstance)this.getShaftInstancer(left).createInstance() : (RotatingInstance)this.getEmptyShaftInstancer().createInstance();
        this.leftShaft.setPosition((class_2382)this.getVisualPosition()).setup((KineticBlockEntity)blockEntity, left.method_10166());
        this.rightShaft = kinetic.hasShaftTowards((class_4538)level, this.pos, this.blockState, right) ? (RotatingInstance)this.getShaftInstancer(right).createInstance() : (RotatingInstance)this.getEmptyShaftInstancer().createInstance();
        this.rightShaft.setPosition((class_2382)this.getVisualPosition()).setup((KineticBlockEntity)blockEntity, right.method_10166());
        this.bottomShaft = kinetic.hasShaftTowards((class_4538)level, this.pos, this.blockState, class_2350.field_11033) ? (RotatingInstance)this.getShaftInstancer(class_2350.field_11033).createInstance() : (RotatingInstance)this.getEmptyShaftInstancer().createInstance();
        this.bottomShaft.setPosition((class_2382)this.getVisualPosition()).setup((KineticBlockEntity)blockEntity, class_2350.class_2351.field_11052);
        boolean isTerminal = walkway.getWalkwaySlope(this.blockState) == WalkwaySlope.TERMINAL;
        boolean isController = ((WalkwayBlockEntity)this.blockEntity).isController();
        class_2350 facing = this.getFacing();
        class_2338 pos1 = this.getVisualPosition();
        this.color = ((WalkwayBlockEntity)this.blockEntity).getColor();
        PartialModel model = this.getStepModel();
        if (isTerminal) {
            boolean flag = facing == class_2350.field_11043 || facing == class_2350.field_11034;
            class_2350 class_23502 = facing = isController ? facing.method_10153() : facing;
            if (flag) {
                this.backStep = (OrientedInstance)this.getStepInstancer(Models.partial((PartialModel)model, (class_2350)facing)).createInstance();
                this.backStep.position((Vector3fc)WalkwayRenderer.getStepOffset((WalkwayBlockEntity)this.blockEntity, facing, pos1, false)).setChanged();
                this.frontStep = (OrientedInstance)this.getEmptyStepInstancer().createInstance();
            } else {
                this.frontStep = (OrientedInstance)this.getStepInstancer(Models.partial((PartialModel)model, (class_2350)facing)).createInstance();
                this.frontStep.position((Vector3fc)WalkwayRenderer.getStepOffset((WalkwayBlockEntity)this.blockEntity, facing, pos1, true)).setChanged();
                this.backStep = (OrientedInstance)this.getEmptyStepInstancer().createInstance();
            }
        } else {
            this.frontStep = (OrientedInstance)this.getStepInstancer(Models.partial((PartialModel)model, (class_2350)facing)).createInstance();
            this.frontStep.position((Vector3fc)WalkwayRenderer.getStepOffset((WalkwayBlockEntity)this.blockEntity, facing, pos1, true)).setChanged();
            this.backStep = (OrientedInstance)this.getStepInstancer(Models.partial((PartialModel)model, (class_2350)facing)).createInstance();
            this.backStep.position((Vector3fc)WalkwayRenderer.getStepOffset((WalkwayBlockEntity)this.blockEntity, facing, pos1, false)).setChanged();
        }
    }

    private Instancer<RotatingInstance> getShaftInstancer(class_2350 dir) {
        return this.instancerProvider().instancer(AllInstanceTypes.ROTATING, Models.partial((PartialModel)AllPartialModels.SHAFT_HALF, (class_2350)dir));
    }

    private Instancer<RotatingInstance> getEmptyShaftInstancer() {
        return this.instancerProvider().instancer(AllInstanceTypes.ROTATING, Models.block((class_2680)class_2246.field_10124.method_9564()));
    }

    private Instancer<OrientedInstance> getStepInstancer(Model model) {
        return this.instancerProvider().instancer(InstanceTypes.ORIENTED, model);
    }

    private Instancer<OrientedInstance> getEmptyStepInstancer() {
        return this.instancerProvider().instancer(InstanceTypes.ORIENTED, Models.block((class_2680)class_2246.field_10124.method_9564()));
    }

    private void updateSteps() {
        WalkwayBlock walkway = (WalkwayBlock)this.blockState.method_26204();
        boolean isTerminal = walkway.getWalkwaySlope(this.blockState) == WalkwaySlope.TERMINAL;
        boolean isController = ((WalkwayBlockEntity)this.blockEntity).isController();
        class_2350 facing = this.getFacing();
        PartialModel model = this.getStepModel();
        if (isTerminal) {
            boolean flag = facing == class_2350.field_11043 || facing == class_2350.field_11034;
            class_2350 class_23502 = facing = isController ? facing.method_10153() : facing;
            if (flag) {
                this.getStepInstancer(Models.partial((PartialModel)model, (class_2350)facing)).stealInstance((Instance)this.backStep);
                this.getEmptyStepInstancer().stealInstance((Instance)this.frontStep);
            } else {
                this.getStepInstancer(Models.partial((PartialModel)model, (class_2350)facing)).stealInstance((Instance)this.frontStep);
                this.getEmptyStepInstancer().stealInstance((Instance)this.backStep);
            }
        } else {
            this.getStepInstancer(Models.partial((PartialModel)model, (class_2350)facing)).stealInstance((Instance)this.frontStep);
            this.getStepInstancer(Models.partial((PartialModel)model, (class_2350)facing)).stealInstance((Instance)this.backStep);
        }
        this.frontStep.setChanged();
        this.backStep.setChanged();
    }

    public void _delete() {
        this.leftShaft.delete();
        this.rightShaft.delete();
        this.bottomShaft.delete();
        this.backStep.delete();
        this.frontStep.delete();
    }

    protected class_2350 getFacing() {
        return ((WalkwayBlock)this.blockState.method_26204()).getFacing(this.blockState);
    }

    public void beginFrame(DynamicVisual.Context ctx) {
        class_2350 facing = this.getFacing();
        class_2338 pos = this.getVisualPosition();
        this.frontStep.position((Vector3fc)WalkwayRenderer.getStepOffset((WalkwayBlockEntity)this.blockEntity, facing, pos, true)).setChanged();
        this.backStep.position((Vector3fc)WalkwayRenderer.getStepOffset((WalkwayBlockEntity)this.blockEntity, facing, pos, false)).setChanged();
    }

    public void update(float partialTick) {
        super.update(partialTick);
        KineticBlock kinetic = (KineticBlock)this.blockState.method_26204();
        class_2350.class_2351 axis = kinetic.getRotationAxis(this.blockState);
        if (((WalkwayBlockEntity)this.blockEntity).getColor() != this.color || ((WalkwayBlockEntity)this.blockEntity).resetClientRender) {
            this.color = ((WalkwayBlockEntity)this.blockEntity).getColor();
            ((WalkwayBlockEntity)this.blockEntity).resetClientRender = false;
            this.updateSteps();
        }
        this.leftShaft.setup((KineticBlockEntity)this.blockEntity, axis).setChanged();
        this.rightShaft.setup((KineticBlockEntity)this.blockEntity, axis).setChanged();
        this.bottomShaft.setup((KineticBlockEntity)this.blockEntity, class_2350.class_2351.field_11052).setChanged();
    }

    public void updateLight(float partialTick) {
        this.relight(this.pos, new FlatLit[]{this.leftShaft});
        this.relight(this.pos, new FlatLit[]{this.rightShaft});
        this.relight(this.pos, new FlatLit[]{this.bottomShaft});
        this.relight(this.pos, new FlatLit[]{this.backStep});
        this.relight(this.pos, new FlatLit[]{this.frontStep});
    }

    protected PartialModel getStepModel() {
        return WalkwayRenderer.baseGetStepModel((WalkwayBlockEntity)this.blockEntity);
    }

    public void collectCrumblingInstances(Consumer<@Nullable Instance> consumer) {
        consumer.accept((Instance)this.leftShaft);
        consumer.accept((Instance)this.rightShaft);
        consumer.accept((Instance)this.bottomShaft);
        consumer.accept((Instance)this.frontStep);
        consumer.accept((Instance)this.backStep);
    }
}

