package com.quantumgarbage.screenshotsettings.util.getters;

//? if fabric {
/*import com.quantumgarbage.screenshotsettings.platforms.fabric.client.ScreenshotSettingsClient;
import static com.quantumgarbage.screenshotsettings.platforms.fabric.client.ScreenshotSettingsClient.LOGGER;
*///?} else {
import com.quantumgarbage.screenshotsettings.platforms.neoforge.client.ScreenshotSettingsClient;
import static com.quantumgarbage.screenshotsettings.platforms.neoforge.client.ScreenshotSettingsClient.LOGGER;
//?}
import com.quantumgarbage.screenshotsettings.integrations.Shaders;
import dev.architectury.platform.Platform;
import java.util.HashMap;
import java.util.Iterator;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.server.IntegratedServer;
import net.minecraft.server.packs.PackResources;
import net.minecraft.world.level.storage.ServerLevelData;
import net.minecraft.world.phys.Vec3;

public class GameMeta {
    public static String getCoordinatesMetadata(final Minecraft client) {
        final var p = client.player;
        assert null != p;
        final Vec3 pos = getCoordinates(p);
        return String.format("X:[%.3f] Y:[%.3f] Z:[%.3f] Yaw:[%.3f] Pitch:[%.3f]", pos.x, pos.y, pos.z, p.getYRot(), p.getXRot());
    }

    public static Vec3 getCoordinates(final LocalPlayer p) {
        try {
            return p.position();
        } catch (NullPointerException e) {
            LOGGER.error("Unable to get player coordinates. Did you try to take the screenshot before you finished loading in?");
            e.printStackTrace();
            return new Vec3(0, 0, 0);
        }
    }

    public static String getPlayerName(final Minecraft client) {
        return client.getUser().getName();
    }

    private static String getWorldNameSinglePlayer(final Minecraft client) {
        assert null != client.getSingleplayerServer();
        try {
            final ServerLevelData worldProperties = (ServerLevelData) client.getSingleplayerServer().getAllLevels().iterator().next().getLevelData();

            return worldProperties.getLevelName();
        } catch (Exception e) {
            LOGGER.error("Unable to get world name for a screenshot.\n" + e);
            return "Unknown World";
        }


    }

    private static String getWorldNameMultiplayer(final Minecraft client) {
        try {
            final ServerData si = client.getCurrentServer();
            assert si != null;
            return si.name;
        } catch (Exception e) {
            LOGGER.error("Unable to get world name for a screenshot.\n" + e);
            return "Unknown World";
        }
    }

    public static String getWorldName(final Minecraft client) {
        if (isSinglePlayer(client)) {
            return getWorldNameSinglePlayer(client);
        } else {
            return getWorldNameMultiplayer(client);
        }
    }

    public static String getSeed(final Minecraft client) {
        if (isSinglePlayer(client)) {
            final IntegratedServer server = client.getSingleplayerServer();
            assert null != server;
            return Long.toString(server.getAllLevels().iterator().next().getSeed());
        }
        return "Screenshot taken in Multiplayer -- Seed Unknown";
    }

    private static boolean isSinglePlayer(final Minecraft client) {
        return client.isLocalServer();
    }

    public static String getResourcePacks(final Minecraft client) {
        final StringBuilder base = new StringBuilder("[");
        final Iterator<PackResources> resourcePackIterator = client.getResourceManager().listPacks().iterator();
        while (resourcePackIterator.hasNext()) {
            base.append(String.format("%s", resourcePackIterator.next()
                    //? if <1.21 {
                    /*.getName()));
                    *///?} elif =1.21.1 {
                    .packId()));
                    //?}
            if (resourcePackIterator.hasNext()) {
                base.append(", ");
            }
        }
        base.append("]");
        return base.toString();
    }

    public static String getVersion(final Minecraft client) {
        String version = Platform.getMinecraftVersion();
        if(Platform.isFabric()){
            return version + " " + "Fabric";
        } else{
            return version + " " + "NeoForge";
        }
    }

    public static String timedate() {
        return Util.getFilenameFormattedDateTime();
    }

    public static HashMap<String, String> getMetadata(final Minecraft client) {
        final HashMap<String, String> meta = new HashMap<>();
        // make sure that metadata even is possible to obtain.
        if (null == client.player || null == client.level) {
            return meta;
        }

        if (!ScreenshotSettingsClient.CONFIG.useMetadata) {
            return meta;
        }
        if (ScreenshotSettingsClient.CONFIG.coordinates) {
            meta.put("Coordinates", getCoordinatesMetadata(client));
        }
        if (ScreenshotSettingsClient.CONFIG.worldName) {
            meta.put("World/Server Name", getWorldName(client));
        }
        if (ScreenshotSettingsClient.CONFIG.seed) {
            meta.put("World Seed", getSeed(client));
        }
        if (ScreenshotSettingsClient.CONFIG.resourcePacks) {
            meta.put("Resource Packs", getResourcePacks(client));
        }
        if (ScreenshotSettingsClient.CONFIG.shaderPack && Shaders.irisPresent()) {
            meta.put("Shader Pack", Shaders.getShaderName());
        }
        if (ScreenshotSettingsClient.CONFIG.mcVersion) {
            meta.put("Minecraft Version", getVersion(client));
        }
        return meta;
    }

}