/*
 * Decompiled with CFR 0.152.
 */
package com.quantumgarbage.screenshotsettings;

import com.quantumgarbage.screenshotsettings.platforms.neoforge.client.ScreenshotSettingsClient;
import dev.isxander.yacl3.api.ButtonOption;
import dev.isxander.yacl3.api.ConfigCategory;
import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.api.OptionDescription;
import dev.isxander.yacl3.api.OptionGroup;
import dev.isxander.yacl3.api.YetAnotherConfigLib;
import dev.isxander.yacl3.api.controller.BooleanControllerBuilder;
import dev.isxander.yacl3.api.controller.StringControllerBuilder;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.ConfigHolder;
import me.shedaniel.autoconfig.annotation.ConfigEntry;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.lwjgl.util.tinyfd.TinyFileDialogs;

@me.shedaniel.autoconfig.annotation.Config(name="assets/screenshotsettings")
public class Config
implements ConfigData {
    private static final String templatingTooltip = "\u00a7l\u00a73<datetime>\u00a7r\n    - Minecraft's default screenshot naming format.\n\n\u00a7l\u00a73<world>\u00a7r\n    - The name of the world in Single Player, and the name of the server in Multiplayer.\n\n\u00a7l\u00a73<version>\u00a7r\n    - The version of Minecraft the screenshot was taken on. (Ex. 1.19.2)\n\n\u00a7l\u00a73<x>, <y>, and <z>\u00a7r\n    - The respective coordinates of where the screenshot was taken.\n\n\u00a7l\u00a73<shader>\u00a7r\n    - The active Shader pack. (requires Iris Shaders)\n\n\u00a7l\u00a73<player>\u00a7r\n    - Your Minecraft username.\n";
    @ConfigEntry.Category(value="Screenshot Directory")
    public String screenshotDirectory;
    public boolean useCustomScreenshotDirectory;
    @ConfigEntry.Category(value="Metadata")
    public boolean useMetadata;
    public boolean coordinates;
    public boolean worldName;
    public boolean mcVersion;
    public boolean shaderPack;
    public boolean resourcePacks;
    public boolean seed;
    @ConfigEntry.Category(value="Naming Scheme")
    public boolean useCustomScreenshotNamingSchema;
    public String screenshotNamingSchema;

    public String getScreenshotDirectory() {
        if (!this.useCustomScreenshotDirectory) {
            return "./screenshots/";
        }
        return this.screenshotDirectory + "/";
    }

    public void validatePostLoad() throws ConfigData.ValidationException {
        if (null == this.screenshotDirectory) {
            this.screenshotDirectory = "./screenshots";
        }
        if (null == this.screenshotNamingSchema) {
            this.screenshotNamingSchema = "<datetime>";
        }
        super.validatePostLoad();
    }

    public Screen createGui(Screen parent) {
        Config INSTANCE = ScreenshotSettingsClient.CONFIG;
        Option screenshotDirectory = Option.createBuilder().name(Component.nullToEmpty((String)"Custom Screenshot Directory")).description(OptionDescription.of((Component[])new Component[]{Component.nullToEmpty((String)"Where screenshots will be saved to, provided Use Custom Screenshot Directory is enabled.")})).binding((Object)"screenshots", () -> INSTANCE.screenshotDirectory, dir -> {
            INSTANCE.screenshotDirectory = dir;
        }).controller(StringControllerBuilder::create).build();
        ConfigCategory dirConfig = ConfigCategory.createBuilder().name(Component.nullToEmpty((String)"Screenshot Directory")).option(Option.createBuilder().name(Component.nullToEmpty((String)"Use Custom Screenshot Directory")).description(OptionDescription.of((Component[])new Component[]{Component.nullToEmpty((String)"Enabling this will set screenshots to be saved to the path specified in Custom Screenshot Directory")})).binding((Object)false, () -> INSTANCE.useCustomScreenshotDirectory, val -> {
            INSTANCE.useCustomScreenshotDirectory = val;
        }).controller(BooleanControllerBuilder::create).build()).group(OptionGroup.createBuilder().name(Component.nullToEmpty((String)"Screenshot Directory")).collapsed(false).option(screenshotDirectory).option((Option)ButtonOption.createBuilder().name(Component.nullToEmpty((String)"Choose Screenshots Folder")).action((yaclScreen, buttonOption) -> {
            String currentSetting = (String)screenshotDirectory.pendingValue();
            String newDir = TinyFileDialogs.tinyfd_selectFolderDialog((CharSequence)"Select New Screenshots Directory", (CharSequence)currentSetting);
            if (newDir != null) {
                screenshotDirectory.requestSet((Object)newDir);
            }
        }).text(Component.nullToEmpty((String)"Open File Chooser Dialog")).description(OptionDescription.of((Component[])new Component[]{Component.nullToEmpty((String)"Opens a graphical file explorer to choose a new directory to save screenshots to.")})).build()).build()).build();
        ConfigCategory metadata = ConfigCategory.createBuilder().name(Component.nullToEmpty((String)"Screenshot Metadata")).option(Option.createBuilder().name(Component.nullToEmpty((String)"Use Custom Metadata")).description(OptionDescription.of((Component[])new Component[]{Component.nullToEmpty((String)"Enable or Disable embedding relevant in-game data into your screenshots' metadata")})).binding((Object)false, () -> INSTANCE.useMetadata, val -> {
            INSTANCE.useMetadata = val;
        }).controller(BooleanControllerBuilder::create).build()).group(OptionGroup.createBuilder().name(Component.nullToEmpty((String)"Screenshot Metadata")).collapsed(false).option(Option.createBuilder().name(Component.nullToEmpty((String)"Include Coordinates")).binding((Object)false, () -> INSTANCE.coordinates, val -> {
            INSTANCE.coordinates = val;
        }).controller(BooleanControllerBuilder::create).build()).option(Option.createBuilder().name(Component.nullToEmpty((String)"Include World/Server Name")).binding((Object)false, () -> INSTANCE.worldName, val -> {
            INSTANCE.worldName = val;
        }).controller(BooleanControllerBuilder::create).build()).option(Option.createBuilder().name(Component.nullToEmpty((String)"Include World Seed")).binding((Object)false, () -> INSTANCE.seed, val -> {
            INSTANCE.seed = val;
        }).controller(BooleanControllerBuilder::create).build()).option(Option.createBuilder().name(Component.nullToEmpty((String)"Include Texture Pack")).binding((Object)false, () -> INSTANCE.resourcePacks, val -> {
            INSTANCE.resourcePacks = val;
        }).controller(BooleanControllerBuilder::create).build()).option(Option.createBuilder().name(Component.nullToEmpty((String)"Include Shader Pack (Requires Iris Shaders)")).binding((Object)false, () -> INSTANCE.shaderPack, val -> {
            INSTANCE.shaderPack = val;
        }).controller(BooleanControllerBuilder::create).build()).option(Option.createBuilder().name(Component.nullToEmpty((String)"Include Game Version")).binding((Object)false, () -> INSTANCE.mcVersion, val -> {
            INSTANCE.mcVersion = val;
        }).controller(BooleanControllerBuilder::create).build()).build()).build();
        ConfigCategory screenshotNaming = ConfigCategory.createBuilder().name(Component.nullToEmpty((String)"Screenshot Naming")).option(Option.createBuilder().name(Component.nullToEmpty((String)"Enable Custom Screenshot Naming")).binding((Object)false, () -> INSTANCE.useCustomScreenshotNamingSchema, val -> {
            INSTANCE.useCustomScreenshotNamingSchema = val;
        }).controller(BooleanControllerBuilder::create).build()).group(OptionGroup.createBuilder().name(Component.nullToEmpty((String)"Screenshot Naming Scheme")).collapsed(false).option(Option.createBuilder().name(Component.nullToEmpty((String)"Naming Schema")).description(OptionDescription.of((Component[])new Component[]{Component.nullToEmpty((String)templatingTooltip)})).binding((Object)"<datetime>", () -> INSTANCE.screenshotNamingSchema, val -> {
            INSTANCE.screenshotNamingSchema = val;
        }).controller(StringControllerBuilder::create).build()).build()).build();
        return YetAnotherConfigLib.createBuilder().title(Component.nullToEmpty((String)"Screenshot Settings")).category(dirConfig).category(metadata).category(screenshotNaming).save(() -> ((ConfigHolder)AutoConfig.getConfigHolder(Config.class)).save()).build().generateScreen(parent);
    }
}

