/*
 * Decompiled with CFR 0.152.
 */
package com.quantumgarbage.screenshotsettings.mixin;

import com.quantumgarbage.screenshotsettings.platforms.neoforge.client.ScreenshotSettingsClient;
import com.quantumgarbage.screenshotsettings.util.FileNameTemplateProcessor;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import net.minecraft.client.Screenshot;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;

@Mixin(value={Screenshot.class})
public abstract class ScreenshotMixin {
    @ModifyVariable(method={"_grab(Ljava/io/File;Ljava/lang/String;Lcom/mojang/blaze3d/pipeline/RenderTarget;Ljava/util/function/Consumer;)V"}, at=@At(value="STORE"), ordinal=1)
    private static File modifyScreenshotFolder(File original) {
        return new File(ScreenshotSettingsClient.CONFIG.screenshotDirectory);
    }

    @ModifyVariable(method={"grab(Ljava/io/File;Ljava/lang/String;Lcom/mojang/blaze3d/pipeline/RenderTarget;Ljava/util/function/Consumer;)V"}, argsOnly=true, at=@At(value="HEAD"), index=1)
    private static String filenameInject(String orig) {
        String filename = orig == null ? FileNameTemplateProcessor.format(ScreenshotSettingsClient.CONFIG.screenshotNamingSchema) : orig;
        String dir = ScreenshotSettingsClient.CONFIG.getScreenshotDirectory();
        int i = 1;
        Object tmp = filename;
        while (true) {
            Path p;
            File f;
            if (!(f = (p = Path.of(dir + (String)tmp + ".png", new String[0])).toFile()).getParentFile().mkdirs() && !f.getParentFile().exists()) {
                throw new IllegalStateException("Couldn't create dir: " + String.valueOf(f.getParentFile()));
            }
            if (!Files.exists(p, new LinkOption[0])) break;
            tmp = filename + "_(" + i + ")";
            ++i;
        }
        return (String)tmp + ".png";
    }
}

