/*
 * Decompiled with CFR 0.152.
 */
package com.quantumgarbage.screenshotsettings.util.getters;

import com.quantumgarbage.screenshotsettings.integrations.Shaders;
import com.quantumgarbage.screenshotsettings.platforms.neoforge.client.ScreenshotSettingsClient;
import dev.architectury.platform.Platform;
import java.util.HashMap;
import java.util.Iterator;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.server.IntegratedServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.packs.PackResources;
import net.minecraft.world.level.storage.ServerLevelData;
import net.minecraft.world.phys.Vec3;

public class GameMeta {
    public static String getCoordinatesMetadata(Minecraft client) {
        LocalPlayer p = client.player;
        assert (null != p);
        Vec3 pos = GameMeta.getCoordinates(p);
        return String.format("X:[%.3f] Y:[%.3f] Z:[%.3f] Yaw:[%.3f] Pitch:[%.3f]", pos.x, pos.y, pos.z, Float.valueOf(p.getYRot()), Float.valueOf(p.getXRot()));
    }

    public static Vec3 getCoordinates(LocalPlayer p) {
        try {
            return p.position();
        }
        catch (NullPointerException e) {
            ScreenshotSettingsClient.LOGGER.error("Unable to get player coordinates. Did you try to take the screenshot before you finished loading in?");
            e.printStackTrace();
            return new Vec3(0.0, 0.0, 0.0);
        }
    }

    public static String getPlayerName(Minecraft client) {
        return client.getUser().getName();
    }

    private static String getWorldNameSinglePlayer(Minecraft client) {
        assert (null != client.getSingleplayerServer());
        try {
            ServerLevelData worldProperties = (ServerLevelData)((ServerLevel)client.getSingleplayerServer().getAllLevels().iterator().next()).getLevelData();
            return worldProperties.getLevelName();
        }
        catch (Exception e) {
            ScreenshotSettingsClient.LOGGER.error("Unable to get world name for a screenshot.\n" + String.valueOf(e));
            return "Unknown World";
        }
    }

    private static String getWorldNameMultiplayer(Minecraft client) {
        try {
            ServerData si = client.getCurrentServer();
            assert (si != null);
            return si.name;
        }
        catch (Exception e) {
            ScreenshotSettingsClient.LOGGER.error("Unable to get world name for a screenshot.\n" + String.valueOf(e));
            return "Unknown World";
        }
    }

    public static String getWorldName(Minecraft client) {
        if (GameMeta.isSinglePlayer(client)) {
            return GameMeta.getWorldNameSinglePlayer(client);
        }
        return GameMeta.getWorldNameMultiplayer(client);
    }

    public static String getSeed(Minecraft client) {
        if (GameMeta.isSinglePlayer(client)) {
            IntegratedServer server = client.getSingleplayerServer();
            assert (null != server);
            return Long.toString(((ServerLevel)server.getAllLevels().iterator().next()).getSeed());
        }
        return "Screenshot taken in Multiplayer -- Seed Unknown";
    }

    private static boolean isSinglePlayer(Minecraft client) {
        return client.isLocalServer();
    }

    public static String getResourcePacks(Minecraft client) {
        StringBuilder base = new StringBuilder("[");
        Iterator resourcePackIterator = client.getResourceManager().listPacks().iterator();
        while (resourcePackIterator.hasNext()) {
            base.append(String.format("%s", ((PackResources)resourcePackIterator.next()).packId()));
            if (!resourcePackIterator.hasNext()) continue;
            base.append(", ");
        }
        base.append("]");
        return base.toString();
    }

    public static String getVersion(Minecraft client) {
        String version = Platform.getMinecraftVersion();
        if (Platform.isFabric()) {
            return version + " Fabric";
        }
        return version + " NeoForge";
    }

    public static String timedate() {
        return Util.getFilenameFormattedDateTime();
    }

    public static HashMap<String, String> getMetadata(Minecraft client) {
        HashMap<String, String> meta = new HashMap<String, String>();
        if (null == client.player || null == client.level) {
            return meta;
        }
        if (!ScreenshotSettingsClient.CONFIG.useMetadata) {
            return meta;
        }
        if (ScreenshotSettingsClient.CONFIG.coordinates) {
            meta.put("Coordinates", GameMeta.getCoordinatesMetadata(client));
        }
        if (ScreenshotSettingsClient.CONFIG.worldName) {
            meta.put("World/Server Name", GameMeta.getWorldName(client));
        }
        if (ScreenshotSettingsClient.CONFIG.seed) {
            meta.put("World Seed", GameMeta.getSeed(client));
        }
        if (ScreenshotSettingsClient.CONFIG.resourcePacks) {
            meta.put("Resource Packs", GameMeta.getResourcePacks(client));
        }
        if (ScreenshotSettingsClient.CONFIG.shaderPack && Shaders.irisPresent()) {
            meta.put("Shader Pack", Shaders.getShaderName());
        }
        if (ScreenshotSettingsClient.CONFIG.mcVersion) {
            meta.put("Minecraft Version", GameMeta.getVersion(client));
        }
        return meta;
    }
}

