/*
 * Decompiled with CFR 0.152.
 */
package com.quantumgarbage.screenshotsettings.mixin;

import com.quantumgarbage.screenshotsettings.client.ScreenshotSettingsClient;
import com.quantumgarbage.screenshotsettings.util.FileNameTemplateProcessor;
import com.quantumgarbage.screenshotsettings.util.PNGMetadataManipulator;
import com.quantumgarbage.screenshotsettings.util.getters.GameMeta;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.function.Consumer;
import net.minecraft.class_1011;
import net.minecraft.class_2561;
import net.minecraft.class_318;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_318.class})
public abstract class ScreenshotMixin {
    @ModifyVariable(method={"method_68157"}, at=@At(value="STORE"), ordinal=1)
    private static File modifyScreenshotFolder(File original) {
        return new File(ScreenshotSettingsClient.CONFIG.screenshotDirectory);
    }

    @Inject(method={"method_22691"}, at={@At(value="INVOKE", target="Ljava/util/function/Consumer;accept(Ljava/lang/Object;)V")})
    private static void onIoWorkerStart(class_1011 image, File file, Consumer<class_2561> consumer, CallbackInfo ci) {
        PNGMetadataManipulator.attachMetadata(file, GameMeta.getMetadata(ScreenshotSettingsClient.client));
    }

    @ModifyVariable(method={"saveScreenshot(Ljava/io/File;Ljava/lang/String;Lnet/minecraft/client/gl/Framebuffer;ILjava/util/function/Consumer;)V"}, argsOnly=true, at=@At(value="HEAD"), index=1)
    private static String filenameInject(String orig) {
        String filename = orig == null ? FileNameTemplateProcessor.format(ScreenshotSettingsClient.CONFIG.screenshotNamingSchema) : orig;
        String dir = ScreenshotSettingsClient.CONFIG.getScreenshotDirectory();
        int i = 1;
        Object tmp = filename;
        while (true) {
            Path p;
            File f;
            if (!(f = (p = Path.of(dir + (String)tmp + ".png", new String[0])).toFile()).getParentFile().mkdirs() && !f.getParentFile().exists()) {
                throw new IllegalStateException("Couldn't create dir: " + String.valueOf(f.getParentFile()));
            }
            if (!Files.exists(p, new LinkOption[0])) break;
            tmp = filename + "_(" + i + ")";
            ++i;
        }
        return (String)tmp + ".png";
    }
}

