/*
 * Decompiled with CFR 0.152.
 */
package com.quantumgarbage.screenshotsettings.util.getters;

import com.quantumgarbage.screenshotsettings.client.ScreenshotSettingsClient;
import com.quantumgarbage.screenshotsettings.integrations.ShaderIntegration;
import java.util.HashMap;
import java.util.Iterator;
import net.minecraft.class_1132;
import net.minecraft.class_155;
import net.minecraft.class_156;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3262;
import net.minecraft.class_5268;
import net.minecraft.class_642;
import net.minecraft.class_746;

public class GameMeta {
    public static String getCoordinatesMetadata(class_310 client) {
        class_746 p = client.field_1724;
        assert (null != p);
        class_243 pos = GameMeta.getCoordinates(p);
        return String.format("X:[%.3f] Y:[%.3f] Z:[%.3f] Yaw:[%.3f] Pitch:[%.3f]", pos.field_1352, pos.field_1351, pos.field_1350, Float.valueOf(p.method_36454()), Float.valueOf(p.method_36455()));
    }

    public static class_243 getCoordinates(class_746 p) {
        try {
            return p.method_19538();
        }
        catch (NullPointerException e) {
            ScreenshotSettingsClient.LOGGER.error("Unable to get player coordinates. Did you try to take the screenshot before you finished loading in?");
            e.printStackTrace();
            return new class_243(0.0, 0.0, 0.0);
        }
    }

    public static String getPlayerName(class_310 client) {
        return client.method_1548().method_1676();
    }

    private static String getWorldNameSinglePlayer(class_310 client) {
        assert (null != client.method_1576());
        try {
            class_5268 worldProperties = (class_5268)((class_3218)client.method_1576().method_3738().iterator().next()).method_8401();
            return worldProperties.method_150();
        }
        catch (Exception e) {
            ScreenshotSettingsClient.LOGGER.error("Unable to get world name for a screenshot.\n" + String.valueOf(e));
            return "Unknown World";
        }
    }

    private static String getWorldNameMultiplayer(class_310 client) {
        try {
            class_642 si = client.method_1558();
            assert (si != null);
            return si.field_3752;
        }
        catch (Exception e) {
            ScreenshotSettingsClient.LOGGER.error("Unable to get world name for a screenshot.\n" + String.valueOf(e));
            return "Unknown World";
        }
    }

    public static String getWorldName(class_310 client) {
        if (GameMeta.isSinglePlayer(client)) {
            return GameMeta.getWorldNameSinglePlayer(client);
        }
        return GameMeta.getWorldNameMultiplayer(client);
    }

    public static String getSeed(class_310 client) {
        if (GameMeta.isSinglePlayer(client)) {
            class_1132 server = client.method_1576();
            assert (null != server);
            return Long.toString(((class_3218)server.method_3738().iterator().next()).method_8412());
        }
        return "Screenshot taken in Multiplayer -- Seed Unknown";
    }

    private static boolean isSinglePlayer(class_310 client) {
        return client.method_1542();
    }

    public static String getResourcePacks(class_310 client) {
        StringBuilder base = new StringBuilder("[");
        Iterator resourcePackIterator = client.method_1478().method_29213().iterator();
        while (resourcePackIterator.hasNext()) {
            base.append(String.format("%s", ((class_3262)resourcePackIterator.next()).method_14409()));
            if (!resourcePackIterator.hasNext()) continue;
            base.append(", ");
        }
        base.append("]");
        return base.toString();
    }

    public static String getVersion(class_310 client) {
        return class_155.method_16673().comp_4025() + " " + client.method_1547();
    }

    public static String timedate() {
        return class_156.method_44893();
    }

    public static HashMap<String, String> getMetadata(class_310 client) {
        HashMap<String, String> meta = new HashMap<String, String>();
        if (null == client.field_1724 || null == client.field_1687) {
            return meta;
        }
        if (!ScreenshotSettingsClient.CONFIG.useMetadata) {
            return meta;
        }
        if (ScreenshotSettingsClient.CONFIG.coordinates) {
            meta.put("Coordinates", GameMeta.getCoordinatesMetadata(client));
        }
        if (ScreenshotSettingsClient.CONFIG.worldName) {
            meta.put("World/Server Name", GameMeta.getWorldName(client));
        }
        if (ScreenshotSettingsClient.CONFIG.seed) {
            meta.put("World Seed", GameMeta.getSeed(client));
        }
        if (ScreenshotSettingsClient.CONFIG.resourcePacks) {
            meta.put("Resource Packs", GameMeta.getResourcePacks(client));
        }
        if (ScreenshotSettingsClient.CONFIG.shaderPack && ShaderIntegration.irisPresent()) {
            meta.put("Shader Pack", ShaderIntegration.getShaderName());
        }
        if (ScreenshotSettingsClient.CONFIG.mcVersion) {
            meta.put("Minecraft Version", GameMeta.getVersion(client));
        }
        return meta;
    }
}

