package com.quantumgarbage.screenshotsettings;
//? if fabric {
import com.quantumgarbage.screenshotsettings.platforms.fabric.client.ScreenshotSettingsClient;
//?} else {
/*import com.quantumgarbage.screenshotsettings.platforms.neoforge.client.ScreenshotSettingsClient;
*///?}
import dev.isxander.yacl3.api.*;
import dev.isxander.yacl3.api.controller.BooleanControllerBuilder;
import dev.isxander.yacl3.api.controller.StringControllerBuilder;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.annotation.ConfigEntry;
import net.minecraft.class_2561;
import net.minecraft.class_437;
import org.lwjgl.util.tinyfd.TinyFileDialogs;

@me.shedaniel.autoconfig.annotation.Config(name = "assets/screenshotsettings")
public class Config implements ConfigData {
    private static final String templatingTooltip =
            """
            §l§3<datetime>§r
                - Minecraft's default screenshot naming format.
            
            §l§3<world>§r
                - The name of the world in Single Player, and the name of the server in Multiplayer.
            
            §l§3<version>§r
                - The version of Minecraft the screenshot was taken on. (Ex. 1.19.2)
            
            §l§3<x>, <y>, and <z>§r
                - The respective coordinates of where the screenshot was taken.
            
            §l§3<shader>§r
                - The active Shader pack. (requires Iris Shaders)
            
            §l§3<player>§r
                - Your Minecraft username.
            """;

    // Change screenshot directory
    @ConfigEntry.Category("Screenshot Directory")
    public String screenshotDirectory;
    public boolean useCustomScreenshotDirectory;

    // Control metadata attached to screenshots.
    @ConfigEntry.Category("Metadata")
    public boolean useMetadata;

    public boolean coordinates;

    public boolean worldName;

    public boolean mcVersion;

    public boolean shaderPack;

    public boolean resourcePacks;

    public boolean seed;

    // Control how screenshots are named.
    @ConfigEntry.Category("Naming Scheme")
    public boolean useCustomScreenshotNamingSchema;
    public String screenshotNamingSchema;

    public String getScreenshotDirectory() {
        if (!this.useCustomScreenshotDirectory) {
            return "./screenshots/";
        } else {
            return this.screenshotDirectory + "/";
        }
    }

    @Override
    public void validatePostLoad() throws ValidationException {
        if (null == this.screenshotDirectory) {
            this.screenshotDirectory = "./screenshots";
        }
        if (null == this.screenshotNamingSchema) {
            this.screenshotNamingSchema = "<datetime>";
        }
        ConfigData.super.validatePostLoad();
    }

    public class_437 createGui(final class_437 parent) {
        final Config INSTANCE = ScreenshotSettingsClient.CONFIG;
        final Option<String> screenshotDirectory = Option.<String>createBuilder()
                .name(class_2561.method_30163("Custom Screenshot Directory"))
                .description(OptionDescription.of(class_2561.method_30163("Where screenshots will be saved to, provided Use Custom Screenshot Directory is enabled.")))
                .binding(
                        "screenshots",
                        () -> INSTANCE.screenshotDirectory,
                        dir -> INSTANCE.screenshotDirectory = dir

                ).controller(StringControllerBuilder::create)
                .build();
        final ConfigCategory dirConfig = ConfigCategory.createBuilder()
                .name(class_2561.method_30163("Screenshot Directory"))
                .option(Option.<Boolean>createBuilder()
                        .name(class_2561.method_30163("Use Custom Screenshot Directory"))
                        .description(OptionDescription.of(class_2561.method_30163("Enabling this will set screenshots to be saved to the path specified in Custom Screenshot Directory")))
                        .binding(
                                false,
                                () -> INSTANCE.useCustomScreenshotDirectory,
                                val -> INSTANCE.useCustomScreenshotDirectory = val
                        ).controller(BooleanControllerBuilder::create)
                        .build())
                .group(OptionGroup.createBuilder()
                        .name(class_2561.method_30163("Screenshot Directory"))
                        .collapsed(false)
                        .option(screenshotDirectory)
                        .option(ButtonOption.createBuilder()
                                .name(class_2561.method_30163("Choose Screenshots Folder"))
                                .action(((yaclScreen, buttonOption) -> {
                                    final String currentSetting = screenshotDirectory.pendingValue();
                                    final String newDir = TinyFileDialogs.tinyfd_selectFolderDialog("Select New Screenshots Directory", currentSetting);
                                    if (newDir != null) {
                                        screenshotDirectory.requestSet(newDir);
                                    }
                                }))
                                .text(class_2561.method_30163("Open File Chooser Dialog"))
                                .description(OptionDescription.of(class_2561.method_30163("Opens a graphical file explorer to choose a new directory to save screenshots to.")))
                                .build())
                        .build())
                .build();
        final ConfigCategory metadata = ConfigCategory.createBuilder()
                .name(class_2561.method_30163("Screenshot Metadata"))
                .option(Option.<Boolean>createBuilder()
                        .name(class_2561.method_30163("Use Custom Metadata"))
                        .description(OptionDescription.of(class_2561.method_30163("Enable or Disable embedding relevant in-game data into your screenshots' metadata")))
                        .binding(
                                false,
                                () -> INSTANCE.useMetadata,
                                val -> INSTANCE.useMetadata = val
                        ).controller(BooleanControllerBuilder::create)
                        .build())
                .group(OptionGroup.createBuilder()
                        .name(class_2561.method_30163("Screenshot Metadata"))
                        .collapsed(false)
                        .option(Option.<Boolean>createBuilder()
                                .name(class_2561.method_30163("Include Coordinates"))
                                .binding(
                                        false,
                                        () -> INSTANCE.coordinates,
                                        val -> INSTANCE.coordinates = val
                                ).controller(BooleanControllerBuilder::create)
                                .build())
                        .option(Option.<Boolean>createBuilder()
                                .name(class_2561.method_30163("Include World/Server Name"))
                                .binding(
                                        false,
                                        () -> INSTANCE.worldName,
                                        val -> INSTANCE.worldName = val
                                ).controller(BooleanControllerBuilder::create)
                                .build())
                        .option(Option.<Boolean>createBuilder()
                                .name(class_2561.method_30163("Include World Seed"))
                                .binding(
                                        false,
                                        () -> INSTANCE.seed,
                                        val -> INSTANCE.seed = val
                                ).controller(BooleanControllerBuilder::create)
                                .build())
                        .option(Option.<Boolean>createBuilder()
                                .name(class_2561.method_30163("Include Texture Pack"))
                                .binding(
                                        false,
                                        () -> INSTANCE.resourcePacks,
                                        val -> INSTANCE.resourcePacks = val
                                ).controller(BooleanControllerBuilder::create)
                                .build())
                        .option(Option.<Boolean>createBuilder()
                                .name(class_2561.method_30163("Include Shader Pack (Requires Iris Shaders)"))
                                .binding(
                                        false,
                                        () -> INSTANCE.shaderPack,
                                        val -> INSTANCE.shaderPack = val
                                ).controller(BooleanControllerBuilder::create)
                                .build())
                        .option(Option.<Boolean>createBuilder()
                                .name(class_2561.method_30163("Include Game Version"))
                                .binding(
                                        false,
                                        () -> INSTANCE.mcVersion,
                                        val -> INSTANCE.mcVersion = val
                                ).controller(BooleanControllerBuilder::create)
                                .build())
                        .build())
                .build();

        final ConfigCategory screenshotNaming = ConfigCategory.createBuilder()
                .name(class_2561.method_30163("Screenshot Naming"))
                .option(Option.<Boolean>createBuilder()
                        .name(class_2561.method_30163("Enable Custom Screenshot Naming"))
                        .binding(
                                false,
                                () -> INSTANCE.useCustomScreenshotNamingSchema,
                                val -> INSTANCE.useCustomScreenshotNamingSchema = val
                        ).controller(BooleanControllerBuilder::create)
                        .build())
                .group(OptionGroup.createBuilder()
                        .name(class_2561.method_30163("Screenshot Naming Scheme"))
                        .collapsed(false)
                        .option(Option.<String>createBuilder()
                                .name(class_2561.method_30163("Naming Schema"))
                                .description(OptionDescription.of(class_2561.method_30163(templatingTooltip)))
                                .binding(
                                        "<datetime>",
                                        () -> INSTANCE.screenshotNamingSchema,
                                        val -> INSTANCE.screenshotNamingSchema = val
                                ).controller(StringControllerBuilder::create)
                                .build())
                        .build())
                .build();

        return YetAnotherConfigLib.createBuilder()
                .title(class_2561.method_30163("Screenshot Settings"))
                .category(dirConfig)
                .category(metadata)
                .category(screenshotNaming)
                .save(AutoConfig.getConfigHolder(Config.class)::save)
                .build()
                .generateScreen(parent);
    }
}