package com.quantumgarbage.screenshotsettings.util.getters;

//? if fabric {
import com.quantumgarbage.screenshotsettings.platforms.fabric.client.ScreenshotSettingsClient;
import static com.quantumgarbage.screenshotsettings.platforms.fabric.client.ScreenshotSettingsClient.LOGGER;
//?} else {
/*import com.quantumgarbage.screenshotsettings.platforms.neoforge.client.ScreenshotSettingsClient;
import static com.quantumgarbage.screenshotsettings.platforms.neoforge.client.ScreenshotSettingsClient.LOGGER;
*///?}
import com.quantumgarbage.screenshotsettings.integrations.Shaders;
import dev.architectury.platform.Platform;
import java.util.HashMap;
import java.util.Iterator;
import net.minecraft.class_1132;
import net.minecraft.class_156;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3262;
import net.minecraft.class_5268;
import net.minecraft.class_642;
import net.minecraft.class_746;

public class GameMeta {
    public static String getCoordinatesMetadata(final class_310 client) {
        final var p = client.field_1724;
        assert null != p;
        final class_243 pos = getCoordinates(p);
        return String.format("X:[%.3f] Y:[%.3f] Z:[%.3f] Yaw:[%.3f] Pitch:[%.3f]", pos.field_1352, pos.field_1351, pos.field_1350, p.method_36454(), p.method_36455());
    }

    public static class_243 getCoordinates(final class_746 p) {
        try {
            return p.method_19538();
        } catch (NullPointerException e) {
            LOGGER.error("Unable to get player coordinates. Did you try to take the screenshot before you finished loading in?");
            e.printStackTrace();
            return new class_243(0, 0, 0);
        }
    }

    public static String getPlayerName(final class_310 client) {
        return client.method_1548().method_1676();
    }

    private static String getWorldNameSinglePlayer(final class_310 client) {
        assert null != client.method_1576();
        try {
            final class_5268 worldProperties = (class_5268) client.method_1576().method_3738().iterator().next().method_8401();

            return worldProperties.method_150();
        } catch (Exception e) {
            LOGGER.error("Unable to get world name for a screenshot.\n" + e);
            return "Unknown World";
        }


    }

    private static String getWorldNameMultiplayer(final class_310 client) {
        try {
            final class_642 si = client.method_1558();
            assert si != null;
            return si.field_3752;
        } catch (Exception e) {
            LOGGER.error("Unable to get world name for a screenshot.\n" + e);
            return "Unknown World";
        }
    }

    public static String getWorldName(final class_310 client) {
        if (isSinglePlayer(client)) {
            return getWorldNameSinglePlayer(client);
        } else {
            return getWorldNameMultiplayer(client);
        }
    }

    public static String getSeed(final class_310 client) {
        if (isSinglePlayer(client)) {
            final class_1132 server = client.method_1576();
            assert null != server;
            return Long.toString(server.method_3738().iterator().next().method_8412());
        }
        return "Screenshot taken in Multiplayer -- Seed Unknown";
    }

    private static boolean isSinglePlayer(final class_310 client) {
        return client.method_1542();
    }

    public static String getResourcePacks(final class_310 client) {
        final StringBuilder base = new StringBuilder("[");
        final Iterator<class_3262> resourcePackIterator = client.method_1478().method_29213().iterator();
        while (resourcePackIterator.hasNext()) {
            base.append(String.format("%s", resourcePackIterator.next()
                    //? if <1.21 {
                    /*.getName()));
                    *///?} elif =1.21.1 {
                    .method_14409()));
                    //?}
            if (resourcePackIterator.hasNext()) {
                base.append(", ");
            }
        }
        base.append("]");
        return base.toString();
    }

    public static String getVersion(final class_310 client) {
        String version = Platform.getMinecraftVersion();
        if(Platform.isFabric()){
            return version + " " + "Fabric";
        } else{
            return version + " " + "NeoForge";
        }
    }

    public static String timedate() {
        return class_156.method_44893();
    }

    public static HashMap<String, String> getMetadata(final class_310 client) {
        final HashMap<String, String> meta = new HashMap<>();
        // make sure that metadata even is possible to obtain.
        if (null == client.field_1724 || null == client.field_1687) {
            return meta;
        }

        if (!ScreenshotSettingsClient.CONFIG.useMetadata) {
            return meta;
        }
        if (ScreenshotSettingsClient.CONFIG.coordinates) {
            meta.put("Coordinates", getCoordinatesMetadata(client));
        }
        if (ScreenshotSettingsClient.CONFIG.worldName) {
            meta.put("World/Server Name", getWorldName(client));
        }
        if (ScreenshotSettingsClient.CONFIG.seed) {
            meta.put("World Seed", getSeed(client));
        }
        if (ScreenshotSettingsClient.CONFIG.resourcePacks) {
            meta.put("Resource Packs", getResourcePacks(client));
        }
        if (ScreenshotSettingsClient.CONFIG.shaderPack && Shaders.irisPresent()) {
            meta.put("Shader Pack", Shaders.getShaderName());
        }
        if (ScreenshotSettingsClient.CONFIG.mcVersion) {
            meta.put("Minecraft Version", getVersion(client));
        }
        return meta;
    }

}