/*
 * Decompiled with CFR 0.152.
 */
package com.pyding.vp.client;

import com.pyding.vp.client.ShieldOverlay;
import com.pyding.vp.client.sounds.SoundRegistry;
import com.pyding.vp.util.ClientConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.FormattedCharSequence;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class GuideScreen
extends Screen {
    private static final ResourceLocation HEALDEBT = new ResourceLocation("vp", "textures/gui/heal_debt.png");
    private static final ResourceLocation SHIELD = new ResourceLocation("vp", "textures/gui/shield.png");
    private static final ResourceLocation OVER_SHIELD = new ResourceLocation("vp", "textures/gui/overshield.png");
    private static final ResourceLocation HEAL1 = new ResourceLocation("vp", "textures/gui/heal1.png");
    private static final ResourceLocation HEAL2 = new ResourceLocation("vp", "textures/gui/heal2.png");
    private static final ResourceLocation HEAL3 = new ResourceLocation("vp", "textures/gui/heal3.png");
    private static final ResourceLocation FRAME = new ResourceLocation("vp", "textures/gui/frame.png");
    int page = 1;
    boolean showEverything = false;
    int maxPages = 9;
    long time = 0L;

    public GuideScreen() {
        super((Component)Component.m_237119_());
    }

    protected void m_7856_() {
        super.m_7856_();
        int buttonSize = 32;
        int padding = 5;
        int center = this.f_96543_ / 2 - buttonSize / 2;
        int top = this.f_96544_ - padding - buttonSize;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        ImageButton nextPage = new ImageButton(center + (buttonSize - padding) * 3, top - this.f_96544_ / 8, buttonSize, buttonSize, 0, 0, 0, new ResourceLocation("vp", "textures/gui/point_r.png"), buttonSize, buttonSize, button -> {
            this.page = Math.min(this.maxPages, this.page + 1);
            this.showEverything = false;
            player.m_20193_().m_7785_(player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)SoundRegistry.BOOK_PAGE1.get(), SoundSource.RECORDS, 1.0f, 1.0f, false);
        });
        ImageButton prevPage = new ImageButton(center - (buttonSize - padding) * 3, top - this.f_96544_ / 8, buttonSize, buttonSize, 0, 0, 0, new ResourceLocation("vp", "textures/gui/point_l.png"), buttonSize, buttonSize, button -> {
            this.page = Math.max(1, this.page - 1);
            this.showEverything = false;
            player.m_20193_().m_7785_(player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)SoundRegistry.BOOK_PAGE1.get(), SoundSource.RECORDS, 1.0f, 1.0f, false);
        });
        ImageButton showAll = new ImageButton(center, top - this.f_96544_ / 8, buttonSize, buttonSize, 0, 0, 0, new ResourceLocation("vp", "textures/gui/button_all.png"), buttonSize, buttonSize, button -> {
            this.showEverything = !this.showEverything;
            player.m_20193_().m_7785_(player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)SoundRegistry.BOOK_PAGE1.get(), SoundSource.RECORDS, 1.0f, 1.0f, false);
        });
        this.m_142416_((GuiEventListener)nextPage);
        this.m_142416_((GuiEventListener)prevPage);
        this.m_142416_((GuiEventListener)showAll);
        this.time = System.currentTimeMillis();
        int right = this.f_96543_ - padding - buttonSize;
        ImageButton zoomInButton = new ImageButton(right - buttonSize - padding, top, buttonSize, buttonSize, 0, 0, 0, new ResourceLocation("vp", "textures/gui/zoom-in.png"), buttonSize, buttonSize, button -> ClientConfig.COMMON.guiScaleGuide.set((Object)Math.min(2.0, (Double)ClientConfig.COMMON.guiScaleGuide.get() + 0.1)));
        ImageButton zoomOutButton = new ImageButton(right, top, buttonSize, buttonSize, 0, 0, 0, new ResourceLocation("vp", "textures/gui/zoom-out.png"), buttonSize, buttonSize, button -> ClientConfig.COMMON.guiScaleGuide.set((Object)Math.max(0.1, (Double)ClientConfig.COMMON.guiScaleGuide.get() - 0.1)));
        this.m_142416_((GuiEventListener)zoomInButton);
        this.m_142416_((GuiEventListener)zoomOutButton);
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(guiGraphics);
        double scale = (Double)ClientConfig.COMMON.guiScaleGuide.get();
        if (!this.showEverything) {
            scale *= 1.5;
        }
        int infoWidth = (int)(256.0 * scale);
        int infoHeight = (int)(256.0 * scale);
        int infoPadding = (int)(30.0 * scale);
        if (this.showEverything) {
            int marginX = infoPadding;
            int marginY = infoPadding;
            int availableWidth = this.f_96543_ - marginX * 2;
            int perRow = Math.max(1, availableWidth / (infoWidth + infoPadding));
            Font font = this.f_96547_;
            for (int i = 1; i <= this.maxPages; ++i) {
                int index = i - 1;
                int col = index % perRow;
                int row = index / perRow;
                int x = marginX + col * (infoWidth + infoPadding) + infoWidth / 5;
                int y = marginY + row * (infoHeight + infoPadding);
                guiGraphics.m_280163_(FRAME, x, y, 0.0f, 0.0f, infoWidth, infoHeight, infoWidth, infoHeight);
                MutableComponent comp = Component.m_237115_((String)("vp.info." + i));
                List lines = font.m_92923_((FormattedText)comp, infoWidth - 2 * infoPadding);
                for (int lineIndex = 0; lineIndex < lines.size(); ++lineIndex) {
                    int textX = x + infoPadding + infoWidth / 25;
                    Objects.requireNonNull(font);
                    int textY = y + infoPadding + lineIndex * 9 + infoHeight / 6;
                    guiGraphics.m_280648_(font, (FormattedCharSequence)lines.get(lineIndex), textX, textY, ChatFormatting.GRAY.m_126665_().intValue());
                }
            }
        } else {
            Font font = this.f_96547_;
            int x = this.f_96543_ / 2 - infoWidth / 2;
            int y = this.f_96544_ / 2 - infoHeight / 2;
            guiGraphics.m_280163_(FRAME, x, y, 0.0f, 0.0f, infoWidth, infoHeight, infoWidth, infoHeight);
            MutableComponent comp = Component.m_237115_((String)("vp.info." + this.page));
            List lines = font.m_92923_((FormattedText)comp, infoWidth - 2 * infoPadding);
            for (int lineIndex = 0; lineIndex < lines.size(); ++lineIndex) {
                int textX = x + infoPadding + infoWidth / 25;
                Objects.requireNonNull(font);
                int textY = y + infoPadding + lineIndex * 9 + infoHeight / 6;
                guiGraphics.m_280648_(font, (FormattedCharSequence)lines.get(lineIndex), textX, textY, ChatFormatting.GRAY.m_126665_().intValue());
            }
            ArrayList<ResourceLocation> pic = new ArrayList<ResourceLocation>();
            if (this.page == 1) {
                pic.add(HEALDEBT);
                pic.add(ShieldOverlay.getTexture(20));
                pic.add(ShieldOverlay.getTexture(11));
                pic.add(ShieldOverlay.getTexture(6));
                pic.add(ShieldOverlay.getTexture(5));
                pic.add(ShieldOverlay.getTexture(7));
                pic.add(ShieldOverlay.getTexture(14));
                pic.add(ShieldOverlay.getTexture(17));
            }
            if (this.page == 2) {
                pic.add(HEAL1);
                pic.add(HEAL2);
                pic.add(HEAL3);
            }
            if (this.page == 3) {
                pic.add(ShieldOverlay.getTexture(16));
                pic.add(ShieldOverlay.getTexture(21));
                pic.add(ShieldOverlay.getTexture(6));
                pic.add(ShieldOverlay.getTexture(22));
            }
            if (this.page == 4) {
                pic.add(SHIELD);
            }
            if (this.page == 5) {
                pic.add(OVER_SHIELD);
            }
            if (this.page == 6) {
                pic.add(ShieldOverlay.getTexture(19));
                pic.add(ShieldOverlay.getTexture(5));
                pic.add(ShieldOverlay.getTexture(18));
                pic.add(ShieldOverlay.getTexture(3));
                pic.add(ShieldOverlay.getTexture(2));
                pic.add(ShieldOverlay.getTexture(21));
                pic.add(ShieldOverlay.getTexture(11));
            }
            if (this.page == 7) {
                pic.add(ShieldOverlay.getTexture(15));
                pic.add(ShieldOverlay.getTexture(20));
            }
            if (this.page == 8) {
                pic.add(ShieldOverlay.getTexture(11));
            }
            if (!pic.isEmpty()) {
                Random random = new Random(this.time + (long)this.page);
                for (int i = 0; i < pic.size(); ++i) {
                    int size = (int)(64.0 * scale);
                    int xPos = this.f_96543_ / 2 - size / 2;
                    int yPos = this.f_96544_ / 2 - size / 2 + infoHeight / 4;
                    if (i != 0) {
                        int bound = 200;
                        xPos = random.nextDouble() < 0.5 ? (xPos += infoWidth / 3 + random.nextInt(bound / 2) + bound / 4) : (xPos -= infoWidth / 3 - random.nextInt(bound / 2) + bound / 4);
                        yPos = random.nextDouble() < 0.5 ? (yPos += infoHeight / 3 + random.nextInt(bound / 2) + bound / 4) : (yPos -= infoHeight - random.nextInt(bound / 2) + bound / 4);
                    }
                    guiGraphics.m_280163_((ResourceLocation)pic.get(i), xPos, yPos, 0.0f, 0.0f, size, size, size, size);
                }
            }
        }
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
    }

    public void m_280273_(GuiGraphics guiGraphics) {
        guiGraphics.m_280024_(0, 0, this.f_96543_, this.f_96544_, Integer.MIN_VALUE, Integer.MIN_VALUE);
    }

    public boolean m_7043_() {
        return false;
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 69 || keyCode == 87 || keyCode == 65 || keyCode == 83 || keyCode == 68 || keyCode == 256 || keyCode == 32) {
            this.m_7379_();
            return true;
        }
        return true;
    }

    public void m_7379_() {
        super.m_7379_();
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        player.m_20193_().m_7785_(player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)SoundRegistry.BOOK_CLOSE.get(), SoundSource.RECORDS, 1.0f, 1.0f, false);
    }
}

