/*
 * Decompiled with CFR 0.152.
 */
package com.pyding.vp.item.vestiges;

import com.pyding.vp.client.sounds.SoundRegistry;
import com.pyding.vp.item.vestiges.Vestige;
import com.pyding.vp.network.PacketHandler;
import com.pyding.vp.network.packets.PlayerFlyPacket;
import com.pyding.vp.util.VPUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class Ball
extends Vestige {
    @Override
    public void dataInit(int vestigeNumber, ChatFormatting color, int specialCharges, int specialCd, int ultimateCharges, int ultimateCd, int specialMaxTime, int ultimateMaxTime, boolean hasDamage, ItemStack stack) {
        super.dataInit(18, ChatFormatting.AQUA, 5, 25, 2, 70, 1, 1, true, stack);
    }

    @Override
    public void doSpecial(long seconds, Player player, Level level, ItemStack stack) {
        VPUtil.play((LivingEntity)player, (SoundEvent)SoundRegistry.BOLT.get());
        for (LivingEntity entity : VPUtil.getEntities(player, 5.0, true)) {
            if (VPUtil.isProtectedFromHit(player, (Entity)entity)) continue;
            VPUtil.dealDamage(entity, player, player.m_269291_().m_269548_(), VPUtil.scalePower(500, 18, player), 2);
            VPUtil.addRadiance(Ball.class, VPUtil.getRadianceSpecial(), player);
        }
        player.m_6469_(player.m_269291_().m_269548_(), VPUtil.getAttack(player, true) * 5.0f);
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            VPUtil.spawnLightning(serverLevel, player.m_20185_(), player.m_20186_(), player.m_20189_());
        }
        Vec3 motion = new Vec3(0.0, 1.0, 0.0);
        player.m_6001_(motion.f_82479_, motion.f_82480_, motion.f_82481_);
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            PacketHandler.sendToClient(new PlayerFlyPacket(1), serverPlayer);
        }
        double originalX = player.m_20185_();
        double originalY = player.m_20186_();
        double originalZ = player.m_20189_();
        VPUtil.teleportRandomly((Entity)player, 30);
        double dx = originalX - player.m_20185_();
        double dy = originalY - (player.m_20186_() + (double)player.m_20192_());
        double dz = originalZ - player.m_20189_();
        double distanceXZ = Math.sqrt(dx * dx + dz * dz);
        float yaw = (float)(Math.atan2(dz, dx) * 57.29577951308232) - 90.0f;
        float pitch = (float)(-(Math.atan2(dy, distanceXZ) * 57.29577951308232));
        player.m_146922_(yaw);
        player.m_146926_(pitch);
        super.doSpecial(seconds, player, level, stack);
    }

    @Override
    public void doUltimate(long seconds, Player player, Level level, ItemStack stack) {
        VPUtil.play((LivingEntity)player, (SoundEvent)SoundRegistry.BOLT.get());
        for (LivingEntity entity : VPUtil.getEntities(player, 30.0, true)) {
            float shield;
            if (VPUtil.isProtectedFromHit(player, (Entity)entity) || !((shield = VPUtil.getShield(entity) + VPUtil.getOverShield(entity)) > 0.0f || entity.m_21223_() < player.m_21223_() || entity.m_21207_() > 0.0f) && !entity.m_20071_()) continue;
            float damageBonus = 1.0f + shield * 0.001f + entity.m_21207_() * 2.0f * ((float)entity.m_21230_() * 0.1f);
            VPUtil.dealDamage(entity, player, player.m_269291_().m_269548_(), VPUtil.scalePower(1000.0f * damageBonus, 18, player), 3);
            VPUtil.addRadiance(Ball.class, VPUtil.getRadianceUltimate(), player);
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                VPUtil.spawnLightning(serverLevel, entity.m_20185_(), entity.m_20186_(), entity.m_20189_());
            }
            if (!entity.m_20071_()) continue;
            VPUtil.dealParagonDamage(entity, player, VPUtil.scalePower(damageBonus / 10.0f, 18, player), 3, true);
        }
        super.doUltimate(seconds, player, level, stack);
    }
}

