/*
 * Decompiled with CFR 0.152.
 */
package com.pyding.vp.util;

import com.pyding.vp.capability.PlayerCapabilityProviderVP;
import com.pyding.vp.util.ConfigHandler;
import com.pyding.vp.util.GradientUtil;
import com.pyding.vp.util.VPUtil;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;

public class LeaderboardUtil {
    public static String topPlayers = "";
    public static String specialPlayers = "";
    public static boolean exception = false;

    public static String getHost() {
        if (ConfigHandler.COMMON_SPEC.isLoaded() && !ConfigHandler.COMMON.leaderboardHost.get().toString().isEmpty()) {
            return ConfigHandler.COMMON.leaderboardHost.get().toString();
        }
        return "95.153.100.57";
    }

    public static String getPort() {
        if (ConfigHandler.COMMON_SPEC.isLoaded() && !ConfigHandler.COMMON.leaderboardPort.get().toString().isEmpty()) {
            return ConfigHandler.COMMON.leaderboardPort.get().toString();
        }
        return "5242";
    }

    public static String addNickname(Player player, UUID uuid, String password) {
        if (!LeaderboardUtil.isLeaderboardsActive(player) || LeaderboardUtil.isCheating(player)) {
            return "Leaderboards disabled.";
        }
        AtomicReference<String> message = new AtomicReference<String>("");
        CompletableFuture.runAsync(() -> {
            try {
                HttpClient client = HttpClient.newHttpClient();
                HttpRequest request = HttpRequest.newBuilder().uri(URI.create("http://" + LeaderboardUtil.getHost() + ":" + LeaderboardUtil.getPort() + "/addNickname?nickName=" + player.m_6302_() + "&UUID=" + uuid.toString() + "&version=" + LeaderboardUtil.getCurrentVersion() + "&password=" + password)).GET().build();
                HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
                message.set(response.body());
            }
            catch (Exception e) {
                player.m_213846_((Component)Component.m_237113_((String)e.getMessage()).m_130940_(ChatFormatting.DARK_RED));
            }
        });
        return message.get();
    }

    public static void checkPassword(Player player, UUID uuid, String password) {
        if (!LeaderboardUtil.isLeaderboardsActive(player) || LeaderboardUtil.isCheating(player)) {
            player.m_213846_((Component)Component.m_237113_((String)"Leaderboard is disabled or you are cheating").m_130940_(ChatFormatting.RED));
            return;
        }
        CompletableFuture.runAsync(() -> {
            try {
                HttpClient client = HttpClient.newHttpClient();
                HttpRequest request = HttpRequest.newBuilder().uri(URI.create("http://" + LeaderboardUtil.getHost() + ":" + LeaderboardUtil.getPort() + "/login?nickName=" + player.m_6302_() + "&UUID=" + uuid.toString() + "&version=" + LeaderboardUtil.getCurrentVersion() + "&password=" + password)).GET().build();
                HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
                if (response.body().equals("ok")) {
                    player.m_213846_((Component)Component.m_237113_((String)"You logged in successfully.").m_130940_(ChatFormatting.GREEN));
                    player.getCapability(PlayerCapabilityProviderVP.playerCap).ifPresent(cap -> {
                        cap.setPassword(password);
                        cap.sync(player);
                    });
                } else {
                    player.m_213846_((Component)Component.m_237113_((String)response.body()).m_130940_(ChatFormatting.RED));
                }
            }
            catch (Exception e) {
                exception = true;
                player.m_213846_((Component)Component.m_237113_((String)e.getMessage()).m_130940_(ChatFormatting.RED));
            }
        });
    }

    public static void addChallenge(Player player, int id, String password) {
        if (!LeaderboardUtil.isLeaderboardsActive(player) || LeaderboardUtil.isCheating(player)) {
            return;
        }
        CompletableFuture.runAsync(() -> {
            try {
                HttpClient client = HttpClient.newHttpClient();
                HttpRequest request = HttpRequest.newBuilder().uri(URI.create("http://" + LeaderboardUtil.getHost() + ":" + LeaderboardUtil.getPort() + "/addChallenge?UUID=" + player.m_20148_().toString() + "&id=" + id + "&version=" + LeaderboardUtil.getCurrentVersion() + "&password=" + password)).GET().build();
                HttpResponse<String> httpResponse = client.send(request, HttpResponse.BodyHandlers.ofString());
            }
            catch (Exception e) {
                exception = true;
                e.printStackTrace();
            }
        });
    }

    public static void setCheating(Player player) {
        player.getCapability(PlayerCapabilityProviderVP.playerCap).ifPresent(cap -> {
            if (!cap.isCheating()) {
                cap.setCheating(true);
                cap.sync(player);
            }
        });
    }

    public static boolean isCheating(Player player) {
        AtomicBoolean atomicBoolean = new AtomicBoolean();
        player.getCapability(PlayerCapabilityProviderVP.playerCap).ifPresent(cap -> atomicBoolean.set(cap.isCheating()));
        return atomicBoolean.get();
    }

    public static String getInformation(UUID uuid) {
        try {
            HttpClient client = HttpClient.newHttpClient();
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create("http://" + LeaderboardUtil.getHost() + ":" + LeaderboardUtil.getPort() + "/getInformation?UUID=" + uuid.toString() + "&version=" + LeaderboardUtil.getCurrentVersion())).GET().build();
            HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
            return response.body();
        }
        catch (Exception e) {
            e.printStackTrace();
            return "null";
        }
    }

    public static String getAll() {
        try {
            HttpClient client = HttpClient.newHttpClient();
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create("http://" + LeaderboardUtil.getHost() + ":" + LeaderboardUtil.getPort() + "/getAll?version=" + LeaderboardUtil.getCurrentVersion())).GET().build();
            HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
            return response.body();
        }
        catch (Exception e) {
            e.printStackTrace();
            return "null";
        }
    }

    public static String check() {
        try {
            HttpClient client = HttpClient.newHttpClient();
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create("http://" + LeaderboardUtil.getHost() + ":" + LeaderboardUtil.getPort() + "/check?version=" + LeaderboardUtil.getCurrentVersion())).GET().build();
            HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
            return response.body();
        }
        catch (Exception e) {
            return "Something is not ok :(((( Backend may be offline \n" + e.getMessage();
        }
    }

    public static void printCheck(Player player) {
        player.m_213846_((Component)Component.m_237113_((String)"This may take some time to check"));
        CompletableFuture.runAsync(() -> {
            Object response = "";
            try {
                response = (String)response + LeaderboardUtil.check();
            }
            catch (Exception e) {
                response = (String)response + e.getMessage();
            }
            player.m_213846_((Component)Component.m_237113_((String)response));
        });
    }

    public static void printAll(Player player) {
        CompletableFuture.runAsync(() -> {
            String response = VPUtil.filterString(LeaderboardUtil.getAll());
            player.m_213846_((Component)Component.m_237113_((String)"Position | Nickname | Challenges | Unique Challenges"));
            int count = 0;
            for (String name : response.split(",")) {
                if (count < 10) {
                    ++count;
                    player.m_213846_(GradientUtil.goldenGradient(name.replaceAll("^\"|\"$", "")));
                    continue;
                }
                player.m_213846_((Component)Component.m_237113_((String)name.replaceAll("^\"|\"$", "")));
            }
        });
    }

    public static void printYourself(Player player) {
        CompletableFuture.runAsync(() -> player.m_213846_((Component)Component.m_237113_((String)LeaderboardUtil.getInformation(player.m_20148_()))));
    }

    public static String getTopPlayers() {
        if (exception) {
            return "exception";
        }
        if (topPlayers.isEmpty()) {
            CompletableFuture.runAsync(() -> {
                try {
                    HttpClient client = HttpClient.newHttpClient();
                    HttpRequest request = HttpRequest.newBuilder().uri(URI.create("http://" + LeaderboardUtil.getHost() + ":" + LeaderboardUtil.getPort() + "/getTop?version=" + LeaderboardUtil.getCurrentVersion())).GET().build();
                    HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
                    topPlayers = response.body();
                }
                catch (Exception e) {
                    exception = true;
                    specialPlayers = "Something is not ok :(((( Backend may be offline \n" + e.getMessage();
                }
            });
        }
        return topPlayers;
    }

    public static String getSpecialPlayers() {
        if (exception) {
            return "exception";
        }
        if (specialPlayers.isEmpty()) {
            CompletableFuture.runAsync(() -> {
                try {
                    HttpClient client = HttpClient.newHttpClient();
                    HttpRequest request = HttpRequest.newBuilder().uri(URI.create("http://" + LeaderboardUtil.getHost() + ":" + LeaderboardUtil.getPort() + "/getSpecial?version=" + LeaderboardUtil.getCurrentVersion())).GET().build();
                    HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
                    specialPlayers = response.body();
                }
                catch (Exception e) {
                    exception = true;
                    specialPlayers = "Something is not ok :(((( Backend may be offline \n" + e.getMessage();
                }
            });
        }
        return specialPlayers;
    }

    public static void refreshTopPlayers() {
        LeaderboardUtil.getTopPlayers();
        LeaderboardUtil.getSpecialPlayers();
    }

    public static String getCurrentVersion() {
        return "1.20.1:1.5.3";
    }

    public static void printVersion(Player player) {
        CompletableFuture.runAsync(() -> {
            try {
                String request = LeaderboardUtil.getVersion();
                if (!request.isEmpty() && !request.equals(LeaderboardUtil.getCurrentVersion().split(":")[1])) {
                    player.m_213846_((Component)Component.m_237113_((String)("\u00a77From \u00a75Vestiges of the Present mod: \u00a77You are running " + LeaderboardUtil.getCurrentVersion().split(":")[1] + " version. Please update to latest " + request + " version.")));
                }
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
        });
    }

    public static String getVersion() {
        try {
            String[] currentVersion = "1.20.1:1.5.3".split(":");
            HttpClient client = HttpClient.newHttpClient();
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create("http://" + LeaderboardUtil.getHost() + ":" + LeaderboardUtil.getPort() + "/getVersion?version=" + currentVersion[0])).GET().build();
            HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
            return response.body();
        }
        catch (Exception e) {
            return "";
        }
    }

    public static boolean hasGoldenName(UUID uuid) {
        if (exception) {
            return false;
        }
        try {
            for (String player : LeaderboardUtil.getTopPlayers().split(",")) {
                if (!uuid.equals(UUID.fromString(player))) continue;
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static boolean hasSpecialName(String name) {
        if (exception) {
            return false;
        }
        try {
            for (String nick : LeaderboardUtil.getSpecialPlayers().split(",")) {
                if (!nick.equals(name)) continue;
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static boolean isLeaderboardsActive(Player player) {
        return (Boolean)ConfigHandler.COMMON.leaderboard.get() != false && !player.m_20310_(2);
    }
}

