/*
 * Decompiled with CFR 0.152.
 */
package com.pyding.vp.capability;

import com.pyding.vp.item.ModItems;
import com.pyding.vp.item.vestiges.Vestige;
import com.pyding.vp.network.PacketHandler;
import com.pyding.vp.network.packets.ItemAnimationPacket;
import com.pyding.vp.network.packets.LorePacket;
import com.pyding.vp.network.packets.SendPlayerCapaToClient;
import com.pyding.vp.util.ConfigHandler;
import com.pyding.vp.util.VPUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.regex.Pattern;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.AutoRegisterCapability;

@AutoRegisterCapability
public class PlayerCapabilityVP {
    public static int totalVestiges = 24;
    private int[] challenges = new int[totalVestiges];
    private String coolDowned = "";
    private String biomesFound = "";
    private String damageDie = "";
    private String rareItems = "";
    private String monstersKilled = "";
    private String creaturesKilledAir = "";
    private String mobsTamed = "";
    private String foodEaten = "";
    private String loreComplete = "";
    private String tools = "";
    private String flowers = "";
    private Long coolDown = 0L;
    private String cats = "";
    private String goldenItems = "";
    private int chance = 0;
    private String randomEntity = "";
    private long chaosTime = 0L;
    private String commonChallenges = "";
    private String stellarChallenges = "";
    private String dimensions = "";
    private String dimensionsDir = "";
    private boolean debug = false;
    private String effects = "";
    private String bosses = "";
    private String music = "";
    private String templates = "";
    private String sea = "";
    private String friends = "";
    private boolean sleep = false;
    private long vip = 0L;
    private long bindTime = 0L;
    private long antiTp = 0L;
    private double bindX = 0.0;
    private double bindY = 0.0;
    private double bindZ = 0.0;
    private long deathTime = 0L;
    private boolean cheating = false;
    private static final Pattern PATTERN = Pattern.compile("minecraft:(\\w+)");
    private int pearls = 0;

    public long getCoolDown() {
        return this.coolDown;
    }

    public void setSleep(boolean slept) {
        this.sleep = slept;
    }

    public boolean getSleep() {
        return this.sleep;
    }

    public void addPearl(Player player) {
        ++this.pearls;
        this.sync(player);
    }

    public int getPearls() {
        return this.pearls;
    }

    public void addDimension(Player player, String dim, String nameSpace) {
        if (VPUtil.notContains(this.dimensions, dim)) {
            this.dimensions = this.dimensions + dim + ",";
            this.dimensionsDir = this.dimensionsDir + nameSpace + ",";
            this.sync(player);
        }
    }

    public void addMusic(String musicDisk, Player player) {
        if (VPUtil.notContains(this.music, musicDisk) && !this.hasCoolDown(22)) {
            this.music = this.music + musicDisk + ",";
            this.setChallenge(22, player);
        }
    }

    public void addTemplate(String template, Player player) {
        if (VPUtil.notContains(this.templates, template) && !this.hasCoolDown(21)) {
            this.templates = this.templates + template + ",";
            this.setChallenge(21, player);
        }
    }

    public void addSea(String seaElement, Player player) {
        if (VPUtil.notContains(this.sea, seaElement) && !this.hasCoolDown(24)) {
            this.sea = this.sea + seaElement + ",";
            this.setChallenge(24, player);
        }
    }

    public String getDimensions() {
        return this.dimensions;
    }

    public List<String> getDimensionList() {
        ArrayList<String> dimList = new ArrayList<String>();
        for (String name : this.dimensions.split(",")) {
            dimList.add(name);
        }
        return dimList;
    }

    public List<String> getDimensionDirList() {
        ArrayList<String> dimList = new ArrayList<String>();
        for (String name : this.dimensionsDir.split(",")) {
            dimList.add(name);
        }
        return dimList;
    }

    public List<String> getRandomDimension() {
        Random random = new Random();
        int numba = random.nextInt(this.getDimensionList().size());
        ArrayList<String> list = new ArrayList<String>();
        list.add(this.getDimensionDirList().get(numba));
        list.add(this.getDimensionList().get(numba));
        return list;
    }

    public void removeDimension(String name) {
    }

    public long getChaosTime() {
        return this.chaosTime;
    }

    public void setChaosTime(long number, Player player) {
        this.chaosTime = number;
        this.sync(player);
    }

    public void setChance(int number) {
        this.chance = number;
    }

    public void setChance() {
        this.chance += ((Integer)ConfigHandler.COMMON.stellarChanceIncrease.get()).intValue();
    }

    public int getChance() {
        return this.chance;
    }

    public void addCommonChallenge(Player player, int number) {
        if (this.getCommonChallenges() >= 1 && this.getLore(player, 3)) {
            this.addLore(player, 4);
        }
        if (this.commonChallenges.isEmpty()) {
            this.addLore(player, 3);
        }
        if (!this.commonChallenges.contains("" + number)) {
            this.commonChallenges = this.commonChallenges + number + ",";
            this.sync(player);
        }
    }

    public void addStellarChallenge(Player player, int number) {
        if (this.stellarChallenges.isEmpty()) {
            this.addLore(player, 7);
        }
        if (!this.stellarChallenges.contains("" + number)) {
            this.stellarChallenges = this.stellarChallenges + number + ",";
            if (this.getStellarChallenges() == totalVestiges) {
                this.addLore(player, 9);
            }
            this.sync(player);
        }
    }

    public int getCommonChallenges() {
        int challs = 0;
        for (String ignored : this.commonChallenges.split(",")) {
            ++challs;
        }
        return challs;
    }

    public int getStellarChallenges() {
        int challs = 0;
        for (String ignored : this.stellarChallenges.split(",")) {
            ++challs;
        }
        return challs;
    }

    public void addLore(Player player, int number) {
        if (!this.loreComplete.contains("" + number)) {
            this.loreComplete = this.loreComplete + number + ",";
            this.sendLore(player, number);
            this.sync(player);
            if (number == 9) {
                player.m_36356_(new ItemStack((ItemLike)ModItems.INFINITE_REFRESHER.get()));
            }
        }
    }

    public boolean getLore(Player player, int number) {
        return this.loreComplete.contains("" + number);
    }

    public void setRandomEntity(EntityType type, Player player) {
        this.randomEntity = type.m_20675_();
        this.sync(player);
    }

    public String getRandomEntity() {
        return this.randomEntity;
    }

    public void giveVestige(Player player, int vp) {
        if (!this.hasCoolDown(vp)) {
            if (player.m_20193_().f_46443_) {
                return;
            }
            this.setChallenge(vp, 0, player);
            this.addCoolDown(vp, player);
            this.clearProgress(vp, player);
            ItemStack stack = this.vestige(vp, player);
            VPUtil.giveStack(stack, player);
            VPUtil.play((LivingEntity)player, SoundEvents.f_12496_);
            VPUtil.addChallenge(player, vp);
        }
    }

    public void addTimeCd(long time, Player player) {
        this.coolDown = time;
        this.sync(player);
    }

    public long getTimeCd() {
        return this.coolDown;
    }

    public void addCoolDown(int vp, Player player) {
        if (!this.hasCoolDown(vp)) {
            this.coolDowned = this.coolDowned + vp + ",";
            this.sync(player);
        }
    }

    public String getDamageDie() {
        return this.damageDie;
    }

    public String getrareItems() {
        return this.rareItems;
    }

    public void clearCoolDown(Player player) {
        this.coolDowned = "";
        this.sync(player);
    }

    public boolean hasCoolDown(int vp) {
        for (String element : this.coolDowned.split(",")) {
            if (!element.equals(Integer.toString(vp))) continue;
            return true;
        }
        return false;
    }

    public void addGold(String gold, Player player) {
        if (VPUtil.notContains(this.goldenItems, gold)) {
            this.goldenItems = this.goldenItems + gold + ",";
            this.sync(player);
        }
    }

    public void addFriend(String friend, Player player) {
        if (VPUtil.notContains(this.friends, friend)) {
            this.friends = this.friends + friend + ",";
            this.sync(player);
        }
    }

    public void removeFriend(String friend, Player player) {
        ArrayList<String> list = new ArrayList<String>(List.of(this.friends.split(",")));
        list.remove(friend);
        this.friends = "";
        for (String element : list) {
            this.friends = this.friends + element + ",";
        }
        this.sync(player);
    }

    public String getFriends() {
        return this.friends;
    }

    public void addCat(String cat, Player player) {
        if (VPUtil.notContains(this.cats, cat) && !this.hasCoolDown(8)) {
            this.cats = this.cats + cat + ",";
            this.setChallenge(8, player);
        }
    }

    public void addEffect(String effect, Player player) {
        if (VPUtil.notContains(this.effects, effect) && !this.hasCoolDown(17)) {
            this.effects = this.effects + effect + ",";
            this.setChallenge(17, player);
        }
    }

    public void addBiome(Player player) {
        String biomeName;
        ResourceLocation key = VPUtil.getCurrentBiome(player);
        if (key != null && VPUtil.notContains(this.biomesFound, biomeName = key.m_135815_()) && !this.hasCoolDown(3)) {
            this.biomesFound = this.biomesFound + biomeName + ",";
            this.setChallenge(3, player);
        }
    }

    public void addFlower(String flower, Player player) {
        if (VPUtil.notContains(this.flowers, flower) && !this.hasCoolDown(16)) {
            this.flowers = this.flowers + flower + ",";
            this.setChallenge(16, player);
        }
    }

    public void addCreatureKilledAir(String name, Player player) {
        if (VPUtil.notContains(this.creaturesKilledAir, name) && !this.hasCoolDown(1)) {
            this.creaturesKilledAir = this.creaturesKilledAir + name + ",";
            this.setChallenge(1, player);
        }
    }

    public void addDamageDie(String damage, Player player) {
        if (VPUtil.notContains(this.damageDie, damage) && !this.hasCoolDown(11)) {
            this.damageDie = this.damageDie + damage + ",";
            this.setChallenge(11, player);
        }
    }

    public void addrareItems(String item, Player player) {
        if (VPUtil.notContains(this.rareItems, item) && !this.hasCoolDown(13)) {
            this.rareItems = this.rareItems + item + ",";
            this.setChallenge(13, player);
        }
    }

    public void addMonsterKill(String monster, Player player) {
        if (VPUtil.notContains(this.monstersKilled, monster) && !this.hasCoolDown(2)) {
            this.monstersKilled = this.monstersKilled + monster + ",";
            this.setChallenge(2, player);
        }
    }

    public String getBosses() {
        return this.bosses;
    }

    public String getMusic() {
        return this.music;
    }

    public String getTemplates() {
        return this.templates;
    }

    public String getSea() {
        return this.sea;
    }

    public void addBossKill(String monster, Player player) {
        if (VPUtil.notContains(this.bosses, monster) && !this.hasCoolDown(15)) {
            this.bosses = this.bosses + monster + ",";
            this.setChallenge(15, player);
        }
    }

    public double getGoldenChance() {
        double chance = 10.0;
        for (String gold : this.goldenItems.split(",")) {
            chance += 1.0;
        }
        return chance;
    }

    public String getMonstersKilled() {
        return this.monstersKilled;
    }

    public String getBiomesFound() {
        return this.biomesFound;
    }

    public String getFoodEaten() {
        return this.foodEaten;
    }

    public String getTools() {
        return this.tools;
    }

    public String getFlowers() {
        return this.flowers;
    }

    public String getEffects() {
        return this.effects;
    }

    public void addMobTame(String mob, Player player) {
        if (VPUtil.notContains(this.mobsTamed, mob) && !this.hasCoolDown(20)) {
            this.mobsTamed = this.mobsTamed + mob + ",";
            this.setChallenge(20, player);
        }
    }

    public void addFood(String food, Player player) {
        if (VPUtil.notContains(this.foodEaten, food) && !this.hasCoolDown(6)) {
            this.foodEaten = this.foodEaten + food + ",";
            this.setChallenge(6, player);
        }
    }

    public void addTool(String tool, Player player) {
        if (VPUtil.notContains(this.tools, tool) && !this.hasCoolDown(10)) {
            this.tools = this.tools + tool + ",";
            this.setChallenge(10, player);
        }
    }

    public String getMobsTamed() {
        return this.mobsTamed;
    }

    public void clearProgress(int vp, Player player) {
        switch (vp) {
            case 1: {
                this.creaturesKilledAir = "";
                break;
            }
            case 2: {
                this.monstersKilled = "";
                break;
            }
            case 3: {
                this.biomesFound = "";
                break;
            }
            case 6: {
                this.foodEaten = "";
                break;
            }
            case 8: {
                this.cats = "";
                break;
            }
            case 9: {
                this.goldenItems = "";
                break;
            }
            case 10: {
                this.tools = "";
                break;
            }
            case 11: {
                this.damageDie = "";
                break;
            }
            case 13: {
                this.rareItems = "";
                break;
            }
            case 14: {
                this.chaosTime = System.currentTimeMillis();
                this.randomEntity = VPUtil.getRandomEntity().m_20675_();
                break;
            }
            case 15: {
                this.bosses = "";
                break;
            }
            case 16: {
                this.flowers = "";
                break;
            }
            case 17: {
                this.effects = "";
                break;
            }
            case 20: {
                this.mobsTamed = "";
                break;
            }
            case 21: {
                this.templates = "";
                break;
            }
            case 22: {
                this.music = "";
                break;
            }
            case 24: {
                this.sea = "";
                break;
            }
        }
        this.setChallenge(vp, 0, player);
        this.sync(player);
    }

    public void failChallenge(int vp, Player player) {
        this.setChallenge(vp, 0, player);
        this.clearProgress(vp, player);
        this.addCoolDown(vp, player);
    }

    public void clearAllProgress(Player player) {
        this.mobsTamed = "";
        this.monstersKilled = "";
        this.biomesFound = "";
        this.rareItems = "";
        this.damageDie = "";
        this.coolDowned = "";
        this.foodEaten = "";
        this.loreComplete = "";
        this.coolDown = 0L;
        this.tools = "";
        this.flowers = "";
        this.cats = "";
        this.goldenItems = "";
        for (int i = 1; i < totalVestiges + 1; ++i) {
            this.setChallenge(i, 0, player);
        }
        this.chance = 10;
        this.chaosTime = System.currentTimeMillis();
        this.randomEntity = VPUtil.getRandomEntity().m_20675_();
        this.commonChallenges = "";
        this.stellarChallenges = "";
        this.dimensions = "";
        this.dimensionsDir = "";
        this.effects = "";
        this.bosses = "";
        this.music = "";
        this.templates = "";
        this.sea = "";
        this.vip = 0L;
        this.pearls = 0;
        this.sync(player);
    }

    public static int getMaximum(int number, Player player) {
        boolean leaderboard = VPUtil.isLeaderboardsActive(player);
        if (((Boolean)ConfigHandler.COMMON.reduceChallengesPercent.get()).booleanValue()) {
            float reduce = 1.0f - (float)ConfigHandler.COMMON.getChallengeReduceByNumber(number) / 100.0f;
            if (leaderboard && (double)reduce < 0.9) {
                reduce = 0.9f;
            }
            switch (number) {
                case 1: {
                    return (int)((float)VPUtil.getEntitiesList().size() / 10.0f * reduce);
                }
                case 2: {
                    return (int)((float)VPUtil.monsterList.size() * reduce);
                }
                case 3: {
                    return (int)((float)VPUtil.getBiomes().size() * reduce);
                }
                case 4: {
                    return (int)(100.0f * reduce);
                }
                case 5: {
                    return (int)(100.0f * reduce);
                }
                case 6: {
                    return (int)((float)VPUtil.getEdibleItems().size() * reduce);
                }
                case 7: {
                    return (int)(15.0f * reduce);
                }
                case 8: {
                    return (int)(11.0f * reduce);
                }
                case 9: {
                    return (int)(8.0f * reduce);
                }
                case 10: {
                    return (int)(20.0f * reduce);
                }
                case 11: {
                    return (int)((float)VPUtil.getDamageKinds().size() * reduce);
                }
                case 12: {
                    return (int)(10.0f * reduce);
                }
                case 13: {
                    return (int)((float)VPUtil.hashRares.size() * reduce);
                }
                case 14: {
                    return (int)(6.0f * reduce);
                }
                case 15: {
                    return (int)((float)VPUtil.bossList.size() * reduce);
                }
                case 16: {
                    return (int)((float)VPUtil.getFlowers().size() * reduce);
                }
                case 17: {
                    return (int)((float)VPUtil.getEffects().size() * reduce);
                }
                case 18: {
                    return (int)(20.0f * reduce);
                }
                case 19: {
                    return (int)(1000000.0f * reduce);
                }
                case 20: {
                    return (int)((float)VPUtil.getEntitiesListOfType(MobCategory.CREATURE).size() * reduce);
                }
                case 21: {
                    return (int)((float)VPUtil.getTemplates().size() * reduce);
                }
                case 22: {
                    return (int)((float)VPUtil.getMusicDisks().size() * reduce);
                }
                case 23: {
                    return (int)(8.0f * reduce);
                }
                case 24: {
                    return (int)((float)VPUtil.getSeaSize() * reduce);
                }
            }
        } else {
            int reduce = ConfigHandler.COMMON.getChallengeReduceByNumber(number);
            if (leaderboard && reduce > 3) {
                reduce = 3;
            }
            switch (number) {
                case 1: {
                    return VPUtil.getEntitiesList().size() / 10 - reduce;
                }
                case 2: {
                    return VPUtil.monsterList.size() - reduce;
                }
                case 3: {
                    return VPUtil.getBiomes().size() - reduce;
                }
                case 4: {
                    return 100 - reduce;
                }
                case 5: {
                    return 100 - reduce;
                }
                case 6: {
                    return VPUtil.getEdibleItems().size() - reduce;
                }
                case 7: {
                    return 15 - reduce;
                }
                case 8: {
                    return 11 - reduce;
                }
                case 9: {
                    return 8 - reduce;
                }
                case 10: {
                    return 20 - reduce;
                }
                case 11: {
                    return VPUtil.getDamageKinds().size() - reduce;
                }
                case 12: {
                    return 10 - reduce;
                }
                case 13: {
                    return (int)((float)VPUtil.hashRares.size() - (float)reduce);
                }
                case 14: {
                    return 6 - reduce;
                }
                case 15: {
                    return VPUtil.bossList.size() - reduce;
                }
                case 16: {
                    return VPUtil.getFlowers().size() - reduce;
                }
                case 17: {
                    return VPUtil.getEffects().size() - reduce;
                }
                case 18: {
                    return 20 - reduce;
                }
                case 19: {
                    return 1000000 - reduce;
                }
                case 20: {
                    return VPUtil.getEntitiesListOfType(MobCategory.CREATURE).size() - reduce;
                }
                case 21: {
                    return VPUtil.getTemplates().size() - reduce;
                }
                case 22: {
                    return VPUtil.getMusicDisks().size() - reduce;
                }
                case 23: {
                    return 8 - reduce;
                }
                case 24: {
                    return VPUtil.getSeaSize() - reduce;
                }
            }
        }
        return 0;
    }

    public static void initMaximum(Player player) {
        Level level = player.m_20193_();
        VPUtil.initMonstersAndBosses(player);
        VPUtil.initBiomes(player, level);
        VPUtil.initBuckets();
        player.getPersistentData().m_128359_("VPVortex", VPUtil.filterString(VPUtil.vortexItems().toString()));
        for (int i = 1; i < totalVestiges + 1; ++i) {
            player.getPersistentData().m_128405_("VPMaxChallenge" + i, PlayerCapabilityVP.getMaximum(i, player));
        }
        VPUtil.sync(player);
    }

    public boolean getDebug() {
        return this.debug;
    }

    public void setDebug(Player player) {
        this.debug = !this.debug;
        this.sync(player);
    }

    public int getChallenge(int vp) {
        if (vp >= 1 && vp <= totalVestiges) {
            return this.challenges[vp - 1];
        }
        return 0;
    }

    public void setChallenge(int vp, int value, Player player) {
        if (vp >= 1 && vp <= totalVestiges && !this.hasCoolDown(vp)) {
            this.challenges[vp - 1] = value;
        }
        this.sync(player);
    }

    public void setChallenge(int vp, Player player) {
        if (vp >= 1 && vp <= totalVestiges && !this.hasCoolDown(vp)) {
            int n = vp - 1;
            this.challenges[n] = this.challenges[n] + 1;
        }
        this.sync(player);
    }

    public void copyNBT(PlayerCapabilityVP source) {
        this.challenges = source.challenges;
        this.coolDowned = source.coolDowned;
        this.biomesFound = source.biomesFound;
        this.damageDie = source.damageDie;
        this.rareItems = source.rareItems;
        this.monstersKilled = source.monstersKilled;
        this.foodEaten = source.foodEaten;
        this.loreComplete = source.loreComplete;
        this.coolDown = source.coolDown;
        this.tools = source.tools;
        this.mobsTamed = source.mobsTamed;
        this.chance = source.chance;
        this.cats = source.cats;
        this.goldenItems = source.goldenItems;
        this.chaosTime = source.chaosTime;
        this.randomEntity = source.randomEntity;
        this.commonChallenges = source.commonChallenges;
        this.stellarChallenges = source.stellarChallenges;
        this.dimensions = source.dimensions;
        this.dimensionsDir = source.dimensionsDir;
        this.debug = source.debug;
        this.effects = source.effects;
        this.bosses = source.bosses;
        this.flowers = source.flowers;
        this.creaturesKilledAir = source.creaturesKilledAir;
        this.music = source.music;
        this.templates = source.templates;
        this.sea = source.sea;
        this.pearls = source.pearls;
        this.sleep = source.sleep;
        this.friends = source.friends;
        this.vip = source.vip;
        this.antiTp = source.antiTp;
        this.bindTime = source.bindTime;
        this.bindX = source.bindX;
        this.bindY = source.bindY;
        this.bindZ = source.bindZ;
        this.deathTime = source.deathTime;
        this.cheating = source.cheating;
    }

    public void saveNBT(CompoundTag nbt) {
        for (int i = 0; i < totalVestiges; ++i) {
            nbt.m_128405_("challenge" + i, this.challenges[i]);
        }
        nbt.m_128359_("VPCoolDowned", this.coolDowned);
        nbt.m_128359_("VPBiomesFound", this.biomesFound);
        nbt.m_128359_("VPDamageDie", this.damageDie);
        nbt.m_128359_("VPrareItems", this.rareItems);
        nbt.m_128359_("VPMonstersKilled", this.monstersKilled);
        nbt.m_128359_("VPFoodEaten", this.foodEaten);
        nbt.m_128359_("VPLore", this.loreComplete);
        nbt.m_128356_("VPCoolDown", this.coolDown.longValue());
        nbt.m_128359_("VPTools", this.tools);
        nbt.m_128359_("VPMobs", this.mobsTamed);
        nbt.m_128359_("VPFlowers", this.flowers);
        nbt.m_128405_("VPChance", this.chance);
        nbt.m_128359_("VPCats", this.cats);
        nbt.m_128359_("VPGold", this.goldenItems);
        nbt.m_128359_("VPRandomEntity", this.randomEntity);
        nbt.m_128356_("VPCT", this.chaosTime);
        nbt.m_128359_("VPCC", this.commonChallenges);
        nbt.m_128359_("VPSC", this.stellarChallenges);
        nbt.m_128359_("VPDimensions", this.dimensions);
        nbt.m_128359_("VPDimensionsDir", this.dimensionsDir);
        nbt.m_128379_("VPDebug", this.debug);
        nbt.m_128359_("VPEffects", this.effects);
        nbt.m_128359_("VPBosses", this.bosses);
        nbt.m_128359_("VPAir", this.creaturesKilledAir);
        nbt.m_128359_("VPMusic", this.music);
        nbt.m_128359_("VPTemplate", this.templates);
        nbt.m_128359_("VPSea", this.sea);
        nbt.m_128359_("VPFriends", this.friends);
        nbt.m_128379_("VPSlept", this.sleep);
        nbt.m_128405_("VPPearls", this.pearls);
        nbt.m_128356_("VPVIP", this.vip);
        nbt.m_128356_("VPAntiTP", this.antiTp);
        nbt.m_128356_("VPBind", this.bindTime);
        nbt.m_128347_("VPBindX", this.bindX);
        nbt.m_128347_("VPBindY", this.bindY);
        nbt.m_128347_("VPBindZ", this.bindZ);
        nbt.m_128356_("VPDeathTime", this.deathTime);
        nbt.m_128379_("VPCheating", this.cheating);
    }

    public void loadNBT(CompoundTag nbt) {
        for (int i = 0; i < totalVestiges; ++i) {
            this.challenges[i] = nbt.m_128451_("challenge" + i);
        }
        this.coolDowned = nbt.m_128461_("VPCoolDowned");
        this.biomesFound = nbt.m_128461_("VPBiomesFound");
        this.damageDie = nbt.m_128461_("VPDamageDie");
        this.rareItems = nbt.m_128461_("VPrareItems");
        this.monstersKilled = nbt.m_128461_("VPMonstersKilled");
        this.foodEaten = nbt.m_128461_("VPFoodEaten");
        this.loreComplete = nbt.m_128461_("VPLore");
        this.coolDown = nbt.m_128454_("VPCoolDown");
        this.tools = nbt.m_128461_("VPTools");
        this.mobsTamed = nbt.m_128461_("VPMobs");
        this.flowers = nbt.m_128461_("VPFlowers");
        this.chance = nbt.m_128451_("VPChance");
        this.cats = nbt.m_128461_("VPCats");
        this.goldenItems = nbt.m_128461_("VPGold");
        this.randomEntity = nbt.m_128461_("VPRandomEntity");
        this.chaosTime = nbt.m_128454_("VPCT");
        this.commonChallenges = nbt.m_128461_("VPCC");
        this.stellarChallenges = nbt.m_128461_("VPSC");
        this.dimensions = nbt.m_128461_("VPDimensions");
        this.dimensionsDir = nbt.m_128461_("VPDimensionsDir");
        this.debug = nbt.m_128471_("VPDebug");
        this.effects = nbt.m_128461_("VPEffects");
        this.bosses = nbt.m_128461_("VPBosses");
        this.creaturesKilledAir = nbt.m_128461_("VPAir");
        this.music = nbt.m_128461_("VPMusic");
        this.templates = nbt.m_128461_("VPTemplate");
        this.sea = nbt.m_128461_("VPSea");
        this.friends = nbt.m_128461_("VPFriends");
        this.pearls = nbt.m_128451_("VPPearls");
        this.sleep = nbt.m_128471_("VPSlept");
        this.vip = nbt.m_128454_("VPVIP");
        this.antiTp = nbt.m_128454_("VPAntiTP");
        this.bindTime = nbt.m_128454_("VPBind");
        this.bindX = nbt.m_128459_("VPBindX");
        this.bindY = nbt.m_128459_("VPBindY");
        this.bindZ = nbt.m_128459_("VPBindZ");
        this.deathTime = nbt.m_128454_("VPDeathTime");
        this.cheating = nbt.m_128471_("VPCheating");
    }

    public void sync(Player player) {
        if (player.m_20193_().f_46443_) {
            return;
        }
        if (this.getVip() < System.currentTimeMillis()) {
            this.setVip(0L);
        }
        VPUtil.resync(this, player);
        ServerPlayer serverPlayer = (ServerPlayer)player;
        CompoundTag nbt = new CompoundTag();
        this.saveNBT(nbt);
        PacketHandler.sendToClient(new SendPlayerCapaToClient(nbt), serverPlayer);
    }

    public void sendLore(Player player, int number) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            PacketHandler.sendToClient(new LorePacket(number), serverPlayer);
        }
    }

    public ItemStack vestige(int vp, Player player) {
        ItemStack stack = switch (vp) {
            case 1 -> new ItemStack((ItemLike)ModItems.ANEMOCULUS.get());
            case 2 -> new ItemStack((ItemLike)ModItems.CROWN.get());
            case 3 -> new ItemStack((ItemLike)ModItems.ATLAS.get());
            case 4 -> new ItemStack((ItemLike)ModItems.KILLER.get());
            case 5 -> new ItemStack((ItemLike)ModItems.MASK.get());
            case 6 -> new ItemStack((ItemLike)ModItems.DONUT.get());
            case 7 -> new ItemStack((ItemLike)ModItems.MARK.get());
            case 8 -> new ItemStack((ItemLike)ModItems.EARS.get());
            case 9 -> new ItemStack((ItemLike)ModItems.MIDAS.get());
            case 10 -> new ItemStack((ItemLike)ModItems.ANOMALY.get());
            case 11 -> new ItemStack((ItemLike)ModItems.ARMOR.get());
            case 12 -> new ItemStack((ItemLike)ModItems.BOOK.get());
            case 13 -> new ItemStack((ItemLike)ModItems.PRISM.get());
            case 14 -> new ItemStack((ItemLike)ModItems.CHAOS.get());
            case 15 -> new ItemStack((ItemLike)ModItems.DEVOURER.get());
            case 16 -> new ItemStack((ItemLike)ModItems.FLOWER.get());
            case 17 -> new ItemStack((ItemLike)ModItems.CATALYST.get());
            case 18 -> new ItemStack((ItemLike)ModItems.BALL.get());
            case 19 -> new ItemStack((ItemLike)ModItems.TRIGON.get());
            case 20 -> new ItemStack((ItemLike)ModItems.SOULBLIGHTER.get());
            case 21 -> new ItemStack((ItemLike)ModItems.RUNE.get());
            case 22 -> new ItemStack((ItemLike)ModItems.LYRA.get());
            case 23 -> new ItemStack((ItemLike)ModItems.PEARL.get());
            case 24 -> new ItemStack((ItemLike)ModItems.WHIRLPOOL.get());
            default -> new ItemStack((ItemLike)ModItems.STELLAR.get());
        };
        double stellarChance = this.getChance();
        Random random = new Random();
        if (VPUtil.getSet(player) == 9) {
            stellarChance += 5.0;
        }
        if (this.getVip() > System.currentTimeMillis()) {
            stellarChance += 10.0;
        }
        if (random.nextDouble() < VPUtil.getChance(stellarChance / 100.0, player)) {
            if (stellarChance >= 200.0) {
                Vestige.setDoubleStellar(stack);
            }
            Vestige.setStellar(stack);
            this.setChance((Integer)ConfigHandler.COMMON.stellarChanceIncrease.get());
            this.addStellarChallenge(player, vp);
            if (random.nextDouble() < VPUtil.getChance((Double)ConfigHandler.COMMON.refresherChance.get(), player)) {
                VPUtil.giveStack(new ItemStack((ItemLike)ModItems.REFRESHER.get()), player);
            }
        } else {
            this.setChance();
            this.addCommonChallenge(player, vp);
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            PacketHandler.sendToClient(new ItemAnimationPacket(stack), serverPlayer);
        }
        return stack;
    }

    public long getVip() {
        return this.vip;
    }

    public void setVip(long vip) {
        this.vip = this.vip > 0L && this.vip > System.currentTimeMillis() ? (this.vip += vip - System.currentTimeMillis()) : vip;
    }

    public long getBindTime() {
        return this.bindTime;
    }

    public void setBindTime(long bindTime) {
        this.bindTime = bindTime;
    }

    public long getAntiTp() {
        return this.antiTp;
    }

    public void setAntiTp(long antiTp) {
        this.antiTp = antiTp;
    }

    public double getBindX() {
        return this.bindX;
    }

    public void setBindX(double bindX) {
        this.bindX = bindX;
    }

    public double getBindY() {
        return this.bindY;
    }

    public void setBindY(double bindY) {
        this.bindY = bindY;
    }

    public double getBindZ() {
        return this.bindZ;
    }

    public void setBindZ(double bindZ) {
        this.bindZ = bindZ;
    }

    public long getDeathTime() {
        return this.deathTime;
    }

    public void setDeathTime(long deathTime) {
        this.deathTime = deathTime;
    }

    public boolean isCheating() {
        return this.cheating;
    }

    public void setCheating(boolean cheating) {
        this.cheating = cheating;
    }
}

