/*
 * Decompiled with CFR 0.152.
 */
package com.pyding.vp.client;

import com.pyding.vp.client.ShieldOverlay;
import com.pyding.vp.client.render.CloudRenderer;
import com.pyding.vp.client.render.EasterEggRenderer;
import com.pyding.vp.client.render.OysterRenderer;
import com.pyding.vp.client.render.SeashellRenderer;
import com.pyding.vp.client.render.ShellHealRenderer;
import com.pyding.vp.client.render.VestigeHunterKillerRenderer;
import com.pyding.vp.client.render.VortexRenderer;
import com.pyding.vp.client.render.blackhole.BlackHoleRenderer;
import com.pyding.vp.entity.ModEntities;
import com.pyding.vp.entity.models.Hunter;
import com.pyding.vp.network.PacketHandler;
import com.pyding.vp.network.packets.ButtonPressPacket;
import com.pyding.vp.util.KeyBinding;
import com.pyding.vp.util.VPUtil;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.TropicalFish;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RegisterGuiOverlaysEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

public class ClientEvents {

    @Mod.EventBusSubscriber(modid="vp", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class ClientModBusEvents {
        @SubscribeEvent
        public static void onKeyRegister(RegisterKeyMappingsEvent event) {
            event.register(KeyBinding.FIRST_KEY);
            event.register(KeyBinding.FIRST_KEY_ULT);
            event.register(KeyBinding.SECOND_KEY);
            event.register(KeyBinding.SECOND_KEY_ULT);
        }

        @SubscribeEvent
        public static void registerGuiOverlays(RegisterGuiOverlaysEvent event) {
            event.registerAboveAll("vpshield", ShieldOverlay.HUD_SHIELD);
        }

        @SubscribeEvent
        public static void registerLayer(EntityRenderersEvent.RegisterLayerDefinitions event) {
            event.registerLayerDefinition(Hunter.LAYER_LOCATION, Hunter::createBodyLayer);
        }

        @SubscribeEvent
        public static void rendererRegister(EntityRenderersEvent.RegisterRenderers event) {
            event.registerEntityRenderer((EntityType)ModEntities.BLACK_HOLE.get(), BlackHoleRenderer::new);
            event.registerEntityRenderer((EntityType)ModEntities.VORTEX.get(), VortexRenderer::new);
            event.registerEntityRenderer((EntityType)ModEntities.KILLER.get(), VestigeHunterKillerRenderer::new);
            event.registerEntityRenderer((EntityType)ModEntities.EASTER_EGG_ENTITY.get(), EasterEggRenderer::new);
            event.registerEntityRenderer((EntityType)ModEntities.CLOUD_ENTITY.get(), CloudRenderer::new);
            event.registerEntityRenderer((EntityType)ModEntities.OYSTER.get(), OysterRenderer::new);
            event.registerEntityRenderer((EntityType)ModEntities.SEASHELL.get(), SeashellRenderer::new);
            event.registerEntityRenderer((EntityType)ModEntities.SHELLHEAL.get(), ShellHealRenderer::new);
        }
    }

    @Mod.EventBusSubscriber(modid="vp", value={Dist.CLIENT})
    public static class ClientForgeEvents {
        @SubscribeEvent
        public static void onKeyInput(InputEvent.Key event) {
            if (KeyBinding.FIRST_KEY_ULT.m_90857_()) {
                PacketHandler.sendToServer(new ButtonPressPacket(3));
            } else if (KeyBinding.FIRST_KEY.m_90857_()) {
                PacketHandler.sendToServer(new ButtonPressPacket(1));
            }
            if (KeyBinding.SECOND_KEY_ULT.m_90857_()) {
                PacketHandler.sendToServer(new ButtonPressPacket(4));
            } else if (KeyBinding.SECOND_KEY.m_90857_()) {
                PacketHandler.sendToServer(new ButtonPressPacket(2));
            }
        }

        @SubscribeEvent
        public static void renderEvent(RenderLivingEvent.Pre<LivingEntity, ?> event) {
            LivingEntity entity = event.getEntity();
            if (VPUtil.isNightmareBoss(entity)) {
                event.getPoseStack().m_85841_(3.0f, 3.0f, 3.0f);
            }
            if (entity instanceof TropicalFish && entity.getPersistentData().m_128454_("VPEating") > 0L) {
                float scale = Math.min(10.0f, (float)(System.currentTimeMillis() - entity.getPersistentData().m_128454_("VPEating")) / 10000.0f);
                event.getPoseStack().m_85841_(scale, scale, scale);
            }
        }
    }
}

