/*
 * Decompiled with CFR 0.152.
 */
package com.pyding.vp.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.pyding.vp.entity.SillySeashell;
import com.pyding.vp.entity.VortexEntity;
import com.pyding.vp.item.vestiges.Catalyst;
import com.pyding.vp.item.vestiges.Vestige;
import com.pyding.vp.util.VPUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import org.joml.Matrix4f;

public class ShieldOverlay {
    private static final ResourceLocation HEALDEBT = new ResourceLocation("vp", "textures/gui/heal_debt.png");
    private static final ResourceLocation SHIELD = new ResourceLocation("vp", "textures/gui/shield.png");
    private static final ResourceLocation OVER_SHIELD = new ResourceLocation("vp", "textures/gui/overshield.png");
    private static final ResourceLocation HEAL1 = new ResourceLocation("vp", "textures/gui/heal1.png");
    private static final ResourceLocation HEAL2 = new ResourceLocation("vp", "textures/gui/heal2.png");
    private static final ResourceLocation HEAL3 = new ResourceLocation("vp", "textures/gui/heal3.png");
    private static final ResourceLocation ORCHESTRA = new ResourceLocation("vp", "textures/gui/orchestra.png");
    private static final ResourceLocation NOTE1 = new ResourceLocation("vp", "textures/gui/note1.png");
    private static final ResourceLocation NOTE2 = new ResourceLocation("vp", "textures/gui/note2.png");
    private static final ResourceLocation NOTE3 = new ResourceLocation("vp", "textures/gui/note3.png");
    private static final ResourceLocation NOTE4 = new ResourceLocation("vp", "textures/gui/note4.png");
    private static final ResourceLocation NOTE5 = new ResourceLocation("vp", "textures/gui/note5.png");
    private static final ResourceLocation NOTE6 = new ResourceLocation("vp", "textures/gui/note6.png");
    private static final ResourceLocation NOTE7 = new ResourceLocation("vp", "textures/gui/note7.png");
    private static final ResourceLocation NOTE8 = new ResourceLocation("vp", "textures/gui/note8.png");
    @OnlyIn(value=Dist.CLIENT)
    public static final IGuiOverlay HUD_SHIELD = (gui, pose, partialTick, width, height) -> {
        float healDebt;
        int x = width / 2;
        int y = height;
        PoseStack poseStack = pose.m_280168_();
        Minecraft minecraft = Minecraft.m_91087_();
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        Font fontRenderer = Minecraft.m_91087_().f_91062_;
        List<ItemStack> vestiges = VPUtil.getVestigeList((Player)player);
        int centerHeight = y - 230;
        if (vestiges.size() > 0) {
            for (int i = 0; i < vestiges.size(); ++i) {
                int show;
                int number;
                Item patt5580$temp = vestiges.get(i).m_41720_();
                if (!(patt5580$temp instanceof Vestige)) continue;
                Vestige vestige = (Vestige)patt5580$temp;
                ItemStack stack = vestiges.get(i);
                int vestigeNumber = vestige.vestigeNumber;
                if (vestigeNumber == 0) continue;
                pose.m_280163_(ShieldOverlay.getTexture(vestigeNumber), x + (130 + i * 40), y - 22, 0.0f, 0.0f, 16, 16, 16, 16);
                int currentChargeSpecial = stack.m_41784_().m_128451_("VPCurrentChargeSpecial");
                int currentChargeUltimate = stack.m_41784_().m_128451_("VPCurrentChargeUltimate");
                long time = stack.m_41784_().m_128454_("VPTime");
                long timeUlt = stack.m_41784_().m_128454_("VPTimeUlt");
                pose.m_280488_(fontRenderer, "" + currentChargeSpecial, x + (150 + i * 40), y - 24, vestige.color.m_126665_().intValue());
                pose.m_280488_(fontRenderer, "" + currentChargeUltimate, x + (150 + i * 40), y - 15, vestige.color.m_126665_().intValue());
                Object info = "";
                if (vestigeNumber == 3) {
                    info = String.valueOf(player.getPersistentData().m_128451_("VPGravity"));
                }
                if (vestigeNumber == 5 && vestige.isSpecialActive(stack)) {
                    info = vestige.isStellar(vestiges.get(i)) ? (int)VPUtil.missingHealth((LivingEntity)player) * 8 + "%" : (int)VPUtil.missingHealth((LivingEntity)player) * 4 + "%";
                }
                if (vestigeNumber == 6) {
                    info = String.valueOf((int)player.getPersistentData().m_128457_("VPSaturation"));
                }
                if (vestigeNumber == 7) {
                    info = String.valueOf(player.getPersistentData().m_128451_("VPMadness"));
                }
                if (vestigeNumber == 11) {
                    info = String.valueOf((int)stack.m_41784_().m_128457_("VPArmor"));
                }
                if (vestigeNumber == 15) {
                    info = String.valueOf(player.getPersistentData().m_128451_("VPDevourerHits"));
                }
                if (vestigeNumber == 16) {
                    info = (int)player.getPersistentData().m_128457_("VPHealResFlower") + "%";
                }
                if (vestigeNumber == 17 && vestige.isStellar(vestiges.get(i)) && vestige instanceof Catalyst) {
                    Catalyst catalyst = (Catalyst)vestige;
                    info = "" + player.getPersistentData().m_128451_("VPDebuffDefence");
                }
                if (vestigeNumber == 19) {
                    info = (int)player.getPersistentData().m_128457_("VPTrigonBonus") + "%";
                }
                if (vestigeNumber == 23) {
                    info = "" + player.getPersistentData().m_128451_("VPLures");
                }
                if (vestigeNumber == 24) {
                    info = "" + player.getPersistentData().m_128451_("VPWhirlpool");
                }
                String durationUlt = "";
                String durationSpecial = "";
                if (vestigeNumber == 8 && (number = Math.round(timeUlt - System.currentTimeMillis()) / 1000) > 0) {
                    durationUlt = String.valueOf(number);
                }
                if (vestigeNumber == 20 && (number = Math.round(time - System.currentTimeMillis()) / 1000) > 0) {
                    durationSpecial = String.valueOf(number);
                }
                if (vestigeNumber == 2 && (number = Math.round(timeUlt - System.currentTimeMillis()) / 1000) > 0) {
                    durationUlt = String.valueOf(number);
                }
                if (vestigeNumber == 1 && (number = Math.round(timeUlt - System.currentTimeMillis()) / 1000) > 0) {
                    durationUlt = String.valueOf(number);
                }
                if (vestigeNumber == 12 && (number = Math.round(time - System.currentTimeMillis()) / 1000) > 0) {
                    durationSpecial = String.valueOf(number);
                }
                if (vestigeNumber == 13 && (number = Math.round(time - System.currentTimeMillis()) / 1000) > 0) {
                    durationSpecial = String.valueOf(number);
                }
                if (vestigeNumber == 4 && (number = Math.round(timeUlt - System.currentTimeMillis()) / 1000) > 0) {
                    durationUlt = String.valueOf(number);
                }
                if (vestigeNumber == 22 && (number = Math.round(timeUlt - System.currentTimeMillis()) / 1000) > 0) {
                    durationUlt = String.valueOf(number);
                }
                if (!((String)info).isEmpty()) {
                    pose.m_280488_(fontRenderer, (String)info, x + (132 + i * 40), y - 33, vestige.color.m_126665_().intValue());
                }
                if (!durationSpecial.isEmpty()) {
                    pose.m_280488_(fontRenderer, durationSpecial, x + (132 + i * 40), y - 33, 49151);
                }
                if (!durationUlt.isEmpty()) {
                    pose.m_280488_(fontRenderer, durationUlt, x + (132 + i * 40), y - 33, 10040012);
                }
                info = "";
                if (vestigeNumber == 15 && (show = player.getPersistentData().m_128451_("VPDevourerShow")) > 0) {
                    pose.m_280488_(fontRenderer, "" + show, x + (132 + i * 40), y - 43, 5534075);
                }
                if (vestigeNumber == 13 && (number = Math.round(timeUlt - System.currentTimeMillis()) / 1000) > 0) {
                    info = String.valueOf(number);
                }
                if (vestigeNumber == 7 && (number = Math.round(timeUlt - System.currentTimeMillis()) / 1000) > 0) {
                    info = String.valueOf(number);
                }
                if (vestigeNumber == 12 && (number = Math.round(timeUlt - System.currentTimeMillis()) / 1000) > 0) {
                    info = String.valueOf(number);
                }
                if (!((String)info).isEmpty()) {
                    pose.m_280488_(fontRenderer, (String)info, x + (132 + i * 40), y - 43, 10040012);
                }
                if (vestigeNumber != 22) continue;
                int sizeX = 20;
                int sizeY = 20;
                int pictureSizeX = 20;
                int pictureSizeY = 20;
                if (player.getPersistentData().m_128454_("VPOrchestra") > System.currentTimeMillis()) {
                    long song = player.getPersistentData().m_128454_("VPOrchestra");
                    long duration = Math.round(song - System.currentTimeMillis()) / 1000;
                    RenderSystem.setShaderTexture((int)0, (ResourceLocation)ORCHESTRA);
                    pose.m_280163_(ORCHESTRA, x + (132 + i * 40), y - 70, 0.0f, 0.0f, sizeX, sizeY, pictureSizeX, pictureSizeY);
                    pose.m_280488_(fontRenderer, "" + duration, x + (132 + i * 33), y - 43, 10040012);
                    continue;
                }
                for (int s = 1; s < 9; ++s) {
                    long song = player.getPersistentData().m_128454_("VPLyra" + s);
                    long duration = Math.round(song - System.currentTimeMillis()) / 1000;
                    int moveY = 0;
                    int moveX = s * 20;
                    if (s > 4) {
                        moveY = 30;
                        moveX = (s - 4) * 20;
                    }
                    int xPos = x - moveX + (183 + i * 40);
                    if (duration <= 0L) continue;
                    RenderSystem.setShaderTexture((int)0, (ResourceLocation)ShieldOverlay.getNote(s));
                    pose.m_280163_(ShieldOverlay.getNote(s), xPos, y - (70 + moveY), 0.0f, 0.0f, sizeX, sizeY, pictureSizeX, pictureSizeY);
                    pose.m_280488_(fontRenderer, "" + duration, xPos, y - (43 + moveY), 10040012);
                }
            }
        }
        float targetShield = player.getPersistentData().m_128457_("VPRender1");
        float targetOverShield = player.getPersistentData().m_128457_("VPRender2");
        float targetHealingDebt = player.getPersistentData().m_128457_("VPRender3");
        LivingEntity target = null;
        for (LivingEntity o : VPUtil.rayClass(Entity.class, (Player)player, 3.0f, 20, true)) {
            SillySeashell sillySeashell;
            int wave;
            if (o instanceof LivingEntity) {
                LivingEntity livingEntity;
                target = livingEntity = o;
            }
            if (o instanceof VortexEntity) {
                VortexEntity vortexEntity = (VortexEntity)o;
                String current = vortexEntity.getPersistentData().m_128461_("VPVortexList");
                String max = player.getPersistentData().m_128461_("VPVortex");
                int currentNumber = 0;
                int maxNumber = 0;
                ArrayList<String> listMax = new ArrayList<String>();
                ArrayList<String> listCurrent = new ArrayList<String>();
                if (!current.isEmpty()) {
                    for (String name : current.split(",")) {
                        ++currentNumber;
                        listCurrent.add(name.trim());
                    }
                }
                for (String name : max.split(",")) {
                    ++maxNumber;
                    listMax.add(name.trim());
                }
                listMax.removeAll(listCurrent);
                pose.m_280488_(fontRenderer, currentNumber + " / " + maxNumber, x - 10, centerHeight + 10, 10040012);
                pose.m_280430_(fontRenderer, VPUtil.filterAndTranslate(((Object)listMax).toString(), ChatFormatting.LIGHT_PURPLE), x - 10, centerHeight + 30, 10040012);
                break;
            }
            if (!(o instanceof SillySeashell) || (wave = (sillySeashell = (SillySeashell)o).getPersistentData().m_128451_("VPWave")) <= 0) continue;
            pose.m_280430_(fontRenderer, (Component)Component.m_237110_((String)"vp.wave", (Object[])new Object[]{wave}), x - 15, centerHeight - 60, 10918374);
        }
        if (targetOverShield > 0.0f) {
            int sizeX = 20;
            int sizeY = 20;
            int pictureSizeX = 20;
            int pictureSizeY = 20;
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)OVER_SHIELD);
            pose.m_280163_(OVER_SHIELD, x - 10, centerHeight, 0.0f, 0.0f, sizeX, sizeY, pictureSizeX, pictureSizeY);
            double log10 = Math.log10(targetOverShield);
            int move = (int)Math.floor(log10) + 1;
            pose.m_280488_(fontRenderer, "" + (float)Math.round(targetOverShield * 100.0f) / 100.0f, x - (10 + move), centerHeight - 9, 10040012);
            if (targetShield > 0.0f) {
                pose.m_280488_(fontRenderer, "" + (float)Math.round(targetShield * 100.0f) / 100.0f, x - (10 + move), centerHeight + 22, 0x808080);
            }
        } else if (targetShield > 0.0f) {
            int sizeX = 16;
            int sizeY = 16;
            int pictureSizeX = 16;
            int pictureSizeY = 16;
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)SHIELD);
            pose.m_280163_(SHIELD, x - 8, centerHeight - 3, 0.0f, 0.0f, sizeX, sizeY, pictureSizeX, pictureSizeY);
            double log10 = Math.log10(targetShield);
            int move = (int)Math.floor(log10) + 1;
            pose.m_280488_(fontRenderer, "" + (float)Math.round(targetShield * 100.0f) / 100.0f, x - (8 + move), centerHeight + 22, 0x808080);
        }
        if (targetHealingDebt > 0.0f && target != null) {
            int sizeX = 16;
            int sizeY = 16;
            int pictureSizeX = 16;
            int pictureSizeY = 16;
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)HEALDEBT);
            pose.m_280163_(HEALDEBT, x - 40, centerHeight - 3, 0.0f, 0.0f, sizeX, sizeY, pictureSizeX, pictureSizeY);
            pose.m_280488_(fontRenderer, (int)(targetHealingDebt / target.m_21233_() * 100.0f) + "%", x - 40, centerHeight + 22, 13523032);
        }
        if (player.m_7500_()) {
            return;
        }
        float healBonus = VPUtil.getHealBonus((LivingEntity)player);
        if (healBonus < 0.0f) {
            healBonus *= -1.0f;
            int sizeX = 8;
            int sizeY = 8;
            int pictureSizeX = 9;
            int pictureSizeY = 9;
            int i = 0;
            while ((float)i < Math.min(10.0f, player.m_21233_() / 2.0f)) {
                if (healBonus <= 30.0f) {
                    pose.m_280163_(HEAL1, x - 90 + (i * sizeX - 1), y - 39, 0.0f, 0.0f, sizeX, sizeY, pictureSizeX, pictureSizeY);
                } else if (healBonus <= 60.0f) {
                    pose.m_280163_(HEAL2, x - 90 + (i * sizeX - 1), y - 39, 0.0f, 0.0f, sizeX, sizeY, pictureSizeX, pictureSizeY);
                } else {
                    pose.m_280163_(HEAL3, x - 90 + (i * sizeX - 1), y - 39, 0.0f, 0.0f, sizeX, sizeY, pictureSizeX, pictureSizeY);
                }
                ++i;
            }
        }
        if ((healDebt = player.getPersistentData().m_128457_("VPHealDebt")) > 0.0f) {
            int sizeX = 16;
            int sizeY = 16;
            int pictureSizeX = 16;
            int pictureSizeY = 16;
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)HEALDEBT);
            pose.m_280163_(HEALDEBT, x - 114, y - 43, 0.0f, 0.0f, sizeX, sizeY, pictureSizeX, pictureSizeY);
            pose.m_280488_(fontRenderer, (int)(healDebt / player.m_21233_() * 100.0f) + "%", x - 117, y - 27, 13523032);
        }
        float overShield = VPUtil.getOverShield((LivingEntity)player);
        float shield = VPUtil.getShield((LivingEntity)player);
        if (overShield > 0.0f) {
            int sizeX = 20;
            sizeY = 20;
            int pictureSizeX = 20;
            int pictureSizeY = 20;
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)OVER_SHIELD);
            pose.m_280163_(OVER_SHIELD, x - 152, y - 42, 0.0f, 0.0f, sizeX, sizeY, pictureSizeX, pictureSizeY);
            double log10 = Math.log10(overShield);
            move = (int)Math.floor(log10) + 1;
            pose.m_280488_(fontRenderer, "" + (float)Math.round(overShield * 100.0f) / 100.0f, x - (149 + move), y - 51, 10040012);
            if (shield > 0.0f) {
                pose.m_280488_(fontRenderer, "" + (float)Math.round(shield * 100.0f) / 100.0f, x - (149 + move), y - 20, 0x808080);
            }
        } else if (shield > 0.0f) {
            int sizeX = 16;
            sizeY = 16;
            int pictureSizeX = 16;
            int pictureSizeY = 16;
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)SHIELD);
            pose.m_280163_(SHIELD, x - 150, y - 39, 0.0f, 0.0f, sizeX, sizeY, pictureSizeX, pictureSizeY);
            double log10 = Math.log10(shield);
            move = (int)Math.floor(log10) + 1;
            pose.m_280488_(fontRenderer, "" + (float)Math.round(shield * 100.0f) / 100.0f, x - (149 + move), y - 20, 0x808080);
        }
    };

    public static ResourceLocation getNote(int number) {
        return switch (number) {
            case 1 -> NOTE1;
            case 2 -> NOTE2;
            case 3 -> NOTE3;
            case 4 -> NOTE4;
            case 5 -> NOTE5;
            case 6 -> NOTE6;
            case 7 -> NOTE7;
            case 8 -> NOTE8;
            default -> ORCHESTRA;
        };
    }

    public static void renderTextureFromCenter(PoseStack matrix, float centerX, float centerY, float texOffX, float texOffY, float texWidth, float texHeight, float width, float height, float scale) {
        BufferBuilder builder = Tesselator.m_85913_().m_85915_();
        RenderSystem.setShader(GameRenderer::m_172817_);
        builder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        matrix.m_85836_();
        matrix.m_252880_(centerX, centerY, 0.0f);
        matrix.m_85841_(scale, scale, scale);
        Matrix4f m = matrix.m_85850_().m_252922_();
        float u1 = texOffX / texWidth;
        float u2 = (texOffX + width) / texWidth;
        float v1 = texOffY / texHeight;
        float v2 = (texOffY + height) / texHeight;
        float w2 = width / 2.0f;
        float h2 = height / 2.0f;
        builder.m_252986_(m, -w2, h2, 0.0f).m_7421_(u1, v2).m_5752_();
        builder.m_252986_(m, w2, h2, 0.0f).m_7421_(u2, v2).m_5752_();
        builder.m_252986_(m, w2, -h2, 0.0f).m_7421_(u2, v1).m_5752_();
        builder.m_252986_(m, -w2, -h2, 0.0f).m_7421_(u1, v1).m_5752_();
        matrix.m_85849_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)builder.m_231175_());
    }

    public static ResourceLocation getTexture(int vp) {
        ArrayList<ResourceLocation> locations = new ArrayList<ResourceLocation>();
        locations.add(new ResourceLocation("vp", "textures/item/anemoculus.png"));
        locations.add(new ResourceLocation("vp", "textures/item/crown.png"));
        locations.add(new ResourceLocation("vp", "textures/item/atlas.png"));
        locations.add(new ResourceLocation("vp", "textures/item/killer.png"));
        locations.add(new ResourceLocation("vp", "textures/item/mask.png"));
        locations.add(new ResourceLocation("vp", "textures/item/donut_static.png"));
        locations.add(new ResourceLocation("vp", "textures/item/mark.png"));
        locations.add(new ResourceLocation("vp", "textures/item/ears.png"));
        locations.add(new ResourceLocation("vp", "textures/item/midas.png"));
        locations.add(new ResourceLocation("vp", "textures/item/anomaly.png"));
        locations.add(new ResourceLocation("vp", "textures/item/armor.png"));
        locations.add(new ResourceLocation("vp", "textures/item/book.png"));
        locations.add(new ResourceLocation("vp", "textures/item/prism.png"));
        locations.add(new ResourceLocation("vp", "textures/item/chaos.png"));
        locations.add(new ResourceLocation("vp", "textures/item/devourer.png"));
        locations.add(new ResourceLocation("vp", "textures/item/flower.png"));
        locations.add(new ResourceLocation("vp", "textures/item/catalyst.png"));
        locations.add(new ResourceLocation("vp", "textures/item/ball.png"));
        locations.add(new ResourceLocation("vp", "textures/item/trigon.png"));
        locations.add(new ResourceLocation("vp", "textures/item/soulblighter.png"));
        locations.add(new ResourceLocation("vp", "textures/item/rune_static.png"));
        locations.add(new ResourceLocation("vp", "textures/item/lyra.png"));
        locations.add(new ResourceLocation("vp", "textures/item/pearl_static.png"));
        locations.add(new ResourceLocation("vp", "textures/item/whirlpool_static.png"));
        return (ResourceLocation)locations.get(vp - 1);
    }
}

