/*
 * Decompiled with CFR 0.152.
 */
package com.pyding.vp.client.render.blackhole;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.pyding.vp.client.render.blackhole.ShaderBlackHole;
import com.pyding.vp.entity.BlackHole;
import com.pyding.vp.item.ModItems;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BlackHoleRenderer
extends EntityRenderer<BlackHole> {
    public static final ResourceLocation TEXTURE = new ResourceLocation("vp", "textures/item/models/blackholepallet.png");
    private final ItemRenderer itemRenderer;

    public BlackHoleRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.itemRenderer = context.m_174025_();
    }

    public ResourceLocation getTextureLocation(BlackHole p_114482_) {
        return TEXTURE;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void render(BlackHole entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        poseStack.m_85836_();
        float gravity = entity.getPersistentData().m_128457_("VPGravity");
        poseStack.m_252880_(0.0f, 2.5f, 0.0f);
        float scale = 6.0f + gravity / 5.0f;
        if (entity.f_19797_ < 20) {
            scale /= (float)(20 - entity.f_19797_);
        } else if ((float)(entity.f_19797_ + 20) > 20.0f * (gravity + 2.0f)) {
            scale /= (float)(entity.f_19797_ + 20) - 20.0f * (gravity + 2.0f);
        }
        poseStack.m_85841_(scale, scale, scale);
        float angle = (float)(System.currentTimeMillis() % 36000L) / 2.0f;
        poseStack.m_252781_(Axis.f_252436_.m_252977_(-angle));
        ItemStack stack = new ItemStack((ItemLike)ModItems.BLACKHOLE_ITEM.get());
        poseStack.m_85841_(0.5f, 0.5f, 0.5f);
        this.itemRenderer.m_269128_(stack, ItemDisplayContext.FIXED, packedLight, OverlayTexture.f_118083_, poseStack, bufferSource, entity.m_9236_(), entity.m_19879_());
        ShaderBlackHole shader = null;
        try {
            shader = new ShaderBlackHole();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        shader.bind();
        shader.setUniform("iTime", (float)(System.currentTimeMillis() % 10000L) / 1000.0f);
        shader.setUniform("iResolution", Minecraft.m_91087_().m_91268_().m_85445_(), Minecraft.m_91087_().m_91268_().m_85446_());
        shader.unbind();
        poseStack.m_85849_();
        super.m_7392_((Entity)entity, entityYaw, partialTicks, poseStack, bufferSource, packedLight);
    }
}

