/*
 * Decompiled with CFR 0.152.
 */
package com.pyding.vp.client.render.blackhole;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import org.lwjgl.opengl.GL20;

public class ShaderBlackHole {
    private int programID;
    private int vertexShaderID = this.loadShader("shaders/blackhole_vertex.glsl", 35633);
    private int fragmentShaderID = this.loadShader("shaders/blackhole_fragment.glsl", 35632);

    public ShaderBlackHole() throws IOException {
        this.programID = GL20.glCreateProgram();
        GL20.glAttachShader((int)this.programID, (int)this.vertexShaderID);
        GL20.glAttachShader((int)this.programID, (int)this.fragmentShaderID);
        GL20.glLinkProgram((int)this.programID);
    }

    public int loadShader(String path, int shaderType) throws IOException {
        ResourceLocation shaderResource = new ResourceLocation("vp", path);
        InputStream inputStream = Minecraft.m_91087_().m_91098_().m_215595_(shaderResource);
        String shaderCode = new BufferedReader(new InputStreamReader(inputStream)).lines().collect(Collectors.joining("\n"));
        int shaderID = GL20.glCreateShader((int)shaderType);
        GL20.glShaderSource((int)shaderID, (CharSequence)shaderCode);
        GL20.glCompileShader((int)shaderID);
        GL20.glUseProgram((int)this.programID);
        if (GL20.glGetShaderi((int)shaderID, (int)35713) == 0) {
            throw new RuntimeException("Error creating shader: " + GL20.glGetShaderInfoLog((int)shaderID, (int)1024));
        }
        return shaderID;
    }

    private String loadResource(String path) throws IOException {
        return new String(Files.readAllBytes(Paths.get(path, new String[0])));
    }

    public void bind() {
        GL20.glUseProgram((int)this.programID);
    }

    public void unbind() {
        GL20.glUseProgram((int)0);
    }

    public void cleanup() {
        GL20.glDetachShader((int)this.programID, (int)this.vertexShaderID);
        GL20.glDetachShader((int)this.programID, (int)this.fragmentShaderID);
        GL20.glDeleteShader((int)this.vertexShaderID);
        GL20.glDeleteShader((int)this.fragmentShaderID);
        GL20.glDeleteProgram((int)this.programID);
    }

    public void setUniform(String name, float value) {
        int location = GL20.glGetUniformLocation((int)this.programID, (CharSequence)name);
        GL20.glUniform1f((int)location, (float)value);
    }

    public void setUniform(String name, float x, float y) {
        int location = GL20.glGetUniformLocation((int)this.programID, (CharSequence)name);
        GL20.glUniform2f((int)location, (float)x, (float)y);
    }
}

