/*
 * Decompiled with CFR 0.152.
 */
package com.pyding.vp.item;

import com.pyding.vp.capability.PlayerCapabilityProviderVP;
import com.pyding.vp.client.sounds.SoundRegistry;
import com.pyding.vp.network.PacketHandler;
import com.pyding.vp.network.packets.ItemAnimationPacket;
import com.pyding.vp.util.VPUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class VipActivator
extends Item {
    long day = 86400000L;
    private static final Map<UUID, BackupData> backups = new HashMap<UUID, BackupData>();

    public VipActivator(Item.Properties p_41383_) {
        super(p_41383_);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand p_41434_) {
        ItemStack stack = player.m_21120_(p_41434_);
        if (stack.m_41784_().m_128403_("VPPlayer") && stack.m_41784_().m_128342_("VPPlayer").compareTo(player.m_20148_()) != 0) {
            player.m_213846_((Component)Component.m_237113_((String)"It's not yours."));
            return super.m_7203_(level, player, p_41434_);
        }
        player.getCapability(PlayerCapabilityProviderVP.playerCap).ifPresent(cap -> {
            cap.setVip(this.day * (long)stack.m_41784_().m_128451_("VPDays") + System.currentTimeMillis());
            cap.sync(player);
        });
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            PacketHandler.sendToClient(new ItemAnimationPacket(stack), serverPlayer);
        }
        stack.m_41620_(1);
        VPUtil.play((LivingEntity)player, SoundEvents.f_12513_);
        VPUtil.play((LivingEntity)player, (SoundEvent)SoundRegistry.SUCCESS.get());
        VPUtil.spawnParticles((Entity)player, (ParticleOptions)ParticleTypes.f_175827_, player.m_20185_(), player.m_20186_(), player.m_20189_(), 8, 0.0, 0.0, 0.0);
        return super.m_7203_(level, player, p_41434_);
    }

    public void m_6883_(ItemStack stack, Level p_41405_, Entity entity, int p_41407_, boolean p_41408_) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (!(stack.m_41784_().m_128471_("VPTrade") || player.m_7500_() || stack.m_41784_().m_128403_("VPPlayer"))) {
                stack.m_41784_().m_128362_("VPPlayer", player.m_20148_());
            }
        }
        super.m_6883_(stack, p_41405_, entity, p_41407_, p_41408_);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> components, TooltipFlag flag) {
        components.add((Component)Component.m_237110_((String)"item.vip.desc1", (Object[])new Object[]{stack.m_41784_().m_128451_("VPDays")}).m_130940_(ChatFormatting.GOLD));
        components.add((Component)Component.m_237115_((String)"item.vip.desc2").m_130940_(ChatFormatting.GOLD));
        if (stack.m_41784_().m_128403_("VPPlayer")) {
            components.add((Component)Component.m_237115_((String)"item.vip.desc3").m_130940_(ChatFormatting.DARK_RED));
        }
        super.m_7373_(stack, level, components, flag);
    }

    public static void saveInventory(Player player) {
        BackupData data = new BackupData();
        data.main = new ArrayList<ItemStack>();
        for (ItemStack stack : player.m_150109_().f_35974_) {
            data.main.add(stack.m_41777_());
        }
        data.armor = new ArrayList<ItemStack>();
        for (ItemStack stack : player.m_150109_().f_35975_) {
            data.armor.add(stack.m_41777_());
        }
        data.offhand = new ArrayList<ItemStack>();
        for (ItemStack stack : player.m_150109_().f_35976_) {
            data.offhand.add(stack.m_41777_());
        }
        backups.put(player.m_20148_(), data);
    }

    public static void loadInventory(Player oldPlayer, Player newPlayer) {
        BackupData data = backups.get(oldPlayer.m_20148_());
        if (data != null) {
            int i;
            newPlayer.m_150109_().f_35974_.clear();
            for (i = 0; i < data.main.size(); ++i) {
                if (i >= newPlayer.m_150109_().f_35974_.size()) continue;
                newPlayer.m_150109_().f_35974_.set(i, (Object)data.main.get(i));
            }
            newPlayer.m_150109_().f_35975_.clear();
            for (i = 0; i < data.armor.size(); ++i) {
                if (i >= newPlayer.m_150109_().f_35975_.size()) continue;
                newPlayer.m_150109_().f_35975_.set(i, (Object)data.armor.get(i));
            }
            newPlayer.m_150109_().f_35976_.clear();
            for (i = 0; i < data.offhand.size(); ++i) {
                if (i >= newPlayer.m_150109_().f_35976_.size()) continue;
                newPlayer.m_150109_().f_35976_.set(i, (Object)data.offhand.get(i));
            }
            backups.remove(oldPlayer.m_20148_());
        }
    }

    public static class BackupData {
        public List<ItemStack> main;
        public List<ItemStack> armor;
        public List<ItemStack> offhand;
    }
}

