/*
 * Decompiled with CFR 0.152.
 */
package com.pyding.vp.item.vestiges;

import com.pyding.vp.client.sounds.SoundRegistry;
import com.pyding.vp.item.vestiges.Vestige;
import com.pyding.vp.network.PacketHandler;
import com.pyding.vp.network.packets.PlayerFlyPacket;
import com.pyding.vp.util.VPUtil;
import java.util.Random;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import top.theillusivec4.curios.api.SlotContext;

public class Anemoculus
extends Vestige {
    @Override
    public void dataInit(int vestigeNumber, ChatFormatting color, int specialCharges, int specialCd, int ultimateCharges, int ultimateCd, int specialMaxTime, int ultimateMaxTime, boolean hasDamage, ItemStack stack) {
        super.dataInit(1, ChatFormatting.DARK_AQUA, 2, 30, 5, 60, 1, 20, hasDamage, stack);
    }

    @Override
    public void doSpecial(long seconds, Player player, Level level, ItemStack stack) {
        if (!this.isUltimateActive(stack)) {
            VPUtil.spawnParticles(player, (ParticleOptions)ParticleTypes.f_123796_, 8.0, 25, 0.0, 0.5, 0.0, 3.0, false);
            for (LivingEntity entity : VPUtil.getEntities(player, 8.0, true)) {
                if (VPUtil.isProtectedFromHit(player, (Entity)entity)) continue;
                VPUtil.liftEntity(entity, VPUtil.commonPower);
            }
        } else {
            Random random = new Random();
            if (random.nextDouble() < 0.5) {
                VPUtil.play((LivingEntity)player, (SoundEvent)SoundRegistry.WIND1.get());
            } else {
                VPUtil.play((LivingEntity)player, (SoundEvent)SoundRegistry.WIND2.get());
            }
            for (LivingEntity entity : VPUtil.getEntities(player, 16.0, false)) {
                VPUtil.suckEntity((Entity)entity, player, 2, true);
            }
            VPUtil.spawnParticles(player, (ParticleOptions)ParticleTypes.f_123796_, 8.0, 1, 0.0, 0.5, 0.0, 3.0, false);
        }
        super.doSpecial(seconds, player, level, stack);
    }

    @Override
    public void doUltimate(long seconds, Player player, Level level, ItemStack stack) {
        VPUtil.play((LivingEntity)player, (SoundEvent)SoundRegistry.WIND3.get());
        player.m_150110_().f_35936_ = true;
        player.m_150110_().f_35935_ = true;
        player.m_6885_();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            PacketHandler.sendToClient(new PlayerFlyPacket(6), serverPlayer);
        }
        VPUtil.spawnParticles(player, (ParticleOptions)ParticleTypes.f_123777_, 3.0, 1, 0.0, 0.1, 0.0, 1.0, false);
        super.doUltimate(seconds, player, level, stack);
    }

    @Override
    public void ultimateEnds(Player player, ItemStack stack) {
        if (player.m_7500_()) {
            return;
        }
        player.m_150110_().f_35936_ = false;
        player.m_150110_().f_35935_ = false;
        player.m_6885_();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            PacketHandler.sendToClient(new PlayerFlyPacket(2), serverPlayer);
        }
        player.m_7292_(new MobEffectInstance(MobEffects.f_19591_, 140));
        super.ultimateEnds(player, stack);
    }

    @Override
    public void curioTick(SlotContext slotContext, ItemStack stack) {
        Player player = (Player)slotContext.entity();
        super.curioTick(slotContext, stack);
    }
}

