/*
 * Decompiled with CFR 0.152.
 */
package com.pyding.vp.item.vestiges;

import com.pyding.vp.capability.PlayerCapabilityProviderVP;
import com.pyding.vp.client.sounds.SoundRegistry;
import com.pyding.vp.item.vestiges.Vestige;
import com.pyding.vp.util.ConfigHandler;
import com.pyding.vp.util.VPUtil;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.EnderEyeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class Anomaly
extends Vestige {
    @Override
    public void dataInit(int vestigeNumber, ChatFormatting color, int specialCharges, int specialCd, int ultimateCharges, int ultimateCd, int specialMaxTime, int ultimateMaxTime, boolean hasDamage, ItemStack stack) {
        super.dataInit(10, ChatFormatting.LIGHT_PURPLE, 2, 60, 1, 360, 30, 1, true, stack);
    }

    @Override
    public void doSpecial(long seconds, Player player, Level level, ItemStack stack) {
        VPUtil.play((LivingEntity)player, (SoundEvent)SoundRegistry.TELEPORT1.get());
        if (player.m_21205_().m_41720_() instanceof EnderEyeItem) {
            this.fuckNbt();
            ItemStack stackInSlot = VPUtil.getVestigeStack(this, player);
            stackInSlot.m_41784_().m_128347_("VPReturnX", player.m_20185_());
            stackInSlot.m_41784_().m_128347_("VPReturnY", player.m_20186_());
            stackInSlot.m_41784_().m_128347_("VPReturnZ", player.m_20189_());
            stackInSlot.m_41784_().m_128359_("VPReturnKey", player.m_20193_().m_46472_().m_135782_().m_135815_());
            stackInSlot.m_41784_().m_128359_("VPReturnDir", player.m_20193_().m_46472_().m_135782_().m_135827_());
        } else {
            for (LivingEntity entity : VPUtil.ray(player, 3.0f, 60, true)) {
                if (!(player instanceof ServerPlayer)) continue;
                ServerPlayer serverPlayer = (ServerPlayer)player;
                serverPlayer.m_6021_(entity.m_20185_() - 1.0, entity.m_20186_(), entity.m_20189_() - 1.0);
                VPUtil.dealDamage(entity, player, player.m_269291_().m_269254_(), 400.0f, 2);
                VPUtil.antiTp(entity, seconds);
            }
        }
        VPUtil.spawnParticles(player, (ParticleOptions)ParticleTypes.f_123760_, 3.0, 1, 0.0, -0.1, 0.0, 1.0, false);
        super.doSpecial(seconds, player, level, stack);
    }

    @Override
    public void doUltimate(long seconds, Player player, Level level, ItemStack stack) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            serverPlayer.getCapability(PlayerCapabilityProviderVP.playerCap).ifPresent(cap -> {
                Random random = new Random();
                if (this.isStellar(stack) && random.nextDouble() < VPUtil.getChance(0.05, player)) {
                    int counter = 0;
                    for (ServerPlayer victim : serverPlayer.m_20193_().m_7654_().m_6846_().m_11314_()) {
                        if (victim == serverPlayer) continue;
                        ++counter;
                        serverPlayer.m_8999_((ServerLevel)victim.m_20193_(), victim.m_20185_(), victim.m_20186_(), victim.m_20189_(), 0.0f, 0.0f);
                        break;
                    }
                    if (counter <= 1) {
                        player.m_213846_((Component)Component.m_237113_((String)"There are no other players!"));
                    }
                    VPUtil.play((LivingEntity)player, (SoundEvent)SoundRegistry.TELEPORT2.get());
                } else {
                    double z;
                    double x;
                    double borderZ;
                    double borderX;
                    ArrayList<String> list = new ArrayList<String>(cap.getRandomDimension());
                    if (list.isEmpty()) {
                        player.m_213846_((Component)Component.m_237113_((String)"Somehow world list is empty?!?!?!?!?!?!"));
                        return;
                    }
                    String key = (String)list.get(0);
                    String path = (String)list.get(1);
                    ServerLevel serverLevel = serverPlayer.m_20193_().m_7654_().m_129880_(VPUtil.getWorldKey(path, key));
                    if (serverLevel == null) {
                        serverLevel = serverPlayer.m_20193_().m_7654_().m_129880_(Level.f_46428_);
                    }
                    if ((Integer)ConfigHandler.COMMON.anomalyBorder.get() == 0) {
                        borderX = level.m_6857_().m_61957_();
                        borderZ = random.nextInt((int)level.m_6857_().m_61958_());
                    } else {
                        borderZ = borderX = (double)((Integer)ConfigHandler.COMMON.anomalyBorder.get()).intValue();
                    }
                    if (random.nextDouble() < 0.5) {
                        x = random.nextInt((int)borderX);
                    } else {
                        x = random.nextInt((int)borderX);
                        x *= -1.0;
                    }
                    if (random.nextDouble() < 0.5) {
                        z = borderZ;
                    } else {
                        z = random.nextInt((int)borderZ);
                        z *= -1.0;
                    }
                    double y = random.nextInt(220);
                    serverPlayer.m_7292_(new MobEffectInstance(MobEffects.f_19591_, 100));
                    serverPlayer.m_8999_(serverLevel, x, y, z, 0.0f, 0.0f);
                    VPUtil.teleportRandomly((Entity)serverPlayer, 50);
                    VPUtil.spawnParticles(player, (ParticleOptions)ParticleTypes.f_123760_, 8.0, 1, 0.0, -0.1, 0.0, 1.0, false);
                    VPUtil.play((LivingEntity)player, (SoundEvent)SoundRegistry.TELEPORT2.get());
                }
            });
        }
        super.doUltimate(seconds, player, level, stack);
    }
}

