/*
 * Decompiled with CFR 0.152.
 */
package com.pyding.vp.item.vestiges;

import com.pyding.vp.client.sounds.SoundRegistry;
import com.pyding.vp.item.vestiges.Vestige;
import com.pyding.vp.util.ConfigHandler;
import com.pyding.vp.util.VPUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import top.theillusivec4.curios.api.SlotContext;

public class Flower
extends Vestige {
    @Override
    public void dataInit(int vestigeNumber, ChatFormatting color, int specialCharges, int specialCd, int ultimateCharges, int ultimateCd, int specialMaxTime, int ultimateMaxTime, boolean hasDamage, ItemStack stack) {
        super.dataInit(16, ChatFormatting.DARK_GREEN, 2, 10, 1, 30, 5, 30, hasDamage, stack);
    }

    @Override
    public void curioTick(SlotContext slotContext, ItemStack stack) {
        Player player = (Player)slotContext.entity();
        float healRes = 0.0f;
        for (LivingEntity entity : VPUtil.getCreaturesAndPlayersAround(player, 30.0, 30.0, 30.0)) {
            healRes += VPUtil.missingHealth(entity) / 10.0f;
            if (!this.isStellar(stack)) continue;
            entity.getPersistentData().m_128356_("VPFlowerStellar", System.currentTimeMillis() + 1000L);
        }
        player.getPersistentData().m_128350_("VPHealResFlower", -healRes);
        player.getPersistentData().m_128350_("VPShieldBonusFlower", healRes * 10.0f);
        if (this.isStellar(stack)) {
            player.getPersistentData().m_128356_("VPFlowerStellar", System.currentTimeMillis() + 1000L);
        }
        super.curioTick(slotContext, stack);
    }

    @Override
    public void doSpecial(long seconds, Player player, Level level, ItemStack stack) {
        VPUtil.play((LivingEntity)player, (SoundEvent)SoundRegistry.HEAL2.get());
        player.getPersistentData().m_128356_("VPFlowerSpecial", System.currentTimeMillis() + seconds);
        super.doSpecial(seconds, player, level, stack);
    }

    @Override
    public void doUltimate(long seconds, Player player, Level level, ItemStack stack) {
        VPUtil.play((LivingEntity)player, (SoundEvent)SoundRegistry.MAGIC2.get());
        float damage = 0.0f;
        for (ItemStack stack2 : VPUtil.getAllEquipment((LivingEntity)player)) {
            if (!stack2.m_41768_()) continue;
            damage += (float)stack2.m_41773_();
        }
        damage = (float)((double)damage * (Double)ConfigHandler.COMMON.flowerShield.get());
        for (LivingEntity entity : VPUtil.getCreaturesAndPlayersAround(player, 30.0, 30.0, 30.0)) {
            VPUtil.addShield(entity, damage, false);
            VPUtil.spawnParticles((Entity)player, (ParticleOptions)ParticleTypes.f_123780_, entity.m_20185_(), entity.m_20186_() + 2.0, entity.m_20189_(), 8, 0.0, 0.5, 0.0);
        }
        super.doUltimate(seconds, player, level, stack);
    }
}

