/*
 * Decompiled with CFR 0.152.
 */
package com.pyding.vp.item.vestiges;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.pyding.vp.client.sounds.SoundRegistry;
import com.pyding.vp.item.vestiges.Vestige;
import com.pyding.vp.util.ConfigHandler;
import com.pyding.vp.util.VPUtil;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import top.theillusivec4.curios.api.SlotContext;

public class MaskOfDemon
extends Vestige {
    @Override
    public void dataInit(int vestigeNumber, ChatFormatting color, int specialCharges, int specialCd, int ultimateCharges, int ultimateCd, int specialMaxTime, int ultimateMaxTime, boolean hasDamage, ItemStack stack) {
        vestigeNumber = 5;
        color = ChatFormatting.BLUE;
        specialCharges = 1;
        specialCd = 1;
        specialMaxTime = 666;
        ultimateMaxTime = 1;
        ultimateCharges = 1;
        ultimateCd = 60;
        super.dataInit(vestigeNumber, color, specialCharges, specialCd, ultimateCharges, ultimateCd, specialMaxTime, ultimateMaxTime, true, stack);
    }

    private Multimap<Attribute, AttributeModifier> createAttributeMap(Player player, ItemStack stack) {
        HashMultimap attributesDefault = HashMultimap.create();
        double attackMultiplier = 4.0;
        double speedMultiplier = 1.0;
        if (this.isStellar(stack)) {
            attackMultiplier *= 1.5;
            speedMultiplier *= 1.5;
        }
        float missingHealth = VPUtil.missingHealth((LivingEntity)player);
        if (this.isStellar(stack)) {
            missingHealth *= 2.0f;
        }
        float attackScale = (float)((double)missingHealth * attackMultiplier + 1.0) / 100.0f;
        float speedScale = (float)((double)missingHealth * speedMultiplier + 1.0) / 100.0f;
        attributesDefault.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(UUID.fromString("ec62548c-5b26-401e-83fd-693e4aafa532"), "vp:attack_speed_modifier", (double)attackScale, AttributeModifier.Operation.MULTIPLY_TOTAL));
        attributesDefault.put((Object)Attributes.f_22279_, (Object)new AttributeModifier(UUID.fromString("f4ece564-d2c0-40d2-a96a-dc68b493137c"), "vp:speed_modifier", (double)speedScale, AttributeModifier.Operation.MULTIPLY_BASE));
        return attributesDefault;
    }

    @Override
    public void curioTick(SlotContext slotContext, ItemStack stack) {
        Player player = (Player)slotContext.entity();
        if (player.m_20193_().f_46443_) {
            return;
        }
        if (this.isSpecialActive(stack)) {
            boolean hurt = false;
            if (player.f_19797_ % 20 == 0) {
                if (player.getPersistentData().m_128457_("VPHealDebt") > player.m_21233_() * (float)((Integer)ConfigHandler.COMMON.maskRotAmount.get()).intValue() / 100.0f + 1.0f) {
                    player.getPersistentData().m_128350_("VPHealDebt", Math.max(0.0f, player.getPersistentData().m_128457_("VPHealDebt") - player.m_21233_() * (float)((Integer)ConfigHandler.COMMON.maskRotAmount.get()).intValue() / 100.0f + 1.0f));
                    hurt = true;
                } else if (player.m_21223_() > player.m_21233_() * (float)((Integer)ConfigHandler.COMMON.maskRotAmount.get()).intValue() / 100.0f + 1.0f) {
                    VPUtil.dealParagonDamage((LivingEntity)player, player, player.m_21233_() * (float)((Integer)ConfigHandler.COMMON.maskRotAmount.get()).intValue() / 100.0f, 0, false);
                    hurt = true;
                }
                player.m_21204_().m_22178_(this.createAttributeMap(player, stack));
            }
            for (LivingEntity entity : VPUtil.getEntities(player, 30.0, false)) {
                if (VPUtil.isProtectedFromHit(player, (Entity)entity) || VPUtil.isFriendlyFireBetween((Entity)entity, (Entity)player)) continue;
                CompoundTag tag = entity.getPersistentData();
                if (tag == null) {
                    tag = new CompoundTag();
                }
                float missingHealth = VPUtil.missingHealth((LivingEntity)player);
                if (this.isStellar(stack)) {
                    missingHealth *= 2.0f;
                }
                tag.m_128350_("VPHealResMask", 0.0f - missingHealth);
                if (this.isStellar(stack)) {
                    tag.m_128379_("MaskStellar", true);
                }
                if (hurt && this.isStellar(stack) && (double)player.m_21223_() <= (double)player.m_21233_() * 0.5) {
                    VPUtil.dealParagonDamage(entity, player, player.m_21233_() * (float)((Integer)ConfigHandler.COMMON.maskRotAmount.get()).intValue() / 100.0f, 1, false);
                    VPUtil.spawnParticles((Entity)player, (ParticleOptions)ParticleTypes.f_123798_, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), 1, 0.0, 0.1, 0.0);
                }
                entity.getPersistentData().m_128391_(tag);
            }
            player.getPersistentData().m_128350_("VPHealResMask", 0.0f - VPUtil.missingHealth((LivingEntity)player));
        } else {
            player.m_21204_().m_22161_(this.createAttributeMap(player, stack));
        }
        super.curioTick(slotContext, stack);
    }

    @Override
    public int setSpecialActive(long seconds, Player player, ItemStack stack) {
        if (this.isSpecialActive(stack) && !player.m_20193_().f_46443_) {
            this.setTime(1L, stack);
            return 0;
        }
        return super.setSpecialActive(seconds, player, stack);
    }

    @Override
    public void doSpecial(long seconds, Player player, Level level, ItemStack stack) {
        VPUtil.play((LivingEntity)player, (SoundEvent)SoundRegistry.STOLAS1.get());
        VPUtil.spawnParticles(player, (ParticleOptions)ParticleTypes.f_123808_, 8.0, 1, 0.0, -0.1, 0.0, 1.0, false);
        super.doSpecial(seconds, player, level, stack);
    }

    @Override
    public void doUltimate(long seconds, Player player, Level level, ItemStack stack) {
        VPUtil.play((LivingEntity)player, (SoundEvent)SoundRegistry.IMPACT.get());
        float damage = 300.0f;
        float VPHealDebt = player.m_21233_() * 3.0f;
        if ((double)player.m_21223_() <= (double)player.m_21233_() * 0.5) {
            damage *= 2.0f;
            VPHealDebt *= 2.0f;
        }
        player.getPersistentData().m_128350_("VPHealDebt", player.getPersistentData().m_128457_("VPHealDebt") + VPHealDebt);
        for (LivingEntity entity : VPUtil.ray(player, 8.0f, 60, false)) {
            entity.getPersistentData().m_128350_("VPHealDebt", entity.getPersistentData().m_128457_("VPHealDebt") + VPHealDebt);
            VPUtil.dealDamage(entity, player, player.m_269291_().m_269285_((Entity)player), damage, 3);
            VPUtil.spawnParticles((Entity)player, (ParticleOptions)ParticleTypes.f_235902_, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), 1, 0.0, -0.1, 0.0);
        }
        super.doUltimate(seconds, player, level, stack);
    }
}

