/*
 * Decompiled with CFR 0.152.
 */
package com.pyding.vp.item.vestiges;

import com.pyding.vp.client.sounds.SoundRegistry;
import com.pyding.vp.item.vestiges.Vestige;
import com.pyding.vp.util.VPUtil;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class Rune
extends Vestige {
    @Override
    public void dataInit(int vestigeNumber, ChatFormatting color, int specialCharges, int specialCd, int ultimateCharges, int ultimateCd, int specialMaxTime, int ultimateMaxTime, boolean hasDamage, ItemStack stack) {
        super.dataInit(21, ChatFormatting.DARK_PURPLE, 1, 30, 1, 160, 10, 40, false, stack);
    }

    @Override
    public void doSpecial(long seconds, Player player, Level level, ItemStack stack) {
        VPUtil.play((LivingEntity)player, (SoundEvent)SoundRegistry.RUNE1.get());
        VPUtil.spawnParticles(player, (ParticleOptions)ParticleTypes.f_175834_, 5.0, 30, 0.1, 0.1, 0.1, 0.5, false);
        float bonus = 0.0f;
        if (player.m_21204_().m_22171_(Attributes.f_22278_)) {
            bonus += (float)player.m_21051_(Attributes.f_22278_).m_22135_();
        }
        bonus += VPUtil.equipmentDurability(20.0f, (LivingEntity)player, player, false);
        if (this.isUltimateActive(stack)) {
            bonus /= 2.0f;
        }
        player.getPersistentData().m_128350_("VPRuneBonus", bonus / 10.0f);
        super.doSpecial(seconds, player, level, stack);
    }

    @Override
    public void doUltimate(long seconds, Player player, Level level, ItemStack stack) {
        VPUtil.play((LivingEntity)player, (SoundEvent)SoundRegistry.RUNE2.get());
        for (LivingEntity entity : VPUtil.getEntitiesAround(player, 20.0, 20.0, 20.0, true)) {
            VPUtil.spawnSphere((Entity)entity, ParticleTypes.f_123744_, 30, 5.0f, 1.0f);
            entity.getPersistentData().m_128356_("VPRuneUlt", seconds);
            entity.m_21204_().m_22178_(VPUtil.createAttributeMap(entity, Attributes.f_22284_, UUID.fromString("4cfa176b-4d5b-43bf-bd9b-9d717ffd7689"), 20.0f * (1.0f + VPUtil.getShieldBonus(entity)), AttributeModifier.Operation.ADDITION, "vp:rune"));
            entity.m_21204_().m_22178_(VPUtil.createAttributeMap(entity, Attributes.f_22285_, UUID.fromString("16c73772-b469-4600-ae01-946807a719f7"), 20.0f * (1.0f + VPUtil.getShieldBonus(entity)), AttributeModifier.Operation.ADDITION, "vp:rune2"));
        }
        super.doUltimate(seconds, player, level, stack);
    }

    @Override
    public void ultimateEnds(Player player, ItemStack stack) {
        player.m_21204_().m_22161_(VPUtil.createAttributeMap((LivingEntity)player, Attributes.f_22284_, UUID.fromString("4cfa176b-4d5b-43bf-bd9b-9d717ffd7689"), 20.0f * (1.0f + VPUtil.getShieldBonus((LivingEntity)player)), AttributeModifier.Operation.ADDITION, "vp:rune"));
        player.m_21204_().m_22161_(VPUtil.createAttributeMap((LivingEntity)player, Attributes.f_22285_, UUID.fromString("16c73772-b469-4600-ae01-946807a719f7"), 20.0f * (1.0f + VPUtil.getShieldBonus((LivingEntity)player)), AttributeModifier.Operation.ADDITION, "vp:rune2"));
        super.ultimateEnds(player, stack);
    }

    @Override
    public void specialEnds(Player player, ItemStack stack) {
        player.getPersistentData().m_128350_("VPRuneBonus", 0.0f);
        super.specialEnds(player, stack);
    }

    @Override
    public void curioSucks(Player player, ItemStack stack) {
        player.getPersistentData().m_128350_("VPRuneBonus", 0.0f);
        player.m_21204_().m_22161_(VPUtil.createAttributeMap((LivingEntity)player, Attributes.f_22284_, UUID.fromString("4cfa176b-4d5b-43bf-bd9b-9d717ffd7689"), 20.0f * (1.0f + VPUtil.getShieldBonus((LivingEntity)player)), AttributeModifier.Operation.ADDITION, "vp:rune"));
        player.m_21204_().m_22161_(VPUtil.createAttributeMap((LivingEntity)player, Attributes.f_22285_, UUID.fromString("16c73772-b469-4600-ae01-946807a719f7"), 20.0f * (1.0f + VPUtil.getShieldBonus((LivingEntity)player)), AttributeModifier.Operation.ADDITION, "vp:rune2"));
        super.curioSucks(player, stack);
    }
}

