/*
 * Decompiled with CFR 0.152.
 */
package com.pyding.vp.item.vestiges;

import com.pyding.vp.client.sounds.SoundRegistry;
import com.pyding.vp.item.vestiges.Vestige;
import com.pyding.vp.network.PacketHandler;
import com.pyding.vp.network.packets.PlayerFlyPacket;
import com.pyding.vp.util.ConfigHandler;
import com.pyding.vp.util.VPUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import top.theillusivec4.curios.api.SlotContext;

public class SweetDonut
extends Vestige {
    @Override
    public void dataInit(int vestigeNumber, ChatFormatting color, int specialCharges, int specialCd, int ultimateCharges, int ultimateCd, int specialMaxTime, int ultimateMaxTime, boolean hasDamage, ItemStack stack) {
        super.dataInit(6, ChatFormatting.RED, 2, 50, 1, 60, 1, 10, hasDamage, stack);
    }

    @Override
    public void doSpecial(long seconds, Player player, Level level, ItemStack stack) {
        VPUtil.play((LivingEntity)player, (SoundEvent)SoundRegistry.HEAL3.get());
        VPUtil.spawnParticles(player, (ParticleOptions)ParticleTypes.f_123750_, 1.0, 1, 0.0, -0.1, 0.0, 1.0, false);
        player.m_5634_(player.m_21233_() * 0.4f);
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            VPUtil.clearEffects((LivingEntity)serverPlayer, false);
            if ((double)serverPlayer.m_21223_() <= (double)serverPlayer.m_21233_() * 0.5) {
                serverPlayer.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 400, 4));
                PacketHandler.sendToClient(new PlayerFlyPacket(4), serverPlayer);
            }
        }
        float shieldBonus = player.getPersistentData().m_128457_("VPShieldBonusDonut");
        if (VPUtil.getShield((LivingEntity)player) < player.m_21233_() * 3.0f * (1.0f + shieldBonus / 100.0f)) {
            VPUtil.addShield((LivingEntity)player, player.m_21233_() * 3.0f, false);
        }
        super.doSpecial(seconds, player, level, stack);
    }

    @Override
    public void doUltimate(long seconds, Player player, Level level, ItemStack stack) {
        VPUtil.play((LivingEntity)player, (SoundEvent)SoundRegistry.HEAL1.get());
        player.getPersistentData().m_128379_("VPSweetUlt", true);
        if (this.isStellar(stack)) {
            player.getPersistentData().m_128350_("VPHealDebt", 0.0f);
        }
        super.doUltimate(seconds, player, level, stack);
    }

    @Override
    public void curioTick(SlotContext slotContext, ItemStack stack) {
        Player player = (Player)slotContext.entity();
        float bonus = ((Integer)ConfigHandler.COMMON.donutHealBonus.get()).intValue();
        if ((double)player.m_21223_() <= (double)player.m_21233_() * 0.5) {
            bonus *= 2.0f;
        }
        player.getPersistentData().m_128350_("VPHealBonusDonutPassive", bonus);
        if (this.isStellar(stack) && VPUtil.getShield((LivingEntity)player) > 0.0f) {
            VPUtil.clearEffects((LivingEntity)player, false);
        }
        super.curioTick(slotContext, stack);
    }

    @Override
    public void whileUltimate(Player player, ItemStack stack) {
        if (VPUtil.getShield((LivingEntity)player) > 0.0f) {
            if (player.f_19797_ % 20 == 0) {
                VPUtil.spawnParticles(player, (ParticleOptions)ParticleTypes.f_123750_, 1.0, 1, 0.0, -0.1, 0.0, 1.0, false);
            }
            float saturation = player.getPersistentData().m_128457_("VPSaturation");
            player.getPersistentData().m_128350_("VPHealBonusDonut", saturation / 10.0f);
            player.getPersistentData().m_128350_("VPShieldBonusDonut", saturation);
            player.getPersistentData().m_128350_("VPDurationBonusDonut", saturation / 10.0f);
        }
        super.whileUltimate(player, stack);
    }

    @Override
    public void ultimateRecharges(Player player, ItemStack stack) {
        this.reset(player);
        super.ultimateRecharges(player, stack);
    }

    public void reset(Player player) {
        player.getPersistentData().m_128379_("VPSweetUlt", false);
        player.getPersistentData().m_128350_("VPSaturation", 0.0f);
        player.getPersistentData().m_128350_("VPHealBonusDonut", 0.0f);
        player.getPersistentData().m_128350_("VPShieldBonusDonut", 0.0f);
        player.getPersistentData().m_128350_("VPHealBonusDonutPassive", 0.0f);
    }
}

