/*
 * Decompiled with CFR 0.152.
 */
package com.pyding.vp.item.vestiges;

import com.pyding.vp.capability.PlayerCapabilityProviderVP;
import com.pyding.vp.capability.PlayerCapabilityVP;
import com.pyding.vp.item.ModItems;
import com.pyding.vp.mixin.BucketMixin;
import com.pyding.vp.network.PacketHandler;
import com.pyding.vp.network.packets.ItemAnimationPacket;
import com.pyding.vp.util.ConfigHandler;
import com.pyding.vp.util.KeyBinding;
import com.pyding.vp.util.VPUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MobBucketItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurio;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

public class Vestige
extends Item
implements ICurioItem {
    public static int maxCurses = 5;
    public Boolean damageType;
    public int ultimateChargesBase;
    public int specialChargesBase;
    public long ultimateDurationBase;
    public long specialDurationBase;
    public int specialCdBase;
    public int ultimateCdBase;
    public int vestigeNumber;
    public ChatFormatting color;
    public float specialTimeBonus = 1.0f;
    public float ultimateTimeBonus = 1.0f;
    public String originalText;

    public Vestige() {
        super(new Item.Properties().m_41487_(1));
    }

    public Vestige(Item.Properties properties) {
        super(properties);
    }

    public int specialCharges(ItemStack stack) {
        return stack.m_41784_().m_128451_("VPSpecialCharges");
    }

    public void setSpecialCharges(int number, ItemStack stack) {
        stack.m_41784_().m_128405_("VPSpecialCharges", number);
    }

    public int ultimateCharges(ItemStack stack) {
        return stack.m_41784_().m_128451_("VPUltimateCharges");
    }

    public void setUltimateCharges(int number, ItemStack stack) {
        stack.m_41784_().m_128405_("VPUltimateCharges", number);
    }

    public int specialCd(ItemStack stack) {
        return stack.m_41784_().m_128451_("VPSpecialCd");
    }

    public void setSpecialCd(int number, ItemStack stack) {
        stack.m_41784_().m_128405_("VPSpecialCd", number);
    }

    public int ultimateCd(ItemStack stack) {
        return stack.m_41784_().m_128451_("VPUltimateCd");
    }

    public void setUltimateCd(int number, ItemStack stack) {
        stack.m_41784_().m_128405_("VPUltimateCd", number);
    }

    public int cdSpecialActive(ItemStack stack) {
        return stack.m_41784_().m_128451_("VPCdSpecialActive");
    }

    public void setCdSpecialActive(int number, ItemStack stack) {
        stack.m_41784_().m_128405_("VPCdSpecialActive", number);
    }

    public int cdUltimateActive(ItemStack stack) {
        return stack.m_41784_().m_128451_("VPCdUltimateActive");
    }

    public void setCdUltimateActive(int number, ItemStack stack) {
        stack.m_41784_().m_128405_("VPCdUltimateActive", number);
    }

    public int specialBonusModifier(ItemStack stack) {
        return stack.m_41784_().m_128451_("VPSpecialBonusModifier");
    }

    public void setSpecialBonusModifier(int number, ItemStack stack) {
        stack.m_41784_().m_128405_("VPSpecialBonusModifier", number);
    }

    public int ultimateBonusModifier(ItemStack stack) {
        return stack.m_41784_().m_128451_("VPUltimateBonusModifier");
    }

    public void setUltimateBonusModifier(int number, ItemStack stack) {
        stack.m_41784_().m_128405_("VPUltimateBonusModifier", number);
    }

    public int currentChargeSpecial(ItemStack stack) {
        return stack.m_41784_().m_128451_("VPCurrentChargeSpecial");
    }

    public void setCurrentChargeSpecial(int number, ItemStack stack) {
        stack.m_41784_().m_128405_("VPCurrentChargeSpecial", number);
    }

    public int currentChargeUltimate(ItemStack stack) {
        return stack.m_41784_().m_128451_("VPCurrentChargeUltimate");
    }

    public void setCurrentChargeUltimate(int number, ItemStack stack) {
        stack.m_41784_().m_128405_("VPCurrentChargeUltimate", number);
    }

    public int ultimateChargesBase(ItemStack stack) {
        return stack.m_41784_().m_128451_("VPUltimateChargesBase");
    }

    public void setUltimateChargesBase(int number, ItemStack stack) {
        stack.m_41784_().m_128405_("VPUltimateChargesBase", number);
    }

    public int specialChargesBase(ItemStack stack) {
        return stack.m_41784_().m_128451_("VPSpecialChargesBase");
    }

    public void setSpecialChargesBase(int number, ItemStack stack) {
        stack.m_41784_().m_128405_("VPSpecialChargesBase", number);
    }

    public long ultimateDurationBase(ItemStack stack) {
        return stack.m_41784_().m_128454_("VPUltimateDurationBase");
    }

    public void setUltimateDurationBase(long number, ItemStack stack) {
        stack.m_41784_().m_128356_("VPUltimateDurationBase", number);
    }

    public long specialDurationBase(ItemStack stack) {
        return stack.m_41784_().m_128454_("VPSpecialDurationBase");
    }

    public void setSpecialDurationBase(long number, ItemStack stack) {
        stack.m_41784_().m_128356_("VPSpecialDurationBase", number);
    }

    public int specialCdBase(ItemStack stack) {
        return stack.m_41784_().m_128451_("VPSpecialCdBase");
    }

    public void setSpecialCdBase(int number, ItemStack stack) {
        stack.m_41784_().m_128405_("VPSpecialCdBase", number);
    }

    public int ultimateCdBase(ItemStack stack) {
        return stack.m_41784_().m_128451_("VPUltimateCdBase");
    }

    public void setUltimateCdBase(int number, ItemStack stack) {
        stack.m_41784_().m_128405_("VPUltimateCdBase", number);
    }

    public void dataInit(int vestigeNumber, ChatFormatting color, int specialCharges, int specialCd, int ultimateCharges, int ultimateCd, int specialMaxTime, int ultimateMaxTime, boolean hasDamage, ItemStack stack) {
        this.setUltimateChargesBase(ultimateCharges, stack);
        this.setSpecialChargesBase(specialCharges, stack);
        this.setUltimateCharges(ultimateCharges, stack);
        this.setUltimateCdBase(ultimateCd * 20, stack);
        this.setUltimateCd(ultimateCd * 20, stack);
        this.setSpecialCharges(specialCharges, stack);
        this.setSpecialCdBase(specialCd * 20, stack);
        this.setSpecialCd(specialCd * 20, stack);
        this.damageType = hasDamage;
        this.vestigeNumber = vestigeNumber;
        this.setVestigeNumber(vestigeNumber, stack);
        this.color = color;
        this.setSpecialMaxTime((long)specialMaxTime * 1000L, stack);
        this.setSpecialDurationBase((long)specialMaxTime * 1000L, stack);
        this.setUltimateMaxTime((long)ultimateMaxTime * 1000L, stack);
        this.setUltimateDurationBase((long)ultimateMaxTime * 1000L, stack);
        this.ultimateChargesBase = ultimateCharges;
        this.specialChargesBase = specialCharges;
        this.ultimateCdBase = ultimateCd * 20;
        this.specialCdBase = specialCd * 20;
        this.specialDurationBase = (long)specialMaxTime * 1000L;
        this.ultimateDurationBase = (long)ultimateMaxTime * 1000L;
    }

    public int getVestigeNumber(ItemStack stack) {
        return stack.m_41784_().m_128451_("VPVestigeNumber");
    }

    public void setVestigeNumber(int number, ItemStack stack) {
        stack.m_41784_().m_128405_("VPVestigeNumber", number);
    }

    public static void setStellar(ItemStack stack) {
        stack.m_41784_().m_128379_("Stellar", true);
    }

    public static void setDoubleStellar(ItemStack stack) {
        stack.m_41784_().m_128379_("DoubleStellar", true);
    }

    public boolean isStellar(ItemStack stack) {
        return stack.m_41784_().m_128471_("Stellar");
    }

    public boolean isDoubleStellar(ItemStack stack) {
        return stack.m_41784_().m_128471_("DoubleStellar");
    }

    public void init(ItemStack stack) {
        this.dataInit(0, null, 0, 0, 0, 0, 0, 0, false, stack);
    }

    public boolean isSpecialActive(ItemStack stack) {
        return stack.m_41784_().m_128471_("VPSpecialActive");
    }

    public void setSpecialActive(boolean state, ItemStack stack) {
        stack.m_41784_().m_128379_("VPSpecialActive", state);
    }

    public boolean isUltimateActive(ItemStack stack) {
        return stack.m_41784_().m_128471_("VPUltimateActive");
    }

    public void setUltimateActive(boolean state, ItemStack stack) {
        stack.m_41784_().m_128379_("VPUltimateActive", state);
    }

    public long time(ItemStack stack) {
        return stack.m_41784_().m_128454_("VPTime");
    }

    public void setTime(long time, ItemStack stack) {
        stack.m_41784_().m_128356_("VPTime", time);
    }

    public long timeUlt(ItemStack stack) {
        return stack.m_41784_().m_128454_("VPTimeUlt");
    }

    public void setTimeUlt(long time, ItemStack stack) {
        stack.m_41784_().m_128356_("VPTimeUlt", time);
    }

    public long specialMaxTime(ItemStack stack) {
        return stack.m_41784_().m_128454_("VPSpecialMaxTime");
    }

    public void setSpecialMaxTime(long time, ItemStack stack) {
        stack.m_41784_().m_128356_("VPSpecialMaxTime", time);
    }

    public long ultimateMaxTime(ItemStack stack) {
        return stack.m_41784_().m_128454_("VPUltimateMaxTime");
    }

    public void setUltimateMaxTime(long time, ItemStack stack) {
        stack.m_41784_().m_128356_("VPUltimateMaxTime", time);
    }

    public int setSpecialActive(long seconds, Player player, ItemStack stack) {
        if (player.getPersistentData().m_128454_("VPForbidden") > System.currentTimeMillis()) {
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                PacketHandler.sendToClient(new ItemAnimationPacket(new ItemStack((ItemLike)Blocks.f_50375_)), serverPlayer);
            }
            return 0;
        }
        if (this.currentChargeSpecial(stack) > 0) {
            if (!player.m_20193_().f_46443_) {
                this.setTime(System.currentTimeMillis() + seconds, stack);
                this.setSpecialActive(true, stack);
                this.setCdSpecialActive(this.cdSpecialActive(stack) + this.specialCd(stack), stack);
                Random random = new Random();
                if (VPUtil.getSet(player) != 3 || !(random.nextDouble() < VPUtil.getChance(0.3, player)) || VPUtil.getSet(player) != 6 || !(random.nextDouble() < VPUtil.getChance(0.5, player)) || random.nextDouble() < VPUtil.getChance(player.getPersistentData().m_128457_("VPDepth") / 10.0f, player)) {
                    this.setCurrentChargeSpecial(this.currentChargeSpecial(stack) - 1, stack);
                }
                if (this.damageType == null) {
                    this.init(stack);
                }
                if (this.damageType.booleanValue()) {
                    player.getPersistentData().m_128379_("VPAttacked", true);
                }
                this.doSpecial(seconds, player, player.m_20193_(), stack);
                if (VPUtil.hasCurse(player, 3)) {
                    player.getPersistentData().m_128356_("VPForbidden", System.currentTimeMillis() + 3000L);
                }
            } else {
                this.localSpecial(player);
            }
        }
        return 0;
    }

    public int setUltimateActive(long seconds, Player player, ItemStack stack) {
        if (player.getPersistentData().m_128454_("VPForbidden") > System.currentTimeMillis()) {
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                PacketHandler.sendToClient(new ItemAnimationPacket(new ItemStack((ItemLike)Blocks.f_50375_)), serverPlayer);
            }
            return 0;
        }
        if (this.currentChargeUltimate(stack) > 0) {
            if (!player.m_20193_().f_46443_) {
                this.setTimeUlt(System.currentTimeMillis() + seconds, stack);
                this.setUltimateActive(true, stack);
                this.setCdUltimateActive(this.cdUltimateActive(stack) + this.ultimateCd(stack), stack);
                Random random = new Random();
                if (VPUtil.getSet(player) != 3 || !(random.nextDouble() < VPUtil.getChance(0.3, player)) || VPUtil.getSet(player) != 6 || !(random.nextDouble() < VPUtil.getChance(0.5, player)) || random.nextDouble() < VPUtil.getChance(player.getPersistentData().m_128457_("VPDepth") / 10.0f, player)) {
                    this.setCurrentChargeUltimate(this.currentChargeUltimate(stack) - 1, stack);
                }
                long bonus = 1L + (long)player.getPersistentData().m_128457_("VPDurationBonusDonut") / 1000L;
                if (this.damageType == null) {
                    this.init(stack);
                }
                if (this.damageType.booleanValue()) {
                    player.getPersistentData().m_128379_("VPAttacked", true);
                }
                this.doUltimate(seconds * bonus, player, player.m_20193_(), stack);
            } else {
                this.localSpecial(player);
            }
        }
        return 0;
    }

    public void applyBonus(ItemStack stack, Player player) {
        int specialBonus = 0;
        int ultimateBonus = 0;
        if (this.isDoubleStellar(stack)) {
            ++specialBonus;
            ++ultimateBonus;
        }
        int spAcsBonus = 0;
        int ultAcsBonus = 0;
        float specialCdBonus = 1.0f;
        float ultimateCdBonus = 1.0f;
        int set = VPUtil.getSet(player);
        if (set == 1) {
            ++spAcsBonus;
            this.specialTimeBonus += 0.2f;
            this.ultimateTimeBonus += 0.2f;
        } else if (set == 6) {
            --spAcsBonus;
        } else if (set == 7) {
            ++ultAcsBonus;
            this.specialTimeBonus -= 0.4f;
            this.ultimateTimeBonus -= 0.4f;
        } else if (set == 8) {
            this.specialTimeBonus += 1.0f;
            this.ultimateTimeBonus += 1.0f;
            specialCdBonus += 0.4f;
            ultimateCdBonus += 0.4f;
        }
        if (player.getPersistentData().m_128454_("VPJuke") >= System.currentTimeMillis() && VPUtil.hasVestige((Item)ModItems.LYRA.get(), player)) {
            this.specialTimeBonus += 0.4f;
            this.ultimateTimeBonus += 0.4f;
            specialCdBonus -= 0.4f;
            ultimateCdBonus -= 0.4f;
        }
        if (VPUtil.hasLyra((LivingEntity)player, 7)) {
            specialCdBonus -= 0.2f;
            ultimateCdBonus -= 0.2f;
        }
        if (VPUtil.isPoisonedByNightmare(player)) {
            this.specialTimeBonus -= 0.5f;
            this.ultimateTimeBonus -= 0.5f;
        }
        this.setSpecialCd((int)((double)this.specialCdBase(stack) * Math.max(0.1, (double)specialCdBonus)), stack);
        this.setUltimateCd((int)((double)this.ultimateCdBase(stack) * Math.max(0.1, (double)ultimateCdBonus)), stack);
        this.setSpecialMaxTime((int)((double)this.specialDurationBase(stack) * Math.max(0.1, (double)this.specialTimeBonus)), stack);
        this.setUltimateMaxTime((int)((double)this.ultimateDurationBase(stack) * Math.max(0.1, (double)this.ultimateTimeBonus)), stack);
        this.setSpecialCharges(this.specialChargesBase(stack) + specialBonus + this.specialBonusModifier(stack) + spAcsBonus, stack);
        this.setUltimateCharges(this.ultimateChargesBase(stack) + ultimateBonus + this.ultimateBonusModifier(stack) + ultAcsBonus, stack);
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (player.m_20193_().f_46443_) {
                super.curioTick(slotContext, stack);
                return;
            }
        }
        if (this.color == null || this.specialCharges(stack) == 0 || this.ultimateCharges(stack) == 0 || this.specialCdBase == 0 || this.ultimateChargesBase == 0 || this.damageType == null) {
            this.init(stack);
        }
        ServerPlayer playerServer = (ServerPlayer)slotContext.entity();
        if (!this.isStellar(stack) && playerServer.m_7500_()) {
            Vestige.setStellar(stack);
        }
        if (playerServer != null) {
            if (this.isSpecialActive(stack)) {
                this.whileSpecial((Player)playerServer, stack);
            }
            if (this.isUltimateActive(stack)) {
                this.whileUltimate((Player)playerServer, stack);
            }
        }
        if (this.time(stack) > 0L && this.time(stack) <= System.currentTimeMillis()) {
            this.setTime(0L, stack);
            this.setSpecialActive(false, stack);
            if (playerServer != null) {
                this.specialEnds((Player)playerServer, stack);
            }
        }
        if (this.timeUlt(stack) > 0L && this.timeUlt(stack) <= System.currentTimeMillis()) {
            this.setTimeUlt(0L, stack);
            this.setUltimateActive(false, stack);
            if (playerServer != null) {
                this.ultimateEnds((Player)playerServer, stack);
            }
        }
        if (this.cdSpecialActive(stack) > 0) {
            this.setCdSpecialActive(this.cdSpecialActive(stack) - 1, stack);
            if ((this.cdSpecialActive(stack) > this.specialCd(stack) ? this.cdSpecialActive(stack) % this.specialCd(stack) == 0 : this.cdSpecialActive(stack) - this.specialCd(stack) == 0 || this.cdSpecialActive(stack) == 0) && this.specialCharges(stack) > this.currentChargeSpecial(stack)) {
                this.setCurrentChargeSpecial(this.currentChargeSpecial(stack) + 1, stack);
                if (playerServer != null) {
                    this.specialRecharges((Player)playerServer, stack);
                }
            }
        }
        if (this.cdUltimateActive(stack) > 0) {
            this.setCdUltimateActive(this.cdUltimateActive(stack) - 1, stack);
            if ((this.cdUltimateActive(stack) > this.ultimateCd(stack) ? this.cdUltimateActive(stack) % this.ultimateCd(stack) == 0 : this.cdUltimateActive(stack) - this.ultimateCd(stack) == 0 || this.cdUltimateActive(stack) == 0) && this.ultimateCharges(stack) > this.currentChargeUltimate(stack)) {
                this.setCurrentChargeUltimate(this.currentChargeUltimate(stack) + 1, stack);
                if (playerServer != null) {
                    this.ultimateRecharges((Player)playerServer, stack);
                }
            }
        }
        if (this.currentChargeUltimate(stack) == 0 && this.cdUltimateActive(stack) == 0 || this.currentChargeSpecial(stack) == 0 && this.cdSpecialActive(stack) == 0) {
            this.curioSucks((Player)playerServer, stack);
        }
        super.curioTick(slotContext, stack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> components, TooltipFlag flag) {
        if (this.color == null || this.specialCharges(stack) == 0 || this.ultimateCharges(stack) == 0 || this.specialCdBase == 0 || this.ultimateChargesBase == 0 || this.damageType == null) {
            this.init(stack);
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        player.getCapability(PlayerCapabilityProviderVP.playerCap).ifPresent(arg_0 -> this.lambda$appendHoverText$0(components, stack, (Player)player, arg_0));
        super.m_7373_(stack, level, components, flag);
    }

    public ICurio.DropRule getDropRule(SlotContext slotContext, DamageSource source, int lootingLevel, boolean recentlyHit, ItemStack stack) {
        if (this.isStellar(stack)) {
            return ICurio.DropRule.ALWAYS_KEEP;
        }
        return ICurio.DropRule.DEFAULT;
    }

    public String symbolsRandom(ItemStack stack) {
        char[] starChars = new char[]{'*', '\u2731', '\u2606', '\u2605'};
        Random random = new Random();
        this.originalText = I18n.m_118938_((String)("vp.name." + this.vestigeNumber), (Object[])new Object[0]).substring(2);
        int randomNumber = random.nextInt(this.originalText.length() - 1);
        int randomNumber2 = random.nextInt(this.originalText.length() - 1);
        Object finalName = "";
        int counter = 0;
        for (String element : this.originalText.split("")) {
            finalName = (String)finalName + element;
            if (counter == randomNumber || counter == randomNumber2) {
                finalName = (String)finalName + starChars[random.nextInt(starChars.length)];
            }
            ++counter;
        }
        return finalName;
    }

    public boolean fuckNbt1(Player player) {
        return player.getPersistentData().m_128471_("VPFuckNbt1");
    }

    public boolean fuckNbt2(Player player) {
        return player.getPersistentData().m_128471_("VPFuckNbt2");
    }

    public void fuckNbt() {
    }

    public void curioSucks(Player player, ItemStack stack) {
        if (player.m_20193_().f_46443_) {
            return;
        }
        this.setTime(0L, stack);
        this.setTimeUlt(0L, stack);
        this.setSpecialActive(false, stack);
        this.setUltimateActive(false, stack);
        this.setCurrentChargeSpecial(0, stack);
        this.setCurrentChargeUltimate(0, stack);
        this.setCdSpecialActive(this.specialCd(stack) * this.specialCharges(stack), stack);
        this.setCdUltimateActive(this.ultimateCd(stack) * this.ultimateCharges(stack), stack);
        VPUtil.vestigeNullify(player);
        this.applyBonus(stack, player);
    }

    public void doSpecial(long seconds, Player player, Level level, ItemStack stack) {
        player.getPersistentData().m_128356_("VPAcsSpecial", System.currentTimeMillis() + 5000L);
        this.applyBonus(stack, player);
    }

    public void doUltimate(long seconds, Player player, Level level, ItemStack stack) {
        player.getPersistentData().m_128350_("VPDurationBonusDonut", 0.0f);
        if (this.vestigeNumber != 3) {
            player.getPersistentData().m_128405_("VPGravity", 0);
        }
        this.applyBonus(stack, player);
    }

    public void specialEnds(Player player, ItemStack stack) {
    }

    public void ultimateEnds(Player player, ItemStack stack) {
    }

    public void whileSpecial(Player player, ItemStack stack) {
    }

    public void whileUltimate(Player player, ItemStack stack) {
    }

    public void specialRecharges(Player player, ItemStack stack) {
    }

    public void ultimateRecharges(Player player, ItemStack stack) {
    }

    public ICurio.SoundInfo getEquipSound(SlotContext slotContext, ItemStack stack) {
        return new ICurio.SoundInfo(SoundEvents.f_11674_, 1.0f, 1.0f);
    }

    public void refresh(Player player, ItemStack stack) {
        this.setCdSpecialActive(0, stack);
        this.setCdUltimateActive(0, stack);
        this.setCurrentChargeSpecial(this.specialCharges(stack), stack);
        this.setCurrentChargeUltimate(this.ultimateCharges(stack), stack);
        this.ultimateEnds(player, stack);
        this.specialEnds(player, stack);
        this.specialRecharges(player, stack);
        this.ultimateRecharges(player, stack);
    }

    public void localSpecial(Player player) {
    }

    public void localUltimate(Player player) {
    }

    private /* synthetic */ void lambda$appendHoverText$0(List components, ItemStack stack, Player player, PlayerCapabilityVP cap) {
        int curse;
        if (Screen.m_96638_()) {
            components.add(Component.m_237115_((String)"vp.passive").m_130940_(this.color));
            components.add(Component.m_237115_((String)("vp.passive." + this.vestigeNumber)).m_130940_(ChatFormatting.GRAY));
            int spCharges = this.specialCharges(stack);
            int spCd = this.specialCd(stack);
            int ultCharges = this.ultimateCharges(stack);
            int ultCd = this.ultimateCd(stack);
            if (this.vestigeNumber == 10) {
                components.add(Component.m_237115_((String)"vp.return").m_130940_(this.color).m_7220_((Component)Component.m_237113_((String)("\n" + stack.m_41784_().m_128461_("VPReturnKey") + " " + stack.m_41784_().m_128459_("VPReturnX") + "X, " + stack.m_41784_().m_128459_("VPReturnY") + "Y, " + stack.m_41784_().m_128459_("VPReturnZ") + "Z, ")).m_130940_(ChatFormatting.GRAY)));
            }
            Object firstKey = "";
            Object secondKey = "";
            if (!VPUtil.getFirstVestige(player).isEmpty() && VPUtil.getFirstVestige(player).get(0) == stack) {
                if (!KeyBinding.FIRST_KEY.getKeyModifier().name().equals("NONE")) {
                    firstKey = (String)firstKey + KeyBinding.FIRST_KEY.getKeyModifier().name() + "+";
                }
                firstKey = (String)firstKey + KeyBinding.FIRST_KEY.getKey().m_84875_().getString();
                if (!KeyBinding.FIRST_KEY_ULT.getKeyModifier().name().equals("NONE")) {
                    secondKey = (String)secondKey + KeyBinding.FIRST_KEY_ULT.getKeyModifier().name() + "+";
                }
                secondKey = (String)secondKey + KeyBinding.FIRST_KEY_ULT.getKey().m_84875_().getString();
            } else {
                if (!KeyBinding.SECOND_KEY.getKeyModifier().name().equals("NONE")) {
                    firstKey = (String)firstKey + KeyBinding.SECOND_KEY.getKeyModifier().name() + "+";
                }
                firstKey = (String)firstKey + KeyBinding.SECOND_KEY.getKey().m_84875_().getString();
                if (!KeyBinding.SECOND_KEY_ULT.getKeyModifier().name().equals("NONE")) {
                    secondKey = (String)secondKey + KeyBinding.SECOND_KEY_ULT.getKeyModifier().name() + "+";
                }
                secondKey = (String)secondKey + KeyBinding.SECOND_KEY_ULT.getKey().m_84875_().getString();
            }
            components.add(Component.m_237115_((String)"vp.special").m_130940_(this.color).m_7220_((Component)Component.m_237115_((String)"vp.charges").m_130940_(this.color)).m_7220_((Component)Component.m_237113_((String)(" " + spCharges)).m_130940_(this.color)).m_7220_((Component)Component.m_237115_((String)"vp.charges2").m_130940_(this.color)).m_7220_((Component)Component.m_237113_((String)(" " + spCd / 20)).m_130940_(this.color)).m_7220_((Component)Component.m_237115_((String)"vp.seconds").m_130940_(this.color)).m_7220_((Component)Component.m_237113_((String)" ")).m_7220_((Component)Component.m_237115_((String)"vp.activation")).m_7220_((Component)Component.m_237113_((String)(" " + (String)firstKey))));
            if (this.vestigeNumber == 2) {
                components.add(Component.m_237110_((String)("vp.special." + this.vestigeNumber), (Object[])new Object[]{ConfigHandler.COMMON.crownShield.get() + "%"}).m_130940_(ChatFormatting.GRAY));
            } else {
                components.add(Component.m_237115_((String)("vp.special." + this.vestigeNumber)).m_130940_(ChatFormatting.GRAY));
            }
            components.add(Component.m_237115_((String)"vp.ultimate").m_130940_(this.color).m_7220_((Component)Component.m_237115_((String)"vp.charges").m_130940_(this.color)).m_7220_((Component)Component.m_237113_((String)(" " + ultCharges)).m_130940_(this.color)).m_7220_((Component)Component.m_237115_((String)"vp.charges2").m_130940_(this.color)).m_7220_((Component)Component.m_237113_((String)(" " + ultCd / 20)).m_130940_(this.color)).m_7220_((Component)Component.m_237115_((String)"vp.seconds").m_130940_(this.color)).m_7220_((Component)Component.m_237113_((String)" ")).m_7220_((Component)Component.m_237115_((String)"vp.activation")).m_7220_((Component)Component.m_237113_((String)(" " + (String)secondKey))));
            if (this.vestigeNumber == 15) {
                components.add(Component.m_237110_((String)("vp.ultimate." + this.vestigeNumber), (Object[])new Object[]{ConfigHandler.COMMON.devourer.get(), (Double)ConfigHandler.COMMON.devourerChance.get() * 100.0 + "%"}).m_130940_(ChatFormatting.GRAY));
            } else if (this.vestigeNumber == 23) {
                components.add(Component.m_237110_((String)("vp.ultimate." + this.vestigeNumber), (Object[])new Object[]{10 + cap.getPearls() * 5}).m_130940_(ChatFormatting.GRAY));
            } else if (this.vestigeNumber == 6) {
                components.add(Component.m_237110_((String)("vp.ultimate." + this.vestigeNumber), (Object[])new Object[]{ConfigHandler.COMMON.donutMaxSaturation.get()}).m_130940_(ChatFormatting.GRAY));
            } else {
                components.add(Component.m_237115_((String)("vp.ultimate." + this.vestigeNumber)).m_130940_(ChatFormatting.GRAY));
            }
            if (this.vestigeNumber == 10) {
                components.add(Component.m_237115_((String)"vp.worlds").m_130940_(this.color).m_7220_((Component)Component.m_237113_((String)("\n" + cap.getDimensions())).m_130940_(ChatFormatting.GRAY)));
            }
            if (this.damageType.booleanValue()) {
                components.add(Component.m_237115_((String)"vp.damage").m_130940_(this.color));
                components.add(Component.m_237115_((String)("vp.damagetype." + this.vestigeNumber)).m_130940_(ChatFormatting.GRAY));
            }
            if (this.isStellar(stack)) {
                if (this.isDoubleStellar(stack)) {
                    components.add(Component.m_237113_((String)VPUtil.getRainbowString("Double Stellar: ")));
                } else {
                    components.add(Component.m_237113_((String)VPUtil.getRainbowString("Stellar: ")));
                }
            } else {
                components.add(Component.m_237115_((String)"Stellar").m_130940_(this.color));
            }
            components.add(Component.m_237115_((String)"vp.stellarText").m_130940_(ChatFormatting.GRAY).m_7220_((Component)Component.m_237115_((String)("vp.stellar." + this.vestigeNumber))));
            for (int visualUlt = this.cdUltimateActive(stack); visualUlt > this.ultimateCd(stack); visualUlt -= this.ultimateCd(stack)) {
            }
            for (int visualSpecial = this.cdSpecialActive(stack); visualSpecial > this.specialCd(stack); visualSpecial -= this.specialCd(stack)) {
            }
            components.add(Component.m_237115_((String)"config").m_130940_(ChatFormatting.GRAY));
        } else if (Screen.m_96637_()) {
            components.add(Component.m_237115_((String)"vp.challenge").m_130940_(ChatFormatting.GRAY).m_7220_((Component)Component.m_237113_((String)(VPUtil.getRainbowString(VPUtil.generateRandomString(7)) + " :"))));
            if (this.vestigeNumber == 9) {
                components.add(Component.m_237115_((String)("vp.get." + this.vestigeNumber)).m_130940_(ChatFormatting.GRAY).m_7220_((Component)Component.m_237113_((String)(cap.getGoldenChance() + "%")).m_130940_(ChatFormatting.GRAY)));
            } else if (this.vestigeNumber == 14) {
                components.add(Component.m_237110_((String)("vp.get." + this.vestigeNumber), (Object[])new Object[]{ConfigHandler.COMMON.chaostime.get(), player.getPersistentData().m_128451_("VPMaxChallenge" + this.vestigeNumber)}).m_130940_(ChatFormatting.GRAY));
                components.add(Component.m_237115_((String)"vp.chaos").m_130940_(ChatFormatting.GRAY).m_7220_((Component)Component.m_237113_((String)cap.getRandomEntity())));
                components.add(Component.m_237115_((String)"vp.chaos2").m_130940_(ChatFormatting.GRAY).m_130946_(VPUtil.formatMilliseconds(cap.getChaosTime() + (long)VPUtil.getChaosTime() - System.currentTimeMillis())));
            } else if (this.vestigeNumber == 16) {
                components.add(Component.m_237115_((String)("vp.get." + this.vestigeNumber)).m_130940_(ChatFormatting.GRAY));
                if (((Boolean)ConfigHandler.COMMON.failFlowers.get()).booleanValue()) {
                    components.add(Component.m_237115_((String)"vp.get.16.fail").m_130940_(ChatFormatting.GRAY));
                }
            } else {
                int[] hobbyHorsing = new int[]{1, 4, 5, 7, 14, 15, 18, 19, 23};
                boolean yesHorsing = false;
                for (int horse : hobbyHorsing) {
                    if (horse != this.vestigeNumber) continue;
                    yesHorsing = true;
                    break;
                }
                if (yesHorsing) {
                    components.add(Component.m_237110_((String)("vp.get." + this.vestigeNumber), (Object[])new Object[]{player.getPersistentData().m_128451_("VPMaxChallenge" + this.vestigeNumber)}).m_130940_(ChatFormatting.GRAY));
                } else if (this.vestigeNumber == 13) {
                    components.add(Component.m_237110_((String)("vp.get." + this.vestigeNumber), (Object[])new Object[]{player.getPersistentData().m_128451_("VPMaxChallenge" + this.vestigeNumber), (Double)ConfigHandler.COMMON.rareItemChance.get() * 100.0 + "%"}).m_130940_(ChatFormatting.GRAY));
                } else {
                    components.add(Component.m_237115_((String)("vp.get." + this.vestigeNumber)).m_130940_(ChatFormatting.GRAY));
                }
            }
            int progress = 0;
            progress = cap.getChallenge(this.vestigeNumber);
            if (this.vestigeNumber == 12) {
                progress = VPUtil.getCurseAmount(player);
            }
            if (this.vestigeNumber == 24) {
                boolean fuckThisStupidGame = false;
                boolean fuckThisStupidGame2 = false;
                for (MobBucketItem bucketItem : VPUtil.getBuckets()) {
                    ArrayList<String> allFish = new ArrayList<String>(VPUtil.fishTypesFromBucket(bucketItem));
                    EntityType<?> type = ((BucketMixin)bucketItem).getFishSup().get();
                    ArrayList<String> bucketFish = new ArrayList<String>();
                    for (String fish : cap.getSea().split(",")) {
                        for (String name : allFish) {
                            if (!fish.trim().contains(name)) continue;
                            bucketFish.add(fish.trim());
                        }
                    }
                    boolean axolotl = ((BucketMixin)bucketItem).getFishSup().get().m_20675_().contains("entity.minecraft.axolotl");
                    boolean tropic = ((BucketMixin)bucketItem).getFishSup().get().m_20675_().contains("entity.minecraft.tropical_fish");
                    if (axolotl) {
                        if (fuckThisStupidGame) continue;
                        fuckThisStupidGame = true;
                    }
                    if (tropic) {
                        if (fuckThisStupidGame2) continue;
                        fuckThisStupidGame2 = true;
                    }
                    if (allFish.size() <= 2) continue;
                    int bucketProgress = bucketFish.size();
                    components.add(Component.m_237115_((String)type.m_20675_()).m_7220_((Component)Component.m_237113_((String)":")).m_130940_(this.color));
                    components.add(Component.m_237115_((String)"vp.progress").m_130940_(ChatFormatting.GRAY).m_7220_((Component)Component.m_237113_((String)(" " + bucketProgress))).m_7220_((Component)Component.m_237113_((String)(" / " + VPUtil.fishTypesFromBucket(bucketItem).size()))));
                }
                components.add(Component.m_237115_((String)"vp.fish").m_130940_(this.color).m_7220_((Component)Component.m_237113_((String)(" " + progress))).m_7220_((Component)Component.m_237113_((String)(" / " + player.getPersistentData().m_128451_("VPMaxChallenge" + this.vestigeNumber)))));
            } else {
                components.add(Component.m_237115_((String)"vp.progress").m_130940_(this.color).m_7220_((Component)Component.m_237113_((String)(" " + progress))).m_7220_((Component)Component.m_237113_((String)(" / " + player.getPersistentData().m_128451_("VPMaxChallenge" + this.vestigeNumber)))));
            }
            double stellarChance = VPUtil.getChance((double)cap.getChance() / 100.0, player) * 100.0;
            if (VPUtil.getSet(player) == 9) {
                stellarChance += 5.0;
            }
            if (cap.getVip() > System.currentTimeMillis()) {
                stellarChance += 10.0;
            }
            components.add(Component.m_237113_((String)((int)stellarChance + "% ")).m_130940_(this.color).m_7220_((Component)Component.m_237115_((String)"vp.chance").m_130940_(ChatFormatting.GRAY).m_7220_((Component)Component.m_237113_((String)VPUtil.getRainbowString("Stellar")))));
            components.add(Component.m_237115_((String)"vp.chance2").m_130940_(ChatFormatting.GRAY).m_7220_((Component)Component.m_237113_((String)(ConfigHandler.COMMON.stellarChanceIncrease.get() + "%"))));
            components.add(Component.m_237115_((String)"vp.getText1").m_130940_(ChatFormatting.GRAY).m_7220_((Component)Component.m_237113_((String)(VPUtil.formatMilliseconds(VPUtil.coolDown(player)) + " ")).m_130940_(ChatFormatting.GRAY)));
            if (cap.hasCoolDown(this.vestigeNumber)) {
                components.add(Component.m_237115_((String)"vp.getText2").m_7220_((Component)Component.m_237113_((String)VPUtil.formatMilliseconds(VPUtil.coolDown(player) - (System.currentTimeMillis() - cap.getTimeCd())))));
            }
            if (player.m_7500_()) {
                components.add(Component.m_237115_((String)"vp.creative").m_130940_(ChatFormatting.DARK_PURPLE));
            }
        } else if (Screen.m_96639_()) {
            String text = "";
            switch (this.vestigeNumber) {
                case 2: {
                    text = VPUtil.getMonsterClient(player).toString();
                    break;
                }
                case 3: {
                    text = VPUtil.getBiomesClient(player).toString();
                    break;
                }
                case 6: {
                    text = VPUtil.filterAndTranslate(VPUtil.getFoodLeft(cap.getFoodEaten()).toString(), ChatFormatting.GRAY).getString();
                    break;
                }
                case 11: {
                    text = VPUtil.getDamageKindsLeft(cap.getDamageDie()).toString();
                    break;
                }
                case 13: {
                    text = VPUtil.getRaresClient(player).toString();
                    break;
                }
                case 15: {
                    text = VPUtil.getBossClient(player).toString();
                    break;
                }
                case 16: {
                    text = VPUtil.filterAndTranslate(VPUtil.getFlowersLeft(cap.getFlowers()).toString(), ChatFormatting.GRAY).getString();
                    break;
                }
                case 17: {
                    text = VPUtil.filterAndTranslate(VPUtil.getEffectsLeft(cap.getEffects()).toString(), ChatFormatting.GRAY).getString();
                    break;
                }
                case 20: {
                    text = VPUtil.getMobsClient(player).toString();
                    break;
                }
                case 21: {
                    text = VPUtil.filterAndTranslate(VPUtil.getTemplatesLeft(cap.getTemplates()).toString()).getString();
                    break;
                }
                case 22: {
                    text = VPUtil.filterAndTranslate(VPUtil.getMusicDisksLeft(cap.getMusic()).toString()).getString();
                    break;
                }
                case 24: {
                    text = VPUtil.filterAndTranslate(VPUtil.getSeaLeft(cap.getSea()).toString()).getString();
                    break;
                }
                default: {
                    text = null;
                }
            }
            if (this.vestigeNumber == 24) {
                components.add(Component.m_237115_((String)"vp.fish.2").m_130940_(ChatFormatting.BLUE));
            }
            if (this.vestigeNumber == 22) {
                components.add(Component.m_237115_((String)"vp.lyre.authors").m_130940_(ChatFormatting.BLUE));
            }
            if (text != null) {
                components.add(Component.m_237113_((String)text).m_130940_(ChatFormatting.GRAY));
            }
            if (this.vestigeNumber == 24) {
                boolean fuckThisStupidGame = false;
                boolean fuckThisStupidGame2 = false;
                for (MobBucketItem bucketItem : VPUtil.getBuckets()) {
                    EntityType<?> type = ((BucketMixin)bucketItem).getFishSup().get();
                    ArrayList<String> bucketFish = new ArrayList<String>();
                    ArrayList<String> allFish = new ArrayList<String>(VPUtil.fishTypesFromBucket(bucketItem));
                    for (String fish : cap.getSea().split(",")) {
                        for (String name : allFish) {
                            if (!fish.trim().contains(name)) continue;
                            bucketFish.add(fish.trim());
                        }
                    }
                    boolean axolotl = ((BucketMixin)bucketItem).getFishSup().get().m_20675_().contains("entity.minecraft.axolotl");
                    int tropic = ((BucketMixin)bucketItem).getFishSup().get().m_20675_().contains("entity.minecraft.tropical_fish") ? 1 : 0;
                    if (axolotl) {
                        if (fuckThisStupidGame) continue;
                        fuckThisStupidGame = true;
                    }
                    if (tropic != 0) {
                        if (fuckThisStupidGame2) continue;
                        fuckThisStupidGame2 = true;
                    }
                    if (allFish.size() == bucketFish.size() || allFish.size() <= 2) continue;
                    allFish.removeAll(bucketFish);
                    components.add(Component.m_237115_((String)type.m_20675_()).m_7220_((Component)Component.m_237113_((String)":")).m_130940_(ChatFormatting.BLUE));
                    components.add(VPUtil.filterAndTranslate(((Object)allFish).toString()));
                }
            }
        } else {
            if (this.isStellar(stack) && !Component.m_237115_((String)("vp.meme." + this.vestigeNumber)).getString().isEmpty()) {
                components.add(Component.m_237115_((String)("vp.meme." + this.vestigeNumber)).m_130940_(this.color));
            }
            components.add(Component.m_237115_((String)("vp.short." + this.vestigeNumber)).m_130940_(this.color));
            components.add(Component.m_237115_((String)"vp.press").m_7220_((Component)Component.m_237113_((String)"SHIFT").m_130940_(this.color).m_7220_((Component)Component.m_237115_((String)"vp.shift"))));
            components.add(Component.m_237115_((String)"vp.press").m_7220_((Component)Component.m_237113_((String)"CTRL").m_130940_(this.color).m_7220_((Component)Component.m_237115_((String)"vp.ctrl"))));
            if (this.vestigeNumber == 2 || this.vestigeNumber == 6 || this.vestigeNumber == 10 || this.vestigeNumber == 11 || this.vestigeNumber == 13 || this.vestigeNumber == 15 || this.vestigeNumber == 16 || this.vestigeNumber == 17 || this.vestigeNumber == 20) {
                components.add(Component.m_237115_((String)"vp.press").m_7220_((Component)Component.m_237113_((String)"ALT").m_130940_(this.color).m_7220_((Component)Component.m_237115_((String)"vp.alt"))));
            }
            if (this.vestigeNumber == 3) {
                components.add(Component.m_237115_((String)"vp.press").m_7220_((Component)Component.m_237113_((String)"ALT").m_130940_(this.color).m_7220_((Component)Component.m_237115_((String)"vp.alt.atlas"))));
            }
        }
        if (this.vestigeNumber == 9) {
            int luck = stack.m_41784_().m_128451_("VPLuck");
            int kills = stack.m_41784_().m_128451_("VPKills");
            components.add(Component.m_237113_((String)("Kills: " + kills)).m_130940_(this.color));
            components.add(Component.m_237113_((String)("Luck: " + luck)).m_130940_(this.color));
        }
        if (this.vestigeNumber == 13) {
            components.add(Component.m_237115_((String)"vp.prism").m_130940_(this.color).m_7220_((Component)Component.m_237113_((String)("" + stack.m_41784_().m_128451_("VPPrismKill"))).m_130940_(ChatFormatting.GRAY)));
        }
        if (this.vestigeNumber == 15) {
            components.add(Component.m_237115_((String)"vp.devourer").m_130940_(this.color).m_7220_((Component)Component.m_237113_((String)("" + stack.m_41784_().m_128451_("VPDevoured"))).m_130940_(ChatFormatting.GRAY)));
        }
        if ((curse = VPUtil.getVestigeCurse(stack)) > 0) {
            int multiplier = 0;
            if (curse == 1) {
                multiplier = 90;
                if (this.isStellar(stack)) {
                    multiplier = 75;
                }
                if (this.isDoubleStellar(stack)) {
                    multiplier = 45;
                }
            } else if (curse == 2) {
                multiplier = -80;
                if (this.isStellar(stack)) {
                    multiplier = -65;
                }
                if (this.isDoubleStellar(stack)) {
                    multiplier = -50;
                }
            } else if (curse == 3) {
                multiplier = 3;
                if (this.isStellar(stack)) {
                    multiplier = 2;
                }
                if (this.isDoubleStellar(stack)) {
                    multiplier = 1;
                }
            } else if (curse == 4) {
                multiplier = 40;
                if (this.isStellar(stack)) {
                    multiplier = 70;
                }
                if (this.isDoubleStellar(stack)) {
                    multiplier = 110;
                }
            } else if (curse == 5) {
                multiplier = 50;
                if (this.isStellar(stack)) {
                    multiplier = 125;
                }
                if (this.isDoubleStellar(stack)) {
                    multiplier = 250;
                }
            }
            components.add(Component.m_237110_((String)("vp.curse." + curse), (Object[])new Object[]{multiplier + "%"}).m_130940_(ChatFormatting.BOLD).m_130940_(ChatFormatting.RED));
        }
        components.add(Component.m_237115_((String)"vp.info").m_130940_(ChatFormatting.GRAY));
        if (this.isStellar(stack)) {
            String name = this.symbolsRandom(stack);
            Component component = Component.m_130674_((String)VPUtil.getRainbowString(name));
            stack.m_41714_(component);
        }
    }
}

