/*
 * Decompiled with CFR 0.152.
 */
package com.pyding.vp.item.vestiges;

import com.pyding.vp.client.sounds.SoundRegistry;
import com.pyding.vp.item.vestiges.Vestige;
import com.pyding.vp.util.VPUtil;
import java.util.Random;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class Whirlpool
extends Vestige {
    @Override
    public void dataInit(int vestigeNumber, ChatFormatting color, int specialCharges, int specialCd, int ultimateCharges, int ultimateCd, int specialMaxTime, int ultimateMaxTime, boolean hasDamage, ItemStack stack) {
        super.dataInit(24, ChatFormatting.BLUE, 3, 40, 1, 60, 30, 20, true, stack);
    }

    @Override
    public void doSpecial(long seconds, Player player, Level level, ItemStack stack) {
        Random random = new Random();
        if (random.nextDouble() < 0.5) {
            VPUtil.play((LivingEntity)player, (SoundEvent)SoundRegistry.BUBBLE2.get());
        } else {
            VPUtil.play((LivingEntity)player, (SoundEvent)SoundRegistry.BUBBLE5.get());
        }
        VPUtil.spawnSphere((Entity)player, ParticleTypes.f_123769_, 40, 3.0f, 0.2f);
        player.getPersistentData().m_128405_("VPWhirlpool", 3 + Math.min(10, Math.max(0, player.m_6062_() / 100)));
        super.doSpecial(seconds, player, level, stack);
    }

    @Override
    public void doUltimate(long seconds, Player player, Level level, ItemStack stack) {
        VPUtil.play((LivingEntity)player, (SoundEvent)SoundRegistry.BUBBLEPOP.get());
        VPUtil.spawnCircleParticles((Entity)player, 50, ParticleTypes.f_123769_, 3.0, 1.0);
        for (LivingEntity entity : VPUtil.getEntities(player, 20.0, false)) {
            if (VPUtil.isProtectedFromHit(player, (Entity)entity)) continue;
            entity.getPersistentData().m_128356_("VPBubble", System.currentTimeMillis() + seconds);
            entity.m_6598_(player);
        }
        super.doUltimate(seconds, player, level, stack);
    }
}

