/*
 * Decompiled with CFR 0.152.
 */
package com.pyding.vp.network;

import com.pyding.vp.network.packets.ButtonPressPacket;
import com.pyding.vp.network.packets.ClientToServerPacket;
import com.pyding.vp.network.packets.ItemAnimationPacket;
import com.pyding.vp.network.packets.LorePacket;
import com.pyding.vp.network.packets.ParticlePacket;
import com.pyding.vp.network.packets.PlayerFlyPacket;
import com.pyding.vp.network.packets.SendEntityNbtToClient;
import com.pyding.vp.network.packets.SendPlayerCapaToClient;
import com.pyding.vp.network.packets.SendPlayerNbtToClient;
import com.pyding.vp.network.packets.SoundPacket;
import com.pyding.vp.network.packets.StackNbtSync;
import com.pyding.vp.network.packets.SuckPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;

public class PacketHandler {
    private static SimpleChannel INSTANCE;
    private static int packetId;

    private static int id() {
        return packetId++;
    }

    public static void register() {
        SimpleChannel net;
        INSTANCE = net = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation("vp", "messages")).networkProtocolVersion(() -> "1.0").clientAcceptedVersions(s -> true).serverAcceptedVersions(s -> true).simpleChannel();
        net.registerMessage(PacketHandler.id(), SendPlayerNbtToClient.class, SendPlayerNbtToClient::encode, SendPlayerNbtToClient::decode, SendPlayerNbtToClient::handle);
        net.registerMessage(PacketHandler.id(), SendPlayerCapaToClient.class, SendPlayerCapaToClient::encode, SendPlayerCapaToClient::decode, SendPlayerCapaToClient::handle);
        net.messageBuilder(ClientToServerPacket.class, PacketHandler.id(), NetworkDirection.PLAY_TO_SERVER).decoder(ClientToServerPacket::new).encoder(ClientToServerPacket::toBytes).consumerMainThread(ClientToServerPacket::handle).add();
        net.registerMessage(PacketHandler.id(), PlayerFlyPacket.class, PlayerFlyPacket::encode, PlayerFlyPacket::decode, PlayerFlyPacket::handle);
        net.registerMessage(PacketHandler.id(), SendEntityNbtToClient.class, SendEntityNbtToClient::encode, SendEntityNbtToClient::decode, SendEntityNbtToClient::handle);
        net.registerMessage(PacketHandler.id(), SoundPacket.class, SoundPacket::encode, SoundPacket::decode, SoundPacket::handle);
        net.registerMessage(PacketHandler.id(), ParticlePacket.class, ParticlePacket::encode, ParticlePacket::decode, ParticlePacket::handle);
        net.registerMessage(PacketHandler.id(), ButtonPressPacket.class, ButtonPressPacket::encode, ButtonPressPacket::decode, ButtonPressPacket::handle);
        net.registerMessage(PacketHandler.id(), LorePacket.class, LorePacket::encode, LorePacket::decode, LorePacket::handle);
        net.registerMessage(PacketHandler.id(), SuckPacket.class, SuckPacket::encode, SuckPacket::decode, SuckPacket::handle);
        net.messageBuilder(ItemAnimationPacket.class, PacketHandler.id(), NetworkDirection.PLAY_TO_CLIENT).decoder(ItemAnimationPacket::new).encoder(ItemAnimationPacket::toBytes).consumerMainThread(ItemAnimationPacket::handle).add();
        net.registerMessage(PacketHandler.id(), StackNbtSync.class, StackNbtSync::encode, StackNbtSync::decode, StackNbtSync::handle);
    }

    public static void sendToClient(Object packet, ServerPlayer player) {
        INSTANCE.sendTo(packet, player.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
    }

    public static <MSG> void sendToServer(MSG message) {
        INSTANCE.sendToServer(message);
    }

    public static <MSG> void sendToPlayer(MSG message, ServerPlayer player) {
        INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), message);
    }

    public static <MSG> void sendToAllAround(MSG message, Player player) {
        INSTANCE.send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint(player.m_20185_(), player.m_20186_(), player.m_20189_(), 64.0, player.m_20193_().m_46472_())), message);
    }

    public static void sendToClients(PacketDistributor.PacketTarget target, Object packet) {
        INSTANCE.send(target, packet);
    }

    static {
        packetId = 0;
    }
}

