/*
 * Decompiled with CFR 0.152.
 */
package com.pyding.vp.network.packets;

import com.pyding.vp.util.VPUtilParticles;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;

public class ParticlePacket {
    private final int id;
    private final double x;
    private final double y;
    private final double z;
    private final double deltaX;
    private final double deltaY;
    private final double deltaZ;
    private final float size;

    public ParticlePacket(int id, double x, double y, double z, double deltaX, double deltaY, double deltaZ) {
        this.id = id;
        this.x = x;
        this.y = y;
        this.z = z;
        this.deltaX = deltaX;
        this.deltaY = deltaY;
        this.deltaZ = deltaZ;
        this.size = 0.0f;
    }

    public ParticlePacket(int id, double x, double y, double z, double deltaX, double deltaY, double deltaZ, float size) {
        this.id = id;
        this.x = x;
        this.y = y;
        this.z = z;
        this.deltaX = deltaX;
        this.deltaY = deltaY;
        this.deltaZ = deltaZ;
        this.size = size;
    }

    public static void encode(ParticlePacket packet, FriendlyByteBuf buf) {
        buf.writeInt(packet.id);
        buf.writeDouble(packet.x);
        buf.writeDouble(packet.y);
        buf.writeDouble(packet.z);
        buf.writeDouble(packet.deltaX);
        buf.writeDouble(packet.deltaY);
        buf.writeDouble(packet.deltaZ);
        buf.writeFloat(packet.size);
    }

    public static ParticlePacket decode(FriendlyByteBuf buf) {
        return new ParticlePacket(buf.readInt(), buf.readDouble(), buf.readDouble(), buf.readDouble(), buf.readDouble(), buf.readDouble(), buf.readDouble());
    }

    public static void handle(ParticlePacket msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> ParticlePacket.handle2(msg.id, msg.x, msg.y, msg.z, msg.deltaX, msg.deltaY, msg.deltaZ, msg.size));
        ctx.get().setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void handle2(int id, double x, double y, double z, double deltaX, double deltaY, double deltaZ, float size) {
        LocalPlayer player;
        ParticleOptions options = VPUtilParticles.getParticleById(id);
        if (options != null && size == 0.0f && (player = Minecraft.m_91087_().f_91074_) != null) {
            player.m_20193_().m_7106_(options, x, y, z, deltaX, deltaY, deltaZ);
        }
    }
}

