/*
 * Decompiled with CFR 0.152.
 */
package com.pyding.vp.util;

import com.pyding.vp.capability.PlayerCapabilityVP;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class ConfigHandler {
    public static final Common COMMON;
    public static final ForgeConfigSpec COMMON_SPEC;

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Common::new);
        COMMON_SPEC = (ForgeConfigSpec)specPair.getRight();
        COMMON = (Common)specPair.getLeft();
    }

    public static class Common {
        public final ForgeConfigSpec.BooleanValue hardcore;
        public final ForgeConfigSpec.BooleanValue easter;
        public final ForgeConfigSpec.IntValue armorHardcore;
        public final ForgeConfigSpec.DoubleValue ballShield;
        public final ForgeConfigSpec.DoubleValue ballOverShield;
        public final ForgeConfigSpec.DoubleValue absorbHardcore;
        public final ForgeConfigSpec.DoubleValue shieldHardcore;
        public final ForgeConfigSpec.DoubleValue overShieldHardcore;
        public final ForgeConfigSpec.DoubleValue healPercent;
        public final ForgeConfigSpec.BooleanValue anomaly;
        public final ForgeConfigSpec.IntValue cooldown;
        public final ForgeConfigSpec.IntValue bossHP;
        public final ForgeConfigSpec.IntValue bossAttack;
        public final ForgeConfigSpec.IntValue chaostime;
        public final ForgeConfigSpec.IntValue devourer;
        public final ForgeConfigSpec.IntValue blackhole;
        public final ForgeConfigSpec.IntValue stellarChanceIncrease;
        public final ForgeConfigSpec.DoubleValue armorAbsorbBase;
        public final ForgeConfigSpec.DoubleValue armorAbsorbPercent;
        public final ForgeConfigSpec.IntValue anomalyBorder;
        public final ForgeConfigSpec.DoubleValue atlasChance;
        public final ForgeConfigSpec.IntValue catalystLvlLimit;
        public final ForgeConfigSpec.IntValue catalystDeffence;
        public final ForgeConfigSpec.DoubleValue catSpeed;
        public final ForgeConfigSpec.IntValue catEvadeCap;
        public final ForgeConfigSpec.IntValue chaosDamageCap;
        public final ForgeConfigSpec.DoubleValue chaosChance;
        public final ForgeConfigSpec.IntValue crownShield;
        public final ForgeConfigSpec.DoubleValue devourerChance;
        public final ForgeConfigSpec.DoubleValue flowerShield;
        public final ForgeConfigSpec.DoubleValue killerRes;
        public final ForgeConfigSpec.IntValue markMaximum;
        public final ForgeConfigSpec.IntValue markHealDebt;
        public final ForgeConfigSpec.IntValue maskRotAmount;
        public final ForgeConfigSpec.DoubleValue midasChance;
        public final ForgeConfigSpec.DoubleValue prismChance;
        public final ForgeConfigSpec.DoubleValue soulBlighterChance;
        public final ForgeConfigSpec.DoubleValue soulBlighterHeal;
        public final ForgeConfigSpec.DoubleValue trigonHeal;
        public final ForgeConfigSpec.IntValue donutMaxSaturation;
        public final ForgeConfigSpec.IntValue donutHealBonus;
        public final ForgeConfigSpec.IntValue markBonus;
        public final ForgeConfigSpec.IntValue chaosCharges;
        public final ForgeConfigSpec.LongValue devourerCdTime;
        public final ForgeConfigSpec.DoubleValue refresherChance;
        public final ForgeConfigSpec.IntValue vortexReduction;
        public final ForgeConfigSpec.IntValue easterChance;
        public final ForgeConfigSpec.ConfigValue bosses;
        public final ForgeConfigSpec.ConfigValue blacklistBosses;
        public final ForgeConfigSpec.ConfigValue repairObjects;
        public final ForgeConfigSpec.ConfigValue repairBlackList;
        public final ForgeConfigSpec.ConfigValue rareItems;
        public final ForgeConfigSpec.ConfigValue fishingBlacklist;
        public final ForgeConfigSpec.DoubleValue rareFishingDropChance;
        public final ForgeConfigSpec.DoubleValue nightmareBoxChance;
        public final ForgeConfigSpec.DoubleValue nightmareRefresherChance;
        public final ForgeConfigSpec.IntValue nightmareFrags;
        public final ForgeConfigSpec.IntValue nightmareLoot;
        public final ForgeConfigSpec.IntValue nightmareLootMin;
        public final ForgeConfigSpec.IntValue nightmareFragsMin;
        public final ForgeConfigSpec.IntValue nightmareBoxes;
        public final ForgeConfigSpec.IntValue nightmareBoxesMin;
        public final ForgeConfigSpec.IntValue eatingMinutes;
        public final ForgeConfigSpec.BooleanValue failFlowers;
        public final ForgeConfigSpec.ConfigValue<List<Integer>> reduceChallenges;
        public final ForgeConfigSpec.BooleanValue reduceChallengesPercent;
        public final ForgeConfigSpec.ConfigValue fishObjects;
        public final ForgeConfigSpec.DoubleValue hardcoreDamage;
        public final ForgeConfigSpec.DoubleValue nightmareDamageCap;
        public final ForgeConfigSpec.BooleanValue unlockHp;
        public final ForgeConfigSpec.BooleanValue eventMode;
        public final ForgeConfigSpec.DoubleValue rareItemChance;
        public final ForgeConfigSpec.DoubleValue empoweredChance;
        public final ForgeConfigSpec.ConfigValue debuffBlacklist;
        public final ForgeConfigSpec.ConfigValue cloneBlackList;
        public final ForgeConfigSpec.ConfigValue cloneWhiteList;
        public final ForgeConfigSpec.ConfigValue mirrorUUIDList;
        public final ForgeConfigSpec.ConfigValue dupersList;
        public final ForgeConfigSpec.ConfigValue leaderboardHost;
        public final ForgeConfigSpec.ConfigValue leaderboardPort;
        public final ForgeConfigSpec.BooleanValue leaderboard;
        public final ForgeConfigSpec.DoubleValue chaosCoreStellarHpRes;

        public Common(ForgeConfigSpec.Builder builder) {
            this.refresherChance = builder.comment("Chance for Refresher after completing Stellar challenge. 1 is 100%, 0.5 is 50%.").defineInRange("refresherChance", 0.5, 0.0, 1.0);
            ArrayList<Integer> reduceList = new ArrayList<Integer>();
            for (int i = 0; i < PlayerCapabilityVP.totalVestiges; ++i) {
                reduceList.add(0);
            }
            this.reduceChallenges = builder.comment("Those are numbers for each Challenge to reduce their maximum").define("reduceChallenges", reduceList);
            this.reduceChallengesPercent = builder.comment("If true, numbers above for reducing Challenges maximum number will count as Percent from maximum").define("reduceChallengesPercent", false);
            this.hardcore = builder.comment("Enables hardcore mode: all bosses will have x4 hp, x2 damage, 100 armor, Shields and Over Shield, Healing, damage absorption 90%").define("hardcore", false);
            this.bossHP = builder.comment("Hardcore mode Hp scale").defineInRange("bossHP", 4, 1, 2100000000);
            this.bossAttack = builder.comment("Hardcore mode attack scale").defineInRange("bossAttack", 2, 1, 2100000000);
            this.armorHardcore = builder.comment("Hardcore mode armor and armor toughness").defineInRange("armorHardcore", 100, 1, 2100000000);
            this.absorbHardcore = builder.comment("Hardcore mode damage absorb percent").defineInRange("absorbHardcore", 0.9, 0.0, 1.0);
            this.shieldHardcore = builder.comment("Hardcore mode Shield from hp percent 1 is 100%").defineInRange("shieldHardcore", 1.5, 0.1, 2.1E9);
            this.overShieldHardcore = builder.comment("Hardcore mode Over Shield from hp percent").defineInRange("overShieldHardcore", 0.5, 0.1, 2.1E9);
            this.healPercent = builder.comment("Hardcore mode Heal percent from max hp").defineInRange("healPercent", 0.005, 0.0, 2.1E9);
            this.hardcoreDamage = builder.comment("Hardcore mode damage percent from maximum hp when starving, drowning. Set 0 to disable.").defineInRange("hardcoreDamage", 0.15, 0.0, 2.1E9);
            this.nightmareBoxChance = builder.comment("Nightmare Bosses boxes chance 0.5 is 50%").defineInRange("nightmareBoxChance", 0.5, 0.0, 1.0);
            this.nightmareRefresherChance = builder.comment("Nightmare Bosses Refresher chance 0.1 is 10%").defineInRange("nightmareRefresherChance", 0.1, 0.0, 1.0);
            this.nightmareFrags = builder.comment("Nightmare Bosses max fragments").defineInRange("nightmareFrags", 26, 1, 2100000000);
            this.nightmareFragsMin = builder.comment("Nightmare Bosses min fragments").defineInRange("nightmareFragsMin", 13, 1, 2100000000);
            this.nightmareLoot = builder.comment("Nightmare Bosses max loot multiplier").defineInRange("nightmareLoot", 20, 1, 2100000000);
            this.nightmareLootMin = builder.comment("Nightmare Bosses min loot multiplier").defineInRange("nightmareLootMin", 10, 1, 2100000000);
            this.nightmareBoxes = builder.comment("Nightmare Bosses max boxes").defineInRange("nightmareBoxes", 8, 1, 2100000000);
            this.nightmareBoxesMin = builder.comment("Nightmare Bosses min boxes").defineInRange("nightmareBoxesMin", 4, 1, 2100000000);
            this.cooldown = builder.comment("Challenge cooldown in hours").defineInRange("cooldown", 8, 0, 2100000000);
            this.stellarChanceIncrease = builder.comment("How many % of stellar chance will you get on failure").defineInRange("stellarChanceIncrease", 10, 0, 100);
            this.armorAbsorbBase = builder.comment("Base Martyr's Habergeon damage absorption from Passive").defineInRange("armorAbsorbBase", 0.1, 0.0, 1.0);
            this.armorAbsorbPercent = builder.comment("Martyr's Habergeon Pain Gauge increase % from Ultimate. 1 is 100%, 0.1 is 10%.").defineInRange("armorAbsorbPercent", 0.1, 0.0, 1.0);
            this.anomalyBorder = builder.comment("Borders for Anomaly's Ultimate teleportation. Leave at 0 for world's max border.").defineInRange("anomalyBorder", 0, 0, Integer.MAX_VALUE);
            this.atlasChance = builder.comment("Chance for Atlas to gain Gravity. 1 is 100%, 0.2 is 20%.").defineInRange("atlasChance", 0.2, 0.0, 1.0);
            this.catalystLvlLimit = builder.comment("Level limit for stellar Catalyst").defineInRange("catalystLvlLimit", 255, 0, 255);
            this.catalystDeffence = builder.comment("How many debuffs can Catalyst absorb.").defineInRange("catalystDefence", 20, 0, Integer.MAX_VALUE);
            this.catSpeed = builder.comment("How many speed will Cat Ears give.").defineInRange("catSpeed", 1.0, 0.0, 10.0);
            this.catEvadeCap = builder.comment("Cap for Cat Ears evasion.").defineInRange("catEvadeCap", 69, 0, 100);
            this.chaosDamageCap = builder.comment("Damage cap for Chaos Core").defineInRange("chaosDamageCap", Integer.MAX_VALUE, 0, Integer.MAX_VALUE);
            this.chaosChance = builder.comment("Chance for Chaos Core reflexion or damage change. 1 is 100%, 0.1 is 10%.").defineInRange("chaosChance", 0.1, 0.0, 1.0);
            this.crownShield = builder.comment("How many % from enemy's health will crown give upon kill").defineInRange("crownShield", 50, 0, Integer.MAX_VALUE);
            this.devourerChance = builder.comment("Chance for Devourer's Ultimate per 1 kill. 1 is 100%, 0.001 is 0.1%").defineInRange("devourerChance", 0.01, 0.0, 100.0);
            this.flowerShield = builder.comment("Multiplier for Shield that will Flower give by Ultimate.").defineInRange("flowerShield", 1.0, 0.0, 2.147483647E9);
            this.killerRes = builder.comment("Killer Queens' Special explosion damage resistance shred").defineInRange("killerRes", 70.0, 0.0, 2.147483647E9);
            this.markMaximum = builder.comment("Maximum value of Cursed Mark Madness stacks").defineInRange("markMaximum", 10, 0, Integer.MAX_VALUE);
            this.markHealDebt = builder.comment("Heal debt of stellar Cursed Mark Ultimate in max health %").defineInRange("markHealDebt", 2000, 0, Integer.MAX_VALUE);
            this.maskRotAmount = builder.comment("Mask of Demon's Special hp consumption value in max health %").defineInRange("maskRotAmount", 10, 0, Integer.MAX_VALUE);
            this.midasChance = builder.comment("Chance for Midas getting luck from Ultimate per 1 gold nugget.").defineInRange("midasChance", 1.0E-4, 0.0, 1.0);
            this.prismChance = builder.comment("Prism loot chance multiplier").defineInRange("prismChance", 1.0, 0.0, 2.147483647E9);
            this.soulBlighterChance = builder.comment("Soul Blighter's Ultimate catch chance multiplier").defineInRange("soulBlighterChance", 1.0, 0.0, 2.147483647E9);
            this.soulBlighterHeal = builder.comment("Soul Blighter Over Shield heal multiplier").defineInRange("soulBlighterHeal", 1.0, 0.0, 2.147483647E9);
            this.trigonHeal = builder.comment("Trigon Over Shield heal multiplier").defineInRange("trigonHeal", 1.0, 0.0, 2.147483647E9);
            this.donutMaxSaturation = builder.comment("Sweet Donut max Saturation stacks.").defineInRange("donutMaxSaturation", 400, 0, Integer.MAX_VALUE);
            this.donutHealBonus = builder.comment("Base heal bonus of Sweet Donut.").defineInRange("donutHealBonus", 40, 0, Integer.MAX_VALUE);
            this.ballShield = builder.comment("How many Shield % will Ball Lightning reduce").defineInRange("ballShield", 0.1, 0.01, 1.0);
            this.ballOverShield = builder.comment("Hardcore mode Shield from hp percent 1 is 100%").defineInRange("ballOverShield", 0.2, 0.01, 1.0);
            this.chaosCharges = builder.comment("Amount of Chaos Core reflection hits from Special").defineInRange("chaosCharges", 20, 1, Integer.MAX_VALUE);
            this.devourerCdTime = builder.comment("Devourer cooldown time between rotting hits. 1000 is 1 sec").defineInRange("devourerCdTime", 200L, 1L, Long.MAX_VALUE);
            this.markBonus = builder.comment("Amount of stats per Curse for Mark's Overdrive").defineInRange("markBonus", 10, 1, Integer.MAX_VALUE);
            this.devourer = builder.comment("How many hits can cause Soul Rotting from Devourer").defineInRange("devourer", 30, 0, 2100000000);
            this.blackhole = builder.comment("How many ticks must pass before Black Hole hits").defineInRange("blackhole", 4, 0, 2100000000);
            this.anomaly = builder.comment("Should anomaly teleport only living entities").define("anomaly", false);
            this.chaostime = builder.comment("Minutes before Chaos Core challenge reset").defineInRange("chaostime", 15, 1, 2100000000);
            this.eatingMinutes = builder.comment("Minutes for fish to fed up").defineInRange("eatingMinutes", 1, 1, 2100000000);
            this.bosses = builder.comment("additional bosses: ").define("bosses", (Object)"hullbreaker,tremorzilla,nucleeper, luxtructosaurus,atlatitan,forsaken,void_worm,");
            this.blacklistBosses = builder.comment("blacklist for bosses: ").define("blacklistBosses", (Object)"void_worm_part,");
            this.repairObjects = builder.comment("repairObjectsId: ").define("repairObjects", (Object)"mending,repair,unbreak,restore,heal,ingot");
            this.repairBlackList = builder.comment("repairBlackListId: ").define("repairBlackList", (Object)"");
            this.vortexReduction = builder.comment("Reduction of maximum amount needed for Vortex").defineInRange("vortexReduction", 0, 0, Integer.MAX_VALUE);
            this.easter = builder.comment("Enables Easter event").define("easter", false);
            this.easterChance = builder.comment("Additional chance for Easter Egg 10 is 10%").defineInRange("easterChance", 0, 0, Integer.MAX_VALUE);
            this.fishObjects = builder.comment("fishObjects: ").define("fishObjects", (Object)"fish,shell,pearl,boot,treasure,sunken,drown,lure,prismarin,water,ocean,coral,shark,whale,manta,rain,abyss,deep,sea,pirate,ship,bottle,wet,river");
            this.rareItems = builder.comment("Rare Items for fishing by Abyssal Pearl: ").define("rareItems", (Object)"item.vp.hearty_pearl,item.vp.seashell,abyssal_heart,ichor_bottle,boot");
            this.fishingBlacklist = builder.comment("Fishing Blacklist for Abyssal Pearl: ").define("fishingBlacklist", (Object)"item.vp.pearl");
            this.rareFishingDropChance = builder.comment("Chance of rare drop in current biome from Fishing with Pearl or by defending Silly Seashell.").defineInRange("rareFishingDropChance", 0.001, 0.0, 1.0);
            this.failFlowers = builder.comment("Fails flowers Challenge when they are being placed.").define("failFlowers", false);
            this.nightmareDamageCap = builder.comment("Damage cap for Nightmare Bosses").defineInRange("nightmareDamageCap", 1000.0, 0.0, 3.4028234663852886E38);
            this.unlockHp = builder.comment("For servers with maxed out desync and hp lock to 2048 or if you just have problems with MaxHp.").define("unlockHp", false);
            this.eventMode = builder.comment("Event mode that disables all teleportations and fly.").define("eventMode", false);
            this.rareItemChance = builder.comment("Chance for Item to define as rare for Prism challenge. For example carrot has 0.025 chance to drop from zobmie").defineInRange("rareItemChance", 0.025, 1.0E-4, 1.0);
            this.empoweredChance = builder.comment("Chance to spawn Empowered mob in Hardcore mode").defineInRange("empoweredChance", 0.001, 0.0, 2.1E9);
            this.debuffBlacklist = builder.comment("Defines blacklist for random potion effects as from Heirloom's Special: ").define("debuffBlacklist", (Object)"crystallized,");
            this.cloneBlackList = builder.comment("Defines blacklist for items that cannot be cloned with Celestial Mirror: ").define("cloneBlackList", (Object)"pouch,bag,backpack,chest,box,pocket,store,storage,satchel,knapsack,cargo,vault,locker,crate,trunk,barrel,bin,safe,drawer,compartment,cache,case,basket,haversack,receptacle,container,ghostly_pickaxe,soul_gem,horse_flute,sack,broom");
            this.cloneWhiteList = builder.comment("Defines whitelist for items that can be cloned with Celestial Mirror with highest priority. F.e. chestplate to not be blocked by chest in blacklist: ").define("cloneWhiteList", (Object)"chestplate,box_eggs,box_saplings,item.vp.box,");
            this.mirrorUUIDList = builder.comment("List of existing mirrors UUID: ").define("mirrorUUIDList", (Object)"");
            this.dupersList = builder.comment("List of dupers: ").define("dupersList", (Object)"");
            this.leaderboardHost = builder.comment("Ip address for leaderboard: ").define("leaderboardHost", (Object)"");
            this.leaderboardPort = builder.comment("Ip port for leaderboard: ").define("leaderboardPort", (Object)"");
            this.leaderboard = builder.comment("Defines if Leaderboard should be enabled: ").define("leaderboard", false);
            this.chaosCoreStellarHpRes = builder.comment("Reduce modifier for Chaos Core Stellar ability of max hp lowering from Healing Debt").defineInRange("chaosCoreStellarHpRes", 10.0, 0.0, 2.1E9);
        }

        public int getChallengeReduceByNumber(int number) {
            return (Integer)((List)this.reduceChallenges.get()).get(number - 1);
        }
    }
}

