/*
 * Decompiled with CFR 0.152.
 */
package com.pyding.vp.util;

import com.pyding.vp.util.VPUtil;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="vp")
public class GradientUtil {
    private static final int COLOR_START = 16766720;
    private static final int COLOR_END = 0xFFFFFF;

    @SubscribeEvent
    public static void onServerChat(ServerChatEvent event) {
        if (event.getPlayer() != null && VPUtil.hasGoldenName(event.getPlayer().m_20148_())) {
            String originalText = event.getMessage().getString();
            Component gradientMessage = GradientUtil.buildGradientComponent(originalText);
            event.setMessage(gradientMessage);
        }
    }

    public static Component buildGradientComponent(String message) {
        MutableComponent result = Component.m_237119_();
        int length = message.length();
        if (length == 0) {
            return result;
        }
        for (int i = 0; i < length; ++i) {
            char c = message.charAt(i);
            float t = (float)i / (float)(length - 1);
            int color = GradientUtil.interpolateColor(16766720, 0xFFFFFF, t);
            result.m_7220_((Component)Component.m_237113_((String)String.valueOf(c)).m_130938_(style -> style.m_178520_(color)));
        }
        return result;
    }

    public static int interpolateColor(int start, int end, float t) {
        int r1 = start >> 16 & 0xFF;
        int g1 = start >> 8 & 0xFF;
        int b1 = start & 0xFF;
        int r2 = end >> 16 & 0xFF;
        int g2 = end >> 8 & 0xFF;
        int b2 = end & 0xFF;
        int r = (int)((float)r1 + (float)(r2 - r1) * t);
        int g = (int)((float)g1 + (float)(g2 - g1) * t);
        int b = (int)((float)b1 + (float)(b2 - b1) * t);
        return r << 16 | g << 8 | b;
    }
}

