/*
 * Decompiled with CFR 0.152.
 */
package com.pyding.vp.item.vestiges;

import com.pyding.vp.client.sounds.SoundRegistry;
import com.pyding.vp.item.vestiges.Vestige;
import com.pyding.vp.util.VPUtil;
import java.util.HashMap;
import java.util.Iterator;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import top.theillusivec4.curios.api.SlotContext;

public class Armor
extends Vestige {
    public HashMap<UUID, HashMap<TagKey<DamageType>, Integer>> damageSources = new HashMap();

    @Override
    public void dataInit(int vestigeNumber, ChatFormatting color, int specialCharges, int specialCd, int ultimateCharges, int ultimateCd, int specialMaxTime, int ultimateMaxTime, boolean hasDamage, ItemStack stack) {
        super.dataInit(11, ChatFormatting.RED, 4, 10, 1, 70, 60, 25, true, stack);
    }

    public int getAbsorbPercent(DamageSource source, UUID uuid) {
        Iterator<TagKey<DamageType>> iterator = VPUtil.getTypes(source).iterator();
        if (iterator.hasNext()) {
            TagKey<DamageType> type = iterator.next();
            if (!this.damageSources.containsKey(uuid)) {
                this.damageSources.put(uuid, new HashMap());
            }
            if (!this.damageSources.get(uuid).containsKey(type)) {
                this.damageSources.get(uuid).put(type, 0);
            }
            return this.damageSources.get(uuid).get(type);
        }
        return 0;
    }

    public void increaseAbsorb(DamageSource source, UUID uuid) {
        for (TagKey<DamageType> type : VPUtil.getTypes(source)) {
            if (!this.damageSources.containsKey(uuid)) {
                this.damageSources.put(uuid, new HashMap());
            }
            if (!this.damageSources.get(uuid).containsKey(type)) {
                this.damageSources.get(uuid).put(type, 0);
            }
            this.damageSources.get(uuid).put(type, Math.min(90, this.damageSources.get(uuid).get(type) + 5));
        }
    }

    public void clearDamage(UUID uuid) {
        if (!this.damageSources.containsKey(uuid)) {
            this.damageSources.put(uuid, new HashMap());
        }
        for (TagKey<DamageType> type : this.damageSources.get(uuid).keySet()) {
            this.damageSources.get(uuid).put(type, 0);
        }
    }

    @Override
    public void doSpecial(long seconds, Player player, Level level, ItemStack stack) {
        VPUtil.play((LivingEntity)player, (SoundEvent)SoundRegistry.FLESH.get());
        player.m_7292_(new MobEffectInstance(VPUtil.getRandomEffect(false), 1200));
        player.m_7292_(new MobEffectInstance(VPUtil.getRandomEffect(false), 1200));
        float debuffCount = 0.0f;
        for (MobEffectInstance effectInstance : player.m_21220_()) {
            MobEffect effect = effectInstance.m_19544_();
            if (effect.m_19486_()) continue;
            debuffCount += 1.0f;
        }
        player.m_6469_(player.m_269291_().m_269325_(), VPUtil.scalePower(VPUtil.getAttack(player, true) * (0.3f + debuffCount), 11, player));
        VPUtil.setHealDebt((LivingEntity)player, VPUtil.scalePower(VPUtil.getHealDebt((LivingEntity)player) + (debuffCount + 4.0f) / 4.0f * player.m_21233_() * 0.4f, 11, player));
        if (VPUtil.getHealDebt((LivingEntity)player) > player.m_21233_() * 6.0f) {
            stack.m_41784_().m_128350_("VPArmor", VPUtil.scalePower(Armor.getPain(stack) + 40.0f, 11, player));
            VPUtil.addShield((LivingEntity)player, VPUtil.scalePower(stack.m_41784_().m_128457_("VPArmor") * 0.1f, 11, player), true);
        }
        VPUtil.spawnParticles(player, (ParticleOptions)ParticleTypes.f_123784_, 3.0, 1, 0.0, -0.1, 0.0, 0.0, false);
        super.doSpecial(seconds, player, level, stack);
    }

    @Override
    public void doUltimate(long seconds, Player player, Level level, ItemStack stack) {
        VPUtil.play((LivingEntity)player, (SoundEvent)SoundRegistry.FLESH2.get());
        VPUtil.spawnParticles(player, (ParticleOptions)ParticleTypes.f_123797_, 3.0, 1, 0.0, 0.0, 0.0, 0.0, false);
        super.doUltimate(seconds, player, level, stack);
    }

    @Override
    public void curioTick(SlotContext slotContext, ItemStack stack) {
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (player.f_19797_ % 7000 == 0) {
                this.clearDamage(player.m_20148_());
            }
        }
        super.curioTick(slotContext, stack);
    }

    @Override
    public void ultimateEnds(Player player, ItemStack stack) {
        VPUtil.repairAll(player, (int)Armor.getPain(stack));
        stack.m_41784_().m_128350_("VPArmor", 0.0f);
        super.ultimateEnds(player, stack);
    }

    @Override
    public void curioSucks(Player player, ItemStack stack) {
        stack.m_41784_().m_128350_("VPArmor", 0.0f);
        super.curioSucks(player, stack);
    }

    public static float getPain(ItemStack stack) {
        return stack.m_41784_().m_128457_("VPArmor");
    }
}

