/*
 * Decompiled with CFR 0.152.
 */
package com.pyding.vp.item.vestiges;

import com.pyding.vp.client.sounds.SoundRegistry;
import com.pyding.vp.item.vestiges.Vestige;
import com.pyding.vp.util.VPUtil;
import java.util.Random;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class Killer
extends Vestige {
    @Override
    public void dataInit(int vestigeNumber, ChatFormatting color, int specialCharges, int specialCd, int ultimateCharges, int ultimateCd, int specialMaxTime, int ultimateMaxTime, boolean hasDamage, ItemStack stack) {
        super.dataInit(4, ChatFormatting.YELLOW, 2, 10, 1, 150, 1, 20, true, stack);
    }

    @Override
    public void doSpecial(long seconds, Player player, Level level, ItemStack stack) {
        Random random = new Random();
        if (random.nextDouble() < 0.5) {
            VPUtil.play((LivingEntity)player, (SoundEvent)SoundRegistry.EXPLODE1.get());
        } else {
            VPUtil.play((LivingEntity)player, (SoundEvent)SoundRegistry.EXPLODE2.get());
        }
        int count = 0;
        for (LivingEntity entity : VPUtil.getEntitiesAround(player, 20.0, 20.0, 20.0)) {
            if (VPUtil.isProtectedFromHit(player, (Entity)entity)) continue;
            if (entity.getPersistentData().m_128471_("VPKillerQueen")) {
                ++count;
            }
            VPUtil.dealDamage(entity, player, player.m_269291_().m_269036_((Entity)entity, (Entity)player), VPUtil.scalePower(400, 4, player), 2);
            entity.getPersistentData().m_128379_("VPKillerQueen", true);
            VPUtil.addRadiance(Killer.class, VPUtil.getRadianceSpecial(), player);
        }
        if (count >= 4) {
            VPUtil.addRadiance(Killer.class, 40, player);
        }
        VPUtil.spawnParticles(player, (ParticleOptions)ParticleTypes.f_123813_, 8.0, 1, 0.0, 0.0, 0.0, 0.0, false);
        super.doSpecial(seconds, player, level, stack);
    }

    @Override
    public void doUltimate(long seconds, Player player, Level level, ItemStack stack) {
        VPUtil.play((LivingEntity)player, (SoundEvent)SoundRegistry.MAGIC3.get());
        player.getPersistentData().m_128356_("VPQueenDeath", System.currentTimeMillis() + seconds);
        VPUtil.spawnParticles(player, (ParticleOptions)ParticleTypes.f_123813_, 4.0, 1, 0.0, 0.0, 0.0, 0.0, false);
        super.doUltimate(seconds, player, level, stack);
    }

    @Override
    public void ultimateRecharges(Player player, ItemStack stack) {
        player.getPersistentData().m_128356_("VPQueenDeath", 0L);
        super.ultimateRecharges(player, stack);
    }
}

