/*
 * Decompiled with CFR 0.152.
 */
package com.pyding.vp.item.vestiges;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.pyding.vp.client.sounds.SoundRegistry;
import com.pyding.vp.item.vestiges.Vestige;
import com.pyding.vp.util.ConfigHandler;
import com.pyding.vp.util.VPUtil;
import java.util.Random;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import top.theillusivec4.curios.api.SlotContext;

public class MaskOfDemon
extends Vestige {
    @Override
    public void dataInit(int vestigeNumber, ChatFormatting color, int specialCharges, int specialCd, int ultimateCharges, int radiance, int specialMaxTime, int ultimateMaxTime, boolean hasDamage, ItemStack stack) {
        vestigeNumber = 5;
        color = ChatFormatting.BLUE;
        specialCharges = 1;
        specialCd = 1;
        specialMaxTime = 666;
        ultimateMaxTime = 1;
        ultimateCharges = 1;
        radiance = 95;
        super.dataInit(vestigeNumber, color, specialCharges, specialCd, ultimateCharges, radiance, specialMaxTime, ultimateMaxTime, true, stack);
    }

    private Multimap<Attribute, AttributeModifier> createAttributeMap(Player player, ItemStack stack) {
        HashMultimap attributesDefault = HashMultimap.create();
        double attackMultiplier = VPUtil.scalePower(4, 5, player);
        double speedMultiplier = VPUtil.scalePower(1, 5, player);
        if (MaskOfDemon.isStellar(stack)) {
            attackMultiplier *= 1.5;
            speedMultiplier *= 1.5;
        }
        float missingHealth = VPUtil.missingHealth((LivingEntity)player);
        if (MaskOfDemon.isStellar(stack)) {
            missingHealth *= 2.0f;
        }
        float attackScale = (float)((double)missingHealth * attackMultiplier + 1.0) / 100.0f;
        float speedScale = (float)((double)missingHealth * speedMultiplier + 1.0) / 100.0f;
        attributesDefault.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(UUID.fromString("ec62548c-5b26-401e-83fd-693e4aafa532"), "vp:attack_speed_modifier", (double)attackScale, AttributeModifier.Operation.MULTIPLY_TOTAL));
        attributesDefault.put((Object)Attributes.f_22279_, (Object)new AttributeModifier(UUID.fromString("f4ece564-d2c0-40d2-a96a-dc68b493137c"), "vp:speed_modifier", (double)speedScale, AttributeModifier.Operation.MULTIPLY_BASE));
        return attributesDefault;
    }

    @Override
    public void curioTick(SlotContext slotContext, ItemStack stack) {
        Player player = (Player)slotContext.entity();
        if (player.m_20193_().f_46443_) {
            return;
        }
        if (this.isSpecialActive(stack)) {
            boolean hurt = false;
            if (player.f_19797_ % 20 == 0) {
                if (VPUtil.getHealDebt((LivingEntity)player) > player.m_21233_() * (float)((Integer)ConfigHandler.COMMON.maskRotAmount.get()).intValue() / 100.0f + 1.0f) {
                    VPUtil.setHealDebt((LivingEntity)player, Math.max(0.0f, VPUtil.getHealDebt((LivingEntity)player) - player.m_21233_() * (float)((Integer)ConfigHandler.COMMON.maskRotAmount.get()).intValue() / 100.0f + 1.0f));
                    hurt = true;
                } else if (player.m_21223_() > player.m_21233_() * (float)((Integer)ConfigHandler.COMMON.maskRotAmount.get()).intValue() / 100.0f + 1.0f) {
                    VPUtil.dealParagonDamage((LivingEntity)player, player, VPUtil.scalePower(player.m_21233_() * (float)((Integer)ConfigHandler.COMMON.maskRotAmount.get()).intValue() / 100.0f, 5, player), 0, false);
                    hurt = true;
                }
                player.m_21204_().m_22178_(this.createAttributeMap(player, stack));
            }
            float missingHealth = VPUtil.scalePower(VPUtil.missingHealth((LivingEntity)player), 5, player);
            if (MaskOfDemon.isStellar(stack)) {
                missingHealth *= 2.0f;
            }
            for (LivingEntity entity : VPUtil.getEntities(player, 30.0, false)) {
                if (VPUtil.isProtectedFromHit(player, (Entity)entity)) continue;
                CompoundTag tag = entity.getPersistentData();
                if (tag == null) {
                    tag = new CompoundTag();
                }
                tag.m_128350_("VPHealResMask", 0.0f - missingHealth);
                if (MaskOfDemon.isStellar(stack)) {
                    tag.m_128379_("MaskStellar", true);
                }
                if (hurt && MaskOfDemon.isStellar(stack) && (double)player.m_21223_() <= (double)player.m_21233_() * 0.5) {
                    VPUtil.dealParagonDamage(entity, player, VPUtil.scalePower(player.m_21233_() * (float)((Integer)ConfigHandler.COMMON.maskRotAmount.get()).intValue() / 100.0f, 5, player), 1, false);
                    VPUtil.spawnParticles((Entity)player, (ParticleOptions)ParticleTypes.f_123798_, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), 1, 0.0, 0.1, 0.0);
                }
                entity.getPersistentData().m_128391_(tag);
            }
            player.getPersistentData().m_128350_("VPHealResMask", 0.0f - missingHealth);
        } else {
            player.m_21204_().m_22161_(this.createAttributeMap(player, stack));
        }
        super.curioTick(slotContext, stack);
    }

    @Override
    public int setSpecialActive(long seconds, Player player, ItemStack stack) {
        if (this.isSpecialActive(stack) && !player.m_20193_().f_46443_) {
            if (this.currentChargeSpecial(stack) > 0) {
                if (!player.m_20193_().f_46443_) {
                    this.setTime(1L, stack);
                    this.setSpecialActive(true, stack);
                    this.setCdSpecialActive(this.cdSpecialActive(stack) + this.specialCd(stack), stack);
                    Random random = new Random();
                    if (VPUtil.getSet(player) != 3 || !(random.nextDouble() < VPUtil.getChance(0.3, player)) || VPUtil.getSet(player) != 6 || !(random.nextDouble() < VPUtil.getChance(0.5, player)) || random.nextDouble() < VPUtil.getChance(player.getPersistentData().m_128457_("VPDepth") / 10.0f, player)) {
                        this.setCurrentChargeSpecial(this.currentChargeSpecial(stack) - 1, stack);
                    }
                    if (this.damageType == null) {
                        this.init(stack);
                    }
                    this.doSpecial(seconds, player, player.m_20193_(), stack);
                    if (VPUtil.hasCurse(player, 3)) {
                        player.getPersistentData().m_128356_("VPForbidden", System.currentTimeMillis() + 3000L);
                    }
                } else {
                    this.localSpecial(player);
                }
            }
            return 0;
        }
        return super.setSpecialActive(seconds, player, stack);
    }

    @Override
    public void doSpecial(long seconds, Player player, Level level, ItemStack stack) {
        VPUtil.play((LivingEntity)player, (SoundEvent)SoundRegistry.STOLAS1.get());
        VPUtil.spawnParticles(player, (ParticleOptions)ParticleTypes.f_123808_, 8.0, 1, 0.0, -0.1, 0.0, 1.0, false);
        super.doSpecial(seconds, player, level, stack);
    }

    @Override
    public void doUltimate(long seconds, Player player, Level level, ItemStack stack) {
        VPUtil.play((LivingEntity)player, (SoundEvent)SoundRegistry.IMPACT.get());
        float damage = VPUtil.scalePower(300, 5, player);
        float healDebt = VPUtil.scalePower(player.m_21233_() * 3.0f, 5, player);
        if ((double)player.m_21223_() <= (double)player.m_21233_() * 0.5) {
            damage *= 2.0f;
            healDebt *= 2.0f;
        }
        VPUtil.setHealDebt((LivingEntity)player, VPUtil.getHealDebt((LivingEntity)player) + healDebt);
        for (LivingEntity entity : VPUtil.ray(player, 8.0f, 60, false)) {
            if (VPUtil.isProtectedFromHit(player, (Entity)entity)) continue;
            VPUtil.setHealDebt(entity, VPUtil.getHealDebt(entity) + healDebt);
            VPUtil.dealDamage(entity, player, player.m_269291_().m_269285_((Entity)player), damage, 3);
            VPUtil.addRadiance(MaskOfDemon.class, VPUtil.getRadianceUltimate(), player);
            VPUtil.spawnParticles((Entity)player, (ParticleOptions)ParticleTypes.f_235902_, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), 1, 0.0, -0.1, 0.0);
        }
        super.doUltimate(seconds, player, level, stack);
    }
}

