/*
 * Decompiled with CFR 0.152.
 */
package com.pyding.vp.item.vestiges;

import com.pyding.vp.item.vestiges.Vestige;
import com.pyding.vp.util.ConfigHandler;
import com.pyding.vp.util.VPUtil;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.level.Level;
import top.theillusivec4.curios.api.SlotContext;

public class Treasure
extends Vestige {
    @Override
    public void dataInit(int vestigeNumber, ChatFormatting color, int specialCharges, int specialCd, int ultimateCharges, int ultimateCd, int specialMaxTime, int ultimateMaxTime, boolean hasDamage, ItemStack stack) {
        super.dataInit(26, ChatFormatting.GOLD, 2, 60, 1, 50, 30, 10, hasDamage, stack);
    }

    @Override
    public void doSpecial(long seconds, Player player, Level level, ItemStack stack) {
        super.doSpecial(seconds, player, level, stack);
    }

    @Override
    public void doUltimate(long seconds, Player player, Level level, ItemStack stack) {
        super.doUltimate(seconds, player, level, stack);
    }

    @Override
    public void curioTick(SlotContext slotContext, ItemStack stack) {
        super.curioTick(slotContext, stack);
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (player.m_21205_().m_41720_() instanceof PickaxeItem || player.m_21206_().m_41720_() instanceof PickaxeItem) {
                float armor = VPUtil.scalePower(Treasure.getOres(player) / 20.0f, 26, player);
                float tough = VPUtil.scalePower(Treasure.getMinerals(player) / 32.0f, 26, player);
                player.m_21204_().m_22178_(VPUtil.createAttributeMap((LivingEntity)player, Attributes.f_22284_, UUID.fromString("e6fdfccb-e294-481c-bd65-f464a9982e3f"), armor, AttributeModifier.Operation.ADDITION, "vp.treasure.armor"));
                player.m_21204_().m_22178_(VPUtil.createAttributeMap((LivingEntity)player, Attributes.f_22285_, UUID.fromString("c692ceea-e05b-441f-8c98-0ff7842fa89e"), tough, AttributeModifier.Operation.ADDITION, "vp.treasure.armor"));
            } else if (player.m_21204_().m_22154_(Attributes.f_22284_, UUID.fromString("e6fdfccb-e294-481c-bd65-f464a9982e3f"))) {
                player.m_21204_().m_22161_(VPUtil.createAttributeMap((LivingEntity)player, Attributes.f_22284_, UUID.fromString("e6fdfccb-e294-481c-bd65-f464a9982e3f"), 0.0f, AttributeModifier.Operation.ADDITION, "vp.treasure.armor"));
                player.m_21204_().m_22161_(VPUtil.createAttributeMap((LivingEntity)player, Attributes.f_22285_, UUID.fromString("c692ceea-e05b-441f-8c98-0ff7842fa89e"), 0.0f, AttributeModifier.Operation.ADDITION, "vp.treasure.armor"));
            }
        }
    }

    @Override
    public void curioSucks(Player player, ItemStack stack) {
        super.curioSucks(player, stack);
        if (player.m_21204_().m_22154_(Attributes.f_22284_, UUID.fromString("e6fdfccb-e294-481c-bd65-f464a9982e3f"))) {
            player.m_21204_().m_22161_(VPUtil.createAttributeMap((LivingEntity)player, Attributes.f_22284_, UUID.fromString("e6fdfccb-e294-481c-bd65-f464a9982e3f"), 0.0f, AttributeModifier.Operation.ADDITION, "vp.treasure.armor"));
            player.m_21204_().m_22161_(VPUtil.createAttributeMap((LivingEntity)player, Attributes.f_22285_, UUID.fromString("c692ceea-e05b-441f-8c98-0ff7842fa89e"), 0.0f, AttributeModifier.Operation.ADDITION, "vp.treasure.armor"));
        }
    }

    public static float getOres(Player player) {
        float ores = 0.0f;
        for (ItemStack stack : player.m_150109_().f_35974_) {
            if (!VPUtil.getOres().contains(stack.m_41778_())) continue;
            ores += (float)stack.m_41613_();
        }
        return ores;
    }

    public static float getMinerals(Player player) {
        float ores = 0.0f;
        for (ItemStack stack : player.m_150109_().f_35974_) {
            for (String name : ConfigHandler.COMMON.mineralCluster.get().toString().split(",")) {
                if (!stack.m_41778_().equals(name)) continue;
                ores += (float)stack.m_41613_();
            }
        }
        return ores;
    }
}

