/*
 * Decompiled with CFR 0.152.
 */
package com.pyding.vp.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.pyding.vp.mixin.SmitingMixing;
import com.pyding.vp.util.ClientConfig;
import com.pyding.vp.util.ConfigHandler;
import com.pyding.vp.util.VPUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.RecordItem;
import net.minecraft.world.item.SmithingTemplateItem;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ChallengeScreen
extends Screen {
    private List<ItemStack> list = new ArrayList<ItemStack>();
    private float time;
    private static final ResourceLocation COMMON_TEXTURE = new ResourceLocation("vp", "textures/item/common.png");
    int startY = 0;
    private Button zoomInButton;
    private Button zoomOutButton;
    private int challenge;
    Object[] data;

    public ChallengeScreen(int challenge, List<ItemStack> list, Object[] data) {
        super((Component)Component.m_237119_());
        this.challenge = challenge;
        this.list = list;
        this.data = data;
    }

    protected void m_7856_() {
        super.m_7856_();
        int buttonSize = 32;
        int padding = 5;
        int right = this.f_96543_ - padding - buttonSize;
        int top = this.f_96544_ - padding - buttonSize;
        this.zoomInButton = new ImageButton(right - buttonSize - padding, top, buttonSize, buttonSize, 0, 0, 0, new ResourceLocation("vp", "textures/gui/zoom-in.png"), buttonSize, buttonSize, button -> ClientConfig.COMMON.guiScaleChallenge.set((Object)Math.min(2.0, (Double)ClientConfig.COMMON.guiScaleChallenge.get() + 0.1)));
        this.zoomOutButton = new ImageButton(right, top, buttonSize, buttonSize, 0, 0, 0, new ResourceLocation("vp", "textures/gui/zoom-out.png"), buttonSize, buttonSize, button -> ClientConfig.COMMON.guiScaleChallenge.set((Object)Math.max(0.1, (Double)ClientConfig.COMMON.guiScaleChallenge.get() - 0.1)));
        this.m_142416_((GuiEventListener)this.zoomInButton);
        this.m_142416_((GuiEventListener)this.zoomOutButton);
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(guiGraphics);
        this.time += partialTicks * 0.05f;
        float scaleMultiplier = (float)((Double)ClientConfig.COMMON.guiScaleChallenge.get() + 0.0);
        float scale = 1.5f * scaleMultiplier;
        int scaledItemSize = (int)(16.0f * scale);
        int itemSpacing = (int)((float)(scaledItemSize + 2) * scale);
        int lineSpacing = (int)((float)(scaledItemSize * 2 + 2) * scale);
        int textOffsetY = (int)(20.0f * scale);
        int startX = scaledItemSize;
        this.startY = scaledItemSize;
        MutableComponent component = this.challenge == 13 ? Component.m_237110_((String)("vp.get." + this.challenge), (Object[])new Object[]{(Double)ConfigHandler.COMMON.rareItemChance.get() * 100.0 + "%"}).m_7220_((Component)Component.m_237113_((String)((String)this.data[1]))).m_130940_(ChatFormatting.GRAY) : Component.m_237115_((String)("vp.get." + this.challenge)).m_7220_((Component)Component.m_237113_((String)((String)this.data[1]))).m_130940_(ChatFormatting.GRAY);
        if (this.challenge != 9) {
            guiGraphics.m_280653_(this.f_96547_, (Component)component, this.f_96543_ / 2, 10, 0xFFFFFF);
        }
        int screenWidth = Minecraft.m_91087_().m_91268_().m_85445_();
        if (this.challenge == 9) {
            component = Component.m_237115_((String)"vp.golden").m_130940_(ChatFormatting.GRAY).m_7220_((Component)Component.m_237113_((String)(String.valueOf(this.data[0]) + "%")).m_7220_((Component)Component.m_237113_((String)((String)this.data[1]))).m_130940_(ChatFormatting.GRAY));
            this.renderCategory(guiGraphics, component.getString(), ChatFormatting.GRAY, this.list, startX, this.startY, screenWidth, scaledItemSize, itemSpacing, lineSpacing, textOffsetY, scale);
        } else {
            this.renderCategory(guiGraphics, Component.m_237115_((String)"vp.left").getString(), ChatFormatting.GRAY, this.list, startX, this.startY, screenWidth, scaledItemSize, itemSpacing, lineSpacing, textOffsetY, scale);
        }
        this.startY += this.f_96543_ / 12;
        if (this.challenge == 24) {
            guiGraphics.m_280488_(Minecraft.m_91087_().f_91062_, Component.m_237115_((String)"vp.tropic").getString(), startX, this.startY, ChatFormatting.BLUE.m_126665_().intValue());
            this.startY += this.f_96543_ / 30;
            guiGraphics.m_280488_(Minecraft.m_91087_().f_91062_, (String)this.data[2], startX, this.startY, ChatFormatting.GRAY.m_126665_().intValue());
            this.startY += this.f_96543_ / 12;
            guiGraphics.m_280488_(Minecraft.m_91087_().f_91062_, Component.m_237115_((String)"vp.axolotl").getString(), startX, this.startY, ChatFormatting.BLUE.m_126665_().intValue());
            this.startY += this.f_96543_ / 30;
            guiGraphics.m_280488_(Minecraft.m_91087_().f_91062_, (String)this.data[0], startX, this.startY, ChatFormatting.GRAY.m_126665_().intValue());
        }
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
    }

    private void renderCategory(GuiGraphics guiGraphics, String title, ChatFormatting color, List<ItemStack> items, int startX, int startY, int screenWidth, int itemSize, int itemSpacing, int lineSpacing, int textOffsetY, float scale) {
        Font font = Minecraft.m_91087_().f_91062_;
        int currentX = startX;
        int currentY = startY + (int)(10.0f * scale);
        int maxInRow = (screenWidth - startX - itemSize) / (itemSize + itemSpacing);
        guiGraphics.m_280488_(font, title, startX, startY, color.m_126665_().intValue());
        for (int i = 0; i < items.size(); ++i) {
            ItemStack stack = items.get(i);
            if (i > 0 && i % maxInRow == 0) {
                currentX = startX;
                currentY += lineSpacing;
            }
            PoseStack poseStack = guiGraphics.m_280168_();
            poseStack.m_85836_();
            poseStack.m_252880_((float)currentX, (float)currentY, 100.0f);
            poseStack.m_85841_(scale, scale, 1.0f);
            guiGraphics.m_280480_(stack, 0, 0);
            poseStack.m_85849_();
            ChallengeScreen.renderBack(guiGraphics, (float)currentX + (float)itemSize / 2.0f, (float)currentY + (float)itemSize / 2.0f, 0.0f, this.time, scale / 2.0f, itemSize);
            Component name = VPUtil.filterAndTranslate(stack.m_41778_(), color);
            Item item = stack.m_41720_();
            if (item instanceof SmithingTemplateItem) {
                SmithingTemplateItem templateItem = (SmithingTemplateItem)item;
                name = ((SmitingMixing)templateItem).upgradeDescription();
            } else {
                item = stack.m_41720_();
                if (item instanceof RecordItem) {
                    RecordItem recordItem = (RecordItem)item;
                    name = recordItem.m_43050_();
                }
            }
            int maxWidth = (int)((float)(itemSpacing - 8) * scale);
            List lines = font.m_92923_((FormattedText)name, maxWidth);
            int textY = currentY + textOffsetY;
            for (FormattedCharSequence line : lines) {
                int textX = currentX + itemSize / 2 - font.m_92724_(line) / 2;
                guiGraphics.m_280648_(font, line, textX, textY, color.m_126665_().intValue());
                Objects.requireNonNull(font);
                textY += 9 + 2;
            }
            currentX += itemSize + itemSpacing;
        }
        this.startY = currentY;
    }

    public static void renderBack(GuiGraphics guiGraphics, float centerX, float centerY, float zOffset, float time, float baseScale, int size) {
        PoseStack poseStack = guiGraphics.m_280168_();
        float scale = baseScale + Mth.m_14031_((float)(time * (float)Math.PI * 3.0f)) * 0.2f;
        float alpha = 1.0f + Mth.m_14031_((float)(time * (float)Math.PI * 3.0f)) * 0.3f;
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        poseStack.m_85836_();
        poseStack.m_252880_(centerX, centerY, zOffset);
        poseStack.m_85841_(scale, scale, 1.0f);
        poseStack.m_252781_(Axis.f_252403_.m_252977_(time * 240.0f));
        guiGraphics.m_280163_(COMMON_TEXTURE, -size / 2, -size / 2, 0.0f, 0.0f, size, size, size, size);
        poseStack.m_85849_();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
    }

    public void m_280273_(GuiGraphics guiGraphics) {
        guiGraphics.m_280024_(0, 0, this.f_96543_, this.f_96544_, Integer.MIN_VALUE, Integer.MIN_VALUE);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 69 || keyCode == 87 || keyCode == 65 || keyCode == 83 || keyCode == 68 || keyCode == 256 || keyCode == 32) {
            this.m_7379_();
            return true;
        }
        return true;
    }
}

