/*
 * Decompiled with CFR 0.152.
 */
package com.pyding.vp.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.pyding.vp.util.ClientConfig;
import com.pyding.vp.util.GradientUtil;
import com.pyding.vp.util.LeaderboardUtil;
import com.pyding.vp.util.VPUtil;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class LeaderboardScreen
extends Screen {
    private static final ResourceLocation FRAME = new ResourceLocation("vp", "textures/gui/leaderboard.png");
    private static final ResourceLocation SCROLL = new ResourceLocation("vp", "textures/gui/scroll.png");
    long time = 0L;
    String text = "";
    private int scrollOffset = 0;

    public LeaderboardScreen() {
        super((Component)Component.m_237119_());
    }

    protected void m_7856_() {
        super.m_7856_();
        CompletableFuture.runAsync(() -> {
            this.text = VPUtil.filterString(LeaderboardUtil.getAll());
        });
        int buttonSize = 32;
        int padding = 5;
        int top = this.f_96544_ - padding - buttonSize;
        this.time = System.currentTimeMillis();
        int right = this.f_96543_ - padding - buttonSize;
        ImageButton zoomInButton = new ImageButton(right - buttonSize - padding, top, buttonSize, buttonSize, 0, 0, 0, new ResourceLocation("vp", "textures/gui/zoom-in.png"), buttonSize, buttonSize, button -> ClientConfig.COMMON.guiScaleLeaderboard.set((Object)Math.min(2.0, (Double)ClientConfig.COMMON.guiScaleLeaderboard.get() + 0.1)));
        ImageButton zoomOutButton = new ImageButton(right, top, buttonSize, buttonSize, 0, 0, 0, new ResourceLocation("vp", "textures/gui/zoom-out.png"), buttonSize, buttonSize, button -> ClientConfig.COMMON.guiScaleLeaderboard.set((Object)Math.max(0.1, (Double)ClientConfig.COMMON.guiScaleLeaderboard.get() - 0.1)));
        this.m_142416_((GuiEventListener)zoomInButton);
        this.m_142416_((GuiEventListener)zoomOutButton);
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(guiGraphics);
        double scale = (Double)ClientConfig.COMMON.guiScaleLeaderboard.get();
        int infoWidth = (int)(512.0 * scale);
        int infoHeight = (int)(512.0 * scale);
        int x = this.f_96543_ / 2 - infoWidth / 2;
        int y = this.f_96544_ / 2 - infoHeight / 2;
        guiGraphics.m_280163_(FRAME, x, y, 0.0f, 0.0f, infoWidth, infoHeight, infoWidth, infoHeight);
        guiGraphics.m_280163_(SCROLL, this.f_96543_ / 2 + infoWidth / 2, this.f_96544_ / 2 - infoHeight / 6 + 35, 0.0f, 0.0f, infoWidth / 4, infoHeight / 4, infoWidth / 4, infoHeight / 4);
        String[] names = this.text.split(",");
        Font font = this.f_96547_;
        float textScale = 1.5f;
        Objects.requireNonNull(font);
        int lineHeight = (int)((float)(9 + 4) * textScale);
        int visibleAreaHeight = infoHeight - infoHeight / 2 - 120;
        int totalHeight = names.length * lineHeight;
        int maxScroll = Math.max(0, totalHeight - visibleAreaHeight);
        this.scrollOffset = Math.max(0, Math.min(this.scrollOffset, maxScroll));
        int textStartY = y + infoHeight / 4 + 90;
        int textCenterX = x + infoWidth / 2;
        this.enableScissor(x + 10, y, infoWidth - 25, infoHeight - infoHeight / 4 - 25);
        PoseStack pose = guiGraphics.m_280168_();
        pose.m_85836_();
        pose.m_85841_(textScale, textScale, 1.0f);
        int startIndex = this.scrollOffset / lineHeight;
        int endIndex = Math.min(names.length, startIndex + visibleAreaHeight / lineHeight + 1);
        for (int i = startIndex; i < endIndex; ++i) {
            String name = names[i].trim();
            int textWidth = font.m_92895_(name);
            int textX = (int)(((float)textCenterX - (float)textWidth * textScale / 2.0f) / textScale);
            int textY = (int)((float)(textStartY + i * lineHeight - this.scrollOffset) / textScale);
            if (i < 10) {
                guiGraphics.m_280614_(font, GradientUtil.goldenGradient(name.replaceAll("^\"|\"$", "")), textX, textY, 0xFFFFFF, false);
                continue;
            }
            guiGraphics.m_280056_(font, name, textX, textY, 0xFFFFFF, false);
        }
        pose.m_85849_();
        RenderSystem.disableScissor();
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        int scrollSpeed = 15;
        this.scrollOffset = (int)((double)this.scrollOffset - delta * (double)scrollSpeed);
        return true;
    }

    private void enableScissor(int x, int y, int width, int height) {
        double guiScale = Minecraft.m_91087_().m_91268_().m_85449_();
        int screenHeight = Minecraft.m_91087_().m_91268_().m_85444_();
        RenderSystem.enableScissor((int)((int)((double)x * guiScale)), (int)((int)((double)screenHeight - (double)(y + height) * guiScale)), (int)((int)((double)width * guiScale)), (int)((int)((double)height * guiScale)));
    }

    public void m_280273_(GuiGraphics guiGraphics) {
        guiGraphics.m_280024_(0, 0, this.f_96543_, this.f_96544_, Integer.MIN_VALUE, Integer.MIN_VALUE);
    }

    public boolean m_7043_() {
        return false;
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 69 || keyCode == 87 || keyCode == 65 || keyCode == 83 || keyCode == 68 || keyCode == 256 || keyCode == 32) {
            this.m_7379_();
            return true;
        }
        return true;
    }

    public void m_7379_() {
        super.m_7379_();
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
    }
}

