/*
 * Decompiled with CFR 0.152.
 */
package com.pyding.vp.entity;

import com.pyding.vp.client.sounds.SoundRegistry;
import com.pyding.vp.entity.ModEntities;
import com.pyding.vp.item.vestiges.Atlas;
import com.pyding.vp.network.PacketHandler;
import com.pyding.vp.network.packets.SendEntityNbtToClient;
import com.pyding.vp.network.packets.SuckPacket;
import com.pyding.vp.util.ConfigHandler;
import com.pyding.vp.util.VPUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.network.PacketDistributor;

public class BlackHole
extends Projectile {
    private static final EntityDataAccessor<Float> DATA_RADIUS = SynchedEntityData.m_135353_(BlackHole.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    float gravity;
    BlockPos pos;
    int ticks;
    public ServerPlayer serverPlayer;
    private static final int loopSoundDurationInTicks = 120;

    public BlackHole(EntityType<? extends Projectile> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public BlackHole(Level pLevel, LivingEntity owner, float gravitation, BlockPos position, int time) {
        this((EntityType<? extends Projectile>)((EntityType)ModEntities.BLACK_HOLE.get()), pLevel);
        this.gravity = gravitation;
        this.pos = position;
        this.m_5602_((Entity)owner);
        this.serverPlayer = (ServerPlayer)this.m_19749_();
        this.getPersistentData().m_128350_("VPGravity", gravitation);
        this.ticks = time;
        VPUtil.syncEntity((Entity)this);
    }

    public void m_6210_() {
        super.m_6210_();
        this.m_20011_(new AABB(this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_20185_() + 1.0, this.m_20186_() + 1.0, this.m_20189_() + 1.0));
        this.m_142242_();
    }

    public void m_7350_(EntityDataAccessor<?> pKey) {
        if (DATA_RADIUS.equals(pKey)) {
            this.m_6210_();
        }
        super.m_7350_(pKey);
    }

    public EntityDimensions m_6972_(Pose pPose) {
        return EntityDimensions.m_20395_((float)((1.0f + this.gravity) * 2.0f), (float)((1.0f + this.gravity) * 2.0f));
    }

    protected void m_8097_() {
        this.m_20088_().m_135372_(DATA_RADIUS, (Object)Float.valueOf(5.0f));
    }

    public void m_8119_() {
        super.m_8119_();
        float gravity = this.getPersistentData().m_128457_("VPGravity") / 2.0f + 15.0f;
        double r = gravity + 1.0f;
        boolean despawn = (double)this.f_19797_ > 20.0 * (r / 4.0);
        Player player = (Player)this.m_19749_();
        if (player == null) {
            return;
        }
        if (this.f_19797_ <= 2 && !this.m_20193_().f_46443_) {
            PacketHandler.sendToClients(PacketDistributor.TRACKING_ENTITY.with(() -> this), new SendEntityNbtToClient(this.getPersistentData(), this.m_19879_()));
        }
        this.getPersistentData().m_128356_("VPAntiTP", System.currentTimeMillis() + 10000L);
        this.m_146915_(true);
        for (LivingEntity entity : this.m_20193_().m_45976_(LivingEntity.class, new AABB(this.m_20185_() + r, this.m_20186_() + r, this.m_20189_() + r, this.m_20185_() - r, this.m_20186_() - r, this.m_20189_() - r))) {
            if (entity.m_20148_() == player.m_20148_() || VPUtil.isProtectedFromHit(player, (Entity)entity)) continue;
            if (!VPUtil.isProtectedFromHit(player, (Entity)entity)) {
                VPUtil.suckToPos((Entity)entity, this.m_20183_(), r / (double)(entity.m_20270_((Entity)this) * 2.0f));
            }
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer1 = (ServerPlayer)entity;
                PacketHandler.sendToClient(new SuckPacket((float)(r / (double)(entity.m_20270_((Entity)this) * 2.0f)), this.m_20183_()), serverPlayer1);
            }
            if (!(entity.m_20270_((Entity)this) <= Math.max(10.0f, gravity - 10.0f)) || this.f_19797_ % (Integer)ConfigHandler.COMMON.blackhole.get() != 0) continue;
            VPUtil.dealDamage(entity, player, player.m_269291_().m_269341_(), VPUtil.scalePower(10.0f / entity.m_20270_((Entity)this), 3, player), 3);
            VPUtil.addRadiance(Atlas.class, 1, player);
        }
        if (!this.m_20193_().f_46443_) {
            if (despawn) {
                this.m_146870_();
                for (LivingEntity entity : this.m_20193_().m_45976_(LivingEntity.class, new AABB(this.m_20185_() + r, this.m_20186_() + r, this.m_20189_() + r, this.m_20185_() - r, this.m_20186_() - r, this.m_20189_() - r))) {
                    if (entity.m_20148_() == player.m_20148_() || VPUtil.isProtectedFromHit(player, (Entity)entity) || !(entity.m_20270_((Entity)this) <= Math.max(20.0f, gravity + 10.0f))) continue;
                    VPUtil.dealParagonDamage(entity, player, VPUtil.scalePower(10.0f / (entity.m_20270_((Entity)this) + 1.0f) * (gravity * 10.0f), 3, player), 3, true);
                }
                VPUtil.spawnParticles(player, (ParticleOptions)ParticleTypes.f_123813_, r, 20, 0.0, 0.0, 0.0, 0.0, false);
            }
            if ((this.f_19797_ - 1) % 120 == 0) {
                this.m_5496_((SoundEvent)SoundRegistry.BLACK_HOLE.get(), gravity, 1.0f);
            }
            VPUtil.syncEntity((Entity)this);
        }
        if (despawn) {
            this.m_146870_();
        }
    }

    public boolean m_6051_() {
        return false;
    }
}

