/*
 * Decompiled with CFR 0.152.
 */
package com.pyding.vp.item.accessories;

import com.pyding.vp.client.sounds.SoundRegistry;
import com.pyding.vp.item.vestiges.Vestige;
import com.pyding.vp.util.VPUtil;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

public class Accessory
extends Item
implements ICurioItem {
    public Accessory() {
        super(new Item.Properties().m_41487_(1));
    }

    public Accessory(Item.Properties properties) {
        super(properties);
    }

    public void init(ItemStack stack, Player player) {
        Random random = new Random();
        int type = random.nextInt(5) + 1;
        stack.m_41784_().m_128405_("VPLvl", 0);
        stack.m_41784_().m_128405_("VPType", type);
        switch (type) {
            case 1: {
                stack.m_41784_().m_128350_("VPStat", (float)(VPUtil.getChance(random.nextDouble(), player) * 3.0 + 1.0));
                break;
            }
            case 2: {
                stack.m_41784_().m_128350_("VPStat", (float)(VPUtil.getChance(random.nextDouble(), player) * 6.0 + 2.0));
                break;
            }
            case 3: {
                stack.m_41784_().m_128350_("VPStat", (float)(VPUtil.getChance(random.nextDouble(), player) * 15.0 + 5.0));
                break;
            }
            case 4: {
                stack.m_41784_().m_128350_("VPStat", (float)(VPUtil.getChance(random.nextDouble(), player) * 9.0 + 3.0));
                break;
            }
            case 5: {
                stack.m_41784_().m_128350_("VPStat", (float)(VPUtil.getChance(random.nextDouble(), player) * 12.0 + 4.0));
                break;
            }
        }
    }

    public boolean lvlUp(ItemStack stack, Player player) {
        Random random;
        double baseChance = 0.9;
        int lvl = this.getLvl(stack);
        if (lvl > 0) {
            for (int i = 0; i < lvl; ++i) {
                baseChance *= 0.8;
            }
        }
        if ((random = new Random()).nextDouble() < VPUtil.getChance(baseChance, player)) {
            VPUtil.play((LivingEntity)player, (SoundEvent)SoundRegistry.RUNE1.get());
            stack.m_41784_().m_128405_("VPLvl", lvl + 1);
            switch (Accessory.getType(stack)) {
                case 1: {
                    stack.m_41784_().m_128350_("VPStat", this.getStatAmount(stack) + (float)(VPUtil.getChance(random.nextDouble(), player) * 3.0 + 1.0));
                    break;
                }
                case 2: {
                    stack.m_41784_().m_128350_("VPStat", this.getStatAmount(stack) + (float)(VPUtil.getChance(random.nextDouble(), player) * 6.0 + 2.0));
                    break;
                }
                case 3: {
                    stack.m_41784_().m_128350_("VPStat", this.getStatAmount(stack) + (float)(VPUtil.getChance(random.nextDouble(), player) * 15.0 + 5.0));
                    break;
                }
                case 4: {
                    stack.m_41784_().m_128350_("VPStat", this.getStatAmount(stack) + (float)(VPUtil.getChance(random.nextDouble(), player) * 9.0 + 3.0));
                    break;
                }
                case 5: {
                    stack.m_41784_().m_128350_("VPStat", this.getStatAmount(stack) + (float)(VPUtil.getChance(random.nextDouble(), player) * 12.0 + 4.0));
                    break;
                }
            }
            return true;
        }
        VPUtil.play((LivingEntity)player, (SoundEvent)SoundRegistry.RUNE2.get());
        return false;
    }

    public int getLvl(ItemStack stack) {
        return stack.m_41784_().m_128451_("VPLvl");
    }

    public static int getType(ItemStack stack) {
        return stack.m_41784_().m_128451_("VPType");
    }

    public float getStatAmount(ItemStack stack) {
        return stack.m_41784_().m_128457_("VPStat");
    }

    public void onEquip(SlotContext slotContext, ItemStack prevStack, ItemStack stack) {
        Player player = (Player)slotContext.entity();
        List<ItemStack> list = VPUtil.getVestigeList(player);
        for (ItemStack itemStack : list) {
            Item item = itemStack.m_41720_();
            if (!(item instanceof Vestige)) continue;
            Vestige vestige = (Vestige)item;
            vestige.applyBonus(stack, player);
        }
        this.refreshStats(player);
        super.onEquip(slotContext, prevStack, stack);
    }

    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        Player player = (Player)slotContext.entity();
        List<ItemStack> list = VPUtil.getVestigeList(player);
        for (ItemStack itemStack : list) {
            Item item = itemStack.m_41720_();
            if (!(item instanceof Vestige)) continue;
            Vestige vestige = (Vestige)item;
            vestige.curioSucks(player, itemStack);
        }
        this.refreshStats(player);
        super.onUnequip(slotContext, newStack, stack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> components, TooltipFlag flag) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        int set = VPUtil.getSet((Player)player);
        if (Screen.m_96638_()) {
            components.add((Component)Component.m_237115_((String)"vp.acs.types"));
        } else if (Screen.m_96637_()) {
            components.add((Component)Component.m_237115_((String)"vp.acs.sets").m_130940_(ChatFormatting.DARK_PURPLE));
            for (int i = 1; i < 11; ++i) {
                if (set > 0 && set == i) {
                    components.add((Component)Component.m_237115_((String)("vp.acs.set." + i)).m_130940_(ChatFormatting.GREEN));
                    continue;
                }
                components.add((Component)Component.m_237115_((String)("vp.acs.set." + i)).m_130940_(ChatFormatting.GRAY));
            }
        } else if (Screen.m_96639_()) {
            components.add((Component)Component.m_237115_((String)"vp.acs.upgrade"));
        } else {
            components.add((Component)Component.m_237115_((String)"vp.acs.lvl").m_7220_((Component)Component.m_237113_((String)(" " + this.getLvl(stack))).m_130940_(ChatFormatting.LIGHT_PURPLE)).m_130940_(ChatFormatting.DARK_PURPLE));
            if (Accessory.getType(stack) > 0) {
                if (Accessory.getType(stack) < 3) {
                    components.add((Component)Component.m_237115_((String)"vp.acs.stats").m_130940_(ChatFormatting.DARK_PURPLE).m_7220_((Component)Component.m_237113_((String)(" +" + String.format("%.1f", Float.valueOf(this.getStatAmount(stack))))).m_7220_((Component)Component.m_237115_((String)("vp.acs.stats." + Accessory.getType(stack)))).m_130940_(ChatFormatting.LIGHT_PURPLE)));
                } else {
                    components.add((Component)Component.m_237115_((String)"vp.acs.stats").m_130940_(ChatFormatting.DARK_PURPLE).m_7220_((Component)Component.m_237113_((String)(" +" + String.format("%.1f", Float.valueOf(this.getStatAmount(stack))) + "%")).m_7220_((Component)Component.m_237115_((String)("vp.acs.stats." + Accessory.getType(stack)))).m_130940_(ChatFormatting.LIGHT_PURPLE)));
                }
            }
            components.add((Component)Component.m_237115_((String)"vp.acs.shift"));
            components.add((Component)Component.m_237115_((String)"vp.acs.ctrl"));
            components.add((Component)Component.m_237115_((String)"vp.acs.alt"));
        }
    }

    public void refreshStats(Player player) {
        List<ItemStack> accessories = VPUtil.getAccessoryList(player);
        if (!accessories.isEmpty()) {
            float health = 0.0f;
            float attack = 0.0f;
            float damage = 0.0f;
            float heal = 0.0f;
            float shields = 0.0f;
            for (ItemStack stackAcs : accessories) {
                Item item = stackAcs.m_41720_();
                if (!(item instanceof Accessory)) continue;
                Accessory accessory = (Accessory)item;
                if (Accessory.getType(stackAcs) == 1) {
                    health += accessory.getStatAmount(stackAcs);
                }
                if (Accessory.getType(stackAcs) == 2) {
                    attack += accessory.getStatAmount(stackAcs);
                }
                if (Accessory.getType(stackAcs) == 3) {
                    damage += accessory.getStatAmount(stackAcs);
                }
                if (Accessory.getType(stackAcs) == 4) {
                    heal += accessory.getStatAmount(stackAcs);
                }
                if (Accessory.getType(stackAcs) != 5) continue;
                shields += accessory.getStatAmount(stackAcs);
            }
            player.m_21204_().m_22161_(VPUtil.createAttributeMap((LivingEntity)player, Attributes.f_22276_, UUID.fromString("d05228bf-b23d-4091-8e9c-4954688989fd"), 0.0f, AttributeModifier.Operation.ADDITION, "vp_accessory:health"));
            player.m_21204_().m_22161_(VPUtil.createAttributeMap((LivingEntity)player, Attributes.f_22281_, UUID.fromString("91595e31-3c5a-4f7d-8097-60a96e37a51c"), 0.0f, AttributeModifier.Operation.ADDITION, "vp_accessory:attack"));
            if (player.m_6084_() && player.m_21223_() > player.m_21233_()) {
                player.m_21153_(player.m_21233_());
            }
            player.m_21204_().m_22178_(VPUtil.createAttributeMap((LivingEntity)player, Attributes.f_22276_, UUID.fromString("d05228bf-b23d-4091-8e9c-4954688989fd"), health, AttributeModifier.Operation.ADDITION, "vp_accessory:health"));
            player.m_21204_().m_22178_(VPUtil.createAttributeMap((LivingEntity)player, Attributes.f_22281_, UUID.fromString("91595e31-3c5a-4f7d-8097-60a96e37a51c"), attack, AttributeModifier.Operation.ADDITION, "vp_accessory:attack"));
            player.getPersistentData().m_128350_("VPAcsDamage", damage);
            player.getPersistentData().m_128350_("VPAcsHeal", heal);
            player.getPersistentData().m_128350_("VPAcsShields", shields);
        } else {
            AttributeModifier modifier = player.m_21051_(Attributes.f_22276_).m_22111_(UUID.fromString("d05228bf-b23d-4091-8e9c-4954688989fd"));
            if (modifier != null) {
                player.m_21051_(Attributes.f_22276_).m_22130_(modifier);
            }
            if ((modifier = player.m_21051_(Attributes.f_22281_).m_22111_(UUID.fromString("91595e31-3c5a-4f7d-8097-60a96e37a51c"))) != null) {
                player.m_21051_(Attributes.f_22281_).m_22130_(modifier);
            }
            player.m_21204_().m_22161_(VPUtil.createAttributeMap((LivingEntity)player, Attributes.f_22276_, UUID.fromString("d05228bf-b23d-4091-8e9c-4954688989fd"), 0.0f, AttributeModifier.Operation.ADDITION, "vp_accessory:health"));
            player.m_21204_().m_22161_(VPUtil.createAttributeMap((LivingEntity)player, Attributes.f_22281_, UUID.fromString("91595e31-3c5a-4f7d-8097-60a96e37a51c"), 0.0f, AttributeModifier.Operation.ADDITION, "vp_accessory:attack"));
        }
    }
}

