/*
 * Decompiled with CFR 0.152.
 */
package com.pyding.vp.item.vestiges;

import com.pyding.vp.client.sounds.SoundRegistry;
import com.pyding.vp.entity.BlackHole;
import com.pyding.vp.item.vestiges.Vestige;
import com.pyding.vp.network.PacketHandler;
import com.pyding.vp.network.packets.PlayerFlyPacket;
import com.pyding.vp.util.VPUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class Atlas
extends Vestige {
    int distance = 30;
    int gravityBonus = 0;

    @Override
    public void dataInit(int vestigeNumber, ChatFormatting color, int specialCharges, int specialCd, int ultimateCharges, int ultimateCd, int specialMaxTime, int ultimateMaxTime, boolean hasDamage, ItemStack stack) {
        super.dataInit(3, ChatFormatting.RED, 2, 10, 1, 220, 1, 4, true, stack);
    }

    @Override
    public void doSpecial(long seconds, Player player, Level level, ItemStack stack) {
        VPUtil.play((LivingEntity)player, (SoundEvent)SoundRegistry.GRAVITY.get());
        for (LivingEntity entity : VPUtil.ray(player, 6.0f, 128, false)) {
            if (VPUtil.isProtectedFromHit(player, (Entity)entity)) continue;
            VPUtil.fall(entity, -10.0);
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                PacketHandler.sendToClient(new PlayerFlyPacket(2), serverPlayer);
            }
            VPUtil.dealDamage(entity, player, player.m_269291_().m_268989_(), VPUtil.scalePower(50, 3, player), 2);
            VPUtil.addRadiance(Atlas.class, VPUtil.getRadianceSpecial(), player);
        }
        VPUtil.rayParticles(player, (ParticleOptions)ParticleTypes.f_175826_, this.distance, 8.0, 30, 0.0, -1.0, 0.0, 5.0, false);
        super.doSpecial(seconds, player, level, stack);
    }

    @Override
    public int setUltimateActive(long seconds, Player player, ItemStack stack) {
        long gravity = Math.max(30, player.getPersistentData().m_128451_("VPGravity"));
        long stellarBonus = 0L;
        if (Atlas.isStellar(stack)) {
            for (LivingEntity entity : VPUtil.ray(player, 8L + gravity, this.distance, true)) {
                ++stellarBonus;
            }
        }
        this.gravityBonus = (int)stellarBonus;
        stellarBonus = 1L + stellarBonus / 10L;
        return super.setUltimateActive(seconds * stellarBonus + gravity * 1000L, player, stack);
    }

    @Override
    public void doUltimate(long seconds, Player player, Level level, ItemStack stack) {
        long gravity = Math.min(30, player.getPersistentData().m_128451_("VPGravity"));
        Level level2 = player.m_20193_();
        if (level2 instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level2;
            BlockPos pos = VPUtil.rayCords((LivingEntity)player, (Level)serverLevel, 10.0);
            int time = (int)(seconds / 50L);
            BlackHole blackHole = new BlackHole((Level)serverLevel, (LivingEntity)player, gravity + 1L, pos, time);
            blackHole.m_6034_(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
            serverLevel.m_7967_((Entity)blackHole);
        }
        player.getPersistentData().m_128405_("VPGravity", 0);
        if (Atlas.isStellar(stack)) {
            player.getPersistentData().m_128405_("VPGravity", Math.min(30, this.gravityBonus));
        }
        super.doUltimate(seconds, player, level, stack);
    }
}

